/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.cmdline;

import java.text.BreakIterator;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.cmdline.Column;
import org.eclipse.aperi.sanmgmt.cmdline.ColumnManager;

public class BlockFormatter {
    static final boolean DEBUG = false;
    static final String NEWLINE = "\n";
    static final String BLANK = " ";
    static final char SPACE = ' ';
    static StringBuffer debugColumnManager;
    String seperator = " ";
    ColumnManager cm = ColumnManager.getManager();
    Column column;
    Vector columns = new Vector();
    BreakIterator charBreak = BreakIterator.getCharacterInstance();
    BreakIterator wordBreak = BreakIterator.getWordInstance();
    StringBuffer output = new StringBuffer();
    StringBuffer pad = new StringBuffer();

    private void init() {
        this.seperator = BLANK;
    }

    public String format(String[] stringArray, int[] nArray) throws Exception {
        return this.format(stringArray, nArray, this.seperator);
    }

    public String format(String[] stringArray, int[] nArray, String string) throws Exception {
        int n;
        this.init();
        if (stringArray.length != nArray.length || stringArray.length == 0) {
            throw new Exception("Invalid input");
        }
        if (string != null) {
            this.seperator = string;
        }
        this.columns.removeAllElements();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.column = this.cm.getColumn();
            this.column.initColumn(stringArray[n2], nArray[n2]);
            this.columns.add(this.column);
            this.column = null;
            ++n2;
        }
        n2 = 0;
        boolean bl = false;
        this.output.setLength(0);
        while (!bl) {
            n2 = 0;
            n = 0;
            while (n < this.columns.size()) {
                int n3;
                int n4;
                this.column = (Column)this.columns.get(n);
                if (this.column.isAtEnd()) {
                    this.output.append(this.getPadding(this.column.getWidth()));
                    ++n2;
                } else if (this.column.getEnd() - this.column.getCurrBegin() <= this.column.getWidth()) {
                    n4 = this.column.getCurrBegin();
                    n3 = this.column.getEnd();
                    this.output.append(this.column.getText().substring(n4, n3));
                    this.output.append(this.getPadding(this.column.getWidth() - (n3 - n4)));
                    this.column.isAtEnd(true);
                    ++n2;
                } else {
                    int n5 = this.column.getCurrBegin() + this.column.getWidth();
                    this.wordBreak.setText(this.column.getText());
                    int n6 = this.wordBreak.preceding(n5);
                    if (n6 > this.column.getCurrBegin() && n6 != -1) {
                        n4 = this.column.getCurrBegin();
                        n3 = n6;
                        this.output.append(this.column.getText().substring(n4, n3));
                        this.output.append(this.getPadding(this.column.getWidth() - (n3 - n4)));
                        this.column.setCurrBegin(n3);
                    } else {
                        this.charBreak.setText(this.column.getText());
                        n6 = this.charBreak.preceding(n5);
                        if (n6 > this.column.getCurrBegin() && n6 != -1) {
                            n4 = this.column.getCurrBegin();
                            n3 = n6;
                            this.output.append(this.column.getText().substring(n4, n3));
                            this.output.append(this.getPadding(this.column.getWidth() - (n3 - n4)));
                            this.column.setCurrBegin(n3);
                        } else {
                            throw new Exception("Formatting failed");
                        }
                    }
                }
                if (n != this.columns.size() - 1) {
                    this.output.append(string);
                }
                ++n;
            }
            this.output.append(NEWLINE);
            if (n2 < this.columns.size()) continue;
            bl = true;
        }
        n = 0;
        while (n < this.columns.size()) {
            this.cm.returnColumn((Column)this.columns.get(n));
            ++n;
        }
        return this.output.toString();
    }

    private StringBuffer getPadding(int n) {
        this.pad.setLength(0);
        int n2 = 0;
        while (n2 < n) {
            this.pad.append(' ');
            ++n2;
        }
        return this.pad;
    }
}

