/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.EventHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class EventProcessor
implements Runnable {
    ILogger msgLogger = LogConstants.msgLogger;
    ILogger traceLogger = LogConstants.traceLogger;
    static final String className;
    private Vector eventGroup = new Vector();
    private EventCorrelatorFactory eventMonitor = null;
    private Thread workerThread = null;
    private static EventProcessor eventProcess;
    private EventHandler eventHndlr = null;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.EventProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        eventProcess = null;
    }

    private EventProcessor() {
    }

    public static EventProcessor shareInstance() {
        if (eventProcess == null) {
            eventProcess = new EventProcessor();
        }
        return eventProcess;
    }

    public void start(EventCorrelatorFactory eventCorrelatorFactory) {
        String string = "start";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)eventCorrelatorFactory);
        }
        if (this.eventHndlr == null) {
            this.eventHndlr = new EventHandler(eventCorrelatorFactory);
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String string = "stop";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.workerThread = null;
        EventProcessor eventProcessor = this;
        synchronized (eventProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block15: {
            var1_1 = "run";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, (Object)EventProcessor.className, var1_1);
            }
            try {
                var2_2 = Thread.currentThread();
                block9: while (this.workerThread == var2_2) {
                    try {
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            if (!this.eventGroup.isEmpty()) {
                                var3_4 = (Object[])this.eventGroup.firstElement();
                                var4_7 = (String)var3_4[0];
                                var5_8 = (Vector)var3_4[1];
                                super.process(var4_7, var5_8);
                                this.eventGroup.removeElement(var3_4);
                                continue block9;
                            }
                            var3_4 = this;
                            // MONITORENTER : this
                            try {
                                this.wait();
                            }
                            catch (InterruptedException v0) {}
                            if (this.workerThread == null) {
                                if (this.traceLogger.isLogging()) {
                                    var4_7 = "event monitor service was shutdown";
                                    this.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, var1_1, var4_7);
                                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventProcessor.className, var1_1);
                                }
                                // MONITOREXIT : var3_4
                                return;
                            }
                            // MONITOREXIT : var3_4
                            continue;
                            break;
                        }
                    }
                    catch (Exception var3_5) {
                        var4_7 = "Failed to publish event.";
                        if (!this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, var1_1, var4_7);
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventProcessor.className, var1_1, (Throwable)var3_5);
                        continue;
                    }
                    {
                        ** while (true)
                    }
                }
            }
            catch (Exception var2_3) {
                var3_6 = "Failed to start EventPublishThread";
                if (!this.traceLogger.isLogging()) break block15;
                this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, var1_1, var3_6);
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventProcessor.className, var1_1, (Throwable)var2_3);
            }
        }
        if (this.traceLogger.isLogging() == false) return;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventProcessor.className, var1_1);
    }

    private void process(String string, Vector vector) {
        String string2 = "process";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, new Object[]{string, "allEvents"});
        }
        EventDBAccessor.initializeThreadLocal();
        this.eventHndlr.publishEvents(string, vector);
        EventDBAccessor.clearThreadLocal();
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventsToProcess(String string, Vector vector) {
        String string2 = "addEventsToProcess";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, new Object[]{string, "allEvents"});
        }
        Object[] objectArray = new Object[]{string, vector};
        this.eventGroup.add(objectArray);
        EventProcessor eventProcessor = this;
        synchronized (eventProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public static void main(String[] stringArray) {
    }
}

