/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.IpAddresses;
import org.eclipse.aperi.infrastructure.database.objects.SnmpTrapOid;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class EventFilter {
    static ILogger msgLogger;
    static ILogger traceLogger;
    private static final String FILENAME = "org.eclipse.aperi.discovery.snmp.scanner.SnmpMibOid";
    static ResourceBundle rb;
    static HashMap eventFilters;
    static HashMap eventFiltersByIp;
    static HashMap genericFilters;
    static final String className;
    OID enterprise = null;
    Integer genericTrap = null;
    Integer specificTrap = null;
    HashMap varbinds = new HashMap();

    static {
        Class<?> clazz;
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
        rb = ResourceBundle.getBundle("org.eclipse.aperi.monitor.eventcorrelator.resources.EventFilterResources", Locale.getDefault());
        eventFilters = null;
        eventFiltersByIp = null;
        genericFilters = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.snmp.EventFilter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    private static DBConnection getConnection() {
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            return (DBConnection)dBConnPoolDataSource.getPooledConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeEventFilters() {
        block24: {
            var0 = "initializeEventFilter";
            if (EventFilter.traceLogger.isLogging()) {
                EventFilter.traceLogger.entry(IRecordType.TYPE_API, (Object)EventFilter.className, var0);
            }
            EventFilter.eventFilters = new HashMap<K, V>();
            EventFilter.eventFiltersByIp = new HashMap<K, V>();
            EventFilter.genericFilters = new HashMap<K, V>();
            var1_1 = EventFilter.getConnection();
            try {
                var2_2 = "select \t\tfilter.SNMP_TRAP_ID, \t\tip.IP_ADDRESS, \t\tfilter.ENTERPRISE_TRAP, \t\tfilter.GENERIC_TRAP, \t\tfilter.SPECIFIC_TRAP, \t\tvalue.OBJECT_ID, \t\tvalue.VALUE from " + var1_1.getSchema() + ".T_RES_SNMP_TRAP filter " + "\t\tleft outer join " + var1_1.getSchema() + ".T_RES_SNMP_TRAP_OID value on (filter.SNMP_TRAP_ID=value.SNMP_TRAP_ID) " + "\t\tleft outer join " + var1_1.getSchema() + ".T_RES_IP_ADDRESSES ip on (ip.OBJECT_TYPE=" + DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP") + " and value.SNMP_TRAP_ID=ip.OBJECT_ID) " + "order by " + "\t\tfilter.SNMP_TRAP_ID ";
                var3_3 = null;
                try {
                    try {
                        var3_3 = ComplexQuery.sqlQuery((DBConnection)var1_1, (String)var2_2, new Hashtable<K, V>());
                        while (var3_3.next()) {
                            var4_4 = var3_3.getString("ENTERPRISE_TRAP");
                            var5_6 = var3_3.getString("GENERIC_TRAP");
                            var6_7 = var3_3.getString("SPECIFIC_TRAP");
                            var7_8 = var3_3.getString("SNMP_TRAP_ID");
                            var8_9 = (EventFilter)EventFilter.eventFilters.get(var7_8);
                            if (var8_9 == null) {
                                var8_9 = new EventFilter(var4_4 == null ? null : new OID(var4_4), var5_6 == null ? null : new Integer(var5_6), var6_7 == null ? null : new Integer(var6_7));
                                EventFilter.eventFilters.put(var7_8, var8_9);
                            }
                            var9_10 = var3_3.getString("OBJECT_ID");
                            var10_11 = var3_3.getString("VALUE");
                            if (var9_10 != null && var10_11 != null) {
                                var8_9.addVarBind(var9_10, var10_11);
                            }
                            if ((var11_12 = var3_3.getString("IP_ADDRESS")) == null) {
                                EventFilter.genericFilters.put(var7_8, var8_9);
                                continue;
                            }
                            var12_13 = (HashMap<String, EventFilter>)EventFilter.eventFiltersByIp.get(var11_12);
                            if (var12_13 == null) {
                                var12_13 = new HashMap<String, EventFilter>();
                                EventFilter.eventFiltersByIp.put(var11_12, var12_13);
                            }
                            var12_13.put(var7_8, var8_9);
                        }
                    }
                    catch (Exception var4_5) {
                        EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var0, (Throwable)var4_5);
                        if (EventFilter.traceLogger.isLogging()) {
                            EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var0, (Throwable)var4_5);
                        }
                    }
                }
                catch (Throwable var14_14) {
                    var13_15 = null;
                    try {
                        if (var3_3 == null) throw var14_14;
                        var3_3.close();
                        throw var14_14;
                    }
                    catch (Exception var15_17) {
                        EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var0, (Throwable)var15_17);
                        if (EventFilter.traceLogger.isLogging() == false) throw var14_14;
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var0, (Throwable)var15_17);
                    }
                    throw var14_14;
                }
                {
                    var13_16 = null;
                    try {}
                    catch (Exception var15_18) {
                        EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var0, (Throwable)var15_18);
                        if (EventFilter.traceLogger.isLogging()) {
                            EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var0, (Throwable)var15_18);
                        }
                    }
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                }
            }
            catch (Throwable var17_19) {
                var16_20 = null;
                try {
                    if (var1_1 == null) throw var17_19;
                    var1_1.close();
                    throw var17_19;
                }
                catch (Exception var18_22) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var0, (Throwable)var18_22);
                    if (EventFilter.traceLogger.isLogging() == false) throw var17_19;
                    EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var0, (Throwable)var18_22);
                }
                throw var17_19;
            }
            {
                var16_21 = null;
            }
            ** try [egrp 5[TRYBLOCK] [6 : 548->559)] { 
lbl83:
            // 1 sources

            if (var1_1 != null) {
                var1_1.close();
            }
            break block24;
lbl86:
            // 1 sources

            catch (Exception var18_23) {
                EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var0, (Throwable)var18_23);
                if (!EventFilter.traceLogger.isLogging()) break block24;
                EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var0, (Throwable)var18_23);
            }
        }
        if (EventFilter.traceLogger.isLogging() == false) return;
        EventFilter.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventFilter.className, var0);
    }

    public static String list() {
        String string = "list";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if (eventFiltersByIp.isEmpty() && genericFilters.isEmpty()) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return rb.getString("OutbandChangeAgent.NoFilters");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = eventFilters.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.filterTitle"), (Object[])new String[]{string2, ((EventFilter)eventFilters.get(string2)).toString()}));
            if (genericFilters.containsKey(string2)) {
                stringBuffer.append(rb.getString("OutbandChangeAgent.allAddresses"));
            } else {
                boolean bl = true;
                Iterator iterator2 = eventFiltersByIp.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!((HashMap)eventFiltersByIp.get(string3)).containsKey(string2)) continue;
                    if (bl) {
                        stringBuffer.append(rb.getString("OutbandChangeAgent.addresses"));
                    } else {
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append(String.valueOf(string3) + "\n");
                    bl = false;
                }
            }
            stringBuffer.append("\n");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String addFilter(String[] var0) {
        block33: {
            var1_1 = "addFilter";
            var2_2 = true;
            if (EventFilter.traceLogger.isLogging()) {
                EventFilter.traceLogger.entry(IRecordType.TYPE_API, (Object)EventFilter.className, var1_1, (Object[])var0);
            }
            if (EventFilter.eventFilters == null) {
                EventFilter.initializeEventFilters();
            }
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            var7_7 = new HashMap<String, String>();
            var8_8 = 1;
            while (true) {
                if (var8_8 >= var0.length) {
                    var8_9 = EventFilter.getConnection();
                    ** try [egrp 0[TRYBLOCK] [1 : 225->459)] { 
lbl17:
                    // 1 sources

                    break;
                }
                var9_10 = var0[var8_8].indexOf("=");
                if (var9_10 < 1) {
                    return EventFilter.rb.getString("OutbandChangeAgent.InvalidParameter");
                }
                if (var0[var8_8].startsWith("enterprise")) {
                    var4_4 = var0[var8_8].substring(var9_10 + 1);
                } else if (var0[var8_8].startsWith("generic")) {
                    var5_5 = var0[var8_8].substring(var9_10 + 1);
                } else if (var0[var8_8].startsWith("specific")) {
                    var6_6 = var0[var8_8].substring(var9_10 + 1);
                } else {
                    var7_7.put(var0[var8_8].substring(0, var9_10), var0[var8_8].substring(var9_10 + 1));
                }
                ++var8_8;
            }
            {
                try {
                    var8_9.setAutoCommit(false);
                    var9_10 = AutoIdentifier.getIdentifier((int)10, (int)1);
                    var3_3 = Integer.toString(var9_10);
                    var10_12 = new SnmpTrapOid();
                    var11_13 = new org.eclipse.aperi.infrastructure.database.objects.SnmpTrap();
                    var11_13.setSnmpTrapId(var9_10);
                    if (var4_4 != null) {
                        var11_13.setEnterpriseTrap(var4_4);
                    }
                    if (var5_5 != null) {
                        var11_13.setGenericTrap((short)Integer.parseInt(var5_5));
                    }
                    if (var6_6 != null) {
                        var11_13.setSpecificTrap((short)Integer.parseInt(var6_6));
                    }
                    var11_13.insert(var8_9);
                    var10_12.setSnmpTrapId(var9_10);
                    if (!var7_7.isEmpty()) {
                        var12_14 = var7_7.keySet().iterator();
                        while (var12_14.hasNext()) {
                            var13_15 = (String)var12_14.next();
                            var10_12.setObjectId(var13_15);
                            var10_12.setValue((String)var7_7.get(var13_15));
                            var10_12.insert(var8_9);
                        }
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var9_11) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var9_11);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var9_11);
                    }
                    var2_2 = false;
                }
            }
lbl66:
            // 1 sources

            catch (Throwable var15_16) {
                var14_17 = null;
                if (var8_9 == null) throw var15_16;
                try {
                    if (var2_2) {
                        var8_9.commit();
                    } else {
                        var8_9.rollback();
                    }
                    var8_9.close();
                    throw var15_16;
                }
                catch (Exception var16_19) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var16_19);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var16_19);
                    }
                    var2_2 = false;
                }
                throw var15_16;
            }
lbl-1000:
            // 2 sources

            {
                var14_18 = null;
                if (var8_9 == null) break block33;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 474->499)] { 
lbl86:
            // 1 sources

            if (var2_2) {
                var8_9.commit();
            } else {
                var8_9.rollback();
            }
            var8_9.close();
            break block33;
lbl92:
            // 1 sources

            catch (Exception var16_20) {
                EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var16_20);
                if (EventFilter.traceLogger.isLogging()) {
                    EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var16_20);
                }
                var2_2 = false;
            }
        }
        if (var2_2) {
            EventFilter.initializeEventFilters();
        }
        if (EventFilter.traceLogger.isLogging()) {
            EventFilter.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventFilter.className, var1_1);
        }
        if (var2_2 == false) return EventFilter.rb.getString("OutbandChangeAgent.filterAddErr");
        return String.valueOf(IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.filterAddOK"), (Object[])new String[]{var3_3})) + EventFilter.rb.getString("OutbandChangeAgent.filterAllMsg");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String addAddress(String[] var0) {
        block22: {
            var1_1 = "addAddress";
            var2_2 = true;
            if (EventFilter.traceLogger.isLogging()) {
                EventFilter.traceLogger.entry(IRecordType.TYPE_API, (Object)EventFilter.className, var1_1, (Object[])var0);
            }
            if (EventFilter.eventFilters == null) {
                EventFilter.initializeEventFilters();
            }
            if (EventFilter.eventFilters.get(var3_3 = var0[1]) == null) {
                return IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.noFilter"), (Object[])new String[]{var3_3});
            }
            var4_4 = EventFilter.getConnection();
            var5_5 = null;
            var6_6 = 0;
            try {
                try {
                    var4_4.setAutoCommit(false);
                    var7_7 = 2;
                    while (var7_7 < var0.length) {
                        var8_9 = var0[var7_7];
                        var5_5 = new IpAddresses(Integer.parseInt(var3_3), (short)Integer.valueOf(DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP")).intValue(), var8_9);
                        var5_5.insert(var4_4);
                        ++var6_6;
                        ++var7_7;
                    }
                }
                catch (Exception var7_8) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var7_8);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var7_8);
                    }
                    var2_2 = false;
                }
            }
            catch (Throwable var10_10) {
                var9_11 = null;
                try {
                    if (var4_4 == null) throw var10_10;
                    if (var2_2) {
                        var4_4.commit();
                    } else {
                        var4_4.rollback();
                    }
                    var4_4.close();
                    throw var10_10;
                }
                catch (Exception var11_13) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var11_13);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var11_13);
                    }
                    var2_2 = false;
                }
                throw var10_10;
            }
            {
                var9_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 221->251)] { 
lbl50:
            // 1 sources

            if (var4_4 != null) {
                if (var2_2) {
                    var4_4.commit();
                } else {
                    var4_4.rollback();
                }
                var4_4.close();
            }
            break block22;
lbl57:
            // 1 sources

            catch (Exception var11_14) {
                EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var11_14);
                if (EventFilter.traceLogger.isLogging()) {
                    EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var11_14);
                }
                var2_2 = false;
            }
        }
        if (var2_2) {
            EventFilter.initializeEventFilters();
        }
        if (EventFilter.traceLogger.isLogging()) {
            EventFilter.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventFilter.className, var1_1);
        }
        if (var2_2 == false) return EventFilter.rb.getString("OutbandChangeAgent.filterAddErr");
        return IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.addAddressOK"), (Object[])new String[]{Integer.toString(var6_6), var3_3});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String removeFilter(String[] var0) {
        block22: {
            var1_1 = "removeFilter";
            if (EventFilter.traceLogger.isLogging()) {
                EventFilter.traceLogger.entry(IRecordType.TYPE_API, (Object)EventFilter.className, var1_1, (Object[])var0);
            }
            if (EventFilter.eventFilters == null) {
                EventFilter.initializeEventFilters();
            }
            if (EventFilter.eventFilters.get(var2_2 = var0[1]) == null) {
                return IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.noFilter"), (Object[])new String[]{var2_2});
            }
            var3_3 = 0;
            var4_4 = true;
            var5_5 = EventFilter.getConnection();
            var6_6 = new org.eclipse.aperi.infrastructure.database.objects.SnmpTrap();
            var7_7 = new Hashtable<ColumnInfo, String>();
            var8_8 = new Hashtable<ColumnInfo, String>();
            var9_9 = new Hashtable<ColumnInfo, String>();
            var7_7.put(SnmpTrapOid.getColumnInfo((String)"SNMP_TRAP_ID"), var2_2);
            var8_8.put(org.eclipse.aperi.infrastructure.database.objects.SnmpTrap.getColumnInfo((String)"SNMP_TRAP_ID"), var2_2);
            var9_9.put(IpAddresses.getColumnInfo((String)"OBJECT_ID"), var2_2);
            var9_9.put(IpAddresses.getColumnInfo((String)"OBJECT_TYPE"), DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP").toString());
            try {
                try {
                    var5_5.setAutoCommit(false);
                    SnmpTrapOid.deletes((DBConnection)var5_5, var7_7);
                    var3_3 += var6_6.delete(var5_5, var8_8);
                    IpAddresses.deletes((DBConnection)var5_5, var9_9);
                }
                catch (Exception var10_10) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var10_10);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var10_10);
                    }
                    var4_4 = false;
                }
            }
            catch (Throwable var12_11) {
                var11_12 = null;
                try {
                    if (var5_5 == null) throw var12_11;
                    if (var4_4) {
                        var5_5.commit();
                    } else {
                        var5_5.rollback();
                    }
                    var5_5.close();
                    throw var12_11;
                }
                catch (Exception var13_14) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var13_14);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var13_14);
                    }
                    var4_4 = false;
                }
                throw var12_11;
            }
            {
                var11_13 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 279->310)] { 
lbl57:
            // 1 sources

            if (var5_5 != null) {
                if (var4_4) {
                    var5_5.commit();
                } else {
                    var5_5.rollback();
                }
                var5_5.close();
            }
            break block22;
lbl64:
            // 1 sources

            catch (Exception var13_15) {
                EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var13_15);
                if (EventFilter.traceLogger.isLogging()) {
                    EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var13_15);
                }
                var4_4 = false;
            }
        }
        if (var4_4) {
            EventFilter.initializeEventFilters();
        }
        if (EventFilter.traceLogger.isLogging()) {
            EventFilter.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventFilter.className, var1_1, var3_3);
        }
        if (!var4_4) {
            v0 = IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.filterRemoveErr"), (Object[])new String[]{var2_2});
            return v0;
        }
        v0 = IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.filterRemoveOK"), (Object[])new String[]{var2_2});
        return v0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String removeAddress(String[] var0) {
        block23: {
            var1_1 = "removeAddress";
            var2_2 = true;
            if (EventFilter.traceLogger.isLogging()) {
                EventFilter.traceLogger.entry(IRecordType.TYPE_API, (Object)EventFilter.className, var1_1, (Object[])var0);
            }
            var3_3 = var0[1];
            if (EventFilter.eventFilters == null) {
                EventFilter.initializeEventFilters();
            }
            if (EventFilter.eventFilters.get(var3_3) == null) {
                return IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.noFilter"), (Object[])new String[]{var3_3});
            }
            var4_4 = EventFilter.getConnection();
            var5_5 = new IpAddresses();
            var6_6 = null;
            var7_7 = 0;
            try {
                try {
                    var4_4.setAutoCommit(false);
                    var8_8 = 2;
                    while (var8_8 < var0.length) {
                        var9_11 = var0[var8_8];
                        var6_6 = new Hashtable<ColumnInfo, String>();
                        var6_6.put(IpAddresses.getColumnInfo((String)"OBJECT_ID"), var3_3);
                        var6_6.put(IpAddresses.getColumnInfo((String)"OBJECT_TYPE"), DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP").toString());
                        var6_6.put(IpAddresses.getColumnInfo((String)"IP_ADDRESS"), var9_11);
                        var7_7 += var5_5.delete(var4_4, var6_6);
                        ++var8_8;
                    }
                }
                catch (Exception var8_9) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var8_9);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var8_9);
                    }
                    var2_2 = false;
                }
            }
            catch (Throwable var11_12) {
                var10_13 = null;
                try {
                    if (var4_4 == null) throw var11_12;
                    if (var2_2) {
                        var4_4.commit();
                    } else {
                        var4_4.rollback();
                    }
                    var4_4.close();
                    throw var11_12;
                }
                catch (Exception var12_15) {
                    EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var12_15);
                    if (EventFilter.traceLogger.isLogging()) {
                        EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var12_15);
                    }
                    var2_2 = false;
                }
                throw var11_12;
            }
            {
                var10_14 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 260->290)] { 
lbl56:
            // 1 sources

            if (var4_4 != null) {
                if (var2_2) {
                    var4_4.commit();
                } else {
                    var4_4.rollback();
                }
                var4_4.close();
            }
            break block23;
lbl63:
            // 1 sources

            catch (Exception var12_16) {
                EventFilter.msgLogger.exception(IRecordType.TYPE_ERR, (Object)EventFilter.className, var1_1, (Throwable)var12_16);
                if (EventFilter.traceLogger.isLogging()) {
                    EventFilter.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)EventFilter.className, var1_1, (Throwable)var12_16);
                }
                var2_2 = false;
            }
        }
        if (var2_2) {
            EventFilter.initializeEventFilters();
        }
        if (EventFilter.traceLogger.isLogging()) {
            EventFilter.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)EventFilter.className, var1_1);
        }
        if (var2_2) {
            var8_10 = IntlMessageFormat.format((String)EventFilter.rb.getString("OutbandChangeAgent.removedAddresses"), (Object[])new String[]{Integer.toString(var7_7), var3_3});
            if (EventFilter.genericFilters.get(var3_3) != null) return String.valueOf(var8_10) + EventFilter.rb.getString("OutbandChangeAgent.filterAllMsg");
            return var8_10;
        }
        return IntlMessageFormat.format((String)"OutbandChangeAgent.filterRemoveErr", (Object[])new String[]{var3_3});
    }

    public static String filterTrap(SnmpTrap snmpTrap) {
        String string;
        Iterator iterator;
        HashMap hashMap;
        String string2 = "filterTrap";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if ((hashMap = (HashMap)eventFiltersByIp.get(snmpTrap.agentAddr.getIpAddress())) != null) {
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!((EventFilter)hashMap.get(string)).filter(snmpTrap)) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, (Object)string);
                }
                return string;
            }
        }
        iterator = genericFilters.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!((EventFilter)genericFilters.get(string)).filter(snmpTrap)) continue;
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, (Object)string);
            }
            return string;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, null);
        }
        return null;
    }

    private EventFilter(OID oID, Integer n, Integer n2) {
        this.genericTrap = n;
        this.specificTrap = n2;
        this.enterprise = oID;
    }

    private void addVarBind(String string, String string2) {
        this.varbinds.put(string, string2);
    }

    private boolean filter(SnmpTrap snmpTrap) {
        if (this.enterprise != null && !snmpTrap.enterprise.startsWith(this.enterprise)) {
            return false;
        }
        if (this.genericTrap != null && this.genericTrap != snmpTrap.genericTrap) {
            return false;
        }
        if (this.specificTrap != null && this.specificTrap != snmpTrap.specificTrap) {
            return false;
        }
        if (!this.varbinds.isEmpty()) {
            Vector vector = snmpTrap.varBindList();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                SnmpVarBind snmpVarBind = (SnmpVarBind)iterator.next();
                String string = snmpVarBind.get_value() instanceof OctetString ? ((OctetString)snmpVarBind.get_value()).toDisplayString() : snmpVarBind.get_printable_value();
                String string2 = (String)this.varbinds.get(snmpVarBind.get_printable_oid());
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.enterprise == null && this.genericTrap == null && this.specificTrap == null && this.varbinds.isEmpty()) {
            return rb.getString("OutbandChangeAgent.allTrapsMsg");
        }
        stringBuffer.append("Enterprise:\t" + (this.enterprise == null ? rb.getString("OutbandChangeAgent.notSpecified") : this.enterprise.toString()) + "\nGeneric Trap:\t" + (this.genericTrap == null ? rb.getString("OutbandChangeAgent.notSpecified") : this.genericTrap.toString()) + "\nSpecific Trap:\t" + (this.specificTrap == null ? rb.getString("OutbandChangeAgent.notSpecified") : this.specificTrap.toString()) + "\n");
        if (!this.varbinds.isEmpty()) {
            Iterator iterator = this.varbinds.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("     " + string + " = " + this.varbinds.get(string) + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

