/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.snmp.SnmpMonitor;
import org.eclipse.aperi.monitor.snmp.SnmpV2Monitor;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.TrapFilter;
import org.eclipse.aperi.snmp.TrapListener;
import org.eclipse.aperi.snmp.TrapReceiver;
import org.eclipse.aperi.snmp.V2TrapFilter;
import org.eclipse.aperi.snmp.V2TrapListener;

public class SNMPReceiver
extends Thread {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private boolean stop = false;
    private static int SNMPForwardPort;
    private SnmpMonitor monitor = null;
    private SnmpV2Monitor v2Monitor = null;
    private static int maxArrayLength;
    private static int initialPort;
    private static final int maxPortNumber = 65535;
    private static final int minPortNumber = 1025;
    private static final int sleepPeriod = 60000;

    static {
        Class<?> clazz;
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.snmp.SNMPReceiver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        SNMPForwardPort = 49152;
        maxArrayLength = 4302;
        initialPort = 49153;
    }

    private SNMPReceiver() {
    }

    public SNMPReceiver(int n, SnmpMonitor snmpMonitor, SnmpV2Monitor snmpV2Monitor) {
        SNMPForwardPort = n;
        this.monitor = snmpMonitor;
        this.v2Monitor = snmpV2Monitor;
    }

    public void requestStop() {
        this.stop = true;
    }

    public void run() {
        DatagramSocket datagramSocket;
        String string;
        block14: {
            string = "run";
            datagramSocket = null;
            try {
                datagramSocket = new DatagramSocket();
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block14;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, string, (Throwable)exception, "Unable to create a DatagramSocket over which to send SNMP Forwarding registration messages.");
            }
        }
        TrapReceiver trapReceiver = null;
        while (trapReceiver == null) {
            try {
                trapReceiver = new TrapReceiver(initialPort);
            }
            catch (SocketException socketException) {
                if (++initialPort <= 65535) continue;
                initialPort = 1025;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_INFO, (Object)this, string, "Listening for forwarded SNMP msgs over port " + initialPort);
        }
        Thread thread = new Thread((Runnable)trapReceiver);
        thread.setName("SNMP Trap Listener");
        trapReceiver.subscribe((TrapListener)this.monitor, (TrapFilter)this.monitor);
        trapReceiver.subscribeV2((V2TrapListener)this.v2Monitor, (V2TrapFilter)this.v2Monitor);
        thread.start();
        while (!this.stop) {
            block15: {
                if (!this.sendRegistration(datagramSocket, initialPort)) {
                    try {
                        if (datagramSocket != null) {
                            datagramSocket.close();
                        }
                        datagramSocket = new DatagramSocket();
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block15;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, string, (Throwable)exception, "Unable to create a DatagramSocket over which to send SNMP Forwarding registration messages.");
                    }
                }
            }
            try {
                SNMPReceiver.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (trapReceiver != null) {
            trapReceiver.terminate();
        }
    }

    private boolean sendRegistration(DatagramSocket datagramSocket, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                String string = "0:" + Integer.toString(n);
                DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), InetAddress.getLocalHost(), SNMPForwardPort);
                datagramSocket.send(datagramPacket);
                bl = true;
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "sendRegistration", (Throwable)exception, "An error occurred when sending the registration message.");
            }
        }
        return bl;
    }
}

