/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class SANEventUtil {
    private static final long serialVersionUID = 20001130L;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventService";
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public static final String className;
    private static IConfigService dbParms;
    public static final String DEFAULT_DOMAIN = "127.0.0.1";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DOMAINID = "SANDomainID";
    public static final String PUBLISHERID = "publisherID";

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.data.SANEventUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        dbParms = null;
    }

    public SANEventUtil() {
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (msgLogger != null) {
            msgLogger.setMessageFile(BUNDLENAME);
        }
    }

    private String getDomainFilter() {
        String string;
        block4: {
            string = "127.0.0.1";
            try {
                dbParms = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
                string = dbParms.getProperty(DOMAINID, "user");
                if (string == null) {
                    string = "127.0.0.1";
                }
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainFilter", (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainFilter", (Throwable)exception);
            }
        }
        return "(SANDomainID = '" + string + "')";
    }

    public static String getDomainName() {
        String string;
        block4: {
            string = "127.0.0.1";
            try {
                dbParms = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
                string = dbParms.getProperty(DOMAINID, "user");
                if (string == null) {
                    string = "127.0.0.1";
                }
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainName", (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainName", (Throwable)exception);
            }
        }
        return string;
    }

    public static String getUniqueQualifier() {
        String string = "127.0.0.1";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress inetAddress2 = InetAddress.getByName(inetAddress.getHostAddress());
            string = inetAddress2.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "127.0.0.1";
        }
        return string.trim();
    }

    public static String getUniqueSubscriberId(String string) {
        String string2 = SANEventUtil.getUniqueQualifier();
        if (string == null) {
            string = "";
        }
        if (string.trim().length() == 0) {
            string = "NONAME";
        }
        return new String(String.valueOf(string2.trim()) + "." + string.trim());
    }
}

