/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageCatalog;

public class EnhancedFormatter
extends Formatter {
    static final long serialVersionUID = -5325854698659692150L;
    protected static final String SPACE = "  ";
    protected transient String date = null;
    protected transient String time = null;
    protected transient String className = null;
    protected transient String methodName = null;
    protected transient String org = null;
    protected transient String product = null;
    protected transient String comp = null;
    protected transient String client = null;
    protected transient String server = null;
    protected transient String threadName = null;

    public EnhancedFormatter() {
    }

    public EnhancedFormatter(String string) {
        super(string);
    }

    public String format(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.initTitles();
        long l = logEvent.getTimeStamp();
        stringBuffer.append(String.valueOf(this.date) + SPACE + this.getDate(l) + SPACE + this.getTime(l) + this.lineSep);
        String string = logEvent.getLoggingClass();
        if (string != null) {
            stringBuffer.append(String.valueOf(this.className) + SPACE + string + this.lineSep);
        }
        if ((string = logEvent.getLoggingMethod()) != null) {
            stringBuffer.append(String.valueOf(this.methodName) + SPACE + string + this.lineSep);
        }
        if ((string = logEvent.getOrganization()) != null && !string.equals("")) {
            stringBuffer.append(String.valueOf(this.org) + SPACE + string + this.lineSep);
        }
        if ((string = logEvent.getProduct()) != null && !string.equals("")) {
            stringBuffer.append(String.valueOf(this.product) + SPACE + string + this.lineSep);
        }
        if ((string = logEvent.getComponent()) != null && !string.equals("")) {
            stringBuffer.append(String.valueOf(this.comp) + SPACE + string + this.lineSep);
        }
        if ((string = logEvent.getServer()) != null && !string.equals("")) {
            stringBuffer.append(String.valueOf(this.server) + SPACE + string + this.lineSep);
        }
        if ((string = logEvent.getClient()) != null && !string.equals("")) {
            stringBuffer.append(String.valueOf(this.client) + SPACE + string + this.lineSep);
        }
        stringBuffer.append(SPACE + this.getText(logEvent));
        return stringBuffer.toString();
    }

    protected void initTitles() {
        if (this.date == null) {
            MessageCatalog messageCatalog = new MessageCatalog("com.ibm.log.util.Msgs", this.getLocale());
            this.date = messageCatalog.getMessage("DATE");
            this.time = messageCatalog.getMessage("TIME");
            this.className = messageCatalog.getMessage("LOGGING_CLASS");
            this.methodName = messageCatalog.getMessage("METHOD_NAME");
            this.org = messageCatalog.getMessage("ORGANIZATION");
            this.product = messageCatalog.getMessage("PRODUCT");
            this.comp = messageCatalog.getMessage("COMPONENT");
            this.client = messageCatalog.getMessage("CLIENT");
            this.server = messageCatalog.getMessage("SERVER");
            this.threadName = messageCatalog.getMessage("THREAD_NAME");
            if (this.date.equals(".")) {
                this.date = "Date:";
                this.time = "Time:";
                this.className = "Class:";
                this.methodName = "Method:";
                this.org = "Organization:";
                this.product = "Product:";
                this.comp = "Component:";
                this.client = "Client:";
                this.server = "Server:";
                this.threadName = "Thread Name:";
            }
            int n = this.date.length();
            if (this.time.length() > n) {
                n = this.time.length();
            }
            if (this.className.length() > n) {
                n = this.className.length();
            }
            if (this.methodName.length() > n) {
                n = this.methodName.length();
            }
            if (this.org.length() > n) {
                n = this.org.length();
            }
            if (this.product.length() > n) {
                n = this.product.length();
            }
            if (this.comp.length() > n) {
                n = this.comp.length();
            }
            if (this.client.length() > n) {
                n = this.client.length();
            }
            if (this.server.length() > n) {
                n = this.server.length();
            }
            if (this.threadName.length() > n) {
                n = this.threadName.length();
            }
            this.date = LogUtil.left(this.date, n);
            this.time = LogUtil.left(this.time, n);
            this.className = LogUtil.left(this.className, n);
            this.methodName = LogUtil.left(this.methodName, n);
            this.org = LogUtil.left(this.org, n);
            this.product = LogUtil.left(this.product, n);
            this.comp = LogUtil.left(this.comp, n);
            this.client = LogUtil.left(this.client, n);
            this.server = LogUtil.left(this.server, n);
            this.threadName = LogUtil.left(this.threadName, n);
        }
    }
}

