/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;

public class ZosConsoleHandler
extends Handler {
    private static final String SYSPROP_OSNAME = "os.name";
    private static final String OS_NAME_ZOS = "z/OS";
    private static final String OS_NAME_OS390 = "OS/390";
    private static final String SYSPROP_OSARCH = "os.name";
    private static final String OS_ARCH_390 = "390";
    private static final String OS_ARCH_390X = "390x";
    private static final String IBM_VM_BITMODE = "com.ibm.vm.bitmode";
    private static final String VM_BITMODE_32 = "32";
    private static final String VM_BITMODE_64 = "64";
    static boolean initialized = false;

    static {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty(IBM_VM_BITMODE);
        if (OS_NAME_OS390.equals(string) || OS_NAME_ZOS.equals(string)) {
            if (VM_BITMODE_64.equals(string2)) {
                System.loadLibrary("JLOG_64");
                initialized = true;
            } else {
                System.loadLibrary("JLOG");
                initialized = true;
            }
        }
    }

    public ZosConsoleHandler() throws Exception {
        if (!initialized) {
            throw new Exception(String.valueOf(this.getClass().getName()) + " is only supported on " + OS_ARCH_390 + " architecture.");
        }
    }

    public ZosConsoleHandler(String string) throws Exception {
        super(string);
        if (!initialized) {
            throw new Exception(String.valueOf(this.getClass().getName()) + " is only supported on " + OS_ARCH_390 + " architecture.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open = true;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.writeTrailer();
                }
                catch (Exception exception) {}
            }
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent logEvent) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            ZosConsoleHandler.zosWTO(this.getFormatter().format(logEvent));
        }
    }

    protected void writeHeader() throws Exception {
        String string = this.getFormatter().getHeader();
        if (string != null) {
            ZosConsoleHandler.zosWTO(string);
        }
    }

    protected void writeTrailer() throws Exception {
        String string = this.getFormatter().getTrailer();
        if (string != null) {
            ZosConsoleHandler.zosWTO(string);
        }
    }

    private static native void zosWTO(String var0) throws Exception;
}

