/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui.connection;

import java.util.Hashtable;
import org.eclipse.aperi.rcp.gui.connection.Server;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ConnectionPreferencesManager {
    private static String SAVED_CONNECTION = "saved_connection";
    private static String LAST_CONNECTION = "last_connection";
    private static String HOST = "host";
    private static String USER = "user";
    private static String PORT = "port";

    public static IEclipsePreferences getConfigurationNode(String string) {
        return new ConfigurationScope().getNode(string);
    }

    public static IEclipsePreferences getSavedConnectionNode(String string) {
        return (IEclipsePreferences)ConnectionPreferencesManager.getConfigurationNode(string).node(SAVED_CONNECTION);
    }

    public static void saveLastConnectionDetail(String string, String string2) {
        ConnectionPreferencesManager.getConfigurationNode(string).put(LAST_CONNECTION, string2);
    }

    public static void saveNewConnectionDetail(String string, String string2, Server server) {
        IEclipsePreferences iEclipsePreferences = (IEclipsePreferences)ConnectionPreferencesManager.getSavedConnectionNode(string).node(string2);
        iEclipsePreferences.put(HOST, server.getHost());
        iEclipsePreferences.put(USER, server.getUser());
        iEclipsePreferences.putInt(PORT, server.getPort());
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public static void removeConnectionDetail(String string, String string2) {
        String string3 = ConnectionPreferencesManager.getLastConnectionDetail(string);
        IEclipsePreferences iEclipsePreferences = ConnectionPreferencesManager.getConfigurationNode(string);
        try {
            if (string2.equals(string3)) {
                iEclipsePreferences.remove(LAST_CONNECTION);
            }
            IEclipsePreferences iEclipsePreferences2 = (IEclipsePreferences)ConnectionPreferencesManager.getSavedConnectionNode(string).node(string2);
            iEclipsePreferences2.removeNode();
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public static Hashtable getSavedConnectionDetails(String string) {
        Hashtable<String, Server> hashtable = new Hashtable<String, Server>();
        int n = 9549;
        try {
            String[] stringArray = ConnectionPreferencesManager.getSavedConnectionNode(string).childrenNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                IEclipsePreferences iEclipsePreferences = (IEclipsePreferences)ConnectionPreferencesManager.getSavedConnectionNode(string).node(stringArray[n2]);
                String string2 = iEclipsePreferences.get(HOST, "");
                String string3 = iEclipsePreferences.get(USER, "");
                n = iEclipsePreferences.getInt(PORT, n);
                Server server = new Server(string2, n, string3, "");
                hashtable.put(stringArray[n2], server);
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    public static String getLastConnectionDetail(String string) {
        return ConnectionPreferencesManager.getConfigurationNode(string).get(LAST_CONNECTION, "");
    }
}

