/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.install.AlterFileList;
import org.eclipse.aperi.install.StorageAlertOSRepoInstall;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public class SilentDatabaseInstall {
    public static boolean exitOnComplete = true;
    public static final Object[] derbyFileParms = new Object[]{"integer", "smallint", "varchar(20) for bit data", "timestamp", "varchar(32000)", "long varchar for bit data", "", "", "current_timestamp", "' '", "", "", "double precision", "varchar(60) for bit data", "", "modify", "", "", "column", "X'4e'", "partition", "default null", "", "varchar(256)", "varchar(512)", "x'000000000000000000000000000000000000000000000000'", "SQL_DESC_DEFAULT_GROUP", "SQL_DESC_DEFAULT_OS_GROUP", "SQL_DESC_DEFAULT_FILESYSTEM_GROUP", "SQL_DESC_DEFAULT_COMPUTER_GROUP", "SQL_DESC_DISCOVERY_ALERT", "SQL_DESC_DISCOVERY_SCHEDULE", "SQL_DESC_HISTORY_ALERT", "SQL_DESC_HISTORY_SCHEDOLE", "SQL_DESC_STAT_BY_OWNER", "SQL_DESC_DATA_LARGEST_DIR", "SQL_DESC_SUM_STATS", "SQL_DESC_MOST_EXTENTS", "SQL_DESC_MOST_UNUSED_SPACE", "SQL_DESC_TABLESPACE_GROUP", "SQL_DESC_PROBE_ALERT", "SQL_DESC_PROBE_COMP_GROUP", "SQL_DESC_SCAN_ALERT", "SQL_DESC_SCAN_TABLESPACE_GROUP", "SQL_DESC_STAT_FILES_SYSTEM", "SQL_DESC_STAT_FILE_SIZE", "SQL_DESC_STAT_FILE_GROUP", "SQL_DESC_STAT_LAST_ACCESSED", "SQL_DESC_STAT_LAST_MODIFIED", "SQL_DESC_STAT_CREAT_TIME", "SQL_DESC_STAT_LAST_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_FILES", "SQL_DESC_DATA_RECENTLY_ACCESSED", "SQL_DESC_DATA_RECENTLY_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_ORPHANED", "SQL_DESC_DATA_RECENTLY_ACCESSED_ORPHANED", "SQL_DESC_NON_OS_FILES", "SQL_DESC_OBSOLETE_FILES_ALERT", "SQL_DESC_FORBID_NON_OS_FILES", "SQL_DESC_ORPHANED_FILES_ALERT", "SQL_DESC_FORBID_ORPHANED_FILES", "SQL_DESC_AT_RISK_FILE_ALERT", "SQL_DESC_NON_OS_NON_BACKEDUP", "SQL_DESC_PING_ALERT", "SQL_DESC_PING_DEFAULT_GROUP", "SQL_DESC_SCAN_DEFAULT_FILESYSTEM_GROUP", "SQL_NAME_DEFAULT_USER_GROUP", "SQL_NAME_DEFAULT_OS_GROUP", "SQL_NAME_DEFAULT_FS_GROUP", "SQL_NAME_DEFAULT_COMPUTER_GROUP", "SQL_NAME_DISCOVERY", "SQL_NAME_AGGREGATOR", "SQL_NAME_DB_USERSPACE", "SQL_NAME_LARGESTTABLES", "SQL_NAME_SUMMARY", "SQL_NAME_SEGMENTMOSTEXTENTS", "SQL_NAME_SEGMENTUNUSED", "SQL_NAME_DEFAULT_TABLESPACEGROUP", "SQL_NAME_DEFAULT_DBPROBE", "SQL_NAME_DEFAULT_DBSCAN", "SQL_NAME_FILE_SIZE", "SQL_NAME_SUMMARY_FILESYS", "SQL_NAME_SUMMARY_OWNER", "SQL_NAME_SUMMARY_GROUP", "SQL_NAME_BYACCESS", "SQL_NAME_BYMODIFICATION", "SQL_NAME_BYCREATION", "SQL_NAME_BYMOD", "SQL_NAME_LARGESTFILES", "SQL_NAME_LARGESTDIR", "SQL_NAME_OBSOLETEFILES", "SQL_NAME_ATRISK", "SQL_NAME_LARGESTORPHANS", "SQL_NAME_OLDESTORPHANS", "SQL_NAME_WASTED", "SQL_NAME_CONSTRAIT", "SQL_NAME_OBSOLETECONSTR", "SQL_NAME_ORPHANEDCONSTR", "SQL_NAME_ATRISKCONSTR", "SQL_NAME_PING", "SQL_NAME_PROBE", "SQL_NAME_SCAN", "SQL_DESC_TEMPFILE", "SQL_NAME_TEMPFILES", "RTRIM (CAST (g.group_id as char(128)))", "SQL_NAME_SUMMARY_FILEEXT", "SQL_DESC_FILE_TYPE", "SQL_NAME_DEFAULT_SS_GROUP", "SQL_DESC_DEFAULT_SS_GROUP", "Default", "x'00'", "bigint", "SQL_NAME_CIMOM_DISCOVERY", "SQL_DESC_CIMOM_DISCOVERY_ALERT", "SQL_DESC_CIMOM_DISCOVERY_SCHEDULE", "SQL_NAME_SNMP_DISCOVERY", "SQL_DESC_SNMP_DISCOVERY_ALERT", "SQL_DESC_SNMP_DISCOVERY_SCHEDULE", "SQL_NAME_NETWARE_DISCOVERY", "SQL_DESC_NETWARE_DISCOVERY_ALERT", "SQL_DESC_NETWARE_DISCOVERY_SCHEDULE", "", "", "", "SQL_DESC_DEFAULT_DISK_JOBS", "SQL_DESC_DEFAULT_FABRIC_JOBS", "SQL_NAME_EXTERNAL_NOTIFICATION", "SQL_DESC_EXTERNAL_NOTIFICATION_ALERT", "SQL_NAME_DISK_ARRAY_DISCOVERY", "SQL_DESC_DISK_ARRAY_DISCOVERY_ALERT", "SQL_NAME_TAPE_ALERT", "SQL_DESC_TAPE_ALERT", "SQL_NAME_DEFAULT_FABRIC_GROUP", "SQL_DESC_DEFAULT_FABRIC_GROUP", "SQL_NAME_DEFAULT_LIBRARIES_GROUP", "SQL_DESC_DEFAULT_LIBRARIES_GROUP"};
    public static final Object[] udbFileParms = new Object[]{"integer", "smallint", "varchar(20) for bit data", "timestamp", "long varchar", "long varchar for bit data", "", "", "current timestamp", "' '", "", "", "float", "varchar(60) for bit data", "", "alter", "set data type", "", "", "x'4e'", "\"partition\"", "", "", "varchar(256)", "varchar(512)", "x'000000000000000000000000000000000000000000000000'", "SQL_DESC_DEFAULT_GROUP", "SQL_DESC_DEFAULT_OS_GROUP", "SQL_DESC_DEFAULT_FILESYSTEM_GROUP", "SQL_DESC_DEFAULT_COMPUTER_GROUP", "SQL_DESC_DISCOVERY_ALERT", "SQL_DESC_DISCOVERY_SCHEDULE", "SQL_DESC_HISTORY_ALERT", "SQL_DESC_HISTORY_SCHEDOLE", "SQL_DESC_STAT_BY_OWNER", "SQL_DESC_DATA_LARGEST_DIR", "SQL_DESC_SUM_STATS", "SQL_DESC_MOST_EXTENTS", "SQL_DESC_MOST_UNUSED_SPACE", "SQL_DESC_TABLESPACE_GROUP", "SQL_DESC_PROBE_ALERT", "SQL_DESC_PROBE_COMP_GROUP", "SQL_DESC_SCAN_ALERT", "SQL_DESC_SCAN_TABLESPACE_GROUP", "SQL_DESC_STAT_FILES_SYSTEM", "SQL_DESC_STAT_FILE_SIZE", "SQL_DESC_STAT_FILE_GROUP", "SQL_DESC_STAT_LAST_ACCESSED", "SQL_DESC_STAT_LAST_MODIFIED", "SQL_DESC_STAT_CREAT_TIME", "SQL_DESC_STAT_LAST_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_FILES", "SQL_DESC_DATA_RECENTLY_ACCESSED", "SQL_DESC_DATA_RECENTLY_MODIFIED_NONBACKEDUP", "SQL_DESC_DATA_LARGEST_ORPHANED", "SQL_DESC_DATA_RECENTLY_ACCESSED_ORPHANED", "SQL_DESC_NON_OS_FILES", "SQL_DESC_OBSOLETE_FILES_ALERT", "SQL_DESC_FORBID_NON_OS_FILES", "SQL_DESC_ORPHANED_FILES_ALERT", "SQL_DESC_FORBID_ORPHANED_FILES", "SQL_DESC_AT_RISK_FILE_ALERT", "SQL_DESC_NON_OS_NON_BACKEDUP", "SQL_DESC_PING_ALERT", "SQL_DESC_PING_DEFAULT_GROUP", "SQL_DESC_SCAN_DEFAULT_FILESYSTEM_GROUP", "SQL_NAME_DEFAULT_USER_GROUP", "SQL_NAME_DEFAULT_OS_GROUP", "SQL_NAME_DEFAULT_FS_GROUP", "SQL_NAME_DEFAULT_COMPUTER_GROUP", "SQL_NAME_DISCOVERY", "SQL_NAME_AGGREGATOR", "SQL_NAME_DB_USERSPACE", "SQL_NAME_LARGESTTABLES", "SQL_NAME_SUMMARY", "SQL_NAME_SEGMENTMOSTEXTENTS", "SQL_NAME_SEGMENTUNUSED", "SQL_NAME_DEFAULT_TABLESPACEGROUP", "SQL_NAME_DEFAULT_DBPROBE", "SQL_NAME_DEFAULT_DBSCAN", "SQL_NAME_FILE_SIZE", "SQL_NAME_SUMMARY_FILESYS", "SQL_NAME_SUMMARY_OWNER", "SQL_NAME_SUMMARY_GROUP", "SQL_NAME_BYACCESS", "SQL_NAME_BYMODIFICATION", "SQL_NAME_BYCREATION", "SQL_NAME_BYMOD", "SQL_NAME_LARGESTFILES", "SQL_NAME_LARGESTDIR", "SQL_NAME_OBSOLETEFILES", "SQL_NAME_ATRISK", "SQL_NAME_LARGESTORPHANS", "SQL_NAME_OLDESTORPHANS", "SQL_NAME_WASTED", "SQL_NAME_CONSTRAIT", "SQL_NAME_OBSOLETECONSTR", "SQL_NAME_ORPHANEDCONSTR", "SQL_NAME_ATRISKCONSTR", "SQL_NAME_PING", "SQL_NAME_PROBE", "SQL_NAME_SCAN", "SQL_DESC_TEMPFILE", "SQL_NAME_TEMPFILES", "RTRIM (CAST (g.group_id as char(128)))", "SQL_NAME_SUMMARY_FILEEXT", "SQL_DESC_FILE_TYPE", "SQL_NAME_DEFAULT_SS_GROUP", "SQL_DESC_DEFAULT_SS_GROUP", "Default", "x'00'", "bigint", "SQL_NAME_CIMOM_DISCOVERY", "SQL_DESC_CIMOM_DISCOVERY_ALERT", "SQL_DESC_CIMOM_DISCOVERY_SCHEDULE", "SQL_NAME_SNMP_DISCOVERY", "SQL_DESC_SNMP_DISCOVERY_ALERT", "SQL_DESC_SNMP_DISCOVERY_SCHEDULE", "SQL_NAME_NETWARE_DISCOVERY", "SQL_DESC_NETWARE_DISCOVERY_ALERT", "SQL_DESC_NETWARE_DISCOVERY_SCHEDULE", "", "", "", "SQL_DESC_DEFAULT_DISK_JOBS", "SQL_DESC_DEFAULT_FABRIC_JOBS", "SQL_NAME_EXTERNAL_NOTIFICATION", "SQL_DESC_EXTERNAL_NOTIFICATION_ALERT", "SQL_NAME_DISK_ARRAY_DISCOVERY", "SQL_DESC_DISK_ARRAY_DISCOVERY_ALERT", "SQL_NAME_TAPE_ALERT", "SQL_DESC_TAPE_ALERT", "SQL_NAME_DEFAULT_FABRIC_GROUP", "SQL_DESC_DEFAULT_FABRIC_GROUP", "SQL_NAME_DEFAULT_LIBRARIES_GROUP", "SQL_DESC_DEFAULT_LIBRARIES_GROUP"};
    private int fileIndex;
    private String[] sqlFiles;
    private static final String MODE_LABEL = "mode";
    private static final String JDBC_DRIVER_LABEL = "jdbcdriver";
    private static final String DBMS_TYPE_LABEL = "dbmstype";
    private static final String SCHEMA_LABEL = "schema";
    private static final String DATABASE_LABEL = "database";
    private static final String DB_HOST_LABEL = "dbhost";
    private static final String DB_PORT_LABEL = "dbport";
    private static final String DB_USER_LABEL = "dbuser";
    private static final String DB_PASSWORD_LABEL = "dbpassword";
    private static final String PATH_LABEL = "path";
    public String m_sMode;
    private String m_sJdbcDriver;
    private String m_sDbmsType;
    private String m_sSchema;
    private String m_sDatabase;
    private String m_sDbPort;
    private String m_sDbUser;
    private String m_sDbPassWord;
    private String m_sHost;
    private String m_sUrl;
    private DBConnPoolDataSource m_dbConnPool;
    private DBConnection m_dbConn;
    private String m_sSchemaPath;

    private int prepFiles(BufferedReader[] bufferedReaderArray) {
        int n = 0;
        try {
            this.fileIndex = 0;
            while (this.fileIndex < bufferedReaderArray.length) {
                String string = String.valueOf(this.m_sSchemaPath) + File.separator + this.sqlFiles[this.fileIndex];
                this.trace("DEBUG SDI prepFiles sqlFile " + string);
                FileInputStream fileInputStream = new FileInputStream(string);
                bufferedReaderArray[this.fileIndex] = new BufferedReader(new InputStreamReader(fileInputStream));
                String string2 = bufferedReaderArray[this.fileIndex].readLine();
                if (string2 != null && string2.regionMatches(true, 0, "sqlcount", 0, 8)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " =", false);
                    stringTokenizer.nextToken();
                    n += Integer.parseInt(stringTokenizer.nextToken());
                }
                ++this.fileIndex;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private void formatLine(String string, StringBuffer stringBuffer, Object[] objectArray) {
        int n = 0;
        boolean bl = false;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '{') {
                int n2 = 0;
                while (Character.isDigit(string.charAt(++n))) {
                    n2 *= 10;
                    n2 += string.charAt(n) - 48;
                }
                stringBuffer.append(objectArray[n2].toString());
            } else {
                if (c == '\'') {
                    bl = !bl;
                }
                if (!bl && c == '#') {
                    n = string.length();
                } else {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append(" ");
    }

    public void executeSql(Statement statement, String string) {
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            System.err.println(string);
            sQLException.printStackTrace();
        }
    }

    private void executeSql(String string) {
        try {
            Statement statement = null;
            statement = this.m_dbConn.getConnection().createStatement();
            this.executeSql(statement, string);
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            System.err.println(string);
            sQLException.printStackTrace();
        }
    }

    private void trace(String string) {
        System.out.println(string);
    }

    private void printUsage() {
        System.out.println("SilentDatabaseInstall Error");
        System.out.println("Usage: SilentDatabaseInstall <parameters> ");
        System.out.println("where parameters are: ");
        System.out.println("");
        System.out.println("required overall parameters");
        System.out.println("  -mode                 [install,uninstall,upgrade]");
        System.out.println("  -jdbcdriver           <jdbcdriver>");
        System.out.println("  -dbmstype             [derby]");
        System.out.println("  -schema               <schema>");
        System.out.println("  -database             <database>");
        System.out.println("  -dbport               <dbport>");
        System.out.println("  -dbuser               <dbuser>");
        System.out.println("  -dbpassword           <dbpassword>");
        System.out.println("  -path           <path>");
    }

    private void initialize() {
        this.m_sMode = null;
        this.m_sJdbcDriver = null;
        this.m_sDbmsType = null;
        this.m_sSchema = null;
        this.m_sDatabase = null;
        this.m_sDbPort = null;
        this.m_sDbUser = null;
        this.m_sDbPassWord = null;
        this.m_sHost = "localhost";
        this.m_sUrl = null;
        this.m_sSchemaPath = null;
    }

    private void parseParameters(String[] stringArray) throws Exception {
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() < 2) {
                if (stringArray[n].compareTo("<") != 0 || stringArray[n + 1].compareTo("NUL") != 0) {
                    throw new Exception("Invalid Parameter Name: " + stringArray[n]);
                }
            } else {
                String string = stringArray[n].substring(1);
                String string2 = stringArray[n + 1];
                if (string.equals(MODE_LABEL)) {
                    this.m_sMode = string2;
                } else if (string.equals(JDBC_DRIVER_LABEL)) {
                    this.m_sJdbcDriver = string2;
                } else if (string.equals(DBMS_TYPE_LABEL)) {
                    this.m_sDbmsType = string2;
                } else if (string.equals(SCHEMA_LABEL)) {
                    this.m_sSchema = string2;
                } else if (string.equals(DATABASE_LABEL)) {
                    this.m_sDatabase = string2;
                } else if (string.equals(DB_PORT_LABEL)) {
                    this.m_sDbPort = string2;
                } else if (string.equals(DB_HOST_LABEL)) {
                    this.m_sHost = string2;
                } else if (string.equals(DB_USER_LABEL)) {
                    this.m_sDbUser = string2;
                } else if (string.equals(PATH_LABEL)) {
                    this.m_sSchemaPath = string2;
                } else if (string.equals(DB_PASSWORD_LABEL)) {
                    String string3;
                    try {
                        string3 = SRMCrypto.decrypt((String)string2);
                    }
                    catch (Exception exception) {
                        throw new Exception();
                    }
                    this.m_sDbPassWord = string3;
                }
            }
            n += 2;
        }
        this.doRepositoryOption();
    }

    public int executeCommand(String[] stringArray) throws Exception {
        Process process = null;
        int n = 0;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            StrmCopier strmCopier = new StrmCopier(process.getInputStream(), System.out);
            StrmCopier strmCopier2 = new StrmCopier(process.getErrorStream(), System.err);
            strmCopier.start();
            strmCopier2.start();
            process.getOutputStream().close();
            process.waitFor();
            strmCopier.join();
            strmCopier2.join();
        }
        catch (Exception exception) {
            n = -1;
            exception.printStackTrace();
        }
        return n;
    }

    static boolean isDefined(String string) {
        return string != null && string.length() > 0;
    }

    private void doRepositoryOption() throws Exception {
        if (this.m_sDbmsType.equals("derby")) {
            SQLUtil.repositoryType = (byte)7;
        } else if (this.m_sDbmsType.equals("db2")) {
            SQLUtil.repositoryType = (byte)5;
        } else {
            System.err.println("Unrecognized database type " + this.m_sDbmsType);
            if (exitOnComplete) {
                System.exit(1);
            }
        }
    }

    private Object[] getFileSqlParms() {
        Object[] objectArray = null;
        switch (SQLUtil.repositoryType) {
            case 7: {
                objectArray = derbyFileParms;
                break;
            }
            case 5: {
                objectArray = udbFileParms;
            }
        }
        return objectArray;
    }

    private void doDerbyRepositoryCreate() {
        String[] stringArray = new String[]{"CREATE SCHEMA " + this.m_sSchema, "SET SCHEMA=" + this.m_sSchema};
        int n = 0;
        while (n < stringArray.length) {
            this.trace("DEBUG SDI doInstall 1.5 " + stringArray[n]);
            this.executeSql(stringArray[n]);
            ++n;
        }
    }

    private void doRepositoryCreate() {
        if (SQLUtil.repositoryType == 7) {
            this.doDerbyRepositoryCreate();
        }
    }

    private void doDerbyRepositoryUpgrade() {
        String[] stringArray = new String[]{"SET SCHEMA=" + this.m_sSchema};
        int n = 0;
        while (n < stringArray.length) {
            this.trace("DEBUG SDI doUpgrade 1.5 " + stringArray[n]);
            this.executeSql(stringArray[n]);
            ++n;
        }
    }

    private void doRepositoryUpgrade() {
        if (SQLUtil.repositoryType == 7) {
            this.doDerbyRepositoryUpgrade();
        }
    }

    private void doInstall() throws Exception {
        this.trace("DEBUG SDI doInstall begin");
        Object[] objectArray = null;
        this.trace("DEBUG SDI doInstall 1 calling doRepositorySpace");
        this.doRepositoryCreate();
        objectArray = this.getFileSqlParms();
        this.createTables(objectArray, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTables(Object[] var1_1, SoftwareVersion var2_2) throws Exception {
        block21: {
            block22: {
                var3_3 = null;
                this.trace("DEBUG SDI doInstall 2 1 ");
                try {
                    try {
                        this.sqlFiles = AlterFileList.getFiles(var2_2, this.m_sSchemaPath);
                        var3_3 = new BufferedReader[this.sqlFiles.length];
                        this.trace("DEBUG SDI doInstall 2 4 ");
                        this.prepFiles(var3_3);
                        this.trace("DEBUG SDI doInstall 3");
                        this.trace("DEBUG SDI doInstall 8");
                        var4_4 = new StringBuffer(1024);
                        var5_6 = 0;
                        this.fileIndex = 0;
lbl15:
                        // 2 sources

                        while (true) {
                            block25: {
                                if (this.fileIndex < this.sqlFiles.length) break block25;
                                this.trace("DEBUG SDI doInstall 11");
                                var6_8 = false;
                                var7_9 = new StorageAlertOSRepoInstall(this.m_dbConn);
                                var6_8 = var7_9.process();
                                this.trace("DEBUG SDI doInstall 12 status " + var6_8);
                                try {}
                                catch (Exception var8_12) {
                                    var8_12.printStackTrace();
                                }
                                ** GOTO lbl-1000
                            }
                            var6_7 = var3_3[this.fileIndex];
                            var5_6 = AlterFileList.getFileVRM(this.sqlFiles[this.fileIndex]);
                            this.trace("DEBUG SDI doInstall 8.5 fileIndex = " + this.fileIndex);
                            if (true) ** GOTO lbl71
lbl-1000:
                            // 1 sources

                            {
                                var8_11 = SoftwareVersion.decodeToSV((int)var5_6);
                                if (var2_2 == null) {
                                    this.insertIntoUpgradeLog(var8_11);
                                } else {
                                    this.finishOffUpgradeLog(var8_11);
                                }
                                this.m_dbConn.commit();
                            }
                            break;
                        }
                    }
                    catch (Exception var4_5) {
                        var4_5.printStackTrace();
                    }
                    var10_16 = null;
                    this.trace("DEBUG SDI doInstall 14");
                    if (var3_3 == null) break block21;
                    var12_18 = 0;
                    if (true) ** GOTO lbl95
                }
                catch (Throwable var11_14) {
                    var10_15 = null;
                    this.trace("DEBUG SDI doInstall 14");
                    if (var3_3 == null) break block22;
                    var12_17 = 0;
                    if (true) ** GOTO lbl83
                }
                do {
                    if (var7_9.length() <= 0) continue;
                    var8_10 = 0;
                    var9_13 = false;
                    while (var7_9.charAt(var8_10) == ' ' || var7_9.charAt(var8_10) == '\t') {
                        if (++var8_10 != var7_9.length()) continue;
                        var7_9 = "";
                        var9_13 = true;
                        break;
                    }
                    if (var9_13 || var7_9.charAt(var8_10) == '#' || var7_9.startsWith("--", var8_10) || var7_9.startsWith("sqlcount", var8_10)) continue;
                    if (var7_9.charAt(var8_10) == ';') {
                        this.trace("DEBUG SDI doInstall 9 " + var4_4.toString());
                        this.executeSql(var4_4.toString());
                        var4_4.setLength(0);
                        continue;
                    }
                    this.formatLine((String)var7_9, var4_4, var1_1);
lbl71:
                    // 5 sources

                } while ((var7_9 = var6_7.readLine()) != null);
                ++this.fileIndex;
                ** while (true)
                do {
                    if (var3_3[var12_17] != null) {
                        try {
                            var3_3[var12_17].close();
                        }
                        catch (IOException var13_19) {
                            this.trace("SilentDatabaseInstall::doInstall ignored io " + var13_19);
                        }
                    }
                    ++var12_17;
lbl83:
                    // 2 sources

                } while (var12_17 < var3_3.length);
            }
            throw var11_14;
            do {
                block24: {
                    if (var3_3[var12_18] != null) {
                        ** try [egrp 3[TRYBLOCK] [4 : 478->488)] { 
lbl89:
                        // 1 sources

                        var3_3[var12_18].close();
                        break block24;
lbl91:
                        // 1 sources

                        catch (IOException var13_20) {
                            this.trace("SilentDatabaseInstall::doInstall ignored io " + var13_20);
                        }
                    }
                }
                ++var12_18;
lbl95:
                // 2 sources

            } while (var12_18 < var3_3.length);
        }
        this.trace("DEBUG SDI doInstall 15");
    }

    private void insertIntoUpgradeLog(SoftwareVersion softwareVersion) throws Exception {
        Statement statement = this.m_dbConn.getConnection().createStatement();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("insert into t_upgrade_log values ('");
        stringBuffer.append(softwareVersion.svVendor);
        stringBuffer.append("', ");
        stringBuffer.append(softwareVersion.svVersion);
        stringBuffer.append(", ");
        stringBuffer.append(softwareVersion.svRelease);
        stringBuffer.append(", ");
        stringBuffer.append(softwareVersion.svModification);
        stringBuffer.append(", ");
        stringBuffer.append(softwareVersion.svSubModification);
        stringBuffer.append(", 0)");
        this.executeSql(statement, stringBuffer.toString());
        statement.close();
    }

    private void finishOffUpgradeLog(SoftwareVersion softwareVersion) throws Exception {
        Statement statement = this.m_dbConn.getConnection().createStatement();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.setLength(0);
        stringBuffer.append("update t_upgrade_log set vendor = '");
        stringBuffer.append(softwareVersion.svVendor);
        stringBuffer.append("', versn = ");
        stringBuffer.append(softwareVersion.svVersion);
        stringBuffer.append(", release = ");
        stringBuffer.append(softwareVersion.svRelease);
        stringBuffer.append(", modification = ");
        stringBuffer.append(softwareVersion.svModification);
        stringBuffer.append(", submodification = ");
        stringBuffer.append(softwareVersion.svSubModification);
        stringBuffer.append(", statement_number = 0");
        this.executeSql(statement, stringBuffer.toString());
        statement.close();
    }

    private void doUninstall() throws Exception {
    }

    private void doUpgrade() throws Exception {
        this.trace("DEBUG SDI doUpgrade begin");
        try {
            this.doRepositoryUpgrade();
            Object[] objectArray = null;
            SoftwareVersion softwareVersion = this.getCurrentSWVersion();
            objectArray = this.getFileSqlParms();
            this.createTables(objectArray, softwareVersion);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.trace("DEBUG SDI doUpgrade end");
    }

    private SoftwareVersion getCurrentSWVersion() {
        ResultSet resultSet = null;
        SoftwareVersion softwareVersion = new SoftwareVersion();
        try {
            Statement statement = this.m_dbConn.getConnection().createStatement();
            resultSet = statement.executeQuery("select versn, release, modification, submodification, vendor from t_upgrade_log");
            if (resultSet.next()) {
                softwareVersion.svVersion = resultSet.getByte(1);
                softwareVersion.svRelease = resultSet.getByte(2);
                softwareVersion.svModification = resultSet.getShort(3);
                softwareVersion.svSubModification = resultSet.getShort(4);
                softwareVersion.svVendor = resultSet.getByte(5);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return softwareVersion;
    }

    public SilentDatabaseInstall() {
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        SilentDatabaseInstall silentDatabaseInstall;
        block13: {
            silentDatabaseInstall = new SilentDatabaseInstall();
            String[] stringArray2 = stringArray;
            DBConstants.useLogging = false;
            System.setProperty("tpc.environment", "Device_Server");
            System.setProperty("tsnm.baseDir", "C:\\");
            try {
                silentDatabaseInstall.parseParameters(stringArray2);
                silentDatabaseInstall.trace("DEBUG SDI calling analyzeParameters");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                silentDatabaseInstall.printUsage();
                if (!exitOnComplete) break block13;
                System.exit(1);
            }
        }
        try {
            block14: {
                try {
                    silentDatabaseInstall.initializeApi(SQLUtil.repositoryType);
                    silentDatabaseInstall.trace("DEBUG SDI thats it for now");
                    if (silentDatabaseInstall.m_sMode.equals("install")) {
                        silentDatabaseInstall.doInstall();
                        break block14;
                    }
                    if (silentDatabaseInstall.m_sMode.equals("uninstall")) {
                        silentDatabaseInstall.doUninstall();
                        break block14;
                    }
                    if (silentDatabaseInstall.m_sMode.equals("upgrade")) {
                        silentDatabaseInstall.doUpgrade();
                        break block14;
                    }
                    MessageLog.logMessage((String)("ERROR SilentDatabaseInstall Invalid mode " + silentDatabaseInstall.m_sMode));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!exitOnComplete) break block14;
                    System.exit(1);
                }
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                silentDatabaseInstall.terminateApi();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        silentDatabaseInstall.terminateApi();
        System.out.println("Database installation successful.");
        if (!exitOnComplete) return;
        System.exit(0);
    }

    void initializeApi(byte by) throws Exception {
        if (by == 7) {
            this.m_sUrl = "jdbc:derby://" + this.m_sHost + ":" + this.m_sDbPort + "/" + this.m_sDatabase + ";create=true";
        } else if (by == 5) {
            this.m_sUrl = "jdbc:db2://" + this.m_sHost + ":" + this.m_sDbPort + "/" + this.m_sDatabase;
        }
        DBConnPoolDataSource.initialize((String)this.m_sJdbcDriver, (String)this.m_sUrl, (String)this.m_sSchema, (String)this.m_sDbUser, (String)this.m_sDbPassWord, (int)2);
        this.m_dbConnPool = DBConnPoolDataSource.getInstance();
        try {
            this.m_dbConn = (DBConnection)this.m_dbConnPool.getPooledConnection();
            this.m_dbConn.setSchema(this.m_sSchema);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            String string = SQLUtil.getSQLExceptionMsg("INS2071E", sQLException, null);
            throw new Exception(String.valueOf(string) + " initializeApi failed in getPooledConnection");
        }
    }

    void terminateApi() throws Exception {
        if (this.m_dbConn != null) {
            try {
                this.m_dbConn.close();
                this.m_dbConn = null;
            }
            catch (SQLException sQLException) {
                throw new Exception("terminatepi failed in close");
            }
        }
    }

    private class StrmCopier
    extends Thread {
        InputStream instrm = null;
        PrintStream outstrm = null;

        StrmCopier(InputStream inputStream, PrintStream printStream) {
            this.instrm = inputStream;
            this.outstrm = printStream;
        }

        public void run() {
            try {
                byte[] byArray = new byte[1024];
                int n = this.instrm.read(byArray);
                while (n >= 0) {
                    if (n > 0) {
                        this.outstrm.write(byArray, 0, n);
                    }
                    n = this.instrm.read(byArray);
                }
                this.instrm.close();
            }
            catch (IOException iOException) {
                this.outstrm.println("Could not copy stream!!");
                iOException.printStackTrace();
                iOException.printStackTrace(this.outstrm);
            }
        }
    }
}

