/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;

public class ConnectionPool {
    private Driver repositoryDriver;
    private Connection[] pool;
    private String repositoryURL;
    private Properties connectProperties;
    private int openConnections = 0;
    private int poolIndex = 0;
    private int poolSize;
    public String udbSqlid;

    public ConnectionPool(String string, String string2, Properties properties, int n) throws ClassNotFoundException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ConnectionPool", (String)"driverName, repositoryURL, connectProperties, poolSize");
        }
        this.repositoryURL = string2;
        this.connectProperties = properties;
        this.poolSize = n;
        this.pool = new Connection[n > 0 ? n : 1];
        Class.forName(string);
        this.repositoryDriver = DriverManager.getDriver(string2);
        if (SQLUtil.isUDB()) {
            this.udbSqlid = this.connectProperties.getProperty("schema");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ConnectionPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePool() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"freePool", (String)"");
        }
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            block17: {
                int n = 0;
                while (n < this.poolSize) {
                    if (this.pool[n] != null) {
                        this.closeConnection(this.pool[n]);
                    }
                    ++n;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (SQLUtil.isCloudscape()) {
                    try {
                        this.repositoryDriver.connect("jdbc:db2j:;shutdown=true", this.connectProperties);
                    }
                    catch (SQLException sQLException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"freePool", (Throwable)sQLException);
                        }
                        if (sQLException.getSQLState().equals("XJ015")) break block17;
                        SQLUtil.logSQLException("SRV0045E", sQLException, null);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"freePool");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConnection", (String)"messageWanted");
        }
        Connection connection = null;
        Object object = this.pool;
        synchronized (this.pool) {
            if (this.poolIndex > 0) {
                --this.poolIndex;
                connection = this.pool[this.poolIndex];
                this.pool[this.poolIndex] = null;
            } else {
                ++this.openConnections;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getConnection", (Throwable)sQLException);
                    }
                    if (bl) {
                        SQLUtil.logSQLException("SRV0046E", sQLException, null);
                    }
                    this.closeConnection(connection);
                    this.decrementOpenConnections();
                    Connection connection2 = this.getConnection(bl);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getConnection", (Object)connection2);
                    }
                    return connection2;
                }
                SQLUtil.setHoldability(connection, true);
                object = connection;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getConnection", (Object)object);
                }
                return object;
            }
            try {
                connection = this.repositoryDriver.connect(this.repositoryURL, this.connectProperties);
                connection.setAutoCommit(false);
                if (!SQLUtil.isOracle()) {
                    connection.setTransactionIsolation(2);
                }
                if (SQLUtil.isUDB()) {
                    object = connection.createStatement();
                    object.executeUpdate("set current schema = " + this.udbSqlid);
                    object.close();
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getConnection", (Throwable)sQLException);
                }
                if (bl) {
                    SQLUtil.logSQLException("SRV0044E", sQLException, new Object[]{this.repositoryDriver, this.repositoryURL});
                }
                this.decrementOpenConnections();
            }
            SQLUtil.setHoldability(connection, true);
            object = connection;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getConnection", (Object)object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementOpenConnections() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"decrementOpenConnections", (String)"");
        }
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            --this.openConnections;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"decrementOpenConnections");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"returnConnection", (String)"dbConnection");
        }
        if (connection == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"returnConnection");
            }
            return;
        }
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            if (this.openConnections <= this.poolSize && this.poolIndex < this.poolSize) {
                this.pool[this.poolIndex] = connection;
                ++this.poolIndex;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"returnConnection");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            --this.openConnections;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.closeConnection(connection);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"returnConnection");
            }
            return;
        }
    }

    public int getConnectionCount() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConnectionCount", (String)"");
        }
        int n = this.openConnections;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConnectionCount", (int)n);
        }
        return n;
    }

    public int getPoolElementCount() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPoolElementCount", (String)"");
        }
        int n = this.poolIndex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPoolElementCount", (int)n);
        }
        return n;
    }

    private void closeConnection(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeConnection", (String)"dbConnection");
        }
        try {
            if (!connection.isClosed()) {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"closeConnection", (Throwable)sQLException);
            }
            SQLUtil.logSQLException("SRV0045E", sQLException, null);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeConnection");
        }
    }
}

