/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.UninstallAgentDriver;
import org.eclipse.aperi.server.alerts.BaseAlerter;
import org.eclipse.aperi.server.alerts.DiscoveryAlerter;
import org.eclipse.aperi.server.alerts.ProbeAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class FilerSaver {
    private Connection dbc;
    private boolean updateScheduler;
    private int[] lockedTrees;
    private long discoveryTime;
    private TResShare shareAccessor;
    private TFoundFilesystem foundFsAccessor;
    private Share shareBuffer = new Share();
    private boolean nasInstalled;
    private LdapTree dummyNasTree;
    private int nasShareID;
    private short nasShareOwnerType;
    private boolean triggerAlerts;
    private short resourceType;
    private short alertType;
    private byte subProduct;
    public Settings settings;
    private static final int[][] varBindOIDs = new int[4][];
    private static final String[] tecSlotNames;
    private static final long MILLIS_PER_DAY = 86400000L;

    static {
        FilerSaver.varBindOIDs[0] = BaseAlerter.COMPUTER_OID;
        FilerSaver.varBindOIDs[1] = BaseAlerter.RESOURCE_TYPE_OID;
        FilerSaver.varBindOIDs[2] = BaseAlerter.RESOURCE_NAME_OID;
        FilerSaver.varBindOIDs[3] = Alerter.ALERT_TYPE_OID;
        tecSlotNames = new String[4];
        FilerSaver.tecSlotNames[0] = "hostname";
        FilerSaver.tecSlotNames[1] = "resourceType";
        FilerSaver.tecSlotNames[2] = "resourceName";
        FilerSaver.tecSlotNames[3] = "alertType";
    }

    public void handleMissingVSs(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleMissingVSs", (String)"clusterID");
        }
        this.getSettings();
        this.resourceType = (short)99;
        this.dummyNasTree.ltTreeID = n;
        Share share = this.handleMissingFilers(null);
        if (share != null) {
            TResCluster tResCluster = new TResCluster(this.dbc);
            tResCluster.cleanupCluster(n);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleMissingVSs");
        }
    }

    public FilerSaver(Connection connection, int n) {
        this(connection, n, 1, false, null, null);
    }

    public FilerSaver(Connection connection, int n, short s, boolean bl, Settings settings, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"FilerSaver", (String)"dbc, nasShareID, pNasShareOwnerType, triggerAlerts, pSettings, nasShareOwnerName");
        }
        try {
            this.discoveryTime = SQLUtil.getTimestamp(connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"FilerSaver", (Throwable)exception);
            }
            return;
        }
        this.dbc = connection;
        this.nasShareID = n;
        this.nasShareOwnerType = s;
        this.triggerAlerts = bl;
        this.settings = settings;
        this.dummyNasTree = new LdapTree();
        this.dummyNasTree.ltTreeID = n;
        this.dummyNasTree.setLtName(string);
        this.shareAccessor = new TResShare(connection);
        this.foundFsAccessor = new TFoundFilesystem(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"FilerSaver");
        }
    }

    private void getSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSettings", (String)"");
        }
        if (this.settings == null) {
            TStormSettings tStormSettings = new TStormSettings(this.dbc);
            this.settings = tStormSettings.getSettings();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSettings");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveDiscoveryData(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDiscoveryData", (String)"filerList");
        }
        this.nasInstalled = true;
        this.getSettings();
        LdapTree ldapTree = this.getTreeList(nasFiler);
        this.lockTrees(ldapTree, true);
        this.resourceType = this.nasShareOwnerType == 103 ? this.nasShareOwnerType : (short)1;
        this.alertType = (short)80;
        this.subProduct = 0;
        try {
            if (!this.nasInstalled) {
                nasFiler = this.pruneFilers(nasFiler);
            }
            nasFiler = this.saveFilers(nasFiler, true);
            this.saveDomains(nasFiler);
            this.saveFilesystems(nasFiler);
            this.handleMissingFilers(ldapTree);
            this.checkNewStorageAlerts(nasFiler);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unlockTrees();
            if (this.updateScheduler) {
                ScheduleQueue.routine.rebuild();
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.unlockTrees();
        if (this.updateScheduler) {
            ScheduleQueue.routine.rebuild();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDiscoveryData");
        }
    }

    public void saveDiskArrays(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDiskArrays", (String)"diskArrayList");
        }
        this.getSettings();
        this.resourceType = (short)78;
        this.alertType = (short)82;
        this.subProduct = 1;
        this.saveFilers(nasFiler, false);
        this.handleMissingFilers(null);
        this.checkNewStorageAlerts(nasFiler);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDiskArrays");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveProbeData(Computer computer) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveProbeData", (String)"computer");
        }
        NasFiler nasFiler = computer.cmpNasFiler;
        LdapTree ldapTree = this.getTreeList(nasFiler);
        this.lockTrees(ldapTree, false);
        try {
            if (!Constants.isDiskArray((short)nasFiler.nfOSType)) {
                this.saveVirtualServers(nasFiler, computer.cmpID);
                this.updateVSProbeTime(computer.cmpCluster);
            }
            this.saveProbeResults(computer.cmpID, nasFiler);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlockTrees();
            if (this.updateScheduler) {
                ScheduleQueue.routine.rebuild();
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.unlockTrees();
        if (this.updateScheduler) {
            ScheduleQueue.routine.rebuild();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveProbeData");
        }
    }

    private LdapTree getTreeList(NasFiler nasFiler) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTreeList", (String)"filerList");
        }
        LdapTree ldapTree = null;
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            LdapTree ldapTree2 = nasFiler2.nfLdapTree;
            if (ldapTree2 != null && ldapTree2.ltComputerID != -1) {
                ldapTree2.ltComputerID = -1;
                ldapTree2.ltNext = ldapTree;
                ldapTree = ldapTree2;
            }
            nasFiler2 = nasFiler2.nfNext;
        }
        nasFiler2 = ldapTree;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTreeList", (Object)nasFiler2);
        }
        return nasFiler2;
    }

    private void lockTrees(LdapTree ldapTree, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"lockTrees", (String)"treeList, isDiscoveryData");
        }
        int n = 0;
        LdapTree ldapTree2 = ldapTree;
        while (ldapTree2 != null) {
            ++n;
            ldapTree2 = ldapTree2.ltNext;
        }
        this.lockedTrees = new int[n];
        ldapTree2 = ldapTree;
        while (ldapTree2 != null) {
            this.lockedTrees[--n] = ldapTree2.ltTreeID;
            ldapTree2 = ldapTree2.ltNext;
        }
        Arrays.sort(this.lockedTrees);
        int n2 = 0;
        while (n2 < this.lockedTrees.length) {
            LockManager.lock((short)0, (String)"LdapTree", (String)String.valueOf(this.lockedTrees[n2]), (byte)(bl ? (byte)1 : 2), (boolean)true);
            ++n2;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lockTrees");
        }
    }

    private void unlockTrees() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"unlockTrees", (String)"");
        }
        if (this.lockedTrees != null) {
            int n = 0;
            while (n < this.lockedTrees.length) {
                if (this.lockedTrees[n] > 0) {
                    LockManager.unLock((short)0, (String)"LdapTree", (String)String.valueOf(this.lockedTrees[n]));
                }
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"unlockTrees");
        }
    }

    private NasFiler pruneFilers(NasFiler nasFiler) {
        NasFiler nasFiler2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"pruneFilers", (String)"filerList");
        }
        NasFiler nasFiler3 = null;
        while (nasFiler != null) {
            nasFiler2 = nasFiler;
            nasFiler = nasFiler2.nfNext;
            if (nasFiler2.nfComputer.cmpOSType != 8) continue;
            nasFiler2.nfNext = nasFiler3;
            nasFiler3 = nasFiler2;
        }
        nasFiler2 = nasFiler3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"pruneFilers", (Object)nasFiler2);
        }
        return nasFiler2;
    }

    private NasFiler saveFilers(NasFiler nasFiler, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveFilers", (String)"filerList, mightBeAgents");
        }
        TResComputer tResComputer = new TResComputer(this.dbc);
        tResComputer.getIDs(nasFiler);
        if (bl) {
            nasFiler = this.pruneAgents(nasFiler);
        }
        Share share = new Share();
        share.shScanTime = this.discoveryTime;
        share.shResourceType = this.resourceType;
        this.shareAccessor = new TResShare(this.dbc);
        this.shareAccessor.prepSave();
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            boolean bl2 = nasFiler2.nfNewFiler;
            nasFiler2.nfComputer.cmpID = nasFiler2.nfComputerID;
            if (nasFiler2.nfLdapTree == null) {
                nasFiler2.nfLdapTree = this.dummyNasTree;
            }
            LdapTree ldapTree = nasFiler2.nfLdapTree;
            if (!nasFiler2.nfNewFiler) {
                ldapTree.ltHasComputers = true;
            }
            if (Constants.isCimomManaged((short)nasFiler2.nfComputer.cmpOSType)) {
                share.shPath = nasFiler2.nfnameSpace;
            }
            share.shComputerID = ldapTree.ltTreeID;
            share.shResourceID = nasFiler2.nfComputerID;
            if (this.nasShareOwnerType == 103 && !nasFiler2.nfNewFiler && !this.shareAccessor.getShareExists(share.shComputerID, share.shResourceID, share.shResourceType)) {
                bl2 = true;
            }
            this.shareAccessor.saveShare(share, bl2);
            this.shareAccessor.commit();
            nasFiler2 = nasFiler2.nfNext;
        }
        this.shareAccessor.closeSave();
        nasFiler2 = nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFilers", (Object)nasFiler2);
        }
        return nasFiler2;
    }

    private NasFiler pruneAgents(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"pruneAgents", (String)"filerList");
        }
        NasFiler nasFiler2 = null;
        AgentManager agentManager = Server.getAgentManager();
        NasFiler nasFiler3 = nasFiler;
        while (nasFiler3 != null) {
            if (agentManager.get(nasFiler3.nfComputerID) != null) {
                if (this.nasShareOwnerType == 103) {
                    throw new GeneralException(MessageLog.getMessage((String)"NAS0025E", (Object)nasFiler3.nfNetworkName));
                }
                if (nasFiler2 == null) {
                    nasFiler = nasFiler3.nfNext;
                } else {
                    nasFiler2.nfNext = nasFiler3.nfNext;
                }
            } else {
                nasFiler2 = nasFiler3;
            }
            nasFiler3 = nasFiler3.nfNext;
        }
        nasFiler3 = nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"pruneAgents", (Object)nasFiler3);
        }
        return nasFiler3;
    }

    private void saveDomains(NasFiler nasFiler) throws GeneralException {
        Domain domain;
        Computer computer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDomains", (String)"filerList");
        }
        Domain domain2 = null;
        Object object = nasFiler;
        while (object != null) {
            computer = ((NasFiler)object).nfComputer;
            domain = computer.cmpDomain;
            if (domain != null && domain.domID != -1) {
                domain.domID = -1;
                domain.domNext = domain2;
                domain2 = domain;
            }
            object = ((NasFiler)object).nfNext;
        }
        if (domain2 != null) {
            object = new TResDomain(this.dbc);
            ((TResDomain)object).getIDs(domain2);
            object = null;
        }
        object = new TStatComputer(this.dbc);
        ((TStatComputer)object).prepUpdateDomain();
        computer = nasFiler;
        while (computer != null) {
            domain = computer.nfComputer;
            if (domain.cmpDomain != null && domain.cmpOSType != 8) {
                domain.cmpDomainID = domain.cmpDomain.domID;
                ((TStatComputer)object).updateDomain((Computer)domain);
            } else {
                domain.cmpDomainID = -1;
            }
            computer = computer.nfNext;
        }
        ((RepositoryAccessor)object).closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDomains");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveFilesystems(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveFilesystems", (String)"filerList");
        }
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            Object var5_5;
            this.nasShareID = nasFiler2.nfLdapTree.ltTreeID;
            try {
                ProbeResultsHndlr.lockComputer(nasFiler2.nfComputer, null);
                Computer computer = nasFiler2.nfComputer;
                boolean bl = this.foundFsAccessor.getIDs(computer);
                this.saveFilesystems(computer, bl);
                this.handleMissingFilesystems(nasFiler2);
                var5_5 = null;
            }
            catch (Throwable throwable) {
                var5_5 = null;
                ProbeResultsHndlr.unLockComputer(nasFiler2.nfComputer);
                throw throwable;
            }
            ProbeResultsHndlr.unLockComputer(nasFiler2.nfComputer);
            nasFiler2 = nasFiler2.nfNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFilesystems");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveFilesystems(Computer computer, boolean bl) throws GeneralException {
        block13: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"saveFilesystems", (String)"computer, newFilesystems");
            }
            this.shareBuffer.shScanTime = this.discoveryTime;
            this.shareBuffer.shRemovedTime = 0L;
            this.shareBuffer.shPath = " ";
            this.shareBuffer.shResourceType = (short)68;
            this.shareBuffer.shComputerID = this.nasShareID;
            try {
                this.shareAccessor.prepSave();
                if (bl) {
                    this.foundFsAccessor.prepInsert();
                }
                LogicalDisk logicalDisk = computer.cmpLogicalDisk;
                while (logicalDisk != null) {
                    Filesystem filesystem = logicalDisk.ldFilesystem;
                    this.shareBuffer.shResourceID = filesystem.fsID;
                    if (filesystem.fsNewFilesystem) {
                        this.foundFsAccessor.insert(computer, filesystem);
                    }
                    this.shareAccessor.saveShare(this.shareBuffer, filesystem.fsNewFilesystem);
                    this.shareAccessor.commit();
                    logicalDisk = logicalDisk.ldNext;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (bl) {
                    this.foundFsAccessor.cleanup();
                }
                this.shareAccessor.cleanup();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (!bl) break block13;
            }
            this.foundFsAccessor.cleanup();
        }
        this.shareAccessor.cleanup();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFilesystems");
        }
    }

    private void handleMissingFilesystems(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleMissingFilesystems", (String)"filer");
        }
        Share share = this.foundFsAccessor.getMissingFilesystems(this.nasShareID, nasFiler.nfComputerID, this.discoveryTime);
        Share share2 = null;
        if (share != null) {
            share2 = this.shareAccessor.setRemovedTime(share, this.discoveryTime, this.settings.seKeepRemovedFS);
        }
        if (share2 != null) {
            this.removeFilesystems(nasFiler, share2);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleMissingFilesystems");
        }
    }

    private void removeFilesystems(NasFiler nasFiler, Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeFilesystems", (String)"filer, removeList");
        }
        Filesystem filesystem = null;
        boolean bl = !Constants.supportsFullProbe((short)nasFiler.nfOSType);
        this.shareAccessor.prepGetShareCount();
        Object object = share;
        while (object != null) {
            ((Share)object).shShareCount = this.shareAccessor.getShareCount(((Share)object).shResourceID, (short)68);
            if (((Share)object).shShareCount <= 1 && bl) {
                Filesystem filesystem2 = new Filesystem();
                filesystem2.fsID = ((Share)object).shResourceID;
                filesystem2.fsNext = filesystem;
                filesystem = filesystem2;
            }
            object = ((Share)object).shNext;
        }
        this.shareAccessor.closeSelect();
        if (filesystem != null) {
            object = new TResFS(this.dbc);
            ((TResFS)object).deleteFS(filesystem, true);
            this.updateScheduler = true;
        }
        this.removeFoundFilesystems(share, nasFiler.nfComputerID, bl);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeFilesystems");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeFoundFilesystems(Share share, int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeFoundFilesystems", (String)"removeList, filerCompID, deleteFsShares");
        }
        if (share == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"removeFoundFilesystems");
            }
            return;
        }
        try {
            int n2 = share.shComputerID;
            this.foundFsAccessor.prepDeleteByID("t_found_filesystem", "filesystem_id");
            this.shareAccessor.prepDelete();
            Share share2 = share;
            while (share2 != null) {
                if (share2.shShareCount <= 1) {
                    if (bl) {
                        share2.shComputerID = n;
                        this.shareAccessor.deleteShare(share2);
                        share2.shComputerID = n2;
                    }
                    this.foundFsAccessor.deleteByID(share2.shResourceID, false);
                }
                this.shareAccessor.deleteShare(share2);
                share2 = share2.shNext;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.shareAccessor.cleanup();
            this.foundFsAccessor.closeDelete();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.shareAccessor.cleanup();
        this.foundFsAccessor.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeFoundFilesystems");
        }
    }

    Share handleMissingFilers(LdapTree ldapTree) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleMissingFilers", (String)"treeList");
        }
        Share share = null;
        Share share2 = null;
        this.dummyNasTree.ltNext = ldapTree;
        LdapTree ldapTree2 = ldapTree = this.dummyNasTree;
        while (ldapTree2 != null) {
            object = this.shareAccessor.getRemovedResources(ldapTree2.ltTreeID, this.resourceType, this.discoveryTime, share);
            if (object != share) {
                ldapTree2.ltHasComputers = true;
                share = object;
                while (object != null && ((Share)object).shResource == null) {
                    ((Share)object).shResource = ldapTree2;
                    object = ((Share)object).shNext;
                }
            }
            ldapTree2 = ldapTree2.ltNext;
        }
        short s = this.resourceType == 1 ? (short)79 : (short)this.resourceType;
        if (share != null) {
            share2 = this.shareAccessor.setRemovedTime(share, this.discoveryTime, this.settings.seKeepRemovedFS);
            share = this.shareAccessor.getUpdateList();
            object = this.resourceType == 78 ? new TResDiskArray(this.dbc) : new TStatComputer(this.dbc);
            MissingAlertAccessible missingAlertAccessible = (MissingAlertAccessible)object;
            missingAlertAccessible.prepFetchByID();
            Share share3 = null;
            LdapTree ldapTree3 = null;
            LinkedList<Share> linkedList = new LinkedList<Share>();
            while (share != null) {
                Share share4 = share.shNext;
                share.shNext = null;
                if (missingAlertAccessible.fetchByID(share)) {
                    if (share.shResource != ldapTree3) {
                        ldapTree3 = (LdapTree)share.shResource;
                        share3 = null;
                    }
                    if (share3 == null) {
                        share3 = share;
                        linkedList.add(share3);
                    } else {
                        share.shNext = share3.shNext;
                        share3.shNext = share;
                    }
                    share.shResourceType = s;
                }
                share = share4;
            }
            ((RepositoryAccessor)object).closeSelect();
            ProbeAlerter probeAlerter = new ProbeAlerter(this.dbc, 0);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                share3 = (Share)iterator.next();
                ldapTree3 = (LdapTree)share3.shResource;
                s = ldapTree3 == this.dummyNasTree ? (short)this.nasShareOwnerType : (short)66;
                DiscoveryAlerter discoveryAlerter = new DiscoveryAlerter(this.dbc, missingAlertAccessible, this.alertType, s, ldapTree3.ltTreeID, ldapTree3.getLtName());
                if (share3.shResourceType != 99) {
                    discoveryAlerter.alert(share3);
                    Server.agentMgr.updateExpirationOfAgentLessManagedNode(share3.shResourceID, true);
                    continue;
                }
                probeAlerter.alertVSRemoved(ldapTree3.ltTreeID, share3);
            }
        }
        if (share2 != null) {
            this.removeFilers(share2, false);
        }
        object = share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleMissingFilers", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFilers(Share share, boolean bl) throws GeneralException {
        TResShare tResShare;
        block25: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"removeFilers", (String)"removeList, force");
            }
            NasFiler nasFiler = null;
            RepositoryAccessor repositoryAccessor = null;
            tResShare = new TResShare(this.dbc);
            tResShare.prepDeleteIncludingType();
            tResShare.prepGetShareCount();
            try {
                Share share2;
                long l = 0L;
                if (this.settings != null) {
                    l = (long)this.settings.seKeepRemovedFilers * 86400000L;
                } else {
                    this.getSettings();
                    l = (long)this.settings.seKeepRemovedFilers * 86400000L;
                }
                long l2 = this.getProbeTime() - l;
                Share share3 = share;
                Share share4 = null;
                Share share5 = null;
                while (true) {
                    if (share3 == null) {
                        share2 = share5;
                        break;
                    }
                    share4 = share3;
                    share3 = share4.shNext;
                    if (share4.shResource != null && share4.shRemovedTime >= l2) continue;
                    share4.shNext = share5;
                    share5 = share4;
                }
                while (share2 != null) {
                    Object var21_19;
                    nasFiler = null;
                    try {
                        short s;
                        int n;
                        int n2;
                        LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(share2.shResourceID), (byte)1, (boolean)true);
                        Share share6 = this.foundFsAccessor.getMissingFilesystems(share2.shComputerID, share2.shResourceID, 0L);
                        if (share2.shResourceType == 103) {
                            n2 = tResShare.getShareCount(share2.shResourceID, (short)1);
                            n = tResShare.getShareCount(share2.shResourceID, share2.shResourceType);
                            s = 1;
                        } else {
                            n2 = tResShare.getShareCount(share2.shResourceID, share2.shResourceType);
                            n = tResShare.getShareCount(share2.shResourceID, (short)103);
                            s = 103;
                        }
                        int n3 = n2 + n;
                        if (n3 <= 1 || bl) {
                            byte by = share2.shResourceType == 78 ? (byte)9 : 1;
                            if (!UninstallAgentDriver.remove(share2.shResourceID, true, by, this.dbc, true)) {
                                String string = MessageLog.getMessage((String)"STS0165E", (Object)String.valueOf(share2.shResourceID));
                                throw new GeneralException(string);
                            }
                            this.removeFoundFilesystems(share6, share2.shResourceID, false);
                        } else {
                            if (repositoryAccessor == null) {
                                repositoryAccessor = new TResComputer(this.dbc);
                                ((TResComputer)repositoryAccessor).prepGetNasFiler();
                            }
                            nasFiler = ((TResComputer)repositoryAccessor).getNasFiler(share2.shResourceID);
                            TResShare tResShare2 = new TResShare(this.dbc);
                            if (!tResShare2.getShareExists(share2.shComputerID, share2.shResourceID, s) && nasFiler != null && !Constants.isDiskArray((short)nasFiler.nfOSType)) {
                                this.removeFilesystems(nasFiler, share6);
                            }
                        }
                        tResShare.deleteIncludingType(share2);
                    }
                    catch (Throwable throwable) {
                        var21_19 = null;
                        LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(share2.shResourceID));
                        throw throwable;
                    }
                    {
                        var21_19 = null;
                    }
                    LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(share2.shResourceID));
                    share2 = share2.shNext;
                }
            }
            catch (Throwable throwable) {
                Object var23_23 = null;
                if (repositoryAccessor != null) {
                    repositoryAccessor.cleanup();
                }
                tResShare.cleanup();
                throw throwable;
            }
            {
                Object var23_24 = null;
                if (repositoryAccessor == null) break block25;
            }
            repositoryAccessor.cleanup();
        }
        tResShare.cleanup();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeFilers");
        }
    }

    private void checkNewStorageAlerts(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkNewStorageAlerts", (String)"filerList");
        }
        AlertDefinition alertDefinition = null;
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            boolean bl;
            if (nasFiler2.nfNewFiler && (bl = nasFiler2.nfOSType == 8 ? nasFiler2.nfLdapTree.ltHasComputers : this.triggerAlerts)) {
                if (alertDefinition == null) {
                    alertDefinition = this.getAlertDefinition(Constants.isDiskArray((short)nasFiler2.nfOSType));
                }
                this.genNewStorageAlert(nasFiler2, alertDefinition);
            }
            nasFiler2 = nasFiler2.nfNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkNewStorageAlerts");
        }
    }

    private AlertDefinition getAlertDefinition(boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAlertDefinition", (String)"isDiskArray");
        }
        TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
        tAlertDefinition.prepSelectByID(false, false);
        AlertDefinition alertDefinition = tAlertDefinition.getByID(100);
        if (alertDefinition == null) {
            Object[] objectArray = new Object[]{new Integer(100)};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getAlertDefinition");
            }
            throw new GeneralException(MessageLog.getMessage((String)"SRV0105E", (Object[])objectArray));
        }
        tAlertDefinition.closeSelect();
        if (bl) {
            alertDefinition.aldProductID = (short)3;
            alertDefinition.aldCondition = (short)64;
        } else {
            alertDefinition.aldProductID = 0;
            alertDefinition.aldCondition = (short)55;
        }
        AlertDefinition alertDefinition2 = alertDefinition;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAlertDefinition", (Object)alertDefinition2);
        }
        return alertDefinition2;
    }

    private void genNewStorageAlert(NasFiler nasFiler, AlertDefinition alertDefinition) {
        int n;
        String string;
        short s;
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genNewStorageAlert", (String)"filer, alertDef");
        }
        if (alertDefinition.aldCondition == 64) {
            n2 = this.nasShareID;
            s = 78;
            string = this.dummyNasTree.getLtName();
            n = 23;
        } else {
            n2 = nasFiler.nfComputerID;
            s = 79;
            string = nasFiler.nfName;
            n = 18;
        }
        String string2 = string;
        if (Constants.isCimomManaged((short)nasFiler.nfOSType)) {
            string2 = nasFiler.nfCIMOM;
        }
        String[] stringArray = new String[]{string2, ResourceTypeManager.getName((short)s), nasFiler.nfName, alertDefinition.getEmailSubjectID()};
        Alert alert = new Alert(n2, nasFiler.nfComputerID, s, alertDefinition, stringArray, n, varBindOIDs, tecSlotNames, -1, -1, this.subProduct, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genNewStorageAlert");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveVirtualServers(NasFiler nasFiler, int n) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveVirtualServers", (String)"filerList, cid");
        }
        NasFiler nasFiler2 = null;
        NasFiler nasFiler3 = nasFiler;
        int n2 = 0;
        TResCluster tResCluster = new TResCluster(this.dbc);
        Cluster cluster = null;
        NasFiler nasFiler4 = nasFiler;
        while (nasFiler4 != null) {
            if (Constants.isVirtualServer((int)nasFiler4.nfOSType)) {
                ++n2;
                if (cluster == null) {
                    cluster = tResCluster.getClusterByName(nasFiler4.nfComputer.cmpCluster.clusterName, nasFiler4.nfComputer.cmpCluster.domain_name);
                }
                nasFiler4.nfLdapTree = new LdapTree();
                nasFiler4.nfLdapTree.ltTreeID = cluster.clusterID;
                if (nasFiler2 == null) {
                    nasFiler2 = nasFiler4;
                } else if (nasFiler4.nfNext == null || !Constants.isVirtualServer((int)nasFiler4.nfNext.nfOSType)) {
                    nasFiler3 = nasFiler4;
                }
            }
            nasFiler4 = nasFiler4.nfNext;
        }
        if (nasFiler2 != null) {
            nasFiler4 = null;
            try {
                nasFiler4 = nasFiler3.nfNext;
                nasFiler3.nfNext = null;
                this.resourceType = (short)99;
                nasFiler2 = this.saveFilers(nasFiler2, false);
                this.updateCIDForClusterResources(n, nasFiler2);
                Object var9_11 = null;
                nasFiler3.nfNext = nasFiler4;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                nasFiler3.nfNext = nasFiler4;
                throw throwable;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveVirtualServers");
        }
    }

    private void updateCIDForClusterResources(int n, NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateCIDForClusterResources", (String)"computerID, filerList");
        }
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            LogicalDisk logicalDisk = nasFiler2.nfComputer.cmpLogicalDisk;
            while (logicalDisk != null && logicalDisk.ldFilesystem != null) {
                logicalDisk.ldFilesystem.fsComputerID = nasFiler2.nfComputer.cmpID;
                logicalDisk.ldFilesystem.fsScanningCompID = n;
                logicalDisk = logicalDisk.ldNext;
            }
            Controller controller = nasFiler2.nfComputer.cmpController;
            while (controller != null) {
                controller.ctlrComputerID = nasFiler2.nfComputer.cmpID;
                controller = controller.ctlrNext;
            }
            nasFiler2.nfComputer.cmpNodeHostedID = n;
            nasFiler2 = nasFiler2.nfNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateCIDForClusterResources");
        }
    }

    private void saveProbeResults(int n, NasFiler nasFiler) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveProbeResults", (String)"computerID, filerList");
        }
        ProbeResultsHndlr probeResultsHndlr = new ProbeResultsHndlr(this.dbc);
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            if (Constants.supportsFullProbe((short)nasFiler2.nfOSType) || Constants.isDiskArray((short)nasFiler2.nfOSType)) {
                nasFiler2.nfComputer.cmpNasFiler = nasFiler2;
                nasFiler2.nfComputer.cmpProbingCompID = n;
                this.updateScheduler = probeResultsHndlr.saveResults(nasFiler2.nfComputer);
            } else {
                probeResultsHndlr.saveNasProbeResults(nasFiler2.nfComputer);
            }
            nasFiler2 = nasFiler2.nfNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveProbeResults");
        }
    }

    public long getProbeTime() {
        return this.discoveryTime;
    }

    public void setProbeTime(long l) {
        this.discoveryTime = l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateVSProbeTime(Cluster cluster) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateVSProbeTime", (String)"cluster");
        }
        if (cluster != null) {
            TResShare tResShare = new TResShare(this.dbc);
            TResComputer tResComputer = new TResComputer(this.dbc);
            Share share = new Share();
            share.shScanTime = this.discoveryTime;
            share.shComputerID = cluster.clusterID;
            share.shResourceType = (short)99;
            try {
                tResShare.prepUpdate();
                Iterator iterator = cluster.virtualServers.iterator();
                while (iterator.hasNext()) {
                    share.shResourceID = tResComputer.selectCID((String)iterator.next());
                    tResShare.updateVSProbeTime(share);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                tResShare.closeUpdate();
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            tResShare.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.FilerSaver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateVSProbeTime");
        }
    }
}

