/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptDiskAssetHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptDisk
extends StorageRepositoryAccessor
implements GuiDataProvider {
    PreparedStatement selectMirrorsStmt;
    private static final String SELECT = " select sh.computer_id as cmpID, sh.resource_id as resID, sh.resource_type, sh.scan_time, sh.removed_time, sh.path, da.controller_id, da.device_id, da.target, da.lun, da.path, dev.physical_volume_id, dev.vendor_id, dev.model_id, dev.serial_number, dev.firmware_rev, dev.manufacture_date, dev.use_count, dev.device_type, dev.unsupported_model, dev.flags, dev.removable_medium, dev.multi_port, dev.discovered_time, dev.subsystem_serial_number, dsk.disk_id, dsk.heads, dsk.cylinders, dsk.rpm, dsk.sector_size, dsk.sectors_avg_track, dsk.sectors_outr_track, dsk.sectors_innr_track, dsk.logical_block_size, dsk.minutes_powered_on, dsk.write_protected, dsk.write_cache_enable, dsk.read_cache_disable, dsk.auto_write_realloc, dsk.auto_read_realloc, dsk.no_error_recovery, dsk.failure_predicted, dsk.capacity, dsk.spare_blocks, dsk.volgroup_id, dsk.desired_awre, dsk.desired_arre, dsk.desired_noerrrcvry, dsk.disk_identity, dkh.disk_id, dkh.statistic_time, dkh.statistic_type, dkh.primary_defects, dkh.grown_defects, dkh.recovrd_wrt_errs, dkh.unrecovrd_wrt_errs, dkh.bytes_written, dkh.recovrd_rd_errs, dkh.unrecovrd_rd_errs, dkh.bytes_read, dkh.recovrd_vfy_errs, dkh.unrecovrd_vfy_errs, dkh.non_medium_errs, dkh.free_space, dkh.temperature, cmp.os_type, cmp.host_url from t_res_share sh, t_res_dev_access da, t_res_physical_volume dev, t_stat_disk dsk, t_stat_disk_hist dkh, t_res_host cmp where sh.resource_type = 10 and sh.resource_id = da.device_id and sh.resource_id = dev.physical_volume_id and sh.resource_id = dsk.disk_id and sh.resource_id = dkh.disk_id and sh.computer_id = cmp.computer_id and dkh.statistic_type = '3' and dsk.logical_disk_id < 0 union  select dev.subsystem_id as cmpID, dev.physical_volume_id as resID, 0, dev.update_timestamp, dev.update_timestamp, dev.device_id, -1, -1, -1, -1,  dev.device_id, dev.physical_volume_id, dev.vendor_id, dev.model_id, dev.serial_number, dev.firmware_rev, dev.manufacture_date,  dev.use_count, dev.device_type, dev.unsupported_model, dev.flags, dev.removable_medium, dev.multi_port, dev.update_timestamp,  dev.subsystem_serial_number, dsk.disk_id, dsk.heads, dsk.cylinders, dsk.rpm, dsk.sector_size, dsk.sectors_avg_track, dsk.sectors_outr_track, dsk.sectors_innr_track,  dsk.logical_block_size, dsk.minutes_powered_on, dsk.write_protected, dsk.write_cache_enable, dsk.read_cache_disable, dsk.auto_write_realloc,  dsk.auto_read_realloc, dsk.no_error_recovery, dsk.failure_predicted, dsk.capacity, dsk.spare_blocks, dsk.volgroup_id, dsk.desired_awre,  dsk.desired_arre, dsk.desired_noerrrcvry, dsk.disk_identity, dkh.disk_id, dkh.statistic_time, dkh.statistic_type, dkh.primary_defects,  dkh.grown_defects, dkh.recovrd_wrt_errs, dkh.unrecovrd_wrt_errs, dkh.bytes_written, dkh.recovrd_rd_errs, dkh.unrecovrd_rd_errs,  dkh.bytes_read, dkh.recovrd_vfy_errs, dkh.unrecovrd_vfy_errs, dkh.non_medium_errs, dkh.free_space, dkh.temperature, cmp.os_type,  case when cmp.user_provided_name is not null  and cmp.user_provided_name <> ''  then cmp.user_provided_name else cmp.display_name end display_name  from t_res_physical_volume dev,  t_stat_disk dsk,  t_stat_disk_hist dkh,  t_res_storage_subsystem cmp  where dev.physical_volume_id = dsk.disk_id  and   dsk.disk_id = dkh.disk_id  and   dev.subsystem_id = cmp.subsystem_id  and dkh.statistic_type = '3' union  select se.subsystem_id as cmpID, se.storage_extent_id as resID, 0, se.update_timestamp, se.update_timestamp, se.element_name, -1, -1, -1, -1, se.element_name, se.storage_extent_id, -1, -1, '', '', se.update_timestamp, -1, -1, CAST(NULL AS CHARACTER), -1, CAST(NULL AS CHARACTER), CAST(NULL AS CHARACTER), se.update_timestamp, '', dsk.disk_id, dsk.heads, dsk.cylinders, dsk.rpm, dsk.sector_size, dsk.sectors_avg_track, dsk.sectors_outr_track, dsk.sectors_innr_track,  dsk.logical_block_size, dsk.minutes_powered_on, dsk.write_protected, dsk.write_cache_enable, dsk.read_cache_disable, dsk.auto_write_realloc,  dsk.auto_read_realloc, dsk.no_error_recovery, dsk.failure_predicted, dsk.capacity, dsk.spare_blocks, dsk.volgroup_id, dsk.desired_awre, dsk.desired_arre,  dsk.desired_noerrrcvry, dsk.disk_identity, dkh.disk_id, dkh.statistic_time, dkh.statistic_type, dkh.primary_defects, dkh.grown_defects,  dkh.recovrd_wrt_errs, dkh.unrecovrd_wrt_errs, dkh.bytes_written, dkh.recovrd_rd_errs, dkh.unrecovrd_rd_errs, dkh.bytes_read, dkh.recovrd_vfy_errs,  dkh.unrecovrd_vfy_errs, dkh.non_medium_errs, dkh.free_space, dkh.temperature, cmp.os_type,  case when cmp.user_provided_name is not null  and cmp.user_provided_name <> ''  then cmp.user_provided_name else cmp.display_name end display_name  from t_res_storage_extent se,  t_stat_disk dsk,  t_stat_disk_hist dkh,  t_res_storage_subsystem cmp  where se.storage_extent_id = dsk.disk_id  and   dsk.disk_id = dkh.disk_id  and   se.subsystem_id = cmp.subsystem_id  and dkh.statistic_type = '3'";
    private static final String SELECT_VIRTUALIZED_MDISKS = "select svid, mdisk_id from t_res_storage_volume where mdisk_id > 0";
    private static final String ORDER_BY = " order by  cmpID, resID";
    private static final String FREESPACE = " and dkh.free_space >= 0 order by free_space desc";
    private static final String PRIMARY_DEFECTS = " and dkh.primary_defects  > 0 order by primary_defects desc";
    private static final String GROWN_DEFECTS = " and dkh.grown_defects > 0 order by grown_defects desc";
    private static final String RECOVERED_ERR = " and (dkh.recovrd_wrt_errs > 0 or dkh.recovrd_rd_errs  > 0 or dkh.recovrd_vfy_errs > 0 ) order by 64 desc";
    private static final String UNRECOVERED_ERR = " and (dkh.unrecovrd_wrt_errs > 0 or dkh.unrecovrd_rd_errs  > 0 or dkh.unrecovrd_vfy_errs > 0 ) order by 65 desc";
    private static final String PROBE_TIME = " order by statistic_time ";
    private static final String DISCOVERED_TIME = " order by 24";

    public RptDisk(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptDisk", (String)"dbc");
        }
        this.tableName = "t_res_physical_volume";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptDisk");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        Share[] shareArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        if (guiReportReq.reportSubtype < 0) {
            RptDiskAssetHist rptDiskAssetHist = new RptDiskAssetHist(this.dbc);
            Serializable serializable = rptDiskAssetHist.getReportData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        Share share = new Share();
        share.shNext = null;
        Share share2 = share;
        int n = 0;
        boolean bl = true;
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, share2);
        }
        Lun lun = this.getMDisksWithCommonStorage();
        try {
            shareArray = SELECT + this.getReport(guiReportReq);
            this.selectStmt = this.prepareStmt((String)shareArray);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            Share share3 = share;
            share2 = new Share();
            while (this.nextResult()) {
                String string;
                String string2;
                DiskHistory diskHistory;
                this.colIndex = 1;
                share2.shComputerID = this.getInt(this.resultSet);
                share2.shResourceID = this.getInt(this.resultSet);
                Share share4 = share.shNext;
                while (share4 != null) {
                    if (share4.shResourceID == share2.shResourceID) break;
                    share4 = share4.shNext;
                }
                if (share4 != null && share4.shResourceID == share2.shResourceID) continue;
                DevAccess devAccess = new DevAccess();
                share2.shResource = devAccess;
                Disk disk = new Disk();
                devAccess.daDevice = disk;
                disk.dskHistory = diskHistory = new DiskHistory();
                share2.shResourceType = this.getShort(this.resultSet);
                share2.shScanTime = this.getTimestamp(this.resultSet);
                share2.shRemovedTime = this.getTimestamp(this.resultSet);
                share2.shPath = this.getString(this.resultSet);
                devAccess.daControllerID = this.getInt(this.resultSet);
                devAccess.daDeviceID = this.getInt(this.resultSet);
                devAccess.daTarget = this.getShort(this.resultSet);
                devAccess.daLUN = this.getShort(this.resultSet);
                devAccess.daPath = this.getString(this.resultSet);
                disk.devID = this.getInt(this.resultSet);
                TResVendorModel tResVendorModel = new TResVendorModel(this.dbc);
                short s = this.getShort(this.resultSet);
                disk.devManufacturer = string2 = tResVendorModel.getVendorName(s);
                disk.devModel = string = tResVendorModel.getModelName(this.getShort(this.resultSet));
                disk.devSerialNumber = this.getString(this.resultSet);
                disk.devFirmwareRev = this.getString(this.resultSet);
                disk.devManufactureDate = this.getTimestamp(this.resultSet);
                disk.devUseCount = this.getShort(this.resultSet);
                disk.devType = this.getShort(this.resultSet);
                disk.devUnsupportedModel = this.getBoolean(this.resultSet);
                disk.devFlags = this.getShort(this.resultSet);
                disk.devRemovableMedium = this.getBoolean(this.resultSet);
                disk.devMultiPort = this.getBoolean(this.resultSet);
                disk.devDiscoveredTime = this.getTimestamp(this.resultSet);
                disk.devSubsystemSerialNumber = this.getString(this.resultSet);
                disk.devID = this.getInt(this.resultSet);
                disk.dskHeads = this.getInt(this.resultSet);
                disk.dskCylinders = this.getInt(this.resultSet);
                disk.dskRPM = this.getInt(this.resultSet);
                disk.dskSectorSize = this.getInt(this.resultSet);
                disk.dskSectorsPerAvgTrack = this.getInt(this.resultSet);
                disk.dskSectorsPerOuterTrack = this.getInt(this.resultSet);
                disk.dskSectorsPerInnerTrack = this.getInt(this.resultSet);
                disk.dskLogicalBlockSize = this.getInt(this.resultSet);
                disk.dskMinutesPoweredOn = this.getInt(this.resultSet);
                disk.dskWriteProtected = this.getBoolean(this.resultSet);
                disk.dskWriteCacheEnabled = this.getBoolean(this.resultSet);
                disk.dskReadCacheDisabled = this.getBoolean(this.resultSet);
                disk.dskAutoWriteRealloc = this.getBoolean(this.resultSet);
                disk.dskAutoReadRealloc = this.getBoolean(this.resultSet);
                disk.dskNoErrorRecovery = this.getBoolean(this.resultSet);
                disk.dskFailurePredicted = this.getBoolean(this.resultSet);
                disk.dskCapacity = this.getLong(this.resultSet);
                disk.dskSpareBlocks = this.getInt(this.resultSet);
                disk.dskVolgroupID = this.getInt(this.resultSet);
                disk.dskDesiredAWRE = this.getByte(this.resultSet);
                disk.dskDesiredARRE = this.getByte(this.resultSet);
                disk.dskDesiredNoErrRcvry = this.getByte(this.resultSet);
                disk.dskIdentity = this.getByte(this.resultSet);
                diskHistory.dkhDiskID = this.getInt(this.resultSet);
                diskHistory.dkhTimestamp = this.getTimestamp(this.resultSet);
                diskHistory.dkhType = this.getByte(this.resultSet);
                diskHistory.dkhPrimaryDefects = this.getInt(this.resultSet);
                diskHistory.dkhGrownDefects = this.getInt(this.resultSet);
                diskHistory.dkhRecoveredWriteErrors = this.getInt(this.resultSet);
                diskHistory.dkhUnrecoveredWriteErrors = this.getInt(this.resultSet);
                diskHistory.dkhBytesWritten = (long)this.getDouble(this.resultSet);
                diskHistory.dkhRecoveredReadErrors = this.getInt(this.resultSet);
                diskHistory.dkhUnrecoveredReadErrors = this.getInt(this.resultSet);
                diskHistory.dkhBytesRead = (long)this.getDouble(this.resultSet);
                diskHistory.dkhRecoveredVerifyErrors = this.getInt(this.resultSet);
                diskHistory.dkhUnrecoveredVerifyErrors = this.getInt(this.resultSet);
                diskHistory.dkhNonMediumErrors = this.getInt(this.resultSet);
                diskHistory.dkhFreeSpace = this.getLong(this.resultSet);
                diskHistory.dkhTemperature = this.getShort(this.resultSet);
                short s2 = this.getShort(this.resultSet);
                if (Constants.isDiskArray((short)s2) || s2 == 10) {
                    share2.shComputerName = this.getString(this.resultSet);
                    share2.shResourceType = (short)78;
                }
                if (reportFilter != null) {
                    this.getComputerNames(share2);
                    bl = reportFilter.isSelected(share2);
                }
                if (this.isDiskToBeExcluded(disk.devID, lun)) {
                    bl = false;
                } else if (reportFilter == null) {
                    bl = true;
                }
                if (!bl) continue;
                share3.shNext = share2;
                share3 = share2;
                ++n;
                share2 = new Share();
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (guiReportReq.isBatchReport) {
            this.getComputerNames(share.shNext);
        }
        shareArray = RptDisk.packUpShares(share.shNext, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)shareArray);
        }
        return shareArray;
    }

    private String getReport(GuiReportReq guiReportReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReport", (String)"grr");
        }
        switch (guiReportReq.reportSubtype) {
            case 1: {
                String string = ORDER_BY;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 39: {
                String string = FREESPACE;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 23: {
                String string = PRIMARY_DEFECTS;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 24: {
                String string = GROWN_DEFECTS;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 25: {
                String string = RECOVERED_ERR;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 26: {
                String string = UNRECOVERED_ERR;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 18: {
                String string = PROBE_TIME;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
            case 37: {
                String string = DISCOVERED_TIME;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getReport", (Object)string);
                }
                return string;
            }
        }
        Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
        String string = MessageLog.getMessage((String)"GEN0125E", (Object[])objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReport");
        }
        throw new GeneralException(string);
    }

    private void getComputerNames(Share share) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (share != null) {
            if (share.shResourceType == 10) {
                share.shComputerName = agentManager.getAgentName(share.shComputerID);
            }
            share = share.shNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Lun getMDisksWithCommonStorage() throws GeneralException {
        Lun lun = null;
        Lun lun2 = new Lun();
        new TResLogicalDisk(this.dbc);
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_VIRTUALIZED_MDISKS);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.nextResult()) {
                    this.colIndex = 1;
                    lun2.lunID = this.getInt(this.resultSet);
                    lun2.lunMdisk_id = this.getInt(this.resultSet);
                    lun2.lunNext = lun;
                    lun = lun2;
                    lun2 = new Lun();
                }
            }
            catch (SQLException sQLException) {
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.closeSelect();
        return lun;
    }

    private boolean isDiskToBeExcluded(int n, Lun lun) {
        boolean bl = false;
        Lun lun2 = lun;
        while (lun2 != null) {
            if (lun2.lunMdisk_id == n) {
                bl = true;
                return bl;
            }
            lun2 = lun2.lunNext;
        }
        return bl;
    }

    public static Share[] packUpShares(Share share, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packUpShares", (String)"head, totalRows");
        }
        Share[] shareArray = new Share[n];
        n = 0;
        while (share != null) {
            Share share2 = share.shNext;
            share.shNext = null;
            shareArray[n] = share;
            ++n;
            share = share2;
        }
        Share[] shareArray2 = shareArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packUpShares", (Object)shareArray2);
        }
        return shareArray2;
    }
}

