/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptDiskHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT = "select disk_id, statistic_time, statistic_type, capacity, free_space from t_stat_disk_hist ";
    private static final String DISK_COL = "disk_id";

    public RptDiskHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptDiskHist", (String)"dbc");
        }
        this.tableName = "T_STAT_DISK_HIST";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptDiskHist");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        SpaceHistory spaceHistory;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory spaceHistory2 = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(SELECT);
        stringBuffer.append(" where statistic_type in ('");
        stringBuffer.append(guiReportReq.histType);
        if (guiReportReq.histType == 0) {
            stringBuffer.append("','3') and");
        } else {
            stringBuffer.append("') and");
        }
        if (guiReportReq.startTime > 0L) {
            stringBuffer.append(" statistic_time between ? and ? and");
        }
        SQLUtil.appendInClause(stringBuffer, DISK_COL, guiReportReq.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            if (guiReportReq.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            spaceHistory = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                spaceHistory.shLegendID1 = this.getInt(this.resultSet);
                spaceHistory.shLegendID2 = Integer.MIN_VALUE;
                spaceHistory.shStatisticTime = this.getTimestamp(this.resultSet);
                this.getByte(this.resultSet);
                long l = this.getLong(this.resultSet);
                if (l <= 0L) continue;
                if (guiReportReq.histSubtype == 5) {
                    spaceHistory.shTotalSize = l;
                } else {
                    spaceHistory.shTotalSize = this.getLong(this.resultSet);
                    if (spaceHistory.shTotalSize < 0L) continue;
                    if (guiReportReq.histSubtype == 2) {
                        spaceHistory.shFileCount = (int)(spaceHistory.shTotalSize * 100L / l);
                    }
                }
                spaceHistory.shNext = spaceHistory2;
                spaceHistory2 = spaceHistory;
                spaceHistory = new SpaceHistory();
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        spaceHistory = RptUserSpace.packUpHistory(spaceHistory2, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)spaceHistory);
        }
        return spaceHistory;
    }
}

