/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptFsHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT = "select filesystem_id, statistic_time, statistic_type, accum_count, file_count, capacity, free_space, used_space from t_stat_fs_hist ";
    private static final String FILESYSTEM_COL = "filesystem_id";

    public RptFsHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFsHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptFsHist", (String)"dbc");
        }
        this.tableName = "t_stat_fs_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFsHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptFsHist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        SpaceHistory spaceHistory;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFsHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory spaceHistory2 = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(SELECT);
        stringBuffer.append(" where statistic_type in ('");
        stringBuffer.append(guiReportReq.histType);
        stringBuffer.append('\'');
        if (guiReportReq.histType != 0) {
            stringBuffer.append(",'");
            stringBuffer.append(guiReportReq.histType + 2);
            stringBuffer.append('\'');
        }
        stringBuffer.append(") and product_id = ");
        stringBuffer.append(guiReportReq.productCode);
        stringBuffer.append(" and");
        if (guiReportReq.startTime > 0L) {
            stringBuffer.append(" statistic_time between ? and ? and");
        }
        SQLUtil.appendInClause(stringBuffer, FILESYSTEM_COL, guiReportReq.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            if (guiReportReq.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            spaceHistory = new SpaceHistory();
            while (true) {
                if (!this.resultSet.next()) {
                    this.closeSelect();
                    break;
                }
                this.colIndex = 1;
                spaceHistory.shLegendID1 = this.getInt(this.resultSet);
                spaceHistory.shLegendID2 = Integer.MIN_VALUE;
                spaceHistory.shStatisticTime = this.getTimestamp(this.resultSet);
                byte by = this.getByte(this.resultSet);
                short s = this.getShort(this.resultSet);
                spaceHistory.shFileCount = this.getLong(this.resultSet);
                if (guiReportReq.histSubtype == 0 && spaceHistory.shFileCount < 0L) continue;
                long l = this.getLong(this.resultSet);
                spaceHistory.shTotalSize = this.getLong(this.resultSet);
                spaceHistory.shUsedSize = this.getLong(this.resultSet);
                if (by == 3 || by == 4) {
                    if (s <= 0) continue;
                    spaceHistory.shFileCount /= (long)s;
                    l /= (long)s;
                    spaceHistory.shTotalSize /= (long)s;
                    spaceHistory.shUsedSize /= (long)s;
                    try {
                        spaceHistory.shStatisticTime = SQLUtil.getTimestamp(this.dbc).getTime();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFsHist");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)exception);
                        }
                        return null;
                    }
                }
                if (guiReportReq.histSubtype == 2) {
                    if (spaceHistory.shTotalSize > 0L) {
                        spaceHistory.shFileCount = spaceHistory.shTotalSize * 100L / l;
                    }
                } else if (guiReportReq.histSubtype == 3) {
                    spaceHistory.shTotalSize = l - spaceHistory.shTotalSize;
                } else if (guiReportReq.histSubtype == 4) {
                    spaceHistory.shTotalSize = spaceHistory.shUsedSize;
                    if (spaceHistory.shTotalSize > 0L) {
                        spaceHistory.shFileCount = spaceHistory.shTotalSize * 100L / l;
                    }
                } else if (guiReportReq.histSubtype == 5) {
                    spaceHistory.shTotalSize = l;
                }
                spaceHistory.shNext = spaceHistory2;
                spaceHistory2 = spaceHistory;
                spaceHistory = new SpaceHistory();
                ++n;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptFsHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        spaceHistory = RptUserSpace.packUpHistory(spaceHistory2, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFsHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)spaceHistory);
        }
        return spaceHistory;
    }
}

