/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptFsHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;

public class RptVolGroup
extends StorageRepositoryAccessor
implements GuiDataProvider {
    int rowCount;
    RespVolGroup listHdr = null;
    private static final String SELECT = " select v.volgroup_id, v.name, v.freespace, v.capacity,  v.volgroup_type, v.config, v.status, v.format,    v.nbrvolumes, v.nbrdisks, v.last_probe_time, v.discovered_time,   v.computer_id, v.disk_group, v.lss, v.surf_lun_cap, v.unsurf_lun_cap,  c.host_name, c.os_type  from t_res_volgroup v, t_res_host c where v.computer_id = c.computer_id and  v.volgroup_type in (0,1)";
    private static final String BY_NAME = " order by v.name desc";
    private static final String BY_CAPACITY = " order by v.capacity";
    private static final String BY_FREESPACE = " order by v.freespace";
    private static final String BY_COMPUTER = " order by c.host_name desc";
    private static final String BY_PROBE_TIME = " order by v.last_probe_time";
    private static final String BY_DISCOVERED_TIME = " order by v.discovered_time";

    public RptVolGroup(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptVolGroup", (String)"dbc");
        }
        this.tableName = "t_res_volgroup";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptVolGroup");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        RespVolGroup respVolGroup;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        if (guiReportReq.reportSubtype == 28) {
            RptFsHist rptFsHist = new RptFsHist(this.dbc);
            Serializable serializable = rptFsHist.getReportData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        this.rowCount = 0;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(SELECT);
        switch (guiReportReq.reportSubtype) {
            case 80: {
                stringBuffer.append(BY_NAME);
                break;
            }
            case 12: {
                stringBuffer.append(BY_COMPUTER);
                break;
            }
            case 78: {
                stringBuffer.append(BY_CAPACITY);
                break;
            }
            case 17: {
                stringBuffer.append(BY_FREESPACE);
                break;
            }
            case 18: {
                stringBuffer.append(BY_PROBE_TIME);
                break;
            }
            case 37: {
                stringBuffer.append(BY_DISCOVERED_TIME);
            }
        }
        int n = 0;
        boolean bl = true;
        RespVolGroup respVolGroup2 = new RespVolGroup();
        RespVolGroup respVolGroup3 = new RespVolGroup();
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, respVolGroup3);
        }
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            respVolGroup = respVolGroup2;
            while (this.nextResult()) {
                ++this.rowCount;
                if (respVolGroup3 == null) {
                    respVolGroup3 = new RespVolGroup();
                }
                this.colIndex = 1;
                respVolGroup3.vgID = this.getInt(this.resultSet);
                respVolGroup3.vgName = this.getString(this.resultSet);
                respVolGroup3.vgFreeSpace = this.getLong(this.resultSet);
                respVolGroup3.vgTotalSpace = this.getLong(this.resultSet);
                respVolGroup3.vgType = this.getShort(this.resultSet);
                respVolGroup3.vgConfig = this.getShort(this.resultSet);
                respVolGroup3.vgOperationalStatus = this.getInt(this.resultSet);
                respVolGroup3.vgStatus = (short)respVolGroup3.vgOperationalStatus;
                respVolGroup3.vgFormat = this.getShort(this.resultSet);
                respVolGroup3.vgVolumes = this.getInt(this.resultSet);
                respVolGroup3.vgDisks = this.getInt(this.resultSet);
                respVolGroup3.vgProbeTime = this.getTimestamp(this.resultSet);
                if (this.resultSet.wasNull()) {
                    respVolGroup3.vgProbeTime = 86400000L;
                }
                respVolGroup3.vgDiscoveredTime = this.getTimestamp(this.resultSet);
                if (this.resultSet.wasNull()) {
                    respVolGroup3.vgDiscoveredTime = 86400000L;
                }
                respVolGroup3.vgComputerID = this.getInt(this.resultSet);
                respVolGroup3.vgDiskGroup = this.getString(this.resultSet);
                respVolGroup3.vgLSS = this.getString(this.resultSet);
                respVolGroup3.vgSurfacedLunCap = this.getLong(this.resultSet);
                respVolGroup3.vgUnSurfacedLunCap = this.getLong(this.resultSet);
                respVolGroup3.rvgComputerName = this.getString(this.resultSet);
                respVolGroup3.rvgComputerOsType = this.getShort(this.resultSet);
                if (reportFilter != null) {
                    RespVolGroup respVolGroup4 = (RespVolGroup)respVolGroup3.clone();
                    bl = reportFilter.isSelected(respVolGroup4);
                }
                if (!bl) continue;
                respVolGroup.next = respVolGroup3;
                respVolGroup = respVolGroup3;
                respVolGroup3 = null;
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        respVolGroup = RptVolGroup.packItUp(respVolGroup2.next, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)respVolGroup);
        }
        return respVolGroup;
    }

    public static RespVolGroup[] packItUp(RespVolGroup respVolGroup, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packItUp", (String)"head, totalRows");
        }
        RespVolGroup[] respVolGroupArray = new RespVolGroup[n];
        n = 0;
        while (respVolGroup != null) {
            RespVolGroup respVolGroup2 = respVolGroup.next;
            respVolGroup.next = null;
            respVolGroupArray[n] = respVolGroup;
            ++n;
            respVolGroup = respVolGroup2;
        }
        RespVolGroup[] respVolGroupArray2 = respVolGroupArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packItUp", (Object)respVolGroupArray2);
        }
        return respVolGroupArray2;
    }
}

