/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report.filter;

import java.lang.reflect.Array;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.report.filter.BetweenEvaluator;
import org.eclipse.aperi.repository.report.filter.EqEvaluator;
import org.eclipse.aperi.repository.report.filter.FilterEvaluator;
import org.eclipse.aperi.repository.report.filter.GtEvaluator;
import org.eclipse.aperi.repository.report.filter.LtEvaluator;
import org.eclipse.aperi.repository.report.filter.StringEvaluator;

public class ReportFilter {
    private GuiReportReq grr;
    private CustomReportDataAdjuster adjuster;
    private ColumnFilter filterList;
    private FilterEvaluator evaluatorList;
    private Object[] dataArray;
    private int frozenRows;
    private boolean breakCondition;

    public ReportFilter(GuiReportReq guiReportReq, Object object) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ReportFilter", (String)"grr, dataRecord");
        }
        this.grr = guiReportReq;
        this.filterList = ColumnFilter.unpack((ColumnFilter[])guiReportReq.columnFilters);
        this.breakCondition = guiReportReq.orFilters;
        this.dataArray = (Object[])Array.newInstance(object.getClass(), 1);
        this.dataArray[0] = object;
        this.adjuster = ReportDataAdjuster.makeCustomAdjuster((GuiReportReq)guiReportReq);
        this.adjuster.adjustInit(this.dataArray, true);
        this.frozenRows = this.adjuster.getNumberFrozenRows();
        ColumnFilter columnFilter = this.filterList;
        while (columnFilter != null) {
            this.convertValueIDs(columnFilter);
            FilterEvaluator filterEvaluator = this.makeEvaluator(columnFilter, this.adjuster);
            if (filterEvaluator != null) {
                filterEvaluator.nextEvaluator = this.evaluatorList;
                this.evaluatorList = filterEvaluator;
            }
            columnFilter = columnFilter.clfNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ReportFilter");
        }
    }

    private void convertValueIDs(ColumnFilter columnFilter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"convertValueIDs", (String)"filter");
        }
        ColumnFilterValue columnFilterValue = columnFilter.clfValueList;
        while (columnFilterValue != null) {
            if (columnFilterValue.fvValueID >= 0) {
                columnFilterValue.fvValue = ColumnDescriptor.getValue((int)columnFilterValue.fvValueID, (int)columnFilter.clfColumnID, (int)this.grr.reportType);
            }
            columnFilterValue = columnFilterValue.fvNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"convertValueIDs");
        }
    }

    private FilterEvaluator makeEvaluator(ColumnFilter columnFilter, CustomReportDataAdjuster customReportDataAdjuster) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeEvaluator", (String)"filter, adjuster");
        }
        if (columnFilter.clfCondition == 13 || columnFilter.clfCondition == 14) {
            this.convertNullFilter(columnFilter);
            FilterEvaluator filterEvaluator = ReportFilter.makeDefaultEvaluator(this.grr, columnFilter, customReportDataAdjuster);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"makeEvaluator", (Object)filterEvaluator);
            }
            return filterEvaluator;
        }
        switch (columnFilter.clfDataType) {
            case 1: {
                FilterEvaluator filterEvaluator = StringEvaluator.makeEvaluator(this.grr, columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeEvaluator", (Object)filterEvaluator);
                }
                return filterEvaluator;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                FilterEvaluator filterEvaluator = ReportFilter.makeDefaultEvaluator(this.grr, columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeEvaluator", (Object)filterEvaluator);
                }
                return filterEvaluator;
            }
            case 6: {
                this.convertOffsetFilter(columnFilter);
                FilterEvaluator filterEvaluator = ReportFilter.makeDefaultEvaluator(this.grr, columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeEvaluator", (Object)filterEvaluator);
                }
                return filterEvaluator;
            }
        }
        Object[] objectArray = new Object[]{Integer.toString(this.grr.reportType), Integer.toString(columnFilter.clfColumnID), Integer.toString(columnFilter.clfDataType)};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeEvaluator");
        }
        throw new GeneralException("STS0307E", objectArray);
    }

    private void convertNullFilter(ColumnFilter columnFilter) throws GeneralException {
        ColumnFilterValue columnFilterValue;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"convertNullFilter", (String)"filter");
        }
        columnFilter.clfValueList = columnFilterValue = new ColumnFilterValue();
        switch (columnFilter.clfDataType) {
            case 2: 
            case 4: 
            case 5: {
                columnFilter.clfCondition = columnFilter.clfCondition == 13 ? (short)4 : (short)5;
                columnFilterValue.fvValue = new MutableLong(0L);
                break;
            }
            case 3: {
                columnFilter.clfCondition = columnFilter.clfCondition == 13 ? (short)3 : (short)6;
                columnFilterValue.fvValue = Constants.NULL_DATE_DATE;
                break;
            }
            default: {
                columnFilter.clfCondition = columnFilter.clfCondition == 13 ? (short)1 : (short)2;
                columnFilterValue.fvValue = "";
                columnFilterValue.fvNext = new ColumnFilterValue();
                columnFilterValue.fvNext.fvValue = " ";
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"convertNullFilter");
        }
    }

    public static FilterEvaluator makeDefaultEvaluator(GuiReportReq guiReportReq, ColumnFilter columnFilter, CustomReportDataAdjuster customReportDataAdjuster) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeDefaultEvaluator", (String)"grr, filter, adjuster");
        }
        switch (columnFilter.clfCondition) {
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                EqEvaluator eqEvaluator = new EqEvaluator(columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeDefaultEvaluator", (Object)eqEvaluator);
                }
                return eqEvaluator;
            }
            case 4: 
            case 5: {
                LtEvaluator ltEvaluator = new LtEvaluator(columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeDefaultEvaluator", (Object)ltEvaluator);
                }
                return ltEvaluator;
            }
            case 3: 
            case 6: {
                GtEvaluator gtEvaluator = new GtEvaluator(columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeDefaultEvaluator", (Object)gtEvaluator);
                }
                return gtEvaluator;
            }
            case 11: 
            case 12: {
                BetweenEvaluator betweenEvaluator = new BetweenEvaluator(columnFilter, customReportDataAdjuster);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeDefaultEvaluator", (Object)betweenEvaluator);
                }
                return betweenEvaluator;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeDefaultEvaluator");
        }
        throw ReportFilter.badFilterCondition(guiReportReq, columnFilter);
    }

    private void convertOffsetFilter(ColumnFilter columnFilter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"convertOffsetFilter", (String)"filter");
        }
        switch (columnFilter.clfCondition) {
            case 4: {
                columnFilter.clfCondition = (short)6;
                break;
            }
            case 5: {
                columnFilter.clfCondition = (short)3;
                break;
            }
            case 6: {
                columnFilter.clfCondition = (short)4;
                break;
            }
            case 3: {
                columnFilter.clfCondition = (short)5;
                break;
            }
            case 11: 
            case 12: {
                ColumnFilterValue columnFilterValue = columnFilter.clfValueList;
                ColumnFilterValue columnFilterValue2 = columnFilterValue.fvNext;
                columnFilterValue2.fvNext = columnFilterValue;
                columnFilterValue.fvNext = null;
                columnFilter.clfValueList = columnFilterValue2;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"convertOffsetFilter");
                }
                throw ReportFilter.badFilterCondition(this.grr, columnFilter);
            }
        }
        long l = System.currentTimeMillis();
        ColumnFilterValue columnFilterValue = columnFilter.clfValueList;
        while (columnFilterValue != null) {
            MutableLong mutableLong = (MutableLong)columnFilterValue.fvValue;
            columnFilterValue.fvValue = new Date(l - mutableLong.value);
            columnFilterValue = columnFilterValue.fvNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"convertOffsetFilter");
        }
    }

    public static GeneralException badFilterCondition(GuiReportReq guiReportReq, ColumnFilter columnFilter) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"badFilterCondition", (String)"grr, filter");
        }
        Object[] objectArray = new Object[]{Integer.toString(guiReportReq.reportType), Integer.toString(columnFilter.clfColumnID), Integer.toString(columnFilter.clfCondition)};
        GeneralException generalException = new GeneralException("STS0308E", objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"badFilterCondition", (Object)((Object)generalException));
        }
        return generalException;
    }

    public boolean isSelected(Object object) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isSelected", (String)"dataRecord");
        }
        this.dataArray[0] = object;
        this.adjuster.adjustData();
        boolean bl = true;
        FilterEvaluator filterEvaluator = this.evaluatorList;
        while (filterEvaluator != null) {
            bl = filterEvaluator.isSelected(this.frozenRows);
            if (bl == this.breakCondition) break;
            filterEvaluator = filterEvaluator.nextEvaluator;
        }
        if (bl) {
            this.adjuster.undo();
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.filter.ReportFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isSelected", (boolean)bl2);
        }
        return bl2;
    }
}

