/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.ConfigParser;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.UninstallAgentDriver;
import org.eclipse.aperi.server.handler.server.GuiToAgentHndlr;
import org.eclipse.aperi.server.req.GuiToAgentReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class TAgent {
    public int serverID = Server.getServerID();
    public int port;
    public byte state = 1;
    public long timestamp;
    public TComputer computer;
    public byte modification;
    public byte[] productState;
    public byte[] productVersions;
    public int featureSet;
    public static final int PRODUCT_ENTRY_LENGTH = 3;
    private static final byte[] DUMMY_PRODUCT_STATES = new byte[1];
    private static final String INSERT_SQL = "insert into t_res_agent (server_id, port_number, state, time_stamp, computer_id, processor_type, processor_number, modification, product_states, product_versions, feature_set) values (?,?,?,?,?,'0',0,?,?,?,?)";
    private static final String UPDATE_CLAUSE = "update t_res_agent set server_id = ?, port_number = ?, state = ?, time_stamp = ?";
    private static final String UPDATE_VERSIONS = ", product_versions = ?";
    private static final String UPDATE_FEATURE_SET = ", feature_set = ?";
    private static final String UPDATE_WHERE = " where computer_id = ?";
    private static final String SELECT_SQL = "select a.port_number, a.state, a.time_stamp, a.computer_id, c.host_name, c.vendor_id, c.hardware_id, c.host_url, c.os_type, c.cpu_architecture, c.network_name, c.domain_name, c.ip_address, c.time_zone, a.modification, c.product_states, a.product_versions, a.feature_set from t_res_agent a, t_res_host c where a.computer_id = c.computer_id and a.server_id = ?";
    private static final String SELECT_BY_HOST = " and (c.host_name = ? or c.vendor_id = ? and c.guid = ?)";
    private static final String SELECT_AGENTDATA_SQL = "select a.port_number, a.state, a.time_stamp, a.computer_id, c.host_name, c.vendor_id, c.hardware_id, c.host_url, c.os_type, c.cpu_architecture, c.network_name, c.domain_name, c.ip_address, c.time_zone, a.modification, c.product_states, a.product_versions, a.feature_set from t_res_agent a, t_res_host c where a.computer_id = c.computer_id and c.guid = ?";
    private static final String SELECT_AGENT_SQL = "select a.computer_id from t_res_agent a, t_res_host c where a.computer_id = c.computer_id and c.guid = ?";

    public TAgent(String string, int n, long l, HardwareID hardwareID, String string2, String string3, String string4, byte[] byArray, SoftwareVersion[] softwareVersionArray, int n2, String string5) {
        this.port = n;
        this.timestamp = l;
        this.productState = byArray;
        this.productVersions = TAgent.getVersionArray(softwareVersionArray);
        this.featureSet = n2;
        this.computer = new TComputer(string, hardwareID, string2, string3, string4, byArray, string5);
    }

    public TAgent() {
        this.computer = new TComputer();
    }

    public static byte[] getVersionArray(SoftwareVersion[] softwareVersionArray) {
        byte[] byArray = new byte[softwareVersionArray.length * 3];
        int n = 0;
        while (n < softwareVersionArray.length) {
            SoftwareVersion softwareVersion = softwareVersionArray[n];
            if (softwareVersion != null) {
                int n2 = n * 3;
                byArray[n2] = softwareVersion.svVersion;
                byArray[n2 + 1] = softwareVersion.svRelease;
                byArray[n2 + 2] = (byte)softwareVersion.svModification;
            }
            ++n;
        }
        return byArray;
    }

    public boolean registerAgent(TAgent tAgent, String string) {
        boolean bl;
        Connection connection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"registerAgent", (String)"repoAgent, newAgentLogDir");
        }
        if ((connection = Server.getConnection()) == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"registerAgent", (boolean)false);
            }
            return false;
        }
        int n = 16;
        if (tAgent == null && this.queryForAgent(connection)) {
            try {
                tAgent = this.getRepoAgent(connection);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"registerAgent", (Throwable)sQLException);
                }
                SQLUtil.logSQLException("SRV0059E", sQLException, null);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"registerAgent");
                }
                tAgent = null;
            }
        }
        if (tAgent == null) {
            n = this.addAgentRegistry(connection);
        } else {
            this.computer.computerID = tAgent.computer.computerID;
            if (string != null && tAgent.productVersions[0] == 1 && this.productVersions[0] >= 2) {
                this.updateAgentLogLocations(string, connection);
            }
            n = this.updateAgentRegistry(tAgent, connection);
        }
        Server.returnConnection(connection);
        if (n == 0) {
            HostAgentPingDbAccess.updateHostStatus((int)this.computer.computerID, (int)1);
        }
        boolean bl2 = bl = n != 16;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"registerAgent", (boolean)bl);
        }
        return bl;
    }

    private int addAgentRegistry(Connection connection) {
        if (this.computer.addComputer(connection) != 0) {
            return 16;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(INSERT_SQL);
            preparedStatement.setInt(1, this.serverID);
            preparedStatement.setInt(2, this.port);
            SQLUtil.setByte(preparedStatement, 3, this.state);
            preparedStatement.setTimestamp(4, new Timestamp(this.timestamp));
            preparedStatement.setInt(5, this.computer.computerID);
            SQLUtil.setByte(preparedStatement, 6, (byte)0);
            SQLUtil.setBytes(preparedStatement, 7, DUMMY_PRODUCT_STATES);
            SQLUtil.setBytes(preparedStatement, 8, this.productVersions);
            preparedStatement.setBytes(9, TAgent.intToBytes(this.featureSet));
            preparedStatement.executeUpdate();
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0061E", sQLException, null);
            return 16;
        }
        return 0;
    }

    private int updateAgentRegistry(TAgent tAgent, Connection connection) {
        if (!this.computer.equalsRepositoryComputer(tAgent.computer) && this.computer.updateComputer(tAgent.computer, connection) != 0) {
            return 16;
        }
        MutableInteger mutableInteger = new MutableInteger(this.featureSet);
        return TAgent.updateAgent(this.computer.computerID, this.serverID, this.port, this.state, this.timestamp, this.productState, this.productVersions, mutableInteger, connection);
    }

    private int updateAgentLogLocations(String string, Connection connection) {
        String string2 = "update t_run_jobs set log_file_name = ? where log_file_name = ?";
        PreparedStatement preparedStatement = null;
        int n = -1;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = string.length();
        try {
            Vector vector = this.getAgentLogLocations(connection);
            stringBuffer2.append(string);
            int n3 = 0;
            while (n3 < vector.size()) {
                string3 = (String)vector.get(n3);
                stringBuffer.setLength(0);
                stringBuffer.append(string3);
                n = string3.lastIndexOf("\\");
                if (n > -1 || (n = string3.lastIndexOf("//")) > -1 || (n = string3.lastIndexOf("/")) > -1) {
                    stringBuffer2.setLength(n2);
                    stringBuffer2.append(string3.substring(n));
                    preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setString(1, stringBuffer2.toString());
                    preparedStatement.setString(2, stringBuffer.toString());
                    preparedStatement.executeUpdate();
                    connection.commit();
                    preparedStatement.close();
                }
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            String string4 = String.valueOf(stringBuffer.toString()) + " Statement: " + string2;
            Object[] objectArray = new Object[]{string4};
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0084E", sQLException, objectArray);
            return 16;
        }
        return 0;
    }

    private Vector getAgentLogLocations(Connection connection) {
        String cfr_ignored_0 = this.computer.tsName;
        String string = "select log_file_name from t_run_jobs where computer_id = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, this.computer.computerID);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            String string2 = "the log files of computer " + this.computer.computerID + "Statement: " + string;
            Object[] objectArray = new Object[]{string2};
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0082E", sQLException, objectArray);
        }
        return vector;
    }

    public static Iterator getManagedAgents(TAgent tAgent, Connection connection) {
        SqlQuery sqlQuery = null;
        try {
            sqlQuery = TAgent.queryPrepare(tAgent.serverID, null, null, null, connection);
        }
        catch (SQLException sQLException) {
            return null;
        }
        return new AgentIterator(tAgent, sqlQuery);
    }

    public static TAgent getAgent(int n, TComputer tComputer, Connection connection) throws SQLException {
        TAgent tAgent;
        String string = tComputer.tsName;
        HardwareID hardwareID = tComputer.hwID;
        SqlQuery sqlQuery = TAgent.queryPrepare(n, string, hardwareID, tComputer.guid, connection);
        TAgent tAgent2 = new TAgent();
        if ((tAgent2 = TAgent.queryFetch(sqlQuery, tAgent2)) != null && TAgent.queryFetch(sqlQuery, tAgent = new TAgent()) != null) {
            Object object;
            TAgent tAgent3 = null;
            TAgent tAgent4 = null;
            if (tComputer.ipAddress.compareToIgnoreCase(tAgent2.computer.ipAddress) == 0) {
                tAgent3 = tAgent;
                tAgent4 = tAgent2;
            } else if (tComputer.ipAddress.compareToIgnoreCase(tAgent.computer.ipAddress) == 0) {
                tAgent3 = tAgent2;
                tAgent4 = tAgent;
            }
            if (tAgent3 != null) {
                TAgent.contactAgent(tAgent3.computer.computerID);
                object = Server.getAgentManager();
                AgentManager.AgentAddress agentAddress = ((AgentManager)object).getAgent(tAgent3.computer.computerID);
                if (agentAddress.state == 0 || agentAddress.state == 1 && agentAddress.consecutiveErrors > 0) {
                    Object object2;
                    byte by;
                    String string2 = TAgent.getDupCompInfoOption();
                    if (string2.compareToIgnoreCase("delete") == 0) {
                        by = 0;
                        object2 = new UninstallAgentDriver(tAgent4.computer.computerID, by);
                        object2.start();
                    } else if (string2.compareToIgnoreCase("keep") == 0) {
                        by = 0;
                        object2 = "DECOMM-" + tAgent4.computer.tsName;
                        String string3 = "DECOMM-" + tAgent4.computer.networkName;
                        TComputer.updateCompNames(tAgent4.computer.computerID, (String)object2, string3, connection);
                        ((AgentManager)object).setState(tAgent4.computer.computerID, by);
                    }
                }
            }
            object = new StringBuffer(40);
            MessageLog.logMessage((String)"GEN0181E", (Object)string);
            TAgent.logAgent(string, hardwareID, (StringBuffer)object);
            TAgent.logAgent(tAgent2.computer.tsName, tAgent2.computer.hwID, (StringBuffer)object);
            do {
                TAgent.logAgent(tAgent.computer.tsName, tAgent.computer.hwID, (StringBuffer)object);
            } while (TAgent.queryFetch(sqlQuery, tAgent) != null);
        }
        sqlQuery.close();
        if (tAgent2 == null && !Util.isEmpty((String)tComputer.networkName) && !Util.isEmpty((String)tComputer.domainName)) {
            tComputer.updateRdbmsHost(connection);
        }
        return tAgent2;
    }

    private TAgent getRepoAgent(Connection connection) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getRepoAgent", (String)"dbConnection");
        }
        SqlQuery sqlQuery = TAgent.queryPrepare(this.computer.guid, connection);
        TAgent tAgent = new TAgent();
        tAgent = TAgent.queryFetch(sqlQuery, tAgent);
        sqlQuery.close();
        if (tAgent == null && !Util.isEmpty((String)this.computer.networkName) && !Util.isEmpty((String)this.computer.domainName)) {
            this.computer.updateRdbmsHost(connection);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getRepoAgent", (Object)tAgent);
        }
        return tAgent;
    }

    private static void contactAgent(int n) {
        Request request = new Request();
        GuiToAgentReq guiToAgentReq = new GuiToAgentReq();
        guiToAgentReq.computerID = n;
        guiToAgentReq.requestHandler = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        guiToAgentReq.agentData = new AgentStatusReq(false);
        request.flags = (byte)4;
        request.machineName = Server.getServerHostName();
        request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.server.svp.ServerSvp");
        request.requestData = guiToAgentReq;
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.userName = "administrator";
        GuiToAgentHndlr guiToAgentHndlr = new GuiToAgentHndlr();
        guiToAgentHndlr.handle(request, null);
    }

    private static String getDupCompInfoOption() {
        String string = "server.config";
        String string2 = "configuration" + File.separator + "repository.config";
        ConfigParser configParser = new ConfigParser("configuration" + File.separator + string, string2);
        if (!configParser.parse()) {
            return "";
        }
        return configParser.dupCompInfo;
    }

    private static void logAgent(String string, HardwareID hardwareID, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < hardwareID.hardwareID.length) {
            int n2 = hardwareID.hardwareID[n] >> 4 & 0xF;
            int n3 = hardwareID.hardwareID[n] & 0xF;
            stringBuffer.append(Integer.toHexString(n2));
            stringBuffer.append(Integer.toHexString(n3));
            ++n;
        }
        MessageLog.logMessage((String)"GEN0182I", (Object)string, (Object)hardwareID.manufacturer, (Object)stringBuffer.toString());
    }

    public static int updateAgent(int n, int n2, int n3, byte by, long l, byte[] byArray, byte[] byArray2, MutableInteger mutableInteger, Connection connection) {
        if (!TComputer.updateState(n, byArray, connection)) {
            return 16;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(UPDATE_CLAUSE);
        if (byArray2 != null) {
            stringBuffer.append(UPDATE_VERSIONS);
        }
        if (mutableInteger != null) {
            stringBuffer.append(UPDATE_FEATURE_SET);
        }
        stringBuffer.append(UPDATE_WHERE);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n3);
            SQLUtil.setByte(preparedStatement, 3, by);
            preparedStatement.setTimestamp(4, new Timestamp(l));
            int n4 = 5;
            if (byArray2 != null) {
                SQLUtil.setBytes(preparedStatement, n4++, byArray2);
            }
            if (mutableInteger != null) {
                preparedStatement.setBytes(n4++, TAgent.intToBytes(mutableInteger.value));
            }
            preparedStatement.setInt(n4, n);
            preparedStatement.executeUpdate();
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0060E", sQLException, null);
            return 16;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public static void deleteAgent(int var0, Connection var1_1) throws GeneralException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 137->141)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean queryForAgent(Connection connection) {
        Class<?> clazz;
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"queryForAgent", (String)"dbConnection");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            block20: {
                try {
                    preparedStatement = connection.prepareStatement(SELECT_AGENT_SQL);
                    preparedStatement.setString(1, this.computer.guid);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    Class<?> clazz3;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz4;
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz4.getName(), (String)"queryForAgent", (Throwable)sQLException);
                    }
                    SQLUtil.errorCleanup(connection, preparedStatement);
                    SQLUtil.logSQLException("SRV0059E", sQLException, null);
                    if (!TraceLogger.enableTrace) break block20;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz3.getName(), (String)"queryForAgent");
                }
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (preparedStatement == null) throw throwable;
                preparedStatement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        boolean bl2 = bl;
        if (!TraceLogger.enableTrace) return bl2;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"queryForAgent", (boolean)bl2);
        return bl2;
    }

    private static SqlQuery queryPrepare(int n, String string, HardwareID hardwareID, String string2, Connection connection) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(SELECT_SQL);
        if (string != null && hardwareID != null) {
            stringBuffer.append(SELECT_BY_HOST);
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, n);
            if (string != null && hardwareID != null) {
                preparedStatement.setString(2, string);
                TResVendorModel tResVendorModel = new TResVendorModel(connection);
                short s = tResVendorModel.getVendorID(hardwareID.manufacturer);
                preparedStatement.setShort(3, s);
                preparedStatement.setString(4, string2);
            }
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0059E", sQLException, null);
            throw sQLException;
        }
        catch (GeneralException generalException) {}
        return new SqlQuery(connection, preparedStatement, resultSet);
    }

    private static SqlQuery queryPrepare(String string, Connection connection) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryPrepare", (String)"guid, dbConnection");
        }
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(SELECT_AGENTDATA_SQL);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"queryPrepare", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0059E", sQLException, null);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"queryPrepare");
            }
            throw sQLException;
        }
        SqlQuery sqlQuery = new SqlQuery(connection, preparedStatement, resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryPrepare", (Object)sqlQuery);
        }
        return sqlQuery;
    }

    private static TAgent queryFetch(SqlQuery sqlQuery, TAgent tAgent) throws SQLException {
        Connection connection;
        ResultSet resultSet;
        block4: {
            resultSet = sqlQuery.resultSet;
            connection = Server.getConnection();
            if (resultSet.next()) break block4;
            sqlQuery.close();
            return null;
        }
        try {
            TComputer tComputer = tAgent.computer;
            tAgent.port = resultSet.getInt(1);
            tAgent.state = SQLUtil.getByte(resultSet, 2);
            tAgent.timestamp = resultSet.getTimestamp(3).getTime();
            tComputer.computerID = resultSet.getInt(4);
            tComputer.tsName = resultSet.getString(5);
            TResVendorModel tResVendorModel = new TResVendorModel(connection);
            tComputer.hwID.manufacturer = tResVendorModel.getVendorName(resultSet.getShort(6));
            tComputer.hwID.hardwareID = SQLUtil.getBytes(resultSet, 7);
            tComputer.hwID.hostName = resultSet.getString(8);
            tComputer.hwID.osType = resultSet.getShort(9);
            tComputer.hwID.cpuArchitecture = resultSet.getShort(10);
            tComputer.networkName = resultSet.getString(11);
            tComputer.domainName = resultSet.getString(12);
            tComputer.ipAddress = resultSet.getString(13);
            tComputer.timezoneID = resultSet.getString(14);
            tAgent.modification = SQLUtil.getByte(resultSet, 15);
            tAgent.productState = SQLUtil.getBytes(resultSet, 16);
            tAgent.productVersions = SQLUtil.getBytes(resultSet, 17);
            tAgent.featureSet = TAgent.bytesToInt(resultSet.getBytes(18));
        }
        catch (SQLException sQLException) {
            SQLUtil.errorCleanup(sqlQuery.dbConnection, sqlQuery.stmt);
            SQLUtil.logSQLException("SRV0059E", sQLException, null);
            throw sQLException;
        }
        catch (GeneralException generalException) {}
        Server.returnConnection(connection);
        return tAgent;
    }

    private static byte[] intToBytes(int n) {
        int n2 = -16777216;
        int n3 = 4;
        while (n3 > 1 && (n & n2) == 0) {
            n2 >>= 8;
            --n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = (byte)n;
            n >>= 8;
            ++n4;
        }
        return byArray;
    }

    private static int bytesToInt(byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            int n2 = byArray.length;
            if (n2 > 4) {
                n2 = 4;
            }
            while (n2 > 0) {
                n <<= 8;
                int n3 = byArray[--n2];
                n |= (n3 &= 0xFF);
            }
        }
        return n;
    }

    private static class SqlQuery {
        Connection dbConnection;
        PreparedStatement stmt;
        ResultSet resultSet;

        SqlQuery(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
            this.dbConnection = connection;
            this.stmt = preparedStatement;
            this.resultSet = resultSet;
        }

        public void close() {
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                    this.dbConnection.commit();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static class AgentIterator
    implements Iterator {
        TAgent returnArea;
        SqlQuery query;
        TAgent fetchedRow;
        boolean SQLError;

        AgentIterator(TAgent tAgent, SqlQuery sqlQuery) {
            this.returnArea = tAgent;
            this.query = sqlQuery;
        }

        public boolean hasNext() {
            try {
                this.fetchedRow = TAgent.queryFetch(this.query, this.returnArea);
            }
            catch (SQLException sQLException) {
                this.SQLError = true;
                this.fetchedRow = this.returnArea;
            }
            return this.fetchedRow != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.fetchedRow == null || this.SQLError) {
                throw new NoSuchElementException();
            }
            this.fetchedRow = null;
            return this.returnArea;
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }
}

