/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.xmsg.MessageLog;

public class TComputer {
    public int computerID = -1;
    public HardwareID hwID;
    public String tsName;
    public String ipAddress;
    public String networkName;
    public String domainName;
    public String timezoneID;
    public byte[] productState = null;
    public TComputer next = null;
    public String guid = null;
    public boolean wasAgentLess;
    private TComputer dupRegComputer = null;
    private static final String SELECT_SQL_TEXT = "select computer_id, vendor_id, hardware_id, host_url, os_type, host_name, network_name, domain_name, ip_address, time_zone, product_states, guid, cpu_architecture from t_res_host ";
    private static final String SELECT_BY_HOST = "where host_name = ? or (vendor_id = ? and hardware_id = ?)";
    private static final String SELECT_BY_ID = "where computer_id = ?";
    private static final String SELECT_BY_GUID = "where guid = ?";
    private static final String SELECT_SS_SQL_TEXT = "select subsystem_id, vendor_id,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name  else display_name end display_name,  os_type, name, ip_address, product_states from t_res_storage_subsystem ";
    private static final String SELECT_BY_SS_ID = "where subsystem_id = ?";
    private static final String INSERT_SQL_TEXT = "insert into t_res_host (computer_id, vendor_id, hardware_id, host_url, os_type, host_name, network_name, domain_name, ip_address, time_zone, discovered_time, product_states, guid, cpu_architecture, original_alias)  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SS_SQL_TEXT = "insert into t_res_storage_subsystem (vendor_id,  display_name, os_type, name, name_type, ip_address, product_states)  values (?,?,?,?,?,?,?)";
    private PreparedStatement insert = null;
    private static final String UPDATE_SQL_TEXT = "update t_res_host set ip_address = ?, time_zone = ?, host_url = ?, os_type = ?, cpu_architecture = ?";
    private static String UPDATE_RDBMS_HOST_SQL_TEXT = "update t_res_host set host_name = ?, vendor_id = ?, hardware_id = ? where network_name = ? and domain_name = ? and os_type = 24";
    private static final String UPDATE_STATE_TEXT = "update t_res_host set product_states = ? where computer_id = ?";
    private static final String UPDATE_OSVERSION_TEXT = "update t_res_host set os_version = ? where computer_id = ?";
    private static final String UPDATE_NAMENSTATE_TEXT = " update t_res_host set host_name = ?, host_url = ?,  network_name = ?  where computer_id = ?";
    private PreparedStatement stateUpdate = null;

    public TComputer(String string, HardwareID hardwareID, String string2, String string3, String string4, byte[] byArray, String string5) {
        this(string, hardwareID, null, null, string3, string4, byArray, string5);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TComputer", (String)"tsName, hwID, netName, ipAddress, timezoneID, pProductState, guid");
        }
        if (string2 != null) {
            int n = string2.indexOf(46);
            if (n < 0) {
                this.networkName = string2;
            } else {
                this.networkName = string2.substring(0, n);
                this.domainName = string2.substring(n + 1);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TComputer");
        }
    }

    public TComputer(String string, HardwareID hardwareID, String string2, String string3, String string4, String string5, byte[] byArray, String string6) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TComputer", (String)"tsName, hwID, networkName, domainName, ipAddress, timezoneID, productState, guid");
        }
        this.tsName = string;
        this.hwID = hardwareID;
        this.timezoneID = string5;
        this.ipAddress = string4;
        this.networkName = string2;
        this.domainName = string3;
        this.productState = byArray;
        this.guid = string6;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TComputer");
        }
    }

    public TComputer() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TComputer", (String)"");
        }
        this.hwID = new HardwareID(null, null, null, 0);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TComputer");
        }
    }

    public static TComputer getComputer(String string, HardwareID hardwareID, int n, String string2, Connection connection) throws SQLException {
        Object object;
        TComputer tComputer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputer", (String)"tsName, hwID, computerID, guid, dbConnection");
        }
        TComputer tComputer2 = tComputer = new TComputer();
        TComputer tComputer3 = null;
        PreparedStatement preparedStatement = null;
        TResVendorModel tResVendorModel = new TResVendorModel(connection);
        try {
            object = new StringBuffer(256);
            ((StringBuffer)object).append(SELECT_SQL_TEXT);
            if (n == -1) {
                ((StringBuffer)object).append(SELECT_BY_HOST);
            } else if (n == -3) {
                ((StringBuffer)object).append(SELECT_BY_GUID);
            } else if (n != -2) {
                ((StringBuffer)object).append(SELECT_BY_ID);
            }
            preparedStatement = connection.prepareStatement(((StringBuffer)object).toString());
            if (n == -1 && hardwareID != null) {
                preparedStatement.setString(1, string);
                short s = tResVendorModel.getVendorID(hardwareID.manufacturer);
                preparedStatement.setShort(2, s);
                SQLUtil.setBytes(preparedStatement, 3, hardwareID.hardwareID);
            } else if (n == -3) {
                preparedStatement.setString(1, string2);
            } else if (n != -2) {
                preparedStatement.setInt(1, n);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
                String string3 = tResVendorModel.getVendorName(resultSet.getShort(2));
                byte[] byArray = SQLUtil.getBytes(resultSet, 3);
                String string4 = resultSet.getString(4);
                short s = resultSet.getShort(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                String string7 = resultSet.getString(8);
                String string8 = resultSet.getString(9);
                String string9 = resultSet.getString(10);
                byte[] byArray2 = SQLUtil.getBytes(resultSet, 11);
                String string10 = resultSet.getString(12);
                short s2 = resultSet.getShort(13);
                HardwareID hardwareID2 = new HardwareID(byArray, string3, string4, s, s2);
                tComputer3 = new TComputer(string5, hardwareID2, string6, string7, string8, string9, byArray2, string10);
                tComputer3.computerID = n;
                tComputer2.next = tComputer3;
                tComputer2 = tComputer3;
            }
            preparedStatement.close();
            connection.commit();
            TComputer.getSS(n, connection, tComputer, tComputer2);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputer", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            if (string == null) {
                string = "COMPUTER ID:" + n;
            }
            SQLUtil.logSQLException("SRV0052E", sQLException, new Object[]{string});
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getComputer");
            }
            throw sQLException;
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputer", (Throwable)generalException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
        }
        object = tComputer.next;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputer", (Object)object);
        }
        return object;
    }

    public static TComputer getSS(int n, Connection connection) throws SQLException {
        return TComputer.getSS(n, connection, null, null);
    }

    private static TComputer getSS(int n, Connection connection, TComputer tComputer, TComputer tComputer2) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSS", (String)"tsName, hwID, computerID, dbConnection");
        }
        TComputer tComputer3 = null;
        TComputer tComputer4 = null;
        TComputer tComputer5 = null;
        TComputer tComputer6 = null;
        if (tComputer != null) {
            tComputer3 = tComputer;
            tComputer4 = tComputer2;
        } else {
            tComputer4 = tComputer3 = new TComputer();
        }
        PreparedStatement preparedStatement = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(SELECT_SS_SQL_TEXT);
            if (n != -2) {
                stringBuffer.append(SELECT_BY_SS_ID);
            }
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            if (n != -2) {
                preparedStatement.setInt(1, n);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
                TResVendorModel tResVendorModel = new TResVendorModel(connection);
                String string = tResVendorModel.getVendorName(resultSet.getShort(2));
                String string2 = resultSet.getString(3);
                short s = resultSet.getShort(4);
                String string3 = resultSet.getString(5);
                String string4 = resultSet.getString(6);
                byte[] byArray = SQLUtil.getBytes(resultSet, 7);
                HardwareID hardwareID = new HardwareID(null, string, string2, s, -1);
                tComputer5 = new TComputer(string3, hardwareID, null, null, string4, null, byArray, null);
                tComputer5.computerID = n;
                tComputer4.next = tComputer5;
                tComputer4 = tComputer5;
            }
            preparedStatement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputer", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0052E", sQLException, new Object[]{new Integer(n)});
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getComputer");
            }
            throw sQLException;
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getSS", (Throwable)generalException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
        }
        tComputer6 = tComputer != null ? tComputer3 : tComputer3.next;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSS", (Object)tComputer6);
        }
        return tComputer6;
    }

    public int addComputer(Connection connection) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addComputer", (String)"dbConnection");
        }
        if ((n = this.insertComputer(connection)) == 4) {
            TComputer tComputer;
            block37: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"addComputer", (String)"Could not insert new computer for ");
                }
                tComputer = null;
                try {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"addComputer", (String)("Duplicate computer exists; trying to find computer with name and hwID: " + this.tsName + ", " + this.hwID.hostName + ", " + this.hwID.hardwareID + " in the repository"));
                    }
                    tComputer = this.dupRegComputer == null ? TComputer.getComputer(null, null, -3, this.guid, connection) : this.dupRegComputer;
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block37;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"addComputer", (Throwable)sQLException);
                }
            }
            if (tComputer == null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"addComputer", (String)("Could not find a computer with name and hwID: " + this.tsName + ", " + this.hwID.hostName + ", " + this.hwID.hardwareID + " in the repository"));
                }
                int n2 = 16;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"addComputer", (int)n2);
                }
                return n2;
            }
            this.computerID = tComputer.computerID;
            if (!this.equalsRepositoryComputer(tComputer)) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"addComputer", (String)("Found a computer with name and hwID: " + this.tsName + ", " + this.hwID.hostName + ", " + this.hwID.hardwareID + " GUID = " + this.guid + " in the repository"));
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"addComputer", (String)("Updating repository with computer found: " + tComputer.tsName + ", " + tComputer.hwID.hostName + ", " + tComputer.hwID.hardwareID + " GUID " + tComputer.guid));
                }
                int n3 = this.updateComputer(tComputer, connection);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"addComputer", (int)n3);
                }
                return n3;
            }
            int n4 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"addComputer", (int)n4);
            }
            return n4;
        }
        int n5 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addComputer", (int)n5);
        }
        return n5;
    }

    public int insertComputer(Connection connection) {
        int n;
        block38: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"insertComputer", (String)"dbConnection");
            }
            TComputer tComputer = null;
            try {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"insertComputer", (String)("Calling getCommputer() to locate computer with guid: " + this.guid));
                }
                if ((tComputer = TComputer.getComputer(null, null, -3, this.guid, connection)) == null) break block38;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"insertComputer", (String)("Found a computer with guid: " + this.guid + "computerID: " + tComputer.computerID));
                }
                int n2 = 4;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"insertComputer", (int)n2);
                }
                this.dupRegComputer = tComputer;
                return n2;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"insertComputer", (Throwable)sQLException);
                }
                SQLUtil.logSQLException("SRV0050E", sQLException, new Object[]{this.tsName});
                int n3 = 16;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"insertComputer", (int)n3);
                }
                return n3;
            }
        }
        try {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"insertComputer", (String)("Did not find computer with guid: " + this.guid + " inserting " + "new row into repo"));
            }
            this.prepareInsert(connection);
            n = SQLUtil.getIdentifier(1, 1, connection);
            this.insertComputer(connection, n);
            this.closeInsert();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertComputer", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, this.insert);
            if (SQLUtil.isDuplicateKeyViolation(sQLException)) {
                int n4 = 4;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"insertComputer", (int)n4);
                }
                return n4;
            }
            SQLUtil.logSQLException("SRV0050E", sQLException, new Object[]{this.tsName});
            int n5 = 16;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"insertComputer", (int)n5);
            }
            return n5;
        }
        n = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertComputer", (int)n);
        }
        return n;
    }

    public void insertComputer(Connection connection, int n) throws SQLException {
        block12: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"insertComputer", (String)"dbConnection, cmpID");
            }
            try {
                byte[] byArray;
                this.insert.setInt(1, n);
                TResVendorModel tResVendorModel = new TResVendorModel(connection);
                short s = tResVendorModel.getVendorID(this.hwID.manufacturer);
                this.insert.setShort(2, s);
                SQLUtil.setBytes(this.insert, 3, this.hwID.hardwareID);
                this.insert.setString(4, this.hwID.hostName);
                this.insert.setShort(5, this.hwID.osType);
                this.insert.setString(6, this.tsName);
                this.insert.setString(7, this.networkName == null ? " " : this.networkName);
                this.insert.setString(8, this.domainName == null ? " " : this.domainName);
                this.insert.setString(9, this.ipAddress);
                this.insert.setString(10, this.timezoneID);
                this.insert.setTimestamp(11, new Timestamp(SQLUtil.getTimestamp(connection).getTime()));
                if (this.productState == null) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 14;
                } else {
                    byArray = this.productState;
                }
                SQLUtil.setBytes(this.insert, 12, byArray);
                this.insert.setString(13, this.guid);
                this.insert.setShort(14, this.hwID.cpuArchitecture);
                this.insert.setString(15, this.hwID.hostName);
                this.insert.executeUpdate();
                connection.commit();
                this.computerID = n;
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block12;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertComputer", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertComputer");
        }
    }

    public void insertSS(Connection connection) throws SQLException, GeneralException {
        byte[] byArray;
        short s = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertSS", (String)"dbConnection");
        }
        TResVendorModel tResVendorModel = new TResVendorModel(connection);
        short s2 = tResVendorModel.getVendorID(this.hwID.manufacturer);
        this.insert.setShort(1, s2);
        this.insert.setString(2, this.hwID.hostName);
        this.insert.setShort(3, this.hwID.osType);
        this.insert.setString(4, this.tsName);
        this.insert.setShort(5, s);
        this.insert.setString(6, this.ipAddress);
        if (this.productState == null) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 14;
        } else {
            byArray = this.productState;
        }
        SQLUtil.setBytes(this.insert, 7, byArray);
        this.insert.executeUpdate();
        connection.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertSS");
        }
    }

    public void prepareInsert(Connection connection) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareInsert", (String)"dbConnection");
        }
        this.insert = connection.prepareStatement(INSERT_SQL_TEXT);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareInsert");
        }
    }

    public void prepareInsertSS(Connection connection) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareInsertSS", (String)"dbConnection");
        }
        this.insert = connection.prepareStatement(INSERT_SS_SQL_TEXT);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareInsert");
        }
    }

    public void closeInsert() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeInsert", (String)"");
        }
        if (this.insert != null) {
            block11: {
                try {
                    this.insert.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block11;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"closeInsert", (Throwable)sQLException);
                }
            }
            this.insert = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeInsert");
        }
    }

    public int updateComputer(TComputer tComputer, Connection connection) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateComputer", (String)"repoComputer, dbConnection");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(UPDATE_SQL_TEXT);
        if (this.networkName != null) {
            stringBuffer.append(", network_name = ?, domain_name = ?");
        }
        if (!this.tsName.equals(tComputer.tsName)) {
            stringBuffer.append(", host_name = ?");
            bl = true;
        }
        if (!this.hwID.equals((Object)tComputer.hwID)) {
            stringBuffer.append(", vendor_id = ?, hardware_id = ?");
            bl2 = true;
        }
        if (this.productState != null && !Arrays.equals(this.productState, tComputer.productState)) {
            stringBuffer.append(", product_states = ?");
            bl3 = true;
        }
        if (!this.guidEqual(this.guid, tComputer.guid)) {
            stringBuffer.append(", guid = ?");
            bl4 = true;
        }
        stringBuffer.append(" where computer_id = ?");
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.ipAddress);
            preparedStatement.setString(2, this.timezoneID);
            preparedStatement.setString(3, this.hwID.hostName);
            preparedStatement.setShort(4, this.hwID.osType);
            preparedStatement.setShort(5, this.hwID.cpuArchitecture);
            n = 6;
            if (this.networkName != null) {
                preparedStatement.setString(n++, this.networkName);
                preparedStatement.setString(n++, this.domainName == null ? " " : this.domainName);
            }
            if (bl) {
                preparedStatement.setString(n++, this.tsName);
            }
            if (bl2) {
                TResVendorModel tResVendorModel = new TResVendorModel(connection);
                short s = tResVendorModel.getVendorID(this.hwID.manufacturer);
                preparedStatement.setShort(n++, s);
                SQLUtil.setBytes(preparedStatement, n++, this.hwID.hardwareID);
            }
            if (bl3) {
                byte[] byArray;
                int n3 = n++;
                if (this.productState == null) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 14;
                } else {
                    byArray = this.productState;
                }
                SQLUtil.setBytes(preparedStatement, n3, byArray);
            }
            if (bl4) {
                preparedStatement.setString(n++, this.guid);
            }
            preparedStatement.setInt(n, this.computerID);
            if (preparedStatement.executeUpdate() == 0) {
                n2 = 100;
            }
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateComputer", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0053E", sQLException, new Object[]{this.tsName, new Integer(this.computerID)});
            int n4 = 16;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"updateComputer", (int)n4);
            }
            return n4;
        }
        catch (GeneralException generalException) {}
        n = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateComputer", (int)n);
        }
        return n;
    }

    public int updateRdbmsHost(Connection connection) {
        int n;
        block16: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"updateRdbmsHost", (String)"repoComputer, dbConnection");
            }
            PreparedStatement preparedStatement = null;
            n = 0;
            try {
                preparedStatement = connection.prepareStatement(UPDATE_RDBMS_HOST_SQL_TEXT);
                preparedStatement.setString(1, this.tsName);
                TResVendorModel tResVendorModel = new TResVendorModel(connection);
                short s = tResVendorModel.getVendorID(this.hwID.manufacturer);
                preparedStatement.setShort(2, s);
                SQLUtil.setBytes(preparedStatement, 3, this.hwID.hardwareID);
                preparedStatement.setString(4, this.networkName);
                preparedStatement.setString(5, this.domainName);
                int n2 = preparedStatement.executeUpdate();
                connection.commit();
                preparedStatement.close();
                this.wasAgentLess = n2 > 0;
            }
            catch (SQLException sQLException) {
                if (SQLUtil.isDuplicateKeyViolation(sQLException)) {
                    n = 4;
                    break block16;
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"updateRdbmsHost", (Throwable)sQLException);
                }
                SQLUtil.errorCleanup(connection, preparedStatement);
                SQLUtil.logSQLException("SRV0053E", sQLException, new Object[]{this.tsName, new Integer(this.computerID)});
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"updateComputer", (int)16);
                }
                return 16;
            }
            catch (GeneralException generalException) {}
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateComputer", (int)n);
        }
        return n;
    }

    protected boolean equalsRepositoryComputer(TComputer tComputer) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"equalsRepositoryComputer", (String)"r");
        }
        boolean bl2 = bl = this.hwID.equals((Object)tComputer.hwID) && this.hwID.hostName.compareToIgnoreCase(tComputer.hwID.hostName) == 0 && this.hwID.osType == tComputer.hwID.osType && this.hwID.cpuArchitecture == tComputer.hwID.cpuArchitecture && this.tsName.compareToIgnoreCase(tComputer.tsName) == 0 && this.ipAddress.compareToIgnoreCase(tComputer.ipAddress) == 0 && this.timezoneID.compareToIgnoreCase(tComputer.timezoneID) == 0 && this.guidEqual(this.guid, tComputer.guid);
        if (!bl) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"equalsRepositoryComputer", (String)("Comparing computers without HWID. Current GUID = " + this.guid + " New GUID = " + tComputer.guid));
            }
            boolean bl3 = bl = this.hwID.hostName.compareToIgnoreCase(tComputer.hwID.hostName) == 0 && this.hwID.osType == tComputer.hwID.osType && this.hwID.cpuArchitecture == tComputer.hwID.cpuArchitecture && this.tsName.compareToIgnoreCase(tComputer.tsName) == 0 && this.ipAddress.compareToIgnoreCase(tComputer.ipAddress) == 0 && this.timezoneID.compareToIgnoreCase(tComputer.timezoneID) == 0 && this.guidEqual(this.guid, tComputer.guid);
        }
        if (!SQLUtil.isNullString(this.networkName)) {
            boolean bl4 = bl = bl && this.networkName.equals(tComputer.networkName);
            if (!SQLUtil.isNullString(this.domainName)) {
                boolean bl5 = bl = bl && this.domainName.equals(tComputer.domainName);
            }
        }
        if (this.productState != null) {
            bl = bl && Arrays.equals(this.productState, tComputer.productState);
        }
        boolean bl6 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"equalsRepositoryComputer", (boolean)bl6);
        }
        return bl6;
    }

    public static boolean updateState(int n, byte[] byArray, Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateState", (String)"computerID, states, dbConnection");
        }
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            byte[] byArray2;
            preparedStatement = connection.prepareStatement(UPDATE_STATE_TEXT);
            if (byArray == null) {
                byte[] byArray3 = new byte[1];
                byArray2 = byArray3;
                byArray3[0] = 14;
            } else {
                byArray2 = byArray;
            }
            SQLUtil.setBytes(preparedStatement, 1, byArray2);
            preparedStatement.setInt(2, n);
            if (preparedStatement.executeUpdate() == 0) {
                bl = false;
            }
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateState", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0160E", sQLException, null);
            bl = false;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateState", (boolean)bl2);
        }
        return bl2;
    }

    public static final boolean updateOSVersion(int n, String string, Connection connection) {
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            preparedStatement = connection.prepareStatement(UPDATE_OSVERSION_TEXT);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            if (preparedStatement.executeUpdate() == 0) {
                bl = false;
            }
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0160E", sQLException, null);
            bl = false;
        }
        return bl;
    }

    public static boolean updateCompNames(int n, String string, String string2, Connection connection) {
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            preparedStatement = connection.prepareStatement(UPDATE_NAMENSTATE_TEXT);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setInt(4, n);
            if (preparedStatement.executeUpdate() == 0) {
                bl = false;
            }
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0160E", sQLException, null);
            bl = false;
        }
        return bl;
    }

    public String prepareStateUpdate(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareStateUpdate", (String)"dbConnection");
        }
        String string = null;
        try {
            this.stateUpdate = connection.prepareStatement(UPDATE_STATE_TEXT);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepareStateUpdate", (Throwable)sQLException);
            }
            SQLUtil.logSQLException("SRV0160E", sQLException, null);
            string = MessageLog.getMessageNoID((String)"SRV0160E");
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareStateUpdate", (Object)string2);
        }
        return string2;
    }

    public String performStateUpdate(int n, byte[] byArray, Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"performStateUpdate", (String)"computerID, states, dbConnection");
        }
        String string = null;
        try {
            byte[] byArray2;
            if (byArray == null) {
                byte[] byArray3 = new byte[1];
                byArray2 = byArray3;
                byArray3[0] = 14;
            } else {
                byArray2 = byArray;
            }
            SQLUtil.setBytes(this.stateUpdate, 1, byArray2);
            this.stateUpdate.setInt(2, n);
            this.stateUpdate.executeUpdate();
            connection.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"performStateUpdate", (Throwable)sQLException);
            }
            SQLUtil.logSQLException("SRV0160E", sQLException, null);
            string = MessageLog.getMessageNoID((String)"SRV0160E");
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"performStateUpdate", (Object)string2);
        }
        return string2;
    }

    public void closeStateUpdate() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeStateUpdate", (String)"");
        }
        if (this.stateUpdate != null) {
            block11: {
                try {
                    this.stateUpdate.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block11;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"closeStateUpdate", (Throwable)sQLException);
                }
            }
            this.stateUpdate = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeStateUpdate");
        }
    }

    private boolean guidEqual(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"guidEqual", (String)"guid1, guid2");
        }
        boolean bl = false;
        if (string == null || string2 == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"guidEqual", (boolean)bl);
            }
            return bl;
        }
        if (string.compareToIgnoreCase(string2) == 0) {
            bl = true;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"guidEqual", (boolean)bl);
        }
        return bl;
    }
}

