/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;

public class TResDevice
extends StorageRepositoryAccessor {
    private TResVendorModel vmAccessor = null;
    private Timestamp tsMan = new Timestamp(0L);
    private Timestamp tsCurr = new Timestamp(0L);
    private TStatDisk dskAccessor;
    private long currentTime;
    protected PreparedStatement insertNetAppStmt;
    protected PreparedStatement updateNetAppStmt;
    private static final String GET_DEVICE_IDS = "select physical_volume_id from t_res_physical_volume where vendor_id = ? and serial_number = ? and device_id = ? ";
    private static final String GET_PV_ID = "select physical_volume_id from t_res_physical_volume where  serial_number = ? ";
    private static final String GET_OLD_STYLE_DEVID = "select physical_volume_id from t_res_physical_volume where  physical_volume_id = ? and DEVICE_ID like '%NETWORK APPLIANCE%'";
    private static final String GET_NEW_STYLE_PV = "select * from t_res_physical_volume where serial_number = ?";
    private static final String UPDATE_NETAPP_DEVICE = "update t_res_physical_volume set serial_number = ?, display_name = ?, subsystem_serial_number = ? where physical_volume_id = ?";
    private static final String INSERT_NETAPP_DEVICE = "insert into t_res_physical_volume (physical_volume_id, vendor_id, serial_number, model_id, manufacture_date, firmware_rev, device_type, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_id, device_id, SYSTEM_NAMES_ID, subsystem_serial_number, name, display_name) values (?,?,?,?,?,?,?,0,?,?,?,?,?,?,-1,?, -1, ?, ?, ?)";
    private static final String GET_DEVICE = "select device_type, physical_volume_id, vendor_id, serial_number, model_id, name, manufacture_date, firmware_rev, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_serial_number from t_res_physical_volume";
    private static final String GET_DEVICE_BY_COMPUTER = "select device_type, physical_volume_id, vendor_id, serial_number, model_id, d.name,  manufacture_date, firmware_rev, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_serial_number from t_res_physical_volume d, t_res_share s where s.computer_id = ? and s.resource_type = 10 and s.resource_id = d.physical_volume_id";
    private static final String INSERT_DEVICE = "insert into t_res_physical_volume (physical_volume_id, vendor_id, serial_number, model_id, manufacture_date, firmware_rev, device_type, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_id, device_id, SYSTEM_NAMES_ID, subsystem_serial_number, name, lunssid) values (?,?,?,?,?,?,?,0,?,?,?,?,?,?,-1,?, -1, ?, ?, ?)";
    private static final String BUMP_DEV_USE_COUNT = "update t_res_physical_volume set use_count = use_count + ? where physical_volume_id = ?";
    private static final String UPDATE_SPARE_DISK = "update t_res_physical_volume set flags = ? where physical_volume_id = ?";
    private static final String NULL_FLAGS = "update t_res_physical_volume set flags = NULL where physical_volume_id = ?";
    private static final String EXTRACT_FLAGS = "select flags from t_res_physical_volume where physical_volume_id = ?";
    private static final String DELETE_DEVICE = "delete from t_res_physical_volume where physical_volume_id = ?";
    private static final String SELECT_SS_DISK = " select physical_volume_id from t_res_physical_volume where physical_volume_id = ?  and subsystem_id <> -1 ";
    private static final String SELECT_SVC_MDISK = " select storage_extent_id from t_res_storage_extent where storage_extent_id = ?";
    private static final String SELECT_SS_TYPE_FOR_DISK = " select ss.os_type from t_res_storage_subsystem ss, t_res_physical_volume pv   where ss.subsystem_id = pv.subsystem_id and pv.physical_volume_id = ?";
    private static final String GET_SVC_MDISK_INFO = "select se.storage_extent_id, ss.vendor_id, se.serial_number, ss.model_id, se.element_name from t_res_storage_extent se, t_res_storage_subsystem ss where se.subsystem_id = ss.subsystem_id and";

    public TResDevice(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResDevice", (String)"dbc");
        }
        try {
            this.currentTime = SQLUtil.getTimestamp(connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"TResDevice", (Throwable)exception);
            }
            return;
        }
        this.dskAccessor = new TStatDisk(connection);
        this.tableName = "t_res_physical_volume";
        this.vmAccessor = new TResVendorModel(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResDevice");
        }
    }

    public void prepGetDevByID(boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepGetDevByID", (String)"SVCMDisk");
        }
        String string = null;
        string = bl ? "select se.storage_extent_id, ss.vendor_id, se.serial_number, ss.model_id, se.element_name from t_res_storage_extent se, t_res_storage_subsystem ss where se.subsystem_id = ss.subsystem_id and storage_extent_id = ?" : "select device_type, physical_volume_id, vendor_id, serial_number, model_id, name, manufacture_date, firmware_rev, use_count, multi_port, flags, removable_medium, unsupported_model, discovered_time, storage_system_type, subsystem_serial_number from t_res_physical_volume where physical_volume_id = ?";
        this.selectStmt = this.prepareStmt(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepGetDevByID", (Object)"SVCMDisk");
        }
    }

    public Device getDevByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDevByID", (String)"devID");
        }
        boolean bl = this.isSVCMDisk(n);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            Device device = this.getDevice(bl);
            this.closeResultSet();
            Device device2 = device;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getDevByID", (Object)device2);
            }
            return device2;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDevByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            Device device = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getDevByID", device);
            }
            return device;
        }
    }

    public Device getDevByCmp(int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDevByCmp", (String)"computerID, devType");
        }
        Device device = null;
        String string = s != -1 ? " and device_type = " + s : null;
        String string2 = GET_DEVICE_BY_COMPUTER + string;
        this.selectStmt = this.prepareStmt(string2);
        try {
            Device device2;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while ((device2 = this.getDevice(false)) != null) {
                device2.devNext = device;
                device = device2;
            }
            this.closeSelect();
            TStatDisk tStatDisk = new TStatDisk(this.dbc);
            Device device3 = tStatDisk.getDiskByID(device);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getDevByCmp", (Object)device3);
            }
            return device3;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDevByCmp", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            Device device4 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getDevByCmp", device4);
            }
            return device4;
        }
    }

    private Device getDevice(boolean bl) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDevice", (String)"");
        }
        if (!this.nextResult()) {
            Device device = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getDevice", device);
            }
            return device;
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        Object object = null;
        if (!bl) {
            short s = this.getShort(this.resultSet);
            object = Device.isFixedDisk((short)s) ? new Disk() : new Device();
            object.devType = s;
        } else {
            object = new Disk();
        }
        object.devID = this.getInt(this.resultSet);
        object.devManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
        object.devSerialNumber = this.getString(this.resultSet);
        object.devModel = this.vmAccessor.getModelName(this.getShort(this.resultSet));
        object.devName = this.getString(this.resultSet);
        if (!bl) {
            object.devManufactureDate = this.getTimestamp(this.resultSet);
            object.devFirmwareRev = this.getString(this.resultSet);
            object.devUseCount = this.getShort(this.resultSet);
            object.devMultiPort = this.getBoolean(this.resultSet);
            object.devFlags = this.getShort(this.resultSet);
            object.devRemovableMedium = this.getBoolean(this.resultSet);
            object.devUnsupportedModel = this.getBoolean(this.resultSet);
            object.devDiscoveredTime = this.getTimestamp(this.resultSet);
            object.devStorageSystemType = this.getShort(this.resultSet);
            object.devSubsystemSerialNumber = this.getString(this.resultSet);
        }
        Disk disk = object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDevice", (Object)disk);
        }
        return disk;
    }

    public void saveDevices(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDevices", (String)"devList");
        }
        if (device == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"saveDevices");
            }
            return;
        }
        Device device2 = null;
        int n = 0;
        int n2 = 0;
        try {
            this.stmtType = 0;
            this.selectStmt = this.prepareStmt(GET_DEVICE_IDS);
            device2 = device;
            while (device2 != null) {
                if (!this.fetchID(device2)) {
                    ++n;
                }
                device2 = device2.devNext;
            }
            if (n > 0) {
                n2 = TResDevice.getIdentifier(1, n, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT_DEVICE);
            }
            this.dskAccessor.prepSave();
            device2 = device;
            while (device2 != null) {
                if (device2.devID == -1) {
                    device2.devFlags = (short)(device2.devFlags | 4);
                    device2.devID = n2++;
                    this.insertDev(device2);
                }
                if (device2.isFixedDisk()) {
                    this.dskAccessor.saveDisk((Disk)device2);
                }
                this.dbc.commit();
                device2 = device2.devNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveDevices", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDevices");
        }
    }

    public void saveNetAppDevices(Device device, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveNetappDevices", (String)"devList");
        }
        if (device == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"saveNetAppDevices");
            }
            return;
        }
        Device device2 = null;
        int n = 0;
        int n2 = 0;
        try {
            device2 = device;
            while (device2 != null) {
                if (!this.fetchNetAppID(device2, string)) {
                    ++n;
                }
                device2 = device2.devNext;
            }
            if (n > 0) {
                n2 = TResDevice.getIdentifier(1, n, this.dbc);
                this.insertNetAppStmt = this.prepareStmt(INSERT_NETAPP_DEVICE);
            }
            this.dskAccessor.prepSave();
            device2 = device;
            while (device2 != null) {
                if (device2.devID == -1) {
                    device2.devFlags = (short)(device2.devFlags | 4);
                    device2.devID = n2++;
                    this.insertNetAppDev(device2, string);
                } else {
                    this.updateNetAppDev(device2, string);
                }
                if (device2.isFixedDisk()) {
                    this.dskAccessor.saveDisk((Disk)device2);
                }
                this.dbc.commit();
                device2 = device2.devNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveNetAppDevices", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveNetAppDevices");
        }
    }

    private boolean fetchNetAppID(Device device, String string) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchNetAppID", (String)"dev");
        }
        this.stmtType = 0;
        this.selectStmt = this.prepareStmt(GET_DEVICE_IDS);
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setDeviceKey(this.selectStmt, device);
        this.setString(this.selectStmt, String.valueOf(device.devSerialNumber) + ":" + device.devManufacturer);
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        boolean bl = this.nextResult();
        if (bl) {
            this.colIndex = 1;
            device.devID = this.getInt(this.resultSet);
            this.closeResultSet();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchNetAppID", (boolean)bl);
            }
            return bl;
        }
        this.closeResultSet();
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.selectStmt = this.prepareStmt(GET_NEW_STYLE_PV);
        String string2 = this.prep_new_serialno(device, string);
        this.setString(this.selectStmt, string2);
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        bl = this.nextResult();
        if (bl) {
            this.colIndex = 1;
            device.devID = this.getInt(this.resultSet);
            this.closeResultSet();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchNetAppID", (boolean)bl);
            }
            return bl;
        }
        device.devID = -1;
        this.closeResultSet();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchNetAppID", (boolean)bl);
        }
        return bl;
    }

    private void setNewDeviceKey(PreparedStatement preparedStatement, Device device, String string) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setNewDeviceKey", (String)"stmt, dev");
        }
        short s = this.vmAccessor.getVendorID(device.devManufacturer);
        this.setShort(preparedStatement, s);
        this.setString(preparedStatement, this.prep_new_serialno(device, string));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setNewDeviceKey");
        }
    }

    private void insertNetAppDev(Device device, String string) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertNetAppDev", (String)"dev, SS_SerialNumber");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertNetAppStmt, device.devID);
        this.setNewDeviceKey(this.insertNetAppStmt, device, string);
        short s = this.vmAccessor.getModelID(device.devModel);
        this.setInt(this.insertNetAppStmt, s);
        this.setTimestamp(this.insertNetAppStmt, device.devManufactureDate, this.tsMan);
        if (device.devFirmwareRev == null) {
            device.devFirmwareRev = " ";
        }
        this.setString(this.insertNetAppStmt, device.devFirmwareRev);
        this.setShort(this.insertNetAppStmt, device.devType);
        this.setBoolean(this.insertNetAppStmt, device.devMultiPort);
        this.setShort(this.insertNetAppStmt, device.devFlags);
        this.setBoolean(this.insertNetAppStmt, device.devRemovableMedium);
        this.setBoolean(this.insertNetAppStmt, device.devUnsupportedModel);
        this.setTimestamp(this.insertNetAppStmt, this.currentTime, this.tsCurr);
        this.setShort(this.insertNetAppStmt, device.devStorageSystemType);
        this.setString(this.insertNetAppStmt, this.prep_new_deviceID(device, string));
        if (string == null || string == "") {
            this.setString(this.insertNetAppStmt, " ");
        } else {
            this.setString(this.insertNetAppStmt, string);
        }
        if (device.devName == null) {
            device.devName = " ";
        }
        this.setString(this.insertNetAppStmt, device.devName);
        this.setString(this.insertNetAppStmt, this.prep_device_str(device));
        this.executeUpdate(this.insertNetAppStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertNetAppDev", (Object)"dev, SS_SerialNumber");
        }
    }

    private void updateNetAppDev(Device device, String string) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDev", (String)"dev, SS_SerialNumber");
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareStmt(UPDATE_NETAPP_DEVICE);
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setString(preparedStatement, this.prep_new_serialno(device, string));
        this.setString(preparedStatement, this.prep_device_str(device));
        if (string == null || string == "") {
            this.setString(preparedStatement, " ");
        } else {
            this.setString(preparedStatement, string);
        }
        this.setInt(preparedStatement, device.devID);
        this.executeUpdate(preparedStatement);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDev", (Object)"dev, SS_SerialNumber");
        }
    }

    private String prep_new_deviceID(Device device, String string) throws GeneralException {
        String string2 = this.prep_device_str(device);
        if (string != null && string != "" && string2 != null) {
            return "ONTAP:" + string + ":" + string2;
        }
        return string2;
    }

    private String prep_new_serialno(Device device, String string) throws GeneralException {
        String string2 = this.prep_device_str(device);
        if (string != null && string2 != null) {
            return String.valueOf(string) + "/" + string2 + ":" + device.devManufacturer;
        }
        GeneralException generalException = new GeneralException("node or device are null");
        throw generalException;
    }

    private String prep_device_str(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prep_device_str", (String)"dev");
        }
        int n = 0;
        n = device.devControllers.daPath.indexOf(":");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prep_device_str");
        }
        if (n != -1) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"prep_device_str");
            }
            return String.valueOf(device.devControllers.daPath.substring(5, n)) + "." + device.devControllers.daTarget;
        }
        int n2 = device.devSerialNumber.indexOf("/");
        String string = device.devSerialNumber;
        if (n2 > 1) {
            device.devSubsystemSerialNumber = device.devSerialNumber.substring(0, n2);
            string = device.devSerialNumber.substring(n2 + 1);
        }
        return string;
    }

    public void prepBumpUseCount() throws GeneralException {
        this.updateStmt = this.prepareStmt(BUMP_DEV_USE_COUNT);
    }

    public void bumpUseCount(Device device, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"bumpUseCount", (String)"dev, value");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.updateStmt, (short)n);
            this.setInt(this.updateStmt, device.devID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"bumpUseCount", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"bumpUseCount");
        }
    }

    private boolean fetchID(Device device) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchID", (String)"dev");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setDeviceKey(this.selectStmt, device);
        this.setString(this.selectStmt, String.valueOf(device.devSerialNumber) + ":" + device.devManufacturer);
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        boolean bl = this.nextResult();
        if (bl) {
            this.colIndex = 1;
            device.devID = this.getInt(this.resultSet);
        } else {
            device.devID = -1;
        }
        this.closeResultSet();
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchID", (boolean)bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getStorageSubsystemTypeForDisk(int n) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getStorageSubsystemTypeForDisk", (String)"disk_id");
        }
        short s = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                short s2 = s = this.isSVCMDisk(n) ? (short)21 : s;
                if (s != 21) {
                    statement = this.dbc.prepareStatement(SELECT_SS_TYPE_FOR_DISK);
                    statement.setInt(1, n);
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        s = resultSet.getShort(1);
                    }
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getStorageSubsystemTypeForDisk", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (statement != null) {
            statement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return s;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getStorageSubsystemTypeForDisk", (short)s);
        return s;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStorageSubsystemDisk(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isStorageSubsystemDisk", (String)"id");
        }
        this.selectStmt = this.prepareStmt(SELECT_SS_DISK);
        int n2 = -1;
        try {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                if (this.nextResult()) {
                    this.colIndex = 1;
                    n2 = this.getInt(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"isStorageSubsystemDisk", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isStorageSubsystemDisk", (int)n2);
        }
        if (n2 <= 0) return false;
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSVCMDisk(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isSVCMDisk", (String)"id");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n2 = -1;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(SELECT_SVC_MDISK);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"isSVCMDisk", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isSVCMDisk", (int)n2);
        }
        if (n2 <= 0) return false;
        return true;
    }

    private void insertDev(Device device) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertDev", (String)"dev");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, device.devID);
        this.setDeviceKey(this.insertStmt, device);
        short s = this.vmAccessor.getModelID(device.devModel);
        this.setInt(this.insertStmt, s);
        this.setTimestamp(this.insertStmt, device.devManufactureDate, this.tsMan);
        if (device.devFirmwareRev == null) {
            device.devFirmwareRev = " ";
        }
        this.setString(this.insertStmt, device.devFirmwareRev);
        this.setShort(this.insertStmt, device.devType);
        this.setBoolean(this.insertStmt, device.devMultiPort);
        this.setShort(this.insertStmt, device.devFlags);
        this.setBoolean(this.insertStmt, device.devRemovableMedium);
        this.setBoolean(this.insertStmt, device.devUnsupportedModel);
        this.setTimestamp(this.insertStmt, this.currentTime, this.tsCurr);
        this.setShort(this.insertStmt, device.devStorageSystemType);
        this.setString(this.insertStmt, String.valueOf(device.devSerialNumber) + ":" + device.devManufacturer);
        this.setString(this.insertStmt, device.devSubsystemSerialNumber);
        if (device.devName == null) {
            device.devName = " ";
        }
        this.setString(this.insertStmt, device.devName);
        this.setString(this.insertStmt, device.lunSSID);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertDev");
        }
    }

    private void setDeviceKey(PreparedStatement preparedStatement, Device device) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDeviceKey", (String)"stmt, dev");
        }
        short s = this.vmAccessor.getVendorID(device.devManufacturer);
        this.setShort(preparedStatement, s);
        int n = device.devSerialNumber.indexOf("/");
        String string = device.devSerialNumber;
        if (n > 1) {
            device.devSubsystemSerialNumber = device.devSerialNumber.substring(0, n).toLowerCase();
            string = device.devSerialNumber.substring(n + 1).toLowerCase();
            device.lunSSID = String.valueOf(device.devSubsystemSerialNumber.toLowerCase()) + "/" + string.toLowerCase();
        }
        this.setString(preparedStatement, string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDeviceKey");
        }
    }

    public void deleteDevices(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteDevices", (String)"devList");
        }
        TStatDiskHist tStatDiskHist = new TStatDiskHist(this.dbc);
        tStatDiskHist.deleteHist(device);
        TAlertLog tAlertLog = new TAlertLog(this.dbc);
        try {
            this.deleteStmt = this.prepareStmt(DELETE_DEVICE);
            this.dskAccessor.prepDelete();
            Device device2 = device;
            while (device2 != null) {
                if (device2.isFixedDisk()) {
                    this.dskAccessor.deleteDisk(device2);
                    tAlertLog.deleteByDisk(device2.devID);
                }
                this.deleteDev(device2);
                device2 = device2.devNext;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteDevices", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteDevices");
        }
    }

    private void deleteDev(Device device) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteDev", (String)"dev");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.deleteStmt, device.devID);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteDev");
        }
    }

    public static String getGeneratedSerialNumber(Disk disk, Share share) {
        if (disk.devSerialNumber == null) {
            disk.devSerialNumber = Constants.hasSSDiskSerialNumber((short)share.shResourceType) ? share.shPath : String.valueOf(share.shPath) + "-" + share.shComputerName;
        }
        return disk.devSerialNumber;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPVID(String string) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getPVID", (String)"serialNum");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            try {
                preparedStatement = this.prepareStmt(GET_PV_ID);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getPVID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return n;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getPVID", (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSpare(int n, boolean bl) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TResDevice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"setSpare", (String)"diskID");
        }
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        short s = 0;
        try {
            try {
                preparedStatement = this.prepareStmt(EXTRACT_FLAGS);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    s = resultSet.getShort(1);
                    s = (short)(s | 8);
                    statement = bl ? this.prepareStmt(NULL_FLAGS) : this.prepareStmt(UPDATE_SPARE_DISK);
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    if (!bl) {
                        this.setShort((PreparedStatement)statement, s);
                    }
                    this.setInt((PreparedStatement)statement, n);
                    this.executeUpdate((PreparedStatement)statement);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"setSpare", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"setSpare", (int)n);
    }

    public void closeInsert() throws GeneralException {
        super.closeInsert();
        this.dskAccessor.closeSave();
    }

    public void closeDelete() throws GeneralException {
        super.closeDelete();
        this.dskAccessor.closeDelete();
    }
}

