/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStatDiskHist
extends StorageRepositoryAccessor {
    private Settings settings;
    private long oldestDaily;
    private long oldestWeekly;
    private long oldestMonthly;
    private static final int NULL_TEMPERATURE = -274;
    private static final String FETCH = "select disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, temperature, free_space, capacity from t_stat_disk_hist where";
    private static final String FETCH_GROWN_DEFECTS = "select grown_defects, free_space from t_stat_disk_hist where disk_id = ? and statistic_type = '3'";
    private static final String INSERT_HIST = "insert into t_stat_disk_hist (disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, temperature, free_space, capacity) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_SS_DISKS = "select h.disk_id, h.capacity from t_stat_disk_hist h, t_res_physical_volume pv  where h.disk_id = pv.physical_volume_id and ";
    private static final String SELECT_SVC_MDISKS = "select h.disk_id, h.capacity from t_stat_disk_hist h, t_res_storage_extent se  where h.disk_id = se.storage_extent_id and ";
    private static final String SELECT_SVC_ALLOCATED_MDISK_SPACE = "select ( sum((chunk_size * 1024 * 1024) / 512) ) from t_res_chunk where disk_id = ?";
    private static final String SELECT_FASTT_ALLOCATED_DISK_SPACE = "select ( sum(chunk_size) ) from t_res_chunk where disk_id = ?";
    private static final String SELECT_SS_ALLOCATED_DISK_SPACE = "select (chunk_size + offset) from t_res_chunk where disk_id = ? and offset = (select MAX(offset) from t_res_chunk where disk_id = ?)";
    private static final String UPDATE_DISK_FREE_SPACE = "update t_stat_disk_hist  set free_space = ? where statistic_type = '3' and disk_id = ?";
    private static final String INSERT_SS_DISK_HIST = "insert into t_stat_disk_hist (disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, capacity, free_space, temperature) select pv.PHYSICAL_VOLUME_ID, pv.update_timestamp, '3', -1, -1, -1, -1, -1.0, -1, -1, -1.0, -1, -1, -1, CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END, CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END, -274 from t_res_physical_volume pv where ";
    private static final String INSERT_SVC_MDISK_HIST = "insert into t_stat_disk_hist (disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, capacity, free_space, temperature) select se.storage_extent_id, se.update_timestamp, '3', -1, -1, -1, -1, -1.0, -1, -1, -1.0, -1, -1, -1, CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END, CASE WHEN se.free_space      IS NULL  THEN (CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END)   ELSE se.free_space      END, -274 from t_res_storage_extent se where ";
    private static final String RESET_CURRENT = "update t_stat_disk_hist set statistic_type = '0' where disk_id = ? and statistic_type = '3'";
    private static final String AGE_OFF_HIST = "delete from t_stat_disk_hist where disk_id = ? and statistic_time < ? and statistic_type = ?";
    private static final String DELETE_BY_DISK = "delete from t_stat_disk_hist where disk_id = ?";
    private static final String MOST_RECENT = " statistic_type = '3' ";
    private static final String BY_ID = " disk_id = ?";
    private static final String ORDER_BY_TIME = " order by statistic_time desc";
    private static final String AGGREGATE_BY_COMPUTER = " select s.computer_id, sum(h.free_space), sum(h.capacity)  from t_stat_disk_hist h, t_res_share s where s.resource_type = 10 and s.resource_id = h.disk_id and statistic_type = '3'  group by s.computer_id UNION select ss.subsystem_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_res_storage_subsystem ss, t_res_physical_volume pv where h.disk_id = pv.physical_volume_id and pv.subsystem_id = ss.subsystem_id and  statistic_type = '3'  group by ss.subsystem_id UNION select ss.subsystem_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_res_storage_subsystem ss, t_res_storage_extent se where h.disk_id = se.storage_extent_id and se.subsystem_id = ss.subsystem_id and  statistic_type = '3'  group by ss.subsystem_id";
    private static final String AGGREGATE_BY_COMPUTER_GROUP = " select  distinct gr.group_id, sum(free_space), sum(capacity)  from t_group gr, t_group2res g2r, t_res_share share, t_stat_disk_hist diskhist  where  statistic_type = '3'  and gr.group_type in (0, 89, 99) and gr.group_id = g2r.group_id  and g2r.resource_id = share.computer_id and share.resource_type = 10  and share.resource_id = diskhist.disk_id group by gr.group_id ";
    private static final String AGGREGATE_BY_DOMAIN = " select d.domain_id, sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_res_domain d where statistic_type = '3' and h.disk_id in (select distinct(resource_id) from t_res_share s, t_stat_computer c where s.resource_type = 10 and s.computer_id = c.computer_id and c.domain_id = d.domain_id) group by d.domain_id";
    private static final String AGGREGATE_BY_NETWORK = " select sum(h.free_space), sum(h.capacity) from t_stat_disk_hist h, t_stat_disk d where h.disk_id = d.disk_id and statistic_type = '3' ";

    public TStatDiskHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatDiskHist", (String)"dbc");
        }
        this.tableName = "t_stat_disk_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatDiskHist");
        }
    }

    private String getSelectSVCMDisks(int[] nArray) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SELECT_SVC_MDISKS);
        SQLUtil.appendInClause(stringBuffer, "se.subsystem_id", nArray);
        return stringBuffer.toString();
    }

    private String getSelectSSDisks(int[] nArray) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SELECT_SS_DISKS);
        SQLUtil.appendInClause(stringBuffer, "pv.subsystem_id", nArray);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetSubsystemDiskHistory(String string) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"resetSubsystemDiskHistory", (String)"selectText");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = -1;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                    DiskHistory diskHistory = new DiskHistory();
                    diskHistory.dkhDiskID = n;
                    this.resetCurrentToDaily(diskHistory);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"resetSubsystemDiskHistory", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"resetSubsystemDiskHistory");
    }

    public int insertSSandSVCDisks(int[] nArray, int[] nArray2) throws GeneralException {
        StringBuffer stringBuffer;
        String string;
        int n = 0;
        TStormSettings tStormSettings = new TStormSettings(this.dbc);
        this.settings = tStormSettings.getSettings(true);
        this.prepSaveHist(this.settings, -1L);
        if (nArray.length > 0) {
            string = this.getSelectSVCMDisks(nArray);
            this.resetSubsystemDiskHistory(string);
            stringBuffer = new StringBuffer();
            stringBuffer.append(INSERT_SVC_MDISK_HIST);
            SQLUtil.appendInClause(stringBuffer, "se.subsystem_id", nArray);
            n += this.executeInsertDisks(stringBuffer.toString());
            this.setDiskFreeSpace(string);
        }
        if (nArray2.length > 0) {
            string = this.getSelectSSDisks(nArray2);
            this.resetSubsystemDiskHistory(string);
            stringBuffer = new StringBuffer();
            stringBuffer.append(INSERT_SS_DISK_HIST);
            SQLUtil.appendInClause(stringBuffer, "pv.subsystem_id", nArray2);
            n += this.executeInsertDisks(stringBuffer.toString());
            this.setDiskFreeSpace(string);
        }
        this.closeSaveHist();
        return n;
    }

    public int executeInsertDisks(String string) throws GeneralException {
        int n = 0;
        try {
            Statement statement = this.dbc.createStatement();
            n = statement.executeUpdate(string);
            statement.close();
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return n;
    }

    public void saveDailyHist(Settings settings, Device device, long l) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDailyHist", (String)"settings, devList, probeTime");
        }
        this.prepSaveHist(settings, l);
        this.selectStmt = this.prepareStmt(FETCH_GROWN_DEFECTS);
        Device device2 = device;
        while (device2 != null) {
            if (device2.isFixedDisk()) {
                Disk disk = (Disk)device2;
                if (disk.dskHistory != null) {
                    DiskHistory diskHistory = disk.dskHistory;
                    diskHistory.dkhTimestamp = l;
                    diskHistory.dkhType = (byte)3;
                    diskHistory.dkhDiskID = disk.devID;
                    diskHistory.dkhOldGrownDefects = (device2.devFlags & 4) == 0 ? this.getGrownDefects(diskHistory) : Integer.MAX_VALUE;
                    if (diskHistory.dkhFreeSpace < 0L) {
                        diskHistory.dkhFreeSpace = diskHistory.dkhCapacity;
                    }
                    this.resetCurrentToDaily(diskHistory);
                    this.insertHist(diskHistory);
                    this.ageHist(diskHistory);
                }
            }
            device2 = device2.devNext;
        }
        this.closeSelect();
        this.closeSaveHist();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDailyHist");
        }
    }

    private void prepSaveHist(Settings settings, long l) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSaveHist", (String)"settings, probeTime");
        }
        if (l == -1L) {
            try {
                l = SQLUtil.getTimestamp(this.dbc).getTime();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"prepSaveHist", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        this.settings = settings;
        this.setRetentionTimes(l);
        this.insertStmt = this.prepareStmt(INSERT_HIST);
        this.updateStmt = this.prepareStmt(RESET_CURRENT);
        this.deleteStmt = this.prepareStmt(AGE_OFF_HIST);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSaveHist");
        }
    }

    private void closeSaveHist() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSaveHist", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSaveHist");
        }
    }

    private void setRetentionTimes(long l) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setRetentionTimes", (String)"probeTime");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date(l);
        gregorianCalendar.setTime(date);
        if (this.settings.seDiskDailyHist != 0) {
            gregorianCalendar.add(5, -this.settings.seDiskDailyHist);
        }
        this.oldestDaily = gregorianCalendar.getTime().getTime();
        if (this.settings.seDiskWeeklyHist != 0) {
            gregorianCalendar.setTime(date);
            gregorianCalendar.add(5, -(this.settings.seDiskWeeklyHist * 7));
            this.oldestWeekly = gregorianCalendar.getTime().getTime();
        }
        if (this.settings.seDiskMonthlyHist != 0) {
            gregorianCalendar.setTime(date);
            gregorianCalendar.add(2, -this.settings.seDiskMonthlyHist);
            this.oldestMonthly = gregorianCalendar.getTime().getTime();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setRetentionTimes");
        }
    }

    public int getGrownDefects(DiskHistory diskHistory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getGrownDefects", (String)"hist");
        }
        int n = Integer.MAX_VALUE;
        int n2 = 3;
        while (true) {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, diskHistory.dkhDiskID);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    this.colIndex = 1;
                    n = this.getInt(this.resultSet);
                    if (diskHistory.dkhFreeSpace < 0L) {
                        diskHistory.dkhFreeSpace = this.getLong(this.resultSet);
                    }
                }
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getGrownDefects", (Throwable)sQLException);
                }
                if (SQLUtil.isDeadlock(sQLException) && --n2 >= 0) {
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
                continue;
            }
            break;
        }
        int n3 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getGrownDefects", (int)n3);
        }
        return n3;
    }

    public void resetCurrentToDaily(DiskHistory diskHistory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"resetCurrentToDaily", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.updateStmt, diskHistory.dkhDiskID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"resetCurrentToDaily", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resetCurrentToDaily");
        }
    }

    public void insertHist(DiskHistory diskHistory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertHist", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(this.insertStmt, diskHistory);
            this.setInt(this.insertStmt, diskHistory.dkhPrimaryDefects);
            this.setInt(this.insertStmt, diskHistory.dkhGrownDefects);
            this.setInt(this.insertStmt, diskHistory.dkhRecoveredWriteErrors);
            this.setInt(this.insertStmt, diskHistory.dkhUnrecoveredWriteErrors);
            double d = diskHistory.dkhBytesWritten;
            this.setDouble(this.insertStmt, d);
            this.setInt(this.insertStmt, diskHistory.dkhRecoveredReadErrors);
            this.setInt(this.insertStmt, diskHistory.dkhUnrecoveredReadErrors);
            d = diskHistory.dkhBytesRead;
            this.setDouble(this.insertStmt, d);
            this.setInt(this.insertStmt, diskHistory.dkhRecoveredVerifyErrors);
            this.setInt(this.insertStmt, diskHistory.dkhUnrecoveredVerifyErrors);
            this.setInt(this.insertStmt, diskHistory.dkhNonMediumErrors);
            this.setShort(this.insertStmt, diskHistory.dkhTemperature);
            this.setLong(this.insertStmt, diskHistory.dkhFreeSpace);
            this.setLong(this.insertStmt, diskHistory.dkhCapacity);
            this.executeUpdate(this.insertStmt);
            this.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertHist", (Throwable)sQLException);
            }
            PrintWriter printWriter = MessageLog.getThreadLog();
            printWriter.println("PrimaryDefects: " + diskHistory.dkhPrimaryDefects);
            printWriter.println("GrownDefects: " + diskHistory.dkhGrownDefects);
            printWriter.println("RecoveredWriteErrors: " + diskHistory.dkhRecoveredWriteErrors);
            printWriter.println("UnrecoveredWriteErrors: " + diskHistory.dkhUnrecoveredWriteErrors);
            printWriter.println("BytesWritten: " + diskHistory.dkhBytesWritten);
            printWriter.println("RecoveredReadErrors: " + diskHistory.dkhRecoveredReadErrors);
            printWriter.println("UnrecoveredReadErrors: " + diskHistory.dkhUnrecoveredReadErrors);
            printWriter.println("BytesRead: " + diskHistory.dkhBytesRead);
            printWriter.println("RecoveredVerifyErrors: " + diskHistory.dkhRecoveredVerifyErrors);
            printWriter.println("UnrecoveredVerifyErrors: " + diskHistory.dkhUnrecoveredVerifyErrors);
            printWriter.println("NonMediumErrors: " + diskHistory.dkhNonMediumErrors);
            printWriter.println("Temperature: " + diskHistory.dkhTemperature);
            printWriter.println("FreeSpace: " + diskHistory.dkhFreeSpace);
            printWriter.println("Capacity: " + diskHistory.dkhCapacity);
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertHist");
        }
    }

    private void setKey(PreparedStatement preparedStatement, DiskHistory diskHistory) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setKey", (String)"pStmt, hist");
        }
        this.setInt(preparedStatement, diskHistory.dkhDiskID);
        this.setTimestamp(preparedStatement, diskHistory.dkhTimestamp);
        this.setByte(preparedStatement, diskHistory.dkhType);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setKey");
        }
    }

    private void ageHist(DiskHistory diskHistory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageHist", (String)"hist");
        }
        try {
            diskHistory.dkhTimestamp = this.oldestDaily;
            diskHistory.dkhType = 0;
            this.ageOff(diskHistory);
            if (this.settings.seDiskWeeklyHist != 0) {
                diskHistory.dkhTimestamp = this.oldestWeekly;
                diskHistory.dkhType = 1;
                this.ageOff(diskHistory);
            }
            if (this.settings.seDiskMonthlyHist != 0) {
                diskHistory.dkhTimestamp = this.oldestMonthly;
                diskHistory.dkhType = (byte)2;
                this.ageOff(diskHistory);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"ageHist", (Throwable)sQLException);
            }
            this.stmtType = 3;
            MessageLog.logMessage((String)"STS0027E");
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageHist");
        }
    }

    private void ageOff(DiskHistory diskHistory) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageOff", (String)"hist");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setKey(this.deleteStmt, diskHistory);
        this.executeUpdate(this.deleteStmt);
        this.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageOff");
        }
    }

    public void deleteHist(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteHist", (String)"devList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_DISK);
            Device device2 = device;
            while (device2 != null) {
                if (device2.isFixedDisk()) {
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.deleteStmt, device2.devID);
                    this.executeUpdate(this.deleteStmt);
                    this.dbc.commit();
                }
                device2 = device2.devNext;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteHist", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteHist");
        }
    }

    public void prepSnapShots() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSnapShots", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT_HIST);
        this.selectStmt = this.prepareStmt("select disk_id, statistic_time, statistic_type, primary_defects, grown_defects, recovrd_wrt_errs, unrecovrd_wrt_errs, bytes_written, recovrd_rd_errs, unrecovrd_rd_errs, bytes_read, recovrd_vfy_errs, unrecovrd_vfy_errs, non_medium_errs, temperature, free_space, capacity from t_stat_disk_hist where statistic_type = '3' ");
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepSnapShots", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSnapShots");
        }
    }

    public void closeSnapShots() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSnapShots", (String)"");
        }
        this.closeResultSet();
        this.closeSelect();
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSnapShots");
        }
    }

    public boolean fetchMostRecent(DiskHistory diskHistory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchMostRecent", (String)"hist");
        }
        boolean bl = false;
        try {
            bl = this.nextResult();
            if (bl) {
                this.getHistory(diskHistory);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchMostRecent", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchMostRecent", (boolean)bl2);
        }
        return bl2;
    }

    public void prepFetchMostRecentByDiskID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepFetchMostRecentByDiskID", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer = stringBuffer.append(FETCH);
        stringBuffer = stringBuffer.append(MOST_RECENT);
        stringBuffer = stringBuffer.append(" and ");
        stringBuffer = stringBuffer.append(BY_ID);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepFetchMostRecentByDiskID");
        }
    }

    public void prepFetchAllByDiskID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepFetchAllByDiskID", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer = stringBuffer.append(FETCH);
        stringBuffer = stringBuffer.append(BY_ID);
        stringBuffer = stringBuffer.append(ORDER_BY_TIME);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepFetchAllByDiskID");
        }
    }

    public DiskHistory fetchByDiskID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchByDiskID", (String)"diskID");
        }
        DiskHistory diskHistory = null;
        DiskHistory diskHistory2 = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                diskHistory2 = new DiskHistory();
                this.getHistory(diskHistory2);
                diskHistory2.dkhNext = diskHistory;
                diskHistory = diskHistory2;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchByDiskID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        DiskHistory diskHistory3 = diskHistory;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchByDiskID", diskHistory3);
        }
        return diskHistory3;
    }

    private void getHistory(DiskHistory diskHistory) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getHistory", (String)"hist");
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        diskHistory.dkhDiskID = this.getInt(this.resultSet);
        diskHistory.dkhTimestamp = this.getTimestamp(this.resultSet);
        diskHistory.dkhType = this.getByte(this.resultSet);
        diskHistory.dkhPrimaryDefects = this.getInt(this.resultSet);
        diskHistory.dkhGrownDefects = this.getInt(this.resultSet);
        diskHistory.dkhRecoveredWriteErrors = this.getInt(this.resultSet);
        diskHistory.dkhUnrecoveredWriteErrors = this.getInt(this.resultSet);
        diskHistory.dkhBytesWritten = (long)this.getDouble(this.resultSet);
        diskHistory.dkhRecoveredReadErrors = this.getInt(this.resultSet);
        diskHistory.dkhUnrecoveredReadErrors = this.getInt(this.resultSet);
        diskHistory.dkhBytesRead = (long)this.getDouble(this.resultSet);
        diskHistory.dkhRecoveredVerifyErrors = this.getInt(this.resultSet);
        diskHistory.dkhUnrecoveredVerifyErrors = this.getInt(this.resultSet);
        diskHistory.dkhNonMediumErrors = this.getInt(this.resultSet);
        diskHistory.dkhTemperature = this.getShort(this.resultSet);
        diskHistory.dkhFreeSpace = this.getLong(this.resultSet);
        diskHistory.dkhCapacity = this.getLong(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getHistory");
        }
    }

    public void aggregateHist(Settings settings, long l) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregateHist", (String)"settings, runTime");
        }
        this.prepSaveHist(settings, l);
        DiskHistory diskHistory = new DiskHistory();
        diskHistory.dkhPrimaryDefects = -1;
        diskHistory.dkhGrownDefects = -1;
        diskHistory.dkhRecoveredWriteErrors = -1;
        diskHistory.dkhUnrecoveredWriteErrors = -1;
        diskHistory.dkhBytesWritten = -1L;
        diskHistory.dkhRecoveredReadErrors = -1;
        diskHistory.dkhUnrecoveredReadErrors = -1;
        diskHistory.dkhBytesRead = -1L;
        diskHistory.dkhRecoveredVerifyErrors = -1;
        diskHistory.dkhUnrecoveredVerifyErrors = -1;
        diskHistory.dkhNonMediumErrors = -1;
        diskHistory.dkhTemperature = (short)-274;
        this.aggregate(AGGREGATE_BY_COMPUTER, diskHistory, l, true);
        this.aggregate(AGGREGATE_BY_COMPUTER_GROUP, diskHistory, l, true);
        this.aggregate(AGGREGATE_BY_DOMAIN, diskHistory, l, true);
        diskHistory.dkhDiskID = -3;
        this.aggregate(AGGREGATE_BY_NETWORK, diskHistory, l, false);
        this.closeSaveHist();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregateHist");
        }
    }

    private void aggregate(String string, DiskHistory diskHistory, long l, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregate", (String)"sqlText, hist, runTime, fetchID");
        }
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                if (bl) {
                    diskHistory.dkhDiskID = this.getInt(this.resultSet);
                }
                diskHistory.dkhFreeSpace = this.getLong(this.resultSet);
                diskHistory.dkhCapacity = this.getLong(this.resultSet);
                diskHistory.dkhTimestamp = l;
                diskHistory.dkhType = (byte)3;
                this.resetCurrentToDaily(diskHistory);
                this.insertHist(diskHistory);
                this.ageHist(diskHistory);
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"aggregate", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregate");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDiskFreeSpace(String string) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"setDiskFreeSpace", (String)"ids, selectDisks");
        }
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        int n = -1;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(string);
                preparedStatement2 = this.dbc.prepareStatement(UPDATE_DISK_FREE_SPACE);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                    l = resultSet.getLong(2);
                    l2 = this.getAllocatedDiskSpace(n);
                    DiskHistory diskHistory = new DiskHistory();
                    diskHistory.dkhDiskID = n;
                    this.ageHist(diskHistory);
                    if (l >= l2) {
                        l3 = l - l2;
                    }
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("disk_id: " + n);
                        stringBuffer.append("   capacity: " + l);
                        stringBuffer.append("   allocatedSpace: " + l2);
                        stringBuffer.append("   free space: " + l3);
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)3, (String)clazz3.getName(), (String)"setDiskFreeSpace", (String)stringBuffer.toString());
                    }
                    preparedStatement2.setLong(1, l3);
                    preparedStatement2.setInt(2, n);
                    preparedStatement2.executeUpdate();
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz4.getName(), (String)"setDiskFreeSpace", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (preparedStatement2 != null) {
                    preparedStatement2.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var14_14 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (preparedStatement2 != null) {
            preparedStatement2.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"setDiskFreeSpace");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getAllocatedDiskSpace(int n) throws GeneralException {
        Class<?> clazz;
        long l = 0L;
        Statement statement = null;
        ResultSet resultSet = null;
        int n2 = -1;
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getAllocatedDiskSpace", (String)"disk_id, selectAllocatedSpace");
        }
        try {
            try {
                String string = null;
                TResDevice tResDevice = new TResDevice(this.dbc);
                n2 = tResDevice.getStorageSubsystemTypeForDisk(n);
                switch (n2) {
                    case 21: {
                        string = SELECT_SVC_ALLOCATED_MDISK_SPACE;
                        break;
                    }
                    case 15: {
                        string = SELECT_FASTT_ALLOCATED_DISK_SPACE;
                        break;
                    }
                    default: {
                        string = SELECT_SS_ALLOCATED_DISK_SPACE;
                        bl = true;
                    }
                }
                statement = this.dbc.prepareStatement(string);
                statement.setInt(1, n);
                if (bl) {
                    statement.setInt(2, n);
                }
                if ((resultSet = statement.executeQuery()).next()) {
                    l = resultSet.getLong(1);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getAllocatedDiskSpace", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (statement != null) {
            statement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return l;
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDiskHist");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getAllocatedDiskSpace", (long)l);
        return l;
    }
}

