/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.SRMServerInfo;

public class DeviceServerManager {
    private Hashtable deviceServerHT = null;
    private static DeviceServerManager devMgr = null;
    private int serverCount = 0;

    private static synchronized void init() {
        devMgr = new DeviceServerManager();
        DeviceServerManager.devMgr.deviceServerHT = new Hashtable();
        DeviceServerManager.loadDeviceServersInfo();
    }

    public static DeviceServerManager getDeviceServerManager() {
        if (devMgr == null) {
            DeviceServerManager.init();
        }
        return devMgr;
    }

    public synchronized void registerDeviceServer(SRMServerInfo sRMServerInfo) {
        if (this.deviceServerHT.put(sRMServerInfo.getServerName(), sRMServerInfo) == null) {
            ++this.serverCount;
        }
    }

    public synchronized void unRegisterDeviceServer(SRMServerInfo sRMServerInfo) {
        if (this.deviceServerHT.remove(sRMServerInfo.getServerName()) != null) {
            --this.serverCount;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadDeviceServersInfo() {
        block36: {
            block33: {
                block35: {
                    block32: {
                        var0 = "loadDeviceServersInfo()";
                        if (TraceLogger.enableTrace) {
                            try {
                                v0 = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                            }
                            catch (ClassNotFoundException v1) {
                                throw new NoClassDefFoundError(v1.getMessage());
                            }
                            TraceLogger.entry((String)v0.getName(), (String)var0, (String)"");
                        }
                        var1_1 = null;
                        var2_2 = null;
                        var3_3 = null;
                        try {
                            try {
                                var1_1 = DBConnPoolDataSource.getInstance();
                                var2_2 = (DBConnection)var1_1.getPooledConnection();
                                var4_4 = new Hashtable<ColumnInfo, String>(1);
                                var4_4.put(Server.getColumnInfo((String)"SERVER_TYPE"), Integer.toString(1));
                                var3_3 = Server.getCursor((DBConnection)var2_2, var4_4, null);
                                if (var3_3 == null) {
                                    if (TraceLogger.enableTrace) {
                                        try {
                                            v2 = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                                        }
                                        catch (ClassNotFoundException v3) {
                                            throw new NoClassDefFoundError(v3.getMessage());
                                        }
                                        TraceLogger.traceMessage((int)3, (String)v2.getName(), (String)var0, (String)"ServerCursor returned is null.");
                                    }
                                    if (TraceLogger.enableTrace) {
                                        try {
                                            v4 = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                                        }
                                        catch (ClassNotFoundException v5) {
                                            throw new NoClassDefFoundError(v5.getMessage());
                                        }
                                        TraceLogger.exit((String)v4.getName(), (String)var0, (Object)"Exiting.  ServerCursor is null.");
                                    }
                                    var6_7 = null;
                                    break block32;
                                }
                                while (var3_3.next()) {
                                    var5_13 = var3_3.getObject();
                                    if (DeviceServerManager.devMgr.deviceServerHT.put(var5_13.getServerName(), var5_13) != null) continue;
                                    ++DeviceServerManager.devMgr.serverCount;
                                }
                                break block33;
                            }
                            catch (SQLException var4_5) {
                                if (!TraceLogger.enableTrace) break block33;
                                try {
                                    v6 = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                                }
                                catch (ClassNotFoundException v7) {
                                    throw new NoClassDefFoundError(v7.getMessage());
                                }
                                TraceLogger.exception((String)v6.getName(), (String)var0, (Throwable)var4_5);
                                break block33;
                            }
                            catch (Exception var4_6) {
                                if (!TraceLogger.enableTrace) break block33;
                                try {
                                    v8 = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                                }
                                catch (ClassNotFoundException v9) {
                                    throw new NoClassDefFoundError(v9.getMessage());
                                }
                                TraceLogger.exception((String)v8.getName(), (String)var0, (Throwable)var4_6);
                                break block33;
                            }
                        }
                        catch (Throwable var7_14) {
                            var6_8 = null;
                            try {
                                if (var3_3 != null) {
                                    var3_3.close();
                                }
                            }
                            catch (SQLException var8_11) {
                                var8_11.printStackTrace();
                            }
                            if (var2_2 == null) throw var7_14;
                            try {
                                var2_2.close();
                                if (var3_3 == null) throw var7_14;
                                var3_3.close();
                                throw var7_14;
                            }
                            catch (SQLException var8_11) {
                                var8_11.printStackTrace();
                            }
                            throw var7_14;
                        }
                    }
                    ** try [egrp 7[TRYBLOCK] [12 : 308->319)] { 
lbl83:
                    // 1 sources

                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    break block35;
lbl86:
                    // 1 sources

                    catch (SQLException var8_10) {
                        var8_10.printStackTrace();
                    }
                }
                if (var2_2 == null) return;
                ** try [egrp 8[TRYBLOCK] [13 : 330->345)] { 
lbl91:
                // 1 sources

                var2_2.close();
                if (var3_3 == null) return;
                var3_3.close();
                return;
lbl95:
                // 1 sources

                catch (SQLException var8_10) {
                    var8_10.printStackTrace();
                }
                return;
            }
            var6_9 = null;
            ** try [egrp 7[TRYBLOCK] [12 : 308->319)] { 
lbl101:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block36;
lbl104:
            // 1 sources

            catch (SQLException var8_12) {
                var8_12.printStackTrace();
            }
        }
        if (var2_2 == null) return;
        try {}
        catch (SQLException var8_12) {
            var8_12.printStackTrace();
            return;
        }
        var2_2.close();
        if (var3_3 == null) return;
        var3_3.close();
    }

    public Server getDeviceServer() {
        String string = "getDeviceServer()";
        Server server = null;
        Enumeration enumeration = this.deviceServerHT.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            try {
                server = (Server)this.deviceServerHT.get(string2);
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)string, (Throwable)exception);
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.DeviceServerManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)string, (Object)"Exiting.  Something went wrong while getting entries from the hashtable.");
                }
                return null;
            }
        }
        return server;
    }

    public synchronized void refresh() {
        this.deviceServerHT.clear();
        DeviceServerManager.loadDeviceServersInfo();
    }

    public int getServerCount() {
        return this.serverCount;
    }
}

