/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.ServiceRequest;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.MessageLog;

public class RequestManager
implements IDisposable {
    private static final String CLASSNAME;
    private static final int THREAD_STOP_WAIT_TIME_MS = 300000;
    private String extensionPointId;
    private RmExtensionManager extensionManager;
    private ServiceQueue queue;
    private ThreadGroup threadGroup;
    private String threadName;
    private int priority;
    private int threadPoolSize;
    private int pendingRequestLimit;
    private int activeThreadCount;
    private Thread[] threads;
    private int[] freeThreads;
    private int freeThreadsIndex;
    private PrintWriter logWriter;
    private boolean shutdown;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.RequestManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CLASSNAME = clazz.getName();
    }

    public RequestManager(String string, ServiceQueue serviceQueue, ThreadGroup threadGroup, String string2, int n, int n2, int n3, int n4) {
        this.extensionPointId = string;
        this.queue = serviceQueue;
        this.threadGroup = threadGroup;
        this.threadName = string2 != null ? string2 : "RequestHandler";
        this.priority = n;
        this.threadPoolSize = n2;
        if (n3 > n2) {
            serviceQueue.setThreadManager(this);
            this.pendingRequestLimit = n4;
        } else {
            serviceQueue.setThreadManager(null);
        }
        this.activeThreadCount = 0;
        this.threads = new RmThread[n3];
        this.freeThreads = new int[n3];
        this.freeThreadsIndex = n3;
        int n5 = this.freeThreadsIndex - 1;
        while (n5 >= 0) {
            this.freeThreads[n5] = n5;
            --n5;
        }
        this.logWriter = MessageLog.getThreadLog();
        this.shutdown = false;
    }

    public boolean initialize() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"initialize", (String)"");
        }
        this.extensionManager = new RmExtensionManager(this.extensionPointId, true);
        this.startThreads();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"initialize", (boolean)true);
        }
        return true;
    }

    public void dispose() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"dispose", (String)"");
        }
        this.stopThreads();
        this.extensionManager.dispose();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"dispose");
        }
    }

    private void startThreads() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startThreads", (String)"");
        }
        this.spawnThreads(this.threadPoolSize);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startThreads");
        }
    }

    private void stopThreads() {
        block8: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"stopThreads", (String)"");
            }
            this.shutdown = true;
            int n = this.threads.length - 1;
            while (n >= 0) {
                if (this.threads[n] != null) {
                    this.threads[n].interrupt();
                }
                --n;
            }
            try {
                n = this.threads.length - 1;
                while (n >= 0) {
                    if (this.threads[n] != null) {
                        this.threads[n].join(300000L);
                    }
                    --n;
                }
            }
            catch (InterruptedException interruptedException) {
                if (!TraceLogger.enableTrace) break block8;
                TraceLogger.exception((String)CLASSNAME, (String)"stopThreads", (Throwable)interruptedException);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"stopThreads");
        }
    }

    public void growThreadPool() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"growThreadPool", (String)"");
        }
        if (this.freeThreadsIndex > 0 && this.queue.getWaiting() == 0 && this.pendingRequestLimit < this.queue.getPending()) {
            this.spawnThreads(1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"growThreadPool");
        }
    }

    synchronized void spawnThreads(int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"spawnThreads", (String)"threadCount");
        }
        if (n > this.freeThreadsIndex) {
            n = this.freeThreadsIndex;
        }
        this.activeThreadCount += n;
        while (n > 0) {
            --this.freeThreadsIndex;
            int n2 = this.freeThreads[this.freeThreadsIndex];
            RmThread rmThread = new RmThread(n2);
            this.threads[n2] = rmThread;
            TSThread.setProperty((Object)"TSThread.key.terminate", null);
            rmThread.setPriority(this.priority);
            rmThread.setDaemon(true);
            rmThread.start();
            --n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"spawnThreads");
        }
    }

    synchronized void freeThread(int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"freeThread", (String)"threadsIndex");
        }
        this.freeThreads[this.freeThreadsIndex] = n;
        ++this.freeThreadsIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"freeThread");
        }
    }

    public synchronized boolean shouldThreadWait() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"shouldThreadWait", (String)"");
        }
        boolean bl = true;
        if (this.activeThreadCount > this.threadPoolSize) {
            TSThread.setProperty((Object)"TSThread.key.terminate", (Object)new Boolean(true));
            --this.activeThreadCount;
            bl = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"shouldThreadWait", (boolean)bl);
        }
        return bl;
    }

    private class RmThread
    extends TSThread {
        private final String CLASSNAME;
        private RmExtensionManager localExtensionManager;
        private int threadsIndex;

        public RmThread(int n) {
            super(RequestManager.this.threadGroup, String.valueOf(RequestManager.this.threadName) + "-" + n);
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.RequestManager$RmThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.CLASSNAME = clazz.getName();
            this.threadsIndex = n;
        }

        public void run() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)this.CLASSNAME, (String)"run", (String)"");
            }
            MessageLog.setThreadLog((PrintWriter)RequestManager.this.logWriter);
            this.localExtensionManager = new RmExtensionManager(RequestManager.this.extensionManager, false);
            while (!RequestManager.this.shutdown) {
                Object object;
                ServiceRequest serviceRequest = (ServiceRequest)RequestManager.this.queue.get();
                if (serviceRequest == null) {
                    object = TSThread.getProperty((Object)"TSThread.key.terminate");
                    if (object == null) continue;
                    break;
                }
                object = serviceRequest.comm;
                Request request = serviceRequest.request;
                String string = request.subType;
                serviceRequest.returnServiceRequest();
                Response response = null;
                RequestHandler requestHandler = null;
                try {
                    requestHandler = (RequestHandler)this.localExtensionManager.getExtensionImpl(string);
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)this.CLASSNAME, (String)"run", (Throwable)exception);
                    }
                    response = Response.getResponse((short)12, null);
                    response.errorMessage = MessageLog.getMessage((String)"SRV0032E", (Object)string);
                }
                if (requestHandler != null) {
                    try {
                        response = requestHandler.handle(request, (Transceiver)object);
                    }
                    catch (RuntimeException runtimeException) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)this.CLASSNAME, (String)"run", (Throwable)runtimeException);
                        }
                        object.close();
                        this.logRuntimeException(request, runtimeException);
                        RequestManager.this.freeThread(this.threadsIndex);
                        throw runtimeException;
                    }
                }
                if (response != null && response.status != -99) {
                    object.transmitResponse(request, response);
                    if (!(object instanceof VMTransceiver)) {
                        response.returnResponse();
                    }
                }
                if ((response == null || response.status == -99) && response != null) continue;
                object.close();
                object.returnTransceiver();
            }
            this.localExtensionManager.dispose();
            RequestManager.this.freeThread(this.threadsIndex);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)this.CLASSNAME, (String)"run");
            }
        }

        private String logRuntimeException(Request request, RuntimeException runtimeException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)this.CLASSNAME, (String)"logRuntimeException", (String)"request, e");
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = request.machineName;
            if (objectArray[0] == null) {
                objectArray[0] = "unknown";
            }
            objectArray[1] = request.serviceName;
            if (objectArray[1] == null) {
                objectArray[1] = "unknown";
            }
            objectArray[2] = request.toString();
            objectArray[3] = request.userName;
            String string = request.userName == null ? "GEN7078E" : "GEN7076E";
            String string2 = MessageLog.getMessage((String)string, (Object[])objectArray);
            MessageLog.getThreadLog().println(string2);
            runtimeException.printStackTrace(MessageLog.getThreadLog());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)this.CLASSNAME, (String)"logRuntimeException", (Object)string2);
            }
            return string2;
        }
    }

    private static class RmExtensionManager
    extends AbstractExtensionMgr {
        private RmExtensionManager parentManager;
        private String extensionPointId;
        private boolean cacheOnlyThreadSafe;

        public RmExtensionManager(RmExtensionManager rmExtensionManager, boolean bl) {
            this(rmExtensionManager, rmExtensionManager.getExtensionPointId(), bl);
        }

        public RmExtensionManager(String string, boolean bl) {
            this(null, string, bl);
        }

        private RmExtensionManager(RmExtensionManager rmExtensionManager, String string, boolean bl) {
            this.parentManager = rmExtensionManager;
            this.extensionPointId = string;
            this.cacheOnlyThreadSafe = bl;
        }

        public Object getExtensionImpl(String string) throws ExtensionException {
            Object object = this.getExtensionImplFromCache(string);
            if (object == null && (object = super.getExtensionImpl(string, false)) != null) {
                this.cacheExtensionImpl(string, object);
            }
            return object;
        }

        private Object getExtensionImplFromCache(String string) {
            Object v = this.cache.get(string);
            if (v == null && this.parentManager != null) {
                return this.parentManager.getExtensionImplFromCache(string);
            }
            return v;
        }

        private void cacheExtensionImpl(String string, Object object) {
            if (!(object instanceof ThrowAway || !(object instanceof ThreadSafe) && this.cacheOnlyThreadSafe)) {
                this.cache.put(string, object);
            }
            if (this.parentManager != null) {
                this.parentManager.cacheExtensionImpl(string, object);
            }
        }

        public Object getExtensionImpl(String string, boolean bl) throws ExtensionException {
            throw new UnsupportedOperationException();
        }

        public String getExtensionPointId() {
            return this.extensionPointId;
        }
    }
}

