/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.ScriptQElement;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScriptSubmitter
implements Runnable {
    public static Thread thread;
    public static ServiceQueue queue;
    private ScriptQElement current;
    private boolean reQueueIt;
    private RunScriptReq requestData;

    public static void init(ThreadGroup threadGroup) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"init", (String)"threadGroup");
        }
        queue = new ServiceQueue();
        ScriptSubmitter scriptSubmitter = new ScriptSubmitter();
        thread = new TSThread(threadGroup, (Runnable)scriptSubmitter, "ScriptSubmitter");
        thread.start();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"init");
        }
    }

    public static byte[] loadFile(String string, MutableBoolean mutableBoolean) {
        byte[] byArray;
        block21: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"loadFile", (String)"path, ok");
            }
            File file = new File(string);
            byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"loadFile", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)iOException);
                mutableBoolean.value = false;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).read(byArray);
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"loadFile", (Throwable)iOException);
                    }
                    MessageLog.logException((String)"GEN0133E", (Exception)iOException, (Object)string);
                    mutableBoolean.value = false;
                }
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block21;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"loadFile", (Throwable)iOException);
                }
            }
        }
        byte[] byArray2 = byArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"loadFile", (Object)byArray2);
        }
        return byArray2;
    }

    private boolean submitRequest() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"submitRequest", (String)"");
        }
        String[] stringArray = this.current.sqFiles;
        int n = stringArray.length;
        this.requestData.scrData = new byte[n][];
        MutableBoolean mutableBoolean = new MutableBoolean(true);
        int n2 = 0;
        while (mutableBoolean.value && n2 < n) {
            if (stringArray[n2] != null) {
                this.requestData.scrData[n2] = ScriptSubmitter.loadFile(stringArray[n2], mutableBoolean);
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            File file = new File(stringArray[n2]);
            file.delete();
            ++n2;
        }
        if (!mutableBoolean.value) {
            this.reQueueIt = false;
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"submitRequest", (boolean)bl);
            }
            return bl;
        }
        Response response = Server.agentMgr.transmitToAgent(this.current.sqRequest, null, this.requestData.getComputerID(), false);
        boolean bl = false;
        this.reQueueIt = true;
        if (response != null) {
            if (response.status <= 4) {
                bl = true;
            } else {
                switch (response.status) {
                    case 12: 
                    case 16: 
                    case 34: {
                        this.reQueueIt = false;
                    }
                }
            }
        }
        if (!bl && this.reQueueIt) {
            --this.current.sqRetryCounter;
            if (this.current.sqRetryCounter <= 0) {
                this.reQueueIt = false;
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"submitRequest", (boolean)bl2);
        }
        return bl2;
    }

    public void run() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
        }
        while ((this.current = (ScriptQElement)queue.get()) != null) {
            this.requestData = (RunScriptReq)this.current.sqRequest.requestData;
            if (!this.submitRequest() && this.reQueueIt) {
                queue.add(this.current, false);
            }
            this.current = null;
            this.requestData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ScriptSubmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }
}

