/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.handler.server.StateChangeHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServerThreadGroup
extends ThreadGroup {
    private static final String CLASSNAME;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.ServerThreadGroup");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CLASSNAME = clazz.getName();
    }

    ServerThreadGroup(String string) {
        super(string);
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"uncaughtException", (String)"t, e");
        }
        MessageLog.logMessage((String)"SRV0064E");
        ServerThreadGroup.fatalError(throwable);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"uncaughtException");
        }
    }

    public static void fatalError(Throwable throwable) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"", (String)"e");
        }
        throwable.printStackTrace();
        StateChangeHndlr.shutdownServer((byte)2, throwable);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"");
        }
    }
}

