/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import java.util.Date;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerThreadGroup;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.MessageLog;

public class SvpThreadGroup
extends ThreadGroup {
    private static final String CLASSNAME;
    private String[] services;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.SvpThreadGroup");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CLASSNAME = clazz.getName();
    }

    public SvpThreadGroup(String string, String[] stringArray) {
        super(string);
        this.services = stringArray;
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"uncaughtException", (String)"t, e");
        }
        String string = RequestTypeManager.getInternalName((String)this.services[0]);
        MessageLog.setThreadLog((PrintWriter)Server.getLogWriter());
        MessageLog.logMessage((String)"SRV0068E", (Object)(string != null ? string : "Request code " + this.services[0] + " (name unknown)"));
        if (throwable instanceof OutOfMemoryError) {
            ServerThreadGroup.fatalError(throwable);
        } else {
            throwable.printStackTrace();
            int n = this.services.length - 1;
            while (n >= 0) {
                Server.serviceMgr.stopService(this.services[n], (byte)2);
                --n;
            }
            Object[] objectArray = new Object[]{String.valueOf(this.services[0]), ((CurtailedWriter)Server.getLogWriter()).getCurrentFileName(), Server.getHomeDirectory(), new Date()};
            Alerter.shutdownNotification("SRV0183M", "SRV0184M", objectArray);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"uncaughtException");
        }
    }
}

