/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.server.agentreq.DiscoveryData;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.FilerSaver;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.UnmanagedSaver;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.alerts.StormAlerter;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryHndlr
implements RequestHandler,
ThrowAway {
    public static final String RESOURCE_TYPE = "CIMOMDISCOVERY";
    private static final long CLEANUP_TIME = 0x6DDD00L;
    private static long lastCleanup;
    private static Map runMap;
    private static final int[][] varBindOIDs;
    private static final String NAS_CONFIG_FILE;
    private Connection dbc;
    private Response response;
    private boolean updateScheduler;
    private int[] lockedTrees;
    private long discoveryTime;
    private TResShare shareAccessor;

    static {
        block4: {
            NAS_CONFIG_FILE = "configuration" + File.separator + "nas.config";
            runMap = new HashMap();
            try {
                lastCleanup = CurrentTime.getTimestamp().getTime();
            }
            catch (Exception exception) {
                Class<?> clazz;
                exception.printStackTrace();
                if (!TraceLogger.enableTrace) break block4;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr$RunAnchor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"static_initializer", (Throwable)exception);
            }
        }
        varBindOIDs = new int[2][];
        DiscoveryHndlr.varBindOIDs[0] = StormAlerter.COMPUTER_OID;
        DiscoveryHndlr.varBindOIDs[1] = Alerter.ALERT_TYPE_OID;
    }

    private static synchronized void setNoComputerDiscovery(DiscoveryData discoveryData, long l) {
        long l2;
        Object[] objectArray;
        Object object;
        NameList nameList;
        RunAnchor runAnchor;
        RunAnchor runAnchor2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setNoComputerDiscovery", (String)"data, now");
        }
        if ((runAnchor2 = (RunAnchor)((Object)runMap.get((Object)(runAnchor = new RunAnchor(discoveryData.dfRunNumber))))) != null) {
            nameList = runAnchor2.domains;
            while (nameList != null && !discoveryData.dfNoNetworkDiscovery) {
                if (nameList.nlName.equalsIgnoreCase(discoveryData.dfDomain)) {
                    discoveryData.dfNoNetworkDiscovery = true;
                    continue;
                }
                nameList = nameList.nlNext;
            }
        } else {
            runAnchor2 = runAnchor;
            runMap.put(runAnchor2, runAnchor2);
        }
        runAnchor2.lastRequest = l;
        if (!discoveryData.dfNoNetworkDiscovery) {
            nameList = new NameList();
            nameList.nlName = discoveryData.dfDomain;
            nameList.nlNext = runAnchor2.domains;
            runAnchor2.domains = nameList;
            String string = Server.agentMgr.getAgentName(discoveryData.dfComputerID.computerID);
            object = Integer.toString(discoveryData.dfRunNumber);
            objectArray = new String[]{object, string, discoveryData.dfDomain};
            MessageLog.logMessage((String)"STS0180I", (Object[])objectArray);
        }
        if (lastCleanup < (l2 = l - 0x6DDD00L)) {
            object = null;
            objectArray = runMap.keySet().iterator();
            while (objectArray.hasNext()) {
                runAnchor2 = (RunAnchor)((Object)objectArray.next());
                if (runAnchor2.lastRequest >= l2) continue;
                runAnchor2.next = object;
                object = runAnchor2;
            }
            while (object != null) {
                runMap.remove(object);
                object = ((LinkedInteger)object).next;
            }
            lastCleanup = l;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setNoComputerDiscovery");
        }
    }

    private static void close(Reader reader) {
        block11: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"reader");
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block11;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)iOException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        DiscoveryData discoveryData = null;
        if (request.requestData != null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.agentreq.DiscoveryData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz2.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            discoveryData = (DiscoveryData)request.requestData;
        }
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            Response response = this.response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        try {
            if (discoveryData != null) {
                this.setDiscoveryData(discoveryData);
            } else {
                this.saveDiscoveryData(request, transceiver);
            }
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)generalException);
            }
            Server.setResponseError(this.response, (Exception)((Object)generalException));
        }
        Server.returnConnection(this.dbc);
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void setDiscoveryData(DiscoveryData discoveryData) throws GeneralException {
        Object object;
        RepositoryAccessor repositoryAccessor;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDiscoveryData", (String)"data");
        }
        try {
            this.discoveryTime = CurrentTime.getTimestamp().getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr$RunAnchor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"setDiscoveryData", (Throwable)exception);
            }
            return;
        }
        TResLdapTree tResLdapTree = new TResLdapTree(this.dbc);
        discoveryData.dfLdapTree = tResLdapTree.getTrees(discoveryData.dfComputerID.computerID);
        tResLdapTree = null;
        if (!discoveryData.dfNetwareOnlyDiscovery) {
            discoveryData.dfNoNetworkDiscovery = false;
        }
        if (discoveryData.dfDomain != null && discoveryData.dfRunNumber > 0 && !discoveryData.dfNetwareOnlyDiscovery) {
            DiscoveryHndlr.setNoComputerDiscovery(discoveryData, this.discoveryTime);
        }
        if (discoveryData.dfDomain != null) {
            repositoryAccessor = new TResPwd(this.dbc);
            discoveryData.dfNasFiler = ((TResPwd)repositoryAccessor).getDomainVisibleFilers(discoveryData.dfDomain);
            object = ((TResPwd)repositoryAccessor).getDefaultLogin();
            repositoryAccessor = null;
            if (object != null) {
                discoveryData.dfDefaultNasLogin = object[0];
                discoveryData.dfDefaultNasPwd = object[1];
            }
        }
        discoveryData.dfNasVendor = DiscoveryHndlr.getNasConfigFile();
        repositoryAccessor = new TSnmpCommunity(this.dbc);
        discoveryData.dfCommunity = ((TSnmpCommunity)repositoryAccessor).getCommunities();
        discoveryData.dfIncludeNonRoot = AgentSvp.saveNonRootExports;
        object = new TStormSettings(this.dbc);
        Settings settings = ((TStormSettings)object).getSettings();
        discoveryData.dfExcludeWorkstations = settings.seNoWkstaDiscovery;
        discoveryData.pack();
        this.response.responseData = discoveryData;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDiscoveryData");
        }
    }

    public static String[] getNasConfigFile() throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNasConfigFile", (String)"");
        }
        String[] stringArray = null;
        File file = new File(NAS_CONFIG_FILE);
        if (file.exists()) {
            object = null;
            BufferedReader bufferedReader = null;
            try {
                String string;
                object = new FileReader(file);
                bufferedReader = new BufferedReader((Reader)object);
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                DiscoveryHndlr.close((Reader)object);
                DiscoveryHndlr.close(bufferedReader);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getNasConfigFile", (Throwable)iOException);
                }
                DiscoveryHndlr.close((Reader)object);
                DiscoveryHndlr.close(bufferedReader);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getNasConfigFile");
                }
                throw new GeneralException(MessageLog.getMessage((String)"GEN0133E", (Object)NAS_CONFIG_FILE));
            }
        }
        object = stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasConfigFile", (Object)object);
        }
        return object;
    }

    private void saveDiscoveryData(Request request, Transceiver transceiver) throws GeneralException {
        boolean bl;
        Class<?> clazz;
        Response response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"saveDiscoveryData", (String)"request, transceiver");
        }
        if (!transceiver.transmitResponse(request, response = Response.getResponse((short)0, null, (byte)0))) {
            response.returnResponse();
            this.response = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"saveDiscoveryData");
            }
            return;
        }
        response.returnResponse();
        request.requestData = (Serializable)transceiver.receiveData(request);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.server.agentreq.DiscoveryData");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"saveDiscoveryData");
            }
            return;
        }
        DiscoveryData discoveryData = (DiscoveryData)request.requestData;
        discoveryData.unpack();
        NasFiler nasFiler = null;
        NasFiler nasFiler2 = null;
        NasFiler nasFiler3 = discoveryData.dfNasFiler;
        while (nasFiler3 != null) {
            NasFiler nasFiler4 = nasFiler3.nfNext;
            if (!Constants.isDiskArray((short)nasFiler3.nfOSType)) {
                nasFiler2 = nasFiler3;
            } else {
                nasFiler3.nfNext = nasFiler;
                nasFiler = nasFiler3;
                if (nasFiler2 != null) {
                    nasFiler2.nfNext = nasFiler4;
                } else {
                    discoveryData.dfNasFiler = nasFiler4;
                }
            }
            nasFiler3 = nasFiler4;
        }
        boolean bl2 = bl = !discoveryData.dfNoNetworkDiscovery;
        if (bl || discoveryData.dfNasFiler != null) {
            Object object;
            short s;
            String string;
            int n;
            if (discoveryData.dfDomain == null || discoveryData.dfNasFiler != null && discoveryData.dfNasFiler.nfOSType == 23) {
                n = discoveryData.dfComputerID.computerID;
                string = Server.agentMgr.getAgentName(n);
                s = 1;
            } else {
                if (bl) {
                    object = new Domain();
                    ((Domain)object).domName = discoveryData.dfDomain;
                    TResDomain tResDomain = new TResDomain(this.dbc);
                    tResDomain.getIDs((Domain)object);
                    n = ((Domain)object).domID;
                    string = ((Domain)object).domName;
                } else {
                    n = -1;
                    string = "ICKYGUY";
                }
                s = 25;
            }
            object = new FilerSaver(this.dbc, n, s, !discoveryData.dfFirstDiscovery, null, string);
            ((FilerSaver)object).saveDiscoveryData(discoveryData.dfNasFiler);
        }
        if (discoveryData.dfDomain != null && bl) {
            UnmanagedSaver unmanagedSaver = new UnmanagedSaver(this.dbc);
            unmanagedSaver.save(discoveryData.dfDomain, discoveryData.dfManageable);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.agent.DiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz5.getName(), (String)"saveDiscoveryData");
        }
    }

    private static class RunAnchor
    extends LinkedInteger {
        public long lastRequest;
        public NameList domains;

        public RunAnchor(int n) {
            super(n);
        }
    }
}

