/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.repository.table.TResLibraries;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiProbeHndlr
implements RequestHandler,
ThrowAway {
    private String jobType;
    private String jobTypeLabel;
    private short resourceAttribute;
    public static final String PROBE_JOB_TYPE = "PROBE";
    public static final String PING_JOB_TYPE = "PING";
    public static final String NAQ_JOB_TYPE = "NETAPPQUOTA";
    public static final String PROBE_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0106L");
    public static final String PING_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0107L");
    public static final String NAQ_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"NAS0007L");
    private ProbePing requestData;
    private Response response;
    private Connection dbc;

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrieve", (String)"");
        }
        TSchedule tSchedule = new TSchedule(this.dbc);
        tSchedule.retrieve((ScheduleHeader)this.requestData, this.jobTypeLabel);
        tSchedule = null;
        int n = this.requestData.ID;
        TStatComputer tStatComputer = new TStatComputer(this.dbc);
        this.requestData.pbComputers = tStatComputer.queryDependents(n);
        tStatComputer = null;
        TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
        this.requestData.pbDiskArrays = tResDiskArray.queryDependents(n);
        tResDiskArray = null;
        TResFabric tResFabric = new TResFabric();
        this.requestData.pbFabrics = tResFabric.queryDependents(n);
        tResFabric = null;
        TResLibraries tResLibraries = new TResLibraries();
        this.requestData.pbLibraries = tResLibraries.queryDependents(n);
        tResLibraries = null;
        TResAttr tResAttr = new TResAttr(this.dbc);
        this.requestData.pbAllComputers = NameListSaver.allObjectsSelected(tResAttr, n, this.resourceAttribute);
        this.requestData.pbComputerGroups = tResAttr.queryDependents("t_group", "group_id", n, (short)0);
        this.requestData.pbClusters = tResAttr.queryDependents("t_group", "group_id", n, (short)99);
        this.requestData.pbAllDiskArrays = NameListSaver.allObjectsSelected(tResAttr, n, this.resourceAttribute, (short)54);
        this.requestData.pbDiskArrayGroups = tResAttr.queryDependents("t_group", "group_id", n, (short)77);
        this.requestData.pbAllFabrics = NameListSaver.allObjectsSelected(tResAttr, n, this.resourceAttribute, (short)115);
        this.requestData.pbFabricGroups = tResAttr.queryDependents("t_group", "group_id", n, (short)113);
        this.requestData.pbAllLibraries = NameListSaver.allObjectsSelected(tResAttr, n, this.resourceAttribute, (short)135);
        this.requestData.pbLibrariesGroups = tResAttr.queryDependents("t_group", "group_id", n, (short)133);
        tResAttr = null;
        TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
        tAlertDefinition.prepSelectByID(false, false);
        this.requestData.pbAlert = tAlertDefinition.getByID(this.requestData.ID);
        tAlertDefinition.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrieve");
        }
    }

    private void fillMap(Map map, short s, String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fillMap", (String)"map, resourceType, tableName, idColumnName");
        }
        MutableInteger mutableInteger = new MutableInteger((int)s);
        String[] stringArray = new String[]{string, string2};
        map.put(mutableInteger, stringArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fillMap");
        }
    }

    private Map createTablesMap() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createTablesMap", (String)"");
        }
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, (short)1, "t_stat_computer", "computer_id");
        this.fillMap(hashMap, (short)0, "t_group", "group_id");
        this.fillMap(hashMap, (short)78, "t_res_storage_subsystem", "subsystem_id");
        this.fillMap(hashMap, (short)77, "t_group", "group_id");
        this.fillMap(hashMap, (short)99, "t_group", "group_id");
        this.fillMap(hashMap, (short)113, "t_group", "group_id");
        this.fillMap(hashMap, (short)133, "t_group", "group_id");
        this.fillMap(hashMap, (short)134, "t_res_tape_library", "tape_library_id");
        this.fillMap(hashMap, (short)114, "t_res_fabric", "fabric_id");
        HashMap hashMap2 = hashMap;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createTablesMap", hashMap2);
        }
        return hashMap2;
    }

    private void save() throws GeneralException {
        NameList[] nameListArray;
        RepositoryAccessor repositoryAccessor;
        RepositoryAccessor repositoryAccessor2;
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"");
        }
        String string = null;
        ProbePing probePing = new ProbePing(16);
        if (this.requestData.ID <= 0) {
            this.requestData.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            bl = false;
        } else {
            repositoryAccessor2 = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.requestData, this.jobTypeLabel);
            ((RaceConditionChecker)repositoryAccessor2).check();
            string = ((RaceConditionChecker)repositoryAccessor2).message;
            bl = !((RaceConditionChecker)repositoryAccessor2).wasDeleted;
            repositoryAccessor2 = null;
            if (bl) {
                repositoryAccessor = new TResAttr(this.dbc);
                ((TResAttr)repositoryAccessor).prepQueryByAttr();
                nameListArray = new ResourceAttribute();
                nameListArray.raAttributeID = this.requestData.ID;
                nameListArray.raAttributeType = this.resourceAttribute;
                nameListArray.raResourceType = 1;
                probePing.pbComputers = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = 0;
                probePing.pbComputerGroups = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)13;
                probePing.pbAllComputers = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray) != null;
                nameListArray.raResourceType = (short)78;
                probePing.pbDiskArrays = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)77;
                probePing.pbDiskArrayGroups = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)54;
                probePing.pbAllDiskArrays = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray) != null;
                nameListArray.raResourceType = (short)99;
                probePing.pbClusters = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)114;
                probePing.pbFabrics = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)113;
                probePing.pbFabricGroups = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)115;
                probePing.pbAllFabrics = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray) != null;
                nameListArray.raResourceType = (short)134;
                probePing.pbLibraries = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)133;
                probePing.pbLibrariesGroups = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)135;
                probePing.pbAllLibraries = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray) != null;
                repositoryAccessor.closeSelect();
            }
        }
        this.requestData.alertID = this.requestData.ID;
        repositoryAccessor2 = new TAlertDefinition(this.dbc);
        if (bl) {
            ((TAlertDefinition)repositoryAccessor2).deleteByID(this.requestData.ID);
        }
        ((TAlertDefinition)repositoryAccessor2).insert((CreateHeader)this.requestData, this.requestData.pbAlert);
        repositoryAccessor2 = null;
        repositoryAccessor = new TSchedule(this.dbc);
        if (bl) {
            ((TSchedule)repositoryAccessor).deleteByID(this.requestData.ID, this.jobTypeLabel);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.requestData);
        ((TSchedule)repositoryAccessor).insert((ScheduleHeader)this.requestData, this.jobTypeLabel);
        repositoryAccessor = null;
        nameListArray = new NameList[]{this.requestData.pbComputers, this.requestData.pbComputerGroups, this.requestData.pbDiskArrays, this.requestData.pbDiskArrayGroups, this.requestData.pbClusters, this.requestData.pbFabrics, this.requestData.pbFabricGroups, this.requestData.pbLibraries, this.requestData.pbLibrariesGroups};
        NameList[] nameListArray2 = new NameList[]{probePing.pbComputers, probePing.pbComputerGroups, probePing.pbDiskArrays, probePing.pbDiskArrayGroups, probePing.pbClusters, probePing.pbFabrics, probePing.pbFabricGroups, probePing.pbLibraries, probePing.pbLibrariesGroups};
        NameListSaver nameListSaver = new NameListSaver(this.dbc, this.response);
        nameListSaver.saveAllObjectsSelected(this.requestData.pbAllComputers, this.requestData.ID, this.resourceAttribute);
        nameListSaver.saveAllObjectsSelected(this.requestData.pbAllDiskArrays, this.requestData.ID, this.resourceAttribute, (short)54);
        nameListSaver.saveAllObjectsSelected(this.requestData.pbAllFabrics, this.requestData.ID, this.resourceAttribute, (short)115);
        nameListSaver.saveAllObjectsSelected(this.requestData.pbAllLibraries, this.requestData.ID, this.resourceAttribute, (short)135);
        nameListSaver.save((CreateHeader)this.requestData, this.jobTypeLabel, this.resourceAttribute, this.requestData.ID, nameListArray, nameListArray2, this.createTablesMap(), bl);
        if (bl) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.requestData);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.requestData);
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz;
            String string2 = bl ? "Modify" : "Create";
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz.getName(), (String)"save()", (String)("\n Username=" + this.requestData.creator + " " + string2 + ". Definition type=" + this.jobType + ".  Name='" + this.requestData.getName() + "'"));
        }
        if (string != null) {
            this.response.status = (short)4;
            this.response.errorMessage = string;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        block30: {
            String string;
            Class<?> clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
            }
            this.response = Response.getResponse((short)0, null);
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.ProbePing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            this.requestData = (ProbePing)request.requestData;
            boolean bl = this.requestData.isEmpty();
            this.dbc = Server.getConnection();
            this.resourceAttribute = this.requestData.jobType;
            switch (this.resourceAttribute) {
                case 16: {
                    this.jobType = PROBE_JOB_TYPE;
                    this.jobTypeLabel = PROBE_JOB_TYPE_LABEL;
                    break;
                }
                case 17: {
                    this.jobType = PING_JOB_TYPE;
                    this.jobTypeLabel = PING_JOB_TYPE_LABEL;
                    break;
                }
            }
            if (this.requestData.ID <= 0) {
                string = null;
            } else {
                string = Integer.toString(this.requestData.ID);
                byte by = bl ? (byte)2 : 1;
                LockManager.lock((short)0, (String)this.jobType, (String)string, (byte)by, (boolean)true);
            }
            try {
                try {
                    if (bl) {
                        this.retrieve();
                    } else {
                        this.save();
                    }
                    this.response.responseData = this.requestData;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz4;
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz4.getName(), (String)"handle", (Throwable)generalException);
                    }
                    if (this.response.status <= 4) {
                        this.response.status = (short)12;
                    }
                    this.response.errorMessage = generalException.getMessage();
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (string != null) {
                    LockManager.unLock((short)0, (String)this.jobType, (String)string);
                }
                Server.returnConnection(this.dbc);
                throw throwable;
            }
            {
                Object var6_11 = null;
                if (string == null) break block30;
            }
            LockManager.unLock((short)0, (String)this.jobType, (String)string);
        }
        Server.returnConnection(this.dbc);
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }
}

