/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.cimom;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.SlpAttributes;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.gui.GuiDeviceRequestHndlr;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class CIMOMMgmtRequestHandler
extends GuiDeviceRequestHndlr {
    private static final String INTERNAL_ERROR = "HWN021503E";
    private static final String BAD_DB_CONNECTION = "HWN021800E";
    private static final String BAD_CIMOM_CURSOR = "HWN021801E";
    private static final String BAD_SLPATTR_CURSOR = "HWN021804E";

    protected void processRequest(DeviceRequest deviceRequest, Response response) throws RemoteException {
        String string = "processRequest";
        this.logEnter(string, deviceRequest, response);
        this.logMessage(string, "Getting CIMOM Service Proxy");
        ICIMOMMgmtService iCIMOMMgmtService = CIMOMMgmtRequestHandler.getCimomProxy(deviceRequest);
        this.logMessage(string, "Processing CIMOM request");
        this.processCIMOMRequest(deviceRequest, response, iCIMOMMgmtService);
        if (response.status <= 4) {
            CIMOM[] cIMOMArray;
            this.logMessage(string, "Collecting refreshed CIMOM list");
            response.responseData = cIMOMArray = this.getCIMOMs();
        }
        this.logExit(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMOM createCIMOMObject(RegisteredCimom registeredCimom, DBConnection dBConnection) throws SQLException {
        Calendar calendar;
        String string = "createCIMOMObject";
        this.logEnter(string, registeredCimom.getServiceUrl(), dBConnection.toString());
        String string2 = registeredCimom.getServiceUrl();
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl(string2);
        cIMOM.setHiName(registeredCimom.getHiName());
        cIMOM.setDescription(registeredCimom.getDescription());
        cIMOM.setSoftwareLevel(registeredCimom.getSoftwareLevel());
        cIMOM.setProtocolVersion(registeredCimom.getProtocolVersion());
        cIMOM.setAuthenticationMechanism(registeredCimom.getAuthenticationMechanism());
        cIMOM.setUserId(registeredCimom.getUserId());
        cIMOM.setServiceId(String.valueOf(registeredCimom.getRegCimomId()));
        String string3 = registeredCimom.getPassword();
        if (string3 != null) {
            try {
                cIMOM.setPassword(SRMCrypto.decrypt((String)string3));
            }
            catch (Exception exception) {
                this.logException(String.valueOf(string) + ": Failed to decrypt password " + string3 + " for CIMOM " + string2 + "due to " + exception.getMessage(), exception);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{exception.getMessage()}));
            }
        }
        cIMOM.setTrustStoreLocation(registeredCimom.getTrustStoreLocation());
        cIMOM.setTrustStorePassphrase(registeredCimom.getTrustStorePassphrase());
        cIMOM.setInteropSchemaNamespace(registeredCimom.getInteropSchemaNamespace());
        cIMOM.setProtocol(registeredCimom.getProtocol());
        cIMOM.setDisplayName(registeredCimom.getDisplayName());
        cIMOM.setStatus(CIMOMConnectionStatus.getStatus((short)registeredCimom.getStatus()));
        Timestamp timestamp = registeredCimom.getStatusTimestamp();
        if (timestamp != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            cIMOM.setStatusTimestamp(calendar);
        }
        calendar = null;
        try {
            try {
                calendar = SlpAttributes.getCursor((DBConnection)dBConnection, null, null);
                if (calendar == null) {
                    this.logMessage(string, "SlpAttributes.getCursor returned null", registeredCimom.getServiceUrl());
                    throw new ServerException(new SRMMessage(BAD_SLPATTR_CURSOR, new String[]{registeredCimom.getServiceUrl()}));
                }
                String string4 = new String();
                while (calendar.next()) {
                    SlpAttributes slpAttributes = calendar.getObject();
                    if (slpAttributes == null) {
                        this.logMessage(string, "Unexpected null SLP attributes reference", registeredCimom.getServiceUrl());
                        throw new ServerException(new SRMMessage(BAD_SLPATTR_CURSOR, new String[]{registeredCimom.getServiceUrl()}));
                    }
                    if (slpAttributes.getRegCimomId() != registeredCimom.getRegCimomId()) continue;
                    string4 = String.valueOf(string4) + slpAttributes.getAttributeName() + ":" + slpAttributes.getValue();
                }
            }
            catch (SQLException sQLException) {
                this.logException("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (calendar == null) throw throwable;
                calendar.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                this.logException(String.valueOf(string) + ": Exception closing SLP attribute cursor", sQLException);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
            }
        }
        {
            Object var11_15 = null;
        }
        try {}
        catch (SQLException sQLException) {
            this.logException(String.valueOf(string) + ": Exception closing SLP attribute cursor", sQLException);
            throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
        }
        if (calendar != null) {
            calendar.close();
        }
        this.logExit(string);
        return cIMOM;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMOM[] getCIMOMs() {
        String string = "createCIMOMObject";
        this.logEnter(string, null);
        DBConnection dBConnection = ServiceUtils.getConnection();
        if (dBConnection == null) {
            this.logMessage(string, "ServiceUtils.getConnection returned null");
            throw new ServerException(new SRMMessage(BAD_DB_CONNECTION, new String[0]));
        }
        RegisteredCimom.RegisteredCimomCursor registeredCimomCursor = null;
        ArrayList<CIMOM> arrayList = new ArrayList<CIMOM>();
        try {
            try {
                registeredCimomCursor = RegisteredCimom.getCursor((DBConnection)dBConnection, null, null);
                if (registeredCimomCursor == null) {
                    this.logMessage(string, "RegisteredCimom.getCursor returned null", dBConnection.toString());
                    throw new ServerException(new SRMMessage(BAD_CIMOM_CURSOR, new String[0]));
                }
                while (registeredCimomCursor.next()) {
                    RegisteredCimom registeredCimom = registeredCimomCursor.getObject();
                    if (registeredCimom == null) {
                        this.logMessage("Unexpected null CIMOM reference from mCursor.getObject()", registeredCimomCursor);
                        throw new ServerException(new SRMMessage(BAD_CIMOM_CURSOR, new String[0]));
                    }
                    if (registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) continue;
                    arrayList.add(this.createCIMOMObject(registeredCimom, dBConnection));
                }
            }
            catch (SQLException sQLException) {
                this.logException("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (registeredCimomCursor != null) {
                    registeredCimomCursor.close();
                }
            }
            catch (SQLException sQLException) {
                this.logException("Exception closing CIMOM cursor", sQLException);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
            }
            try {
                dBConnection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                this.logException("Exception closing connection", sQLException);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
            }
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (SQLException sQLException) {
            this.logException("Exception closing CIMOM cursor", sQLException);
            throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
        }
        if (registeredCimomCursor != null) {
            registeredCimomCursor.close();
        }
        try {}
        catch (SQLException sQLException) {
            this.logException("Exception closing connection", sQLException);
            throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{sQLException.getMessage()}));
        }
        dBConnection.close();
        this.logExit(string);
        return arrayList.toArray(new CIMOM[arrayList.size()]);
    }

    public static ICIMOMMgmtService getCimomProxy(DeviceRequest deviceRequest) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.common.api.ICIMOMMgmtService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ICIMOMMgmtService iCIMOMMgmtService = (ICIMOMMgmtService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
        if (iCIMOMMgmtService == null) {
            throw new RuntimeException(MessageLog.getMessageNoTS((String)"GUI8104E"));
        }
        return iCIMOMMgmtService;
    }

    protected abstract void processCIMOMRequest(DeviceRequest var1, Response var2, ICIMOMMgmtService var3) throws RemoteException;

    private static String getBestDisplayName(CIMOM cIMOM) {
        String string = cIMOM.getDisplayName();
        if (string == null || string.length() == 0) {
            string = cIMOM.getServiceUrl();
        }
        return string;
    }

    protected final boolean testCIMOM(CIMOM cIMOM, Response response, ICIMOMMgmtService iCIMOMMgmtService) throws RemoteException {
        boolean bl = true;
        CIMOMConnectionStatus[] cIMOMConnectionStatusArray = iCIMOMMgmtService.testCIMOMConnection(new CIMOM[]{cIMOM});
        if (cIMOMConnectionStatusArray[0] != CIMOMConnectionStatus.SUCCESS) {
            Server.setResponseError(response, "GUI8101I", new Object[]{CIMOMMgmtRequestHandler.getBestDisplayName(cIMOM), this.getLocalizedStatus(cIMOMConnectionStatusArray[0])});
            bl = false;
        }
        return bl;
    }

    private Object getLocalizedStatus(CIMOMConnectionStatus cIMOMConnectionStatus) {
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNCONFIGURED) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNKNOWN) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.INVALID_NAMESPACE) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.TIMEOUT) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.REFUSED) {
            return Util.getString((String)"DISK_COMMON_STATE_UNREACHABLE");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.LOGIN_FAILED) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SSL_REGISTRATION_INVALID) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.CIMCLIENT_ERROR) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
        }
        return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    }
}

