/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.ExtendedVolumeAssignments;
import org.eclipse.aperi.disk.api.HostInfo;
import org.eclipse.aperi.disk.api.IDiskReportingService;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUICapabilityData;
import org.eclipse.aperi.gui.disk.common.model.GUIFabric;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIPortAssignment;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.common.model.GUIZone;
import org.eclipse.aperi.gui.disk.common.model.GUIZoneSet;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public class GUIEntityFactory {
    private static final String[] CAPABILITY_DATA_DB_ATTRIBUTES = new String[]{"CAPABILITY_DATA_ID", "VOLUME_CREATION", "VOLUME_DELETION", "ACCESS_ASSIGNMENT", "ACCESS_UNASSIGNMENT", "NUM_VOLUMES", "RAID_LEVELS", "TARGET_PORT_RESTRICTION", "PORTS_PER_VIEW", "MAX_MAP_COUNT"};
    private static final String[] FABRIC_DB_ATTRIBUTES = new String[]{"FABRIC_ID", "FABRIC_WWN", "NAME", "SAN_WWN", "CONSOLIDATED_STATUS", "DETECTABLE", "SUPPORTS_ZONING", "DISPLAY_NAME"};
    private static final String[] IO_GROUP_DB_ATTRIBUTES = new String[]{"IO_GROUP_ID", "GROUP_ID", "NAME", "SUBSYSTEM_ID"};
    private static final String[] MDISK_DB_ATTRIBUTES = new String[]{"STORAGE_EXTENT_ID", "DEVICE_ID", "NAME", "ELEMENT_NAME", "TOTAL_CAPACITY", "FREE_SPACE", "BLOCK_SIZE", "NUM_OF_BLOCKS", "CONSUMABLE_BLOCKS", "POOL_ID", "NATIVE_STATUS", "SUBSYSTEM_ID", "MODE"};
    private static final String PORT_ATTR_PORT_WWN = "PORT_WWN";
    private static final String PORT_ATTR_FABRIC_WWN = "FABRIC_WWN";
    private static final String PORT_ATTR_HOST_URL = "HOST_URL";
    private static final String PORT_ATTR_SUBSYSTEM_DISPLAY_TYPE = "SUBSYSTEM_DISPLAY_TYPE";
    private static String PORT_ATTR_PORT_TYPE = "TYPE";
    public static final String[] PORT_DB_ATTRIBUTES = new String[]{"PORT_WWN", "FABRIC_WWN", "HOST_URL", "SUBSYSTEM_DISPLAY_TYPE", PORT_ATTR_PORT_TYPE};
    private static final String[] PORT_TYPE_ATTRIBUTES = new String[]{"CLIENT_TYPES", "ELEMENT_NAME", "CLIENT_TYPE_DESCRIPTIONS"};
    private static final String[] PORT_HOST_TYPE_ATTRIBUTES = new String[]{"OS_TYPE"};
    private static final String[] STORAGE_POOL_DB_ATTRIBUTES = new String[]{"POOL_ID", "NAME", "DISPLAY_NAME", "INSTANCE_ID", "CONSOLIDATED_STATUS", "DETECTABLE", "RAID_LEVEL", "DATA_REDUNDANCY_DEF", "PCK_REDUNDANCY_DEF", "TOTAL_AVAILABLE_SPACE", "FORMAT", "SUBSYSTEM_ID"};
    private static final String SUBSYSTEM_ATTR_MODEL = "MODEL";
    private static final String SUBSYSTEM_ATTR_VENDOR = "VENDOR";
    private static final String[] SUBSYSTEM_DB_ATTRIBUTES = new String[]{"SUBSYSTEM_ID", "NAME", "NAME_FORMAT", "DISPLAY_NAME", "CONSOLIDATED_STATUS", "DETECTABLE", "TYPE", "MODEL", "VENDOR", "MODEL_ID", "VENDOR_ID", "CODE_LEVEL", "SERIAL_NUMBER", "ACCESS_INFO", "IP_ADDRESS", "ALLOCATED_CAPACITY", "AVAILABLE_CAPACITY", "VG_CAPACITY", "VG_FREESPACE", "USER_PROVIDED_NAME", "USER_PROVIDED_LOCATION", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3", "LAST_PROBE_TIME"};
    private static final String[] VDISK_DB_ATTRIBUTES = new String[]{"SVID", "NAME", "DISPLAY_NAME", "CONSOLIDATED_STATUS", "DETECTABLE", "LSS", "CAPACITY", "SUBSYSTEM_ID", "POOL_ID", "REDUNDANCY", "DATA_REDUNDANCY", "PACKAGE_REDUNDANCY", "FORMAT", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3", "VDISK_TYPE", "NATIVE_STATUS", "MDISK_ID", "IO_GROUP_ID", "IS_FORMATTED", "THROTTLE", "PREFERRED_NODE", "FAST_WRITE_STATE", "UNIQUE_ID", "IS_ASSIGNED", "FLASH_COPY_ID", "FLASH_COPY_NAME", "METRO_MIRROR_ID", "METRO_MIRROR_NAME"};
    private static final String[] VOLUME_DB_ATTRIBUTES = new String[]{"SVID", "NAME", "DISPLAY_NAME", "CONSOLIDATED_STATUS", "DETECTABLE", "LSS", "CAPACITY", "SUBSYSTEM_ID", "POOL_ID", "REDUNDANCY", "DATA_REDUNDANCY", "PACKAGE_REDUNDANCY", "FORMAT", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3"};
    private static final String[] ZONE_DB_ATTRIBUTES = new String[]{"ZONE_ID", "ZONE_NAME", "ZONE_TYPE"};
    private static final String[] ZONE_SET_DB_ATTRIBUTES = new String[]{"ZSET_ID", "ZSET_NAME", "ACTIVE", "FABRIC_WWN"};
    private static GUIEntityFactory factory = null;

    private static GUICapabilityData createCapabilityDataInstance(HashMap hashMap) {
        GUICapabilityData gUICapabilityData = new GUICapabilityData();
        if (hashMap != null) {
            int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("CAPABILITY_DATA_ID"))).intValue();
            boolean bl = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("VOLUME_CREATION"))).shortValue() == 1;
            boolean bl2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("VOLUME_DELETION"))).shortValue() == 1;
            boolean bl3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("ACCESS_ASSIGNMENT"))).shortValue() == 1;
            boolean bl4 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("ACCESS_UNASSIGNMENT"))).shortValue() == 1;
            long l = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("NUM_VOLUMES"))).longValue();
            String string = GUIEntityUtil.getStringValue((String)((String)hashMap.get("RAID_LEVELS")));
            boolean bl5 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("TARGET_PORT_RESTRICTION"))).shortValue() == 1;
            int n2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("PORTS_PER_VIEW"))).intValue();
            if (string != null && !string.equals("__NULL__") && string.trim().length() > 0) {
                String[] stringArray = string.trim().split(",");
                int[] nArray = new int[stringArray.length];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    String string2 = stringArray[n3].trim().toLowerCase();
                    if (string2.startsWith("raid")) {
                        string2 = string2.substring(4);
                    }
                    nArray[n3] = Integer.parseInt(string2);
                    ++n3;
                }
                if (nArray.length > 1 || nArray[0] != 0) {
                    gUICapabilityData.setRaidLevelsSupported(nArray);
                }
            }
            if (n2 == 1) {
                n2 = 3;
            }
            gUICapabilityData.setSubsystemId(n);
            gUICapabilityData.setVolumeCreationSupported(bl);
            gUICapabilityData.setVolumeDeletionSupported(bl2);
            gUICapabilityData.setPortAssignmentSupported(bl3);
            gUICapabilityData.setPortUnassignmentSupported(bl4);
            if (l != 0L && l != 0L) {
                gUICapabilityData.setNumVolumesSupported(l);
            }
            gUICapabilityData.setTargetPortRestrictionSupported(bl5);
            gUICapabilityData.setPortsPerView(n2);
        }
        return gUICapabilityData;
    }

    private static GUIFabric createFabricInstance(HashMap hashMap) {
        GUIFabric gUIFabric = new GUIFabric();
        String string = GUIEntityUtil.getStringValue((String)((String)hashMap.get("DISPLAY_NAME")));
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("NAME")));
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("SAN_WWN")));
        String string4 = GUIEntityUtil.getStringValue((String)((String)hashMap.get(PORT_ATTR_FABRIC_WWN)));
        gUIFabric.setId(string4);
        gUIFabric.setName(string4);
        if (string != null && string.trim().length() > 0) {
            gUIFabric.setDeviceId(string);
        } else if (string2 != null && string2.trim().length() > 0) {
            gUIFabric.setDeviceId(string2);
        } else if (string3 != null && string3.trim().length() > 0) {
            gUIFabric.setDeviceId(string3);
        } else {
            gUIFabric.setDeviceId(string4);
        }
        gUIFabric.setZoningSupported(true);
        return gUIFabric;
    }

    private static GUIIOGroup createIOGroupInstance(HashMap hashMap) {
        GUIIOGroup gUIIOGroup = new GUIIOGroup();
        String string = String.valueOf(GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("IO_GROUP_ID"))));
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("GROUP_ID")));
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("NAME")));
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("SUBSYSTEM_ID"))).intValue();
        gUIIOGroup.setId(string);
        gUIIOGroup.setDeviceId(string2);
        gUIIOGroup.setName(string3);
        gUIIOGroup.setSubsystemId(String.valueOf(n));
        return gUIIOGroup;
    }

    private static GUIMDisk createMDiskInstance(HashMap hashMap, GUIStorageSubsystem gUIStorageSubsystem) {
        GUIMDisk gUIMDisk = new GUIMDisk();
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("STORAGE_EXTENT_ID"))).intValue();
        String string = GUIEntityUtil.getStringValue((String)((String)hashMap.get("DEVICE_ID")));
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("ELEMENT_NAME")));
        double d = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("TOTAL_CAPACITY"))).doubleValue() * 512.0;
        double d2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("FREE_SPACE"))).doubleValue() * 512.0;
        int n2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("POOL_ID"))).intValue();
        short s = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("NATIVE_STATUS"))).shortValue();
        short s2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("SUBSYSTEM_ID"))).shortValue();
        int n3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("MODE"))).shortValue();
        if (n3 < 0 || n3 > 3) {
            n3 = 99;
        }
        gUIMDisk.setId(ExternalKeyConverter.frameKeyStorageExtent((String)string, (String)gUIStorageSubsystem.getName(), (short)gUIStorageSubsystem.getNameFormat()));
        gUIMDisk.setInternalId(n);
        gUIMDisk.setName(string2);
        gUIMDisk.setDeviceId(string2);
        gUIMDisk.setCapacity((long)d);
        gUIMDisk.setUnusedCapacity((long)d2);
        gUIMDisk.setNativeStatus((int)s);
        gUIMDisk.setMode(n3);
        gUIMDisk.setSubsystemId(String.valueOf(s2));
        gUIMDisk.setMdiskGroupId(String.valueOf(n2));
        return gUIMDisk;
    }

    private static GUIStoragePool createMDiskGroupInstance(HashMap hashMap, String string) {
        GUIMDiskGroup gUIMDiskGroup = new GUIMDiskGroup();
        GUIEntityFactory.populateStoragePoolInstance((GUIStoragePool)gUIMDiskGroup, hashMap, string);
        return gUIMDiskGroup;
    }

    private static GUIPort createPortInstance(HashMap hashMap) {
        GUIPort gUIPort = new GUIPort();
        String string = GUIEntityUtil.getStringValue((String)((String)hashMap.get(PORT_ATTR_PORT_WWN)));
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get(PORT_ATTR_FABRIC_WWN)));
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get(PORT_ATTR_HOST_URL)));
        String string4 = GUIEntityUtil.getStringValue((String)((String)hashMap.get(PORT_ATTR_SUBSYSTEM_DISPLAY_TYPE)));
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get(PORT_ATTR_PORT_TYPE))).intValue();
        gUIPort.setId(string);
        gUIPort.setName(string);
        gUIPort.setDeviceId(string);
        gUIPort.setWwpn(string);
        gUIPort.setType(n);
        if (string2 != null) {
            gUIPort.addFabricId(string2);
        }
        if (string3 != null) {
            gUIPort.setHostName(string3);
        } else if (string4 != null) {
            gUIPort.setHostName(String.valueOf(string4));
        }
        return gUIPort;
    }

    private static GUIPortAssignment createPortAssignmentInstance(ExtendedVolumeAssignments extendedVolumeAssignments, String string, String string2) {
        GUIPortAssignment gUIPortAssignment = new GUIPortAssignment();
        gUIPortAssignment.setVolumeId(string);
        gUIPortAssignment.setHostPortWwpn(string2);
        gUIPortAssignment.setLunId(extendedVolumeAssignments.getVolumeDeviceNumber());
        gUIPortAssignment.setSubsystemPorts(extendedVolumeAssignments.getSubsystemPorts());
        return gUIPortAssignment;
    }

    private static GUIStoragePool createStoragePoolInstance(HashMap hashMap, String string) {
        GUIStoragePool gUIStoragePool = new GUIStoragePool();
        GUIEntityFactory.populateStoragePoolInstance(gUIStoragePool, hashMap, string);
        return gUIStoragePool;
    }

    private static void populateStoragePoolInstance(GUIStoragePool gUIStoragePool, HashMap hashMap, String string) {
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("POOL_ID"))).intValue();
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("NAME")));
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("DISPLAY_NAME")));
        String string4 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("INSTANCE_ID")));
        short s = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("CONSOLIDATED_STATUS"))).shortValue();
        boolean bl = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("DETECTABLE"))).shortValue() != 0;
        String string5 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("RAID_LEVEL")));
        int n2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("DATA_REDUNDANCY_DEF"))).intValue();
        int n3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("PCK_REDUNDANCY_DEF"))).intValue();
        long l = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("TOTAL_AVAILABLE_SPACE"))).longValue();
        short s2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("FORMAT"))).shortValue();
        String string6 = String.valueOf(GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("SUBSYSTEM_ID"))));
        int n4 = 99;
        if (string5 != null && !string5.equals("__NULL__") && string5.trim().length() > 0) {
            if ((string5 = string5.trim()).indexOf(",") > 0 || string5.indexOf(" ") > 0) {
                n4 = 77;
            } else {
                String string7 = string5.toLowerCase();
                if (string7.startsWith("raid")) {
                    string7 = string7.substring(4);
                }
                n4 = Integer.parseInt(string7);
            }
        }
        if (n4 == 99 && (n4 = GUIEntityUtil.getRaidLevel((int)n2, (int)n3)) == -1) {
            n4 = 99;
        }
        int n5 = 99;
        if (s2 >= 1 && s2 <= 4) {
            n5 = 0;
        } else if (s2 == 5) {
            n5 = 1;
        } else if (s2 == 6) {
            n5 = 2;
        }
        gUIStoragePool.setId(string);
        gUIStoragePool.setName(string2);
        gUIStoragePool.setDeviceId(string3);
        gUIStoragePool.setState((int)s);
        gUIStoragePool.setDetectable(bl);
        gUIStoragePool.setRaidLevel(n4);
        if (l != 0L) {
            gUIStoragePool.setUnusedCapacity(l * 512L);
        }
        gUIStoragePool.setSubsystemId(string6);
        gUIStoragePool.setFormat(n5);
        gUIStoragePool.setInternalId(n);
        gUIStoragePool.setInstanceId(string4);
    }

    private static GUIStorageSubsystem createStorageSubsystemInstance(HashMap hashMap, String string) {
        GUIStorageSubsystem gUIStorageSubsystem = new GUIStorageSubsystem();
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("SUBSYSTEM_ID"))).intValue();
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("NAME")));
        short s = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("NAME_FORMAT"))).shortValue();
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("DISPLAY_NAME")));
        String string4 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("TYPE")));
        String string5 = GUIEntityUtil.getStringValue((String)((String)hashMap.get(SUBSYSTEM_ATTR_MODEL)));
        String string6 = GUIEntityUtil.getStringValue((String)((String)hashMap.get(SUBSYSTEM_ATTR_VENDOR)));
        String string7 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("SERIAL_NUMBER")));
        String string8 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("CODE_LEVEL")));
        String string9 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_PROVIDED_NAME")));
        String string10 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("ACCESS_INFO")));
        String string11 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("IP_ADDRESS")));
        short s2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("CONSOLIDATED_STATUS"))).shortValue();
        boolean bl = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("DETECTABLE"))).shortValue() != 0;
        long l = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("ALLOCATED_CAPACITY"))).longValue();
        long l2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("AVAILABLE_CAPACITY"))).longValue();
        long l3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("VG_CAPACITY"))).longValue();
        long l4 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("VG_FREESPACE"))).longValue();
        String string12 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_PROVIDED_LOCATION")));
        String string13 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_ATTRIB1")));
        String string14 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_ATTRIB2")));
        String string15 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_ATTRIB3")));
        int n2 = 99;
        if (string4.equals("FAStT")) {
            n2 = 1;
        } else if (string4.equals("DS6000")) {
            n2 = 2;
        } else if (string4.equals("DS8000")) {
            n2 = 3;
        } else if (string4.equals("ESS")) {
            n2 = 0;
        } else if (string4.equals("SVC")) {
            n2 = 4;
        } else if (string4.equals("HDS")) {
            n2 = 5;
        } else if (string4.equals("EMC")) {
            n2 = 6;
        } else if (string4.equals("HP")) {
            n2 = 7;
        } else if (string4.equals("FUJITSU")) {
            n2 = 9;
        } else if (string4.equals("XP128")) {
            n2 = 10;
        } else if (string4.equals("SUN")) {
            n2 = 8;
        }
        Timestamp timestamp = (Timestamp)hashMap.get("LAST_PROBE_TIME");
        if (timestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            gUIStorageSubsystem.setProbed(true);
        } else {
            gUIStorageSubsystem.setProbed(false);
        }
        gUIStorageSubsystem.setId(string);
        gUIStorageSubsystem.setName(string2);
        gUIStorageSubsystem.setNameFormat(s);
        if (string9 != null && !string9.equals("__NULL__")) {
            gUIStorageSubsystem.setUserProvidedName(string9);
        }
        gUIStorageSubsystem.setState((int)s2);
        gUIStorageSubsystem.setDetectable(bl);
        gUIStorageSubsystem.setRevision(string8);
        gUIStorageSubsystem.setVendor(string6);
        gUIStorageSubsystem.setModel(string5);
        gUIStorageSubsystem.setSerialNumber(string7);
        if (string10 != null && !string10.equals("__NULL__")) {
            gUIStorageSubsystem.setElementManager(string10);
        }
        if (l3 != 0L) {
            gUIStorageSubsystem.setUsedCapacity(l3 * 512L - l4 * 512L);
            gUIStorageSubsystem.setUnusedCapacity(l4 * 512L);
        } else {
            gUIStorageSubsystem.setUsedCapacity(l * 512L);
            gUIStorageSubsystem.setUnusedCapacity(l2 * 512L);
        }
        gUIStorageSubsystem.setLocation(string12);
        if (string11 != null && !string11.equals("__NULL__")) {
            gUIStorageSubsystem.setIpAddress(string11);
        }
        gUIStorageSubsystem.setDeviceId(string3);
        gUIStorageSubsystem.setType(n2);
        gUIStorageSubsystem.setInternalId(n);
        if (string13 != null && !string13.equals("__NULL__")) {
            gUIStorageSubsystem.setUserAttrib1(string13);
        }
        if (string14 != null && !string14.equals("__NULL__")) {
            gUIStorageSubsystem.setUserAttrib2(string14);
        }
        if (string15 != null && !string15.equals("__NULL__")) {
            gUIStorageSubsystem.setUserAttrib3(string15);
        }
        return gUIStorageSubsystem;
    }

    private static GUIVolume createVolumeInstance(HashMap hashMap, String string, GUIStorageSubsystem gUIStorageSubsystem) {
        GUIVolume gUIVolume = new GUIVolume();
        GUIEntityFactory.populateVolumeInstance(gUIVolume, hashMap, string, gUIStorageSubsystem);
        return gUIVolume;
    }

    private static GUIVolume createVDiskInstance(HashMap hashMap, String string, GUIStorageSubsystem gUIStorageSubsystem) {
        GUIVDisk gUIVDisk = new GUIVDisk();
        GUIEntityFactory.populateVolumeInstance((GUIVolume)gUIVDisk, hashMap, string, gUIStorageSubsystem);
        GUIEntityFactory.populateVDiskInstance(gUIVDisk, hashMap, string);
        return gUIVDisk;
    }

    private static void populateVolumeInstance(GUIVolume gUIVolume, HashMap hashMap, String string, GUIStorageSubsystem gUIStorageSubsystem) {
        String string2 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("NAME")));
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("DISPLAY_NAME")));
        short s = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("CONSOLIDATED_STATUS"))).shortValue();
        boolean bl = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("DETECTABLE"))).shortValue() != 0;
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("LSS"))).intValue();
        long l = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("CAPACITY"))).longValue();
        int n2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("SUBSYSTEM_ID"))).intValue();
        int n3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("POOL_ID"))).intValue();
        Short s2 = (Short)hashMap.get("REDUNDANCY");
        int n4 = s2 != null ? (int)s2.shortValue() : -1;
        short s3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("DATA_REDUNDANCY"))).shortValue();
        short s4 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("PACKAGE_REDUNDANCY"))).shortValue();
        int n5 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("FORMAT"))).shortValue();
        String string4 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_ATTRIB1")));
        String string5 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_ATTRIB2")));
        String string6 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("USER_ATTRIB3")));
        int n6 = n4;
        if (n6 == -1 || n6 == 0) {
            n6 = GUIEntityUtil.getRaidLevel((int)s3, (int)s4);
        }
        if (n6 == -1) {
            n6 = 99;
        }
        n5 = n5 >= 1 && n5 <= 4 ? 0 : (n5 == 5 ? 1 : (n5 == 6 ? 2 : 0));
        gUIVolume.setId(string);
        gUIVolume.setName(string2);
        if (string3 == null) {
            string3 = string2;
        }
        gUIVolume.setDeviceId(string3);
        gUIVolume.setState((int)s);
        gUIVolume.setDetectable(bl);
        gUIVolume.setUserAttrib1(string4);
        gUIVolume.setUserAttrib2(string5);
        gUIVolume.setUserAttrib3(string6);
        if (Integer.toString(n) != null) {
            gUIVolume.setLcu(String.valueOf(n));
        }
        if (l != 0L) {
            gUIVolume.setCapacity(l * 512L);
        }
        gUIVolume.setSubsystemId(String.valueOf(n2));
        gUIVolume.setSubsystemDeviceId(gUIStorageSubsystem.getDeviceId());
        gUIVolume.setSubsystemName(gUIStorageSubsystem.getUserProvidedName());
        gUIVolume.setStoragePoolId(String.valueOf(n3));
        gUIVolume.setRaidLevel(n6);
        gUIVolume.setFormat(n5);
    }

    private static void populateVDiskInstance(GUIVDisk gUIVDisk, HashMap hashMap, String string) {
        short s = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("VDISK_TYPE"))).shortValue();
        short s2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("NATIVE_STATUS"))).shortValue();
        int n = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("IO_GROUP_ID"))).intValue();
        int n2 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("MDISK_ID"))).intValue();
        long l = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("THROTTLE"))).longValue();
        int n3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("FAST_WRITE_STATE"))).intValue();
        short s3 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("IS_ASSIGNED"))).shortValue();
        short s4 = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("IS_FORMATTED"))).shortValue();
        Object v = hashMap.get("FLASH_COPY_ID");
        Object v2 = hashMap.get("FLASH_COPY_NAME");
        Object v3 = hashMap.get("METRO_MIRROR_ID");
        Object v4 = hashMap.get("METRO_MIRROR_NAME");
        Object v5 = hashMap.get("UNIQUE_ID");
        Object v6 = hashMap.get("PREFERRED_NODE");
        gUIVDisk.setType((int)s);
        gUIVDisk.setNativeStatus((int)s2);
        gUIVDisk.setIoGroupId(String.valueOf(n));
        if (n2 != 0) {
            gUIVDisk.setMdiskId(String.valueOf(n2));
        }
        gUIVDisk.setIoThrottling(l);
        if (v6 != null && !v6.equals("__NULL__")) {
            gUIVDisk.setPreferredNodeForIO(String.valueOf(v6));
        }
        if (n3 != 0) {
            gUIVDisk.setFastWriteState(n3);
        }
        if (v5 != null && !v5.equals("__NULL__")) {
            gUIVDisk.setUid(String.valueOf(String.valueOf(v5)));
        }
        gUIVDisk.setAssigned(s3 == 1);
        gUIVDisk.setFormatted(s4 == 1);
        if (v != null && !v.equals("__NULL__")) {
            gUIVDisk.setFlashCopyId(String.valueOf(v));
        }
        if (v2 != null && !v2.equals("__NULL__")) {
            gUIVDisk.setFlashCopyName(String.valueOf(v2));
        }
        if (v3 != null && !v3.equals("__NULL__")) {
            gUIVDisk.setMetroMirrorId(String.valueOf(v3));
        }
        if (v4 != null && !v4.equals("__NULL__")) {
            gUIVDisk.setMetroMirrorName(String.valueOf(v4));
        }
    }

    private static GUIZone createZoneInstance(HashMap hashMap, String string, String string2) {
        GUIZone gUIZone = new GUIZone();
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("ZONE_NAME")));
        gUIZone.setId(string3);
        gUIZone.setDeviceId(string3);
        gUIZone.setName(string3);
        gUIZone.setZonesetId(string2);
        return gUIZone;
    }

    private static GUIZoneSet createZoneSetInstance(HashMap hashMap, String string, String string2) {
        GUIZoneSet gUIZoneSet = new GUIZoneSet();
        String string3 = GUIEntityUtil.getStringValue((String)((String)hashMap.get("ZSET_NAME")));
        boolean bl = GUIEntityUtil.getNumberValue((Number)((Number)hashMap.get("ACTIVE"))).intValue() == 1;
        gUIZoneSet.setId(string2);
        gUIZoneSet.setDeviceId(string3);
        gUIZoneSet.setName(string3);
        gUIZoneSet.setActive(bl);
        gUIZoneSet.setFabricId(string);
        return gUIZoneSet;
    }

    public static GUIEntityFactory getInstance() {
        if (factory == null) {
            factory = new GUIEntityFactory();
        }
        return factory;
    }

    private DBConnection getDBConnection() {
        return ServiceUtils.getConnection();
    }

    private void closeDBConnection(DBConnection dBConnection) throws Exception {
        if (dBConnection != null && !dBConnection.isClosed()) {
            dBConnection.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllStorageSubsystems() throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap hashMap = null;
        try {
            try {
                Class<?> clazz;
                DeviceRequest deviceRequest = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
                String[] stringArray = iDiskReportingService.getStorageSubsystems(new HashMap());
                hashMap = this.getStorageSubsystems(stringArray);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getStorageSubsystems(String[] stringArray) throws Exception {
        HashMap<String, GUIStorageSubsystem> hashMap = new HashMap<String, GUIStorageSubsystem>();
        DBConnection dBConnection = this.getDBConnection();
        try {
            if (stringArray != null && stringArray.length > 0) {
                Class<?> clazz;
                DeviceRequest deviceRequest = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
                HashMap[] hashMapArray = iDiskReportingService.getStorageSubsystemAttributes(stringArray, SUBSYSTEM_DB_ATTRIBUTES);
                if (hashMapArray != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap2 = hashMapArray[n];
                        GUIStorageSubsystem gUIStorageSubsystem = GUIEntityFactory.createStorageSubsystemInstance(hashMap2, stringArray[n]);
                        hashMap.put(gUIStorageSubsystem.getId(), gUIStorageSubsystem);
                        ++n;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getSubsystemPorts(String string) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap hashMap = this.getStorageSubsystems(new String[]{string});
        GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap.values().iterator().next();
        HashMap<String, GUIPort> hashMap2 = new HashMap<String, GUIPort>();
        try {
            HashMap[] hashMapArray = DiskDbAccessor.getPortsForSubsystem((String)String.valueOf(gUIStorageSubsystem.getInternalId()), (String[])PORT_DB_ATTRIBUTES, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap3 = hashMapArray[n];
                    GUIPort gUIPort = GUIEntityFactory.createPortInstance(hashMap3);
                    GUIPort gUIPort2 = (GUIPort)hashMap2.get(gUIPort.getWwpn());
                    if (gUIPort2 != null) {
                        Vector vector = gUIPort.getFabrics();
                        if (vector.size() >= 1) {
                            gUIPort2.addFabricId((String)vector.elementAt(0));
                        }
                    } else {
                        gUIPort.setHostName(gUIStorageSubsystem.getDeviceId());
                        hashMap2.put(gUIPort.getWwpn(), gUIPort);
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap2;
    }

    public HashMap getFabricPortMap() throws Exception {
        HashMap hashMap = new HashMap();
        String[] stringArray = FabricDbAccess.getFabrics(new HashMap());
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String[] stringArray2 = FabricDbAccess.getZoneSets((String)string, (boolean)true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        String string2 = stringArray2[n2];
                        String[] stringArray3 = FabricDbAccess.getZones((String)string, (String)string2, (boolean)true);
                        if (stringArray3 != null && stringArray3.length > 0) {
                            int n3 = 0;
                            while (n3 < stringArray3.length) {
                                String string3 = stringArray3[n3];
                                String[] stringArray4 = FabricDbAccess.getPortsInZone((String)string, (String)string3, (boolean)true);
                                Vector<String> vector = (Vector<String>)hashMap.get(stringArray4);
                                if (vector == null) {
                                    vector = new Vector<String>();
                                }
                                if (!vector.contains(string)) {
                                    vector.add(string);
                                }
                                hashMap.put(stringArray4, vector);
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getHostPortsBySubsystem(String string) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap<String, GUIPort> hashMap = new HashMap<String, GUIPort>();
        try {
            GUIPort gUIPort;
            GUIPort gUIPort2;
            HashMap hashMap2;
            int n;
            HashMap hashMap3 = this.getStorageSubsystems(new String[]{string});
            GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap3.values().iterator().next();
            HashMap[] hashMapArray = DiskDbAccessor.getHostPortsInFabricForSubsystem((String)String.valueOf(gUIStorageSubsystem.getInternalId()), (String[])PORT_DB_ATTRIBUTES, (DBConnection)dBConnection);
            HashMap[] hashMapArray2 = DiskDbAccessor.getDefinedHostPortsForSubsystem((String)String.valueOf(gUIStorageSubsystem.getInternalId()), (String[])PORT_DB_ATTRIBUTES, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                n = 0;
                while (n < hashMapArray.length) {
                    hashMap2 = hashMapArray[n];
                    gUIPort2 = GUIEntityFactory.createPortInstance(hashMap2);
                    gUIPort = (GUIPort)hashMap.get(gUIPort2.getWwpn());
                    if (gUIPort != null) {
                        Vector vector = gUIPort2.getFabrics();
                        if (vector.size() >= 1) {
                            gUIPort.addFabricId((String)vector.elementAt(0));
                        }
                    } else {
                        hashMap.put(gUIPort2.getWwpn(), gUIPort2);
                    }
                    ++n;
                }
            }
            if (hashMapArray2 != null && hashMapArray2.length > 0) {
                n = 0;
                while (n < hashMapArray2.length) {
                    hashMap2 = hashMapArray2[n];
                    gUIPort2 = GUIEntityFactory.createPortInstance(hashMap2);
                    gUIPort = (GUIPort)hashMap.get(gUIPort2.getWwpn());
                    if (gUIPort == null) {
                        hashMap.put(gUIPort2.getWwpn(), gUIPort2);
                    }
                    ++n;
                }
            }
            Vector vector = new Vector(hashMap.values());
            hashMap2 = null;
            int n2 = 0;
            while (n2 < vector.size()) {
                hashMap2 = (GUIPort)vector.get(n2);
                this.getTypeForPortFromHost((GUIPort)hashMap2);
                this.getTypeForPortFromClientSetting((GUIPort)hashMap2);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var13_17 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * Exception decompiling
     */
    private void getTypeForPortFromHost(GUIPort var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 215->219)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void getTypeForPortFromClientSetting(GUIPort var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 296->300)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getStoragePoolsBySubsytstem(String string) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap hashMap = new HashMap();
        try {
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
            String[] stringArray = iDiskReportingService.getStoragePoolsForSubsystem(string, new HashMap());
            hashMap = this.getStoragePools(string, stringArray);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getStoragePools(String string, String[] stringArray) throws Exception {
        HashMap<String, GUIStoragePool> hashMap = new HashMap<String, GUIStoragePool>();
        DBConnection dBConnection = this.getDBConnection();
        try {
            if (stringArray != null && stringArray.length > 0) {
                Class<?> clazz;
                DeviceRequest deviceRequest = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
                HashMap[] hashMapArray = iDiskReportingService.getStoragePoolAttributes(stringArray, STORAGE_POOL_DB_ATTRIBUTES);
                if (hashMapArray != null && hashMapArray.length > 0 && hashMapArray.length == hashMapArray.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap2 = hashMapArray[n];
                        GUIStoragePool gUIStoragePool = GUIEntityFactory.createStoragePoolInstance(hashMap2, stringArray[n]);
                        if (gUIStoragePool.isDetectable()) {
                            hashMap.put(gUIStoragePool.getId(), gUIStoragePool);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getIOGroupsBySVC(String string) throws Exception {
        HashMap hashMap = this.getStorageSubsystems(new String[]{string});
        GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap.values().iterator().next();
        DBConnection dBConnection = this.getDBConnection();
        HashMap<String, GUIIOGroup> hashMap2 = new HashMap<String, GUIIOGroup>();
        try {
            HashMap[] hashMapArray = DiskDbAccessor.getIOGroupsBySVC((String)String.valueOf(gUIStorageSubsystem.getInternalId()), (String[])IO_GROUP_DB_ATTRIBUTES, null, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap3 = hashMapArray[n];
                    GUIIOGroup gUIIOGroup = GUIEntityFactory.createIOGroupInstance(hashMap3);
                    hashMap2.put(gUIIOGroup.getId(), gUIIOGroup);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getMDiskGroupsBySVC(String string) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap hashMap = null;
        try {
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
            String[] stringArray = iDiskReportingService.getStoragePoolsForSubsystem(string, new HashMap());
            hashMap = this.getMDiskGroups(string, stringArray);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getMDiskGroups(String string, String[] stringArray) throws Exception {
        HashMap<String, GUIMDiskGroup> hashMap = new HashMap<String, GUIMDiskGroup>();
        DBConnection dBConnection = this.getDBConnection();
        try {
            if (stringArray != null && stringArray.length > 0) {
                Class<?> clazz;
                DeviceRequest deviceRequest = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
                HashMap[] hashMapArray = iDiskReportingService.getStoragePoolAttributes(stringArray, STORAGE_POOL_DB_ATTRIBUTES);
                if (hashMapArray != null && hashMapArray.length > 0 && hashMapArray.length == hashMapArray.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap2 = hashMapArray[n];
                        GUIMDiskGroup gUIMDiskGroup = (GUIMDiskGroup)GUIEntityFactory.createMDiskGroupInstance(hashMap2, stringArray[n]);
                        if (gUIMDiskGroup.isDetectable()) {
                            hashMap.put(gUIMDiskGroup.getId(), gUIMDiskGroup);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getMDisksByMDiskGroup(String string, String string2) throws Exception {
        HashMap hashMap = this.getStorageSubsystems(new String[]{string});
        GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap.values().iterator().next();
        HashMap hashMap2 = this.getMDiskGroups(string, new String[]{string2});
        GUIMDiskGroup gUIMDiskGroup = (GUIMDiskGroup)hashMap2.values().iterator().next();
        DBConnection dBConnection = this.getDBConnection();
        HashMap<String, GUIMDisk> hashMap3 = new HashMap<String, GUIMDisk>();
        try {
            HashMap[] hashMapArray = DiskDbAccessor.getMDisksByMDiskGroup((String)String.valueOf(gUIMDiskGroup.getInternalId()), (String[])MDISK_DB_ATTRIBUTES, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap4 = hashMapArray[n];
                    GUIMDisk gUIMDisk = GUIEntityFactory.createMDiskInstance(hashMap4, gUIStorageSubsystem);
                    hashMap3.put(gUIMDisk.getId(), gUIMDisk);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap3;
    }

    public HashMap getUnmanagedMDisksBySVC(String string) throws Exception {
        return this.getMDisksBySVC(string, 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getMDisksBySVC(String string, int n) throws Exception {
        HashMap hashMap = this.getStorageSubsystems(new String[]{string});
        GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap.values().iterator().next();
        DBConnection dBConnection = this.getDBConnection();
        HashMap<String, GUIMDisk> hashMap2 = new HashMap<String, GUIMDisk>();
        try {
            HashMap[] hashMapArray = DiskDbAccessor.getMDisksBySVC((String)String.valueOf(gUIStorageSubsystem.getInternalId()), (int)n, (String[])MDISK_DB_ATTRIBUTES, null, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                int n2 = 0;
                while (n2 < hashMapArray.length) {
                    HashMap hashMap3 = hashMapArray[n2];
                    GUIMDisk gUIMDisk = GUIEntityFactory.createMDiskInstance(hashMap3, gUIStorageSubsystem);
                    hashMap2.put(gUIMDisk.getId(), gUIMDisk);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getVDiskIdsByIOGroup(String string, String string2) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        String[] stringArray = null;
        try {
            stringArray = DiskDbAccessor.getVDiskIdsForByIOGroup((String)string, (String)string2, new HashMap(), null, (DBConnection)dBConnection);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.closeDBConnection(dBConnection);
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getVolumeIdsBySubsystem(String string) throws Exception {
        String[] stringArray = null;
        DBConnection dBConnection = this.getDBConnection();
        try {
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
            stringArray = iDiskReportingService.getStorageVolumesForSubsystem(string, new HashMap());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.closeDBConnection(dBConnection);
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getVolumeNamesBySubsystem(String string) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap hashMap = this.getStorageSubsystems(new String[]{string});
        GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap.values().iterator().next();
        String[] stringArray = new String[]{};
        try {
            HashMap[] hashMapArray = DiskDbAccessor.getVolumeNamesForSubsystem((String)String.valueOf(gUIStorageSubsystem.getInternalId()), (String[])new String[]{"DISPLAY_NAME"}, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                stringArray = new String[hashMapArray.length];
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap2 = hashMapArray[n];
                    stringArray[n] = (String)hashMap2.get("DISPLAY_NAME");
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.closeDBConnection(dBConnection);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getVolumes(String string, String[] stringArray) throws Exception {
        HashMap<String, GUIVolume> hashMap = new HashMap<String, GUIVolume>();
        DBConnection dBConnection = this.getDBConnection();
        try {
            String[] stringArray2 = stringArray;
            if (stringArray2 != null && stringArray2.length > 0) {
                Class<?> clazz;
                DeviceRequest deviceRequest;
                HashMap hashMap2 = this.getStorageSubsystems(new String[]{string});
                GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap2.values().iterator().next();
                HashMap hashMap3 = this.getStoragePoolsBySubsytstem(string);
                HashMap<Integer, String> hashMap4 = new HashMap<Integer, String>();
                Iterator iterator = hashMap3.values().iterator();
                while (iterator.hasNext()) {
                    deviceRequest = (GUIStoragePool)iterator.next();
                    hashMap4.put(new Integer(deviceRequest.getInternalId()), deviceRequest.getDeviceId());
                }
                deviceRequest = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
                HashMap[] hashMapArray = iDiskReportingService.getStorageVolumeAttributes(stringArray2, VOLUME_DB_ATTRIBUTES);
                if (hashMapArray != null && hashMapArray.length > 0 && hashMapArray.length == stringArray2.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap5 = hashMapArray[n];
                        if (hashMap5 != null) {
                            GUIVolume gUIVolume = GUIEntityFactory.createVolumeInstance(hashMap5, stringArray2[n], gUIStorageSubsystem);
                            gUIVolume.setStoragePoolName((String)hashMap4.get(new Integer(gUIVolume.getStoragePoolId())));
                            if (gUIVolume.isDetectable()) {
                                hashMap.put(gUIVolume.getId(), gUIVolume);
                            }
                        }
                        ++n;
                    }
                }
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    public HashMap getVolumesBySubsystem(String string) throws Exception {
        String[] stringArray = this.getVolumeIdsBySubsystem(string);
        return this.getVolumes(string, stringArray);
    }

    public String[] getVDiskIdsBySVC(String string) throws Exception {
        return this.getVolumeIdsBySubsystem(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getVDisks(String string, String[] stringArray) throws Exception {
        HashMap<String, GUIVDisk> hashMap = new HashMap<String, GUIVDisk>();
        DBConnection dBConnection = this.getDBConnection();
        try {
            if (stringArray != null && stringArray.length > 0) {
                Class<?> clazz;
                DeviceRequest deviceRequest;
                Object object;
                HashMap hashMap2;
                HashMap hashMap3 = this.getStorageSubsystems(new String[]{string});
                GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap3.values().iterator().next();
                HashMap hashMap4 = this.getMDiskGroupsBySVC(string);
                HashMap<String, String> hashMap5 = new HashMap<String, String>();
                Iterator iterator = hashMap4.values().iterator();
                while (iterator.hasNext()) {
                    hashMap2 = (GUIMDiskGroup)iterator.next();
                    hashMap5.put(String.valueOf(hashMap2.getInternalId()), hashMap2.getDeviceId());
                }
                hashMap2 = this.getIOGroupsBySVC(string);
                HashMap<String, String> hashMap6 = new HashMap<String, String>();
                HashMap<String, String> hashMap7 = new HashMap<String, String>();
                Iterator iterator2 = hashMap2.values().iterator();
                while (iterator2.hasNext()) {
                    object = (GUIIOGroup)iterator2.next();
                    hashMap6.put(object.getId(), object.getName());
                    hashMap7.put(object.getId(), object.getDeviceId());
                }
                object = this.getMDisksBySVC(string, -1);
                HashMap<String, String> hashMap8 = new HashMap<String, String>();
                Iterator iterator3 = ((HashMap)object).values().iterator();
                while (iterator3.hasNext()) {
                    deviceRequest = (GUIMDisk)iterator3.next();
                    hashMap8.put(String.valueOf(deviceRequest.getInternalId()), deviceRequest.getName());
                }
                deviceRequest = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
                HashMap[] hashMapArray = iDiskReportingService.getStorageVolumeAttributes(stringArray, VDISK_DB_ATTRIBUTES);
                if (hashMapArray != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap9 = hashMapArray[n];
                        if (hashMap9 != null) {
                            GUIVDisk gUIVDisk = (GUIVDisk)GUIEntityFactory.createVDiskInstance(hashMap9, stringArray[n], gUIStorageSubsystem);
                            gUIVDisk.setStoragePoolName((String)hashMap5.get(gUIVDisk.getStoragePoolId()));
                            gUIVDisk.setIoGroupName((String)hashMap6.get(gUIVDisk.getIoGroupId()));
                            gUIVDisk.setMdiskName((String)hashMap8.get(gUIVDisk.getMdiskId()));
                            gUIVDisk.setIoGrpId((String)hashMap7.get(gUIVDisk.getIoGroupId()));
                            if (gUIVDisk.isDetectable()) {
                                hashMap.put(gUIVDisk.getId(), gUIVDisk);
                            }
                        }
                        ++n;
                    }
                }
            }
            Object var23_25 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    public HashMap getVDisksBySVC(String string) throws Exception {
        String[] stringArray = this.getVDiskIdsBySVC(string);
        return this.getVDisks(string, stringArray);
    }

    /*
     * Exception decompiling
     */
    public HashMap getMDisksForVDisk(String var1_1, String var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 147->150)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GUIVolume getVolume(String string, String string2) throws Exception {
        GUIVolume gUIVolume = null;
        String[] stringArray = new String[]{string2};
        HashMap hashMap = this.getVolumes(string, stringArray);
        if (hashMap != null && hashMap.size() > 0) {
            gUIVolume = (GUIVolume)hashMap.values().iterator().next();
        }
        return gUIVolume;
    }

    public GUIVDisk getVDisk(String string, String string2) throws Exception {
        GUIVDisk gUIVDisk = null;
        String[] stringArray = new String[]{string2};
        HashMap hashMap = this.getVDisks(string, stringArray);
        if (hashMap != null && hashMap.size() > 0) {
            gUIVDisk = (GUIVDisk)hashMap.values().iterator().next();
        }
        return gUIVDisk;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getVolumeIdsByStoragePool(String string, String string2) throws Exception {
        String[] stringArray = null;
        DBConnection dBConnection = this.getDBConnection();
        try {
            Class<?> clazz;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("DETECTABLE", "1");
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
            stringArray = iDiskReportingService.getStorageVolumesForPool(string2, hashMap);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.closeDBConnection(dBConnection);
        return stringArray;
    }

    public HashMap getVolumesByStoragePool(String string, String string2) throws Exception {
        String[] stringArray = this.getVolumeIdsByStoragePool(string, string2);
        return this.getVolumes(string, stringArray);
    }

    public String[] getVDiskIdsByMDiskGroup(String string, String string2) throws Exception {
        return this.getVolumeIdsByStoragePool(string, string2);
    }

    public HashMap getVDisksByMDiskGroup(String string, String string2) throws Exception {
        String[] stringArray = this.getVDiskIdsByMDiskGroup(string, string2);
        return this.getVDisks(string, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getVolumeIdsByHost(String string, String string2) throws Exception {
        String[] stringArray = null;
        DBConnection dBConnection = this.getDBConnection();
        try {
            Class<?> clazz;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("WWPN", new String[]{string2});
            hashMap.put("Assigned", Boolean.TRUE);
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
            HashMap hashMap2 = iDiskReportingService.getHostInfo(string, hashMap, true);
            if (hashMap2 != null && hashMap2.size() > 0) {
                Iterator iterator = hashMap2.values().iterator();
                Vector<String> vector = new Vector<String>();
                while (iterator.hasNext()) {
                    HostInfo hostInfo = (HostInfo)iterator.next();
                    String[] stringArray2 = hostInfo.getMappedVolumeIDs();
                    if (stringArray2 == null || stringArray2.length <= 0) continue;
                    int n = 0;
                    while (n < stringArray2.length) {
                        String string3 = stringArray2[n];
                        if (!vector.contains(string3)) {
                            vector.add(string3);
                        }
                        ++n;
                    }
                }
                stringArray = vector.toArray(new String[0]);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        this.closeDBConnection(dBConnection);
        return stringArray;
    }

    public HashMap getVolumesByHost(String string, String string2) throws Exception {
        String[] stringArray = this.getVolumeIdsByHost(string, string2);
        return this.getVolumes(string, stringArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAssignedHostPortsBySubsystem(String string) throws Exception {
        HashMap<String, GUIPort> hashMap = new HashMap<String, GUIPort>();
        DBConnection dBConnection = this.getDBConnection();
        try {
            Class<?> clazz;
            Object object;
            String string2;
            Object object2;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap[] hashMapArray = DiskDbAccessor.getPort2HostMapping((String[])new String[]{PORT_ATTR_PORT_WWN, PORT_ATTR_HOST_URL}, (DBConnection)dBConnection);
            if (hashMapArray != null && hashMapArray.length > 0) {
                int n = 0;
                while (n < hashMapArray.length) {
                    object2 = hashMapArray[n];
                    string2 = (String)((HashMap)object2).get(PORT_ATTR_PORT_WWN);
                    object = (String)((HashMap)object2).get(PORT_ATTR_HOST_URL);
                    hashMap2.put(string2, (String)object);
                    ++n;
                }
            }
            HashMap<String, Boolean> hashMap3 = new HashMap<String, Boolean>();
            hashMap3.put("Assigned", Boolean.TRUE);
            object2 = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm((DeviceRequest)object2);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            string2 = (IDiskReportingService)ConnectorClient.getService((String)((DeviceRequest)object2).deviceServerHost, (int)((DeviceRequest)object2).deviceServerPort, clazz, (String)"DiskManagerService");
            object = string2.getHostInfo(string, hashMap3, false);
            if (object != null && ((HashMap)object).size() > 0) {
                Iterator iterator = ((HashMap)object).keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    GUIPort gUIPort = new GUIPort();
                    gUIPort.setId(string3);
                    gUIPort.setName(string3);
                    gUIPort.setWwpn(string3);
                    gUIPort.setDeviceId(string3);
                    String string4 = (String)hashMap2.get(string3);
                    if (string4 != null) {
                        gUIPort.setHostName(string4);
                    }
                    hashMap.put(string3, gUIPort);
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMap;
    }

    public String[] getVDiskIdsByHost(String string, String string2) throws Exception {
        return this.getVolumeIdsByHost(string, string2);
    }

    public HashMap getVDisksByHost(String string, String string2) throws Exception {
        String[] stringArray = this.getVDiskIdsByHost(string, string2);
        return this.getVDisks(string, stringArray);
    }

    public HashMap getPortAssignments(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string2};
        return this.getPortAssignments(string, stringArray)[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getPortAssignments(String string, String[] stringArray) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        try {
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
            HashMap[] hashMapArray2 = iDiskReportingService.getStorageVolumeAssignments(stringArray, new HashMap());
            if (hashMapArray2 != null && hashMapArray2.length == stringArray.length) {
                int n = 0;
                while (n < stringArray.length) {
                    HashMap hashMap = hashMapArray2[n];
                    HashMap<String, GUIPortAssignment> hashMap2 = new HashMap<String, GUIPortAssignment>();
                    if (hashMap != null && hashMap.size() > 0) {
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            ExtendedVolumeAssignments extendedVolumeAssignments = (ExtendedVolumeAssignments)hashMap.get(string2);
                            GUIPortAssignment gUIPortAssignment = GUIEntityFactory.createPortAssignmentInstance(extendedVolumeAssignments, stringArray[n], string2);
                            hashMap2.put(string2, gUIPortAssignment);
                        }
                    }
                    hashMapArray[n] = hashMap2;
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var15_17 = null;
        }
        this.closeDBConnection(dBConnection);
        return hashMapArray;
    }

    public GUICapabilityData getCapabilities(String string) throws Exception {
        GUICapabilityData gUICapabilityData = null;
        HashMap hashMap = this.getStorageSubsystems(new String[]{string});
        GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)hashMap.values().iterator().next();
        String string2 = String.valueOf(gUIStorageSubsystem.getInternalId());
        HashMap[] hashMapArray = DiskDbAccessor.getStorageSubsystemCapabilities((String[])new String[]{string2}, (String[])CAPABILITY_DATA_DB_ATTRIBUTES, null);
        HashMap hashMap2 = hashMapArray[0];
        gUICapabilityData = hashMap2 != null ? GUIEntityFactory.createCapabilityDataInstance(hashMap2) : new GUICapabilityData();
        return gUICapabilityData;
    }

    public int[] getSupportedRaidLevels(String string) throws Exception {
        return this.getCapabilities(string).getRaidLevelsSupported();
    }

    public long getMaxVolumes(String string) throws Exception {
        return this.getCapabilities(string).getNumVolumesSupported();
    }

    private long[] getVolumeSizeRange(String string, String string2) throws Exception {
        Class<?> clazz;
        DeviceRequest deviceRequest = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskReportingService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IDiskReportingService iDiskReportingService = (IDiskReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiskManagerService");
        return iDiskReportingService.getDefaultSupportedVolumeSizeRange(string2);
    }

    public HashMap getFabrics() throws Exception {
        HashMap[] hashMapArray;
        HashMap<String, GUIFabric> hashMap = new HashMap<String, GUIFabric>();
        String[] stringArray = FabricDbAccess.getFabrics(new HashMap());
        if (stringArray != null && stringArray.length > 0 && (hashMapArray = FabricDbAccess.getFabricAttributes((String[])stringArray, (String[])FABRIC_DB_ATTRIBUTES)) != null && hashMapArray.length > 0) {
            int n = 0;
            while (n < hashMapArray.length) {
                HashMap hashMap2 = hashMapArray[n];
                GUIFabric gUIFabric = GUIEntityFactory.createFabricInstance(hashMap2);
                GUIZoneSet gUIZoneSet = this.getActiveZoneSet(gUIFabric.getId());
                if (gUIZoneSet != null) {
                    gUIFabric.setActiveZoneSet(gUIZoneSet);
                }
                hashMap.put(gUIFabric.getId(), gUIFabric);
                ++n;
            }
        }
        return hashMap;
    }

    public GUIZoneSet getActiveZoneSet(String string) throws Exception {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap[] hashMapArray;
        GUIZoneSet gUIZoneSet = null;
        String[] stringArray = FabricDbAccess.getZoneSets((String)string, (boolean)true);
        if (stringArray != null && stringArray.length > 0 && (hashMapArray = FabricDbAccess.getZoneSetAttributes((String)string, (String[])stringArray, (boolean)true, (String[])ZONE_SET_DB_ATTRIBUTES)) != null && hashMapArray.length > 0 && (gUIZoneSet = GUIEntityFactory.createZoneSetInstance(hashMap2 = hashMapArray[0], string, stringArray[0])) != null && (hashMap = this.getZones(string, gUIZoneSet.getId())) != null) {
            gUIZoneSet.setZones(hashMap);
        }
        return gUIZoneSet;
    }

    public HashMap getZones(String string, String string2) throws Exception {
        HashMap[] hashMapArray;
        HashMap<String, GUIZone> hashMap = new HashMap<String, GUIZone>();
        String[] stringArray = FabricDbAccess.getZones((String)string, (String)string2, (boolean)true);
        if (stringArray != null && stringArray.length > 0 && (hashMapArray = FabricDbAccess.getZoneAttributes((String)string, (String[])stringArray, (boolean)true, (String[])ZONE_DB_ATTRIBUTES)) != null && hashMapArray.length > 0) {
            int n = 0;
            while (n < hashMapArray.length) {
                String[] stringArray2;
                HashMap hashMap2 = hashMapArray[n];
                GUIZone gUIZone = GUIEntityFactory.createZoneInstance(hashMap2, string, string2);
                if (gUIZone != null && (stringArray2 = this.getPortsByZone(string, string2, gUIZone.getId())) != null) {
                    gUIZone.setPorts(stringArray2);
                }
                hashMap.put(gUIZone.getId(), gUIZone);
                ++n;
            }
        }
        return hashMap;
    }

    public String[] getPortsByZone(String string, String string2, String string3) throws Exception {
        String[] stringArray = null;
        stringArray = FabricDbAccess.getPortsInZone((String)string, (String)string3, (boolean)true);
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean areVolumeActionsInProgress(String string) throws Exception {
        DBConnection dBConnection = this.getDBConnection();
        int n = 0;
        try {
            n = DiskDbAccessor.getNumberOfJobs((int)113, (int)2, null, (DBConnection)dBConnection);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.closeDBConnection(dBConnection);
        return n > 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setStorageSubsystemAttributes(String string, Hashtable hashtable) throws Exception {
        int n = 0;
        DBConnection dBConnection = this.getDBConnection();
        try {
            n = DiskDbAccessor.updateSubsystemAttributes((String)string, (Hashtable)hashtable, null, (DBConnection)dBConnection);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.closeDBConnection(dBConnection);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setStorageVolumeAttributes(String string, Hashtable hashtable) throws Exception {
        int n = 0;
        DBConnection dBConnection = this.getDBConnection();
        try {
            n = DiskDbAccessor.updateVolumeAttributes((String)string, (Hashtable)hashtable, null, (DBConnection)dBConnection);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeDBConnection(dBConnection);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.closeDBConnection(dBConnection);
        return n;
    }
}

