/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.fabric;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMException;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.gui.fabric.GUIDeviceAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutOfBandFabricAgentHandler
implements RequestHandler,
ThreadSafe {
    private static String IP_ADDRESS_COLUMN = "IP_ADDRESS";

    private void log(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)3, (String)"OutOfBandFabricAgentHandler", (String)"log", (String)string);
        }
    }

    private void setResponseError(Response response, String string, String string2) {
        this.log(string);
        response.responseData = null;
        response.status = (short)12;
        response.errorMessage = string;
        if (string2 != null) {
            response.errorMessage = string2;
        }
        if (response.errorMessage == null) {
            response.errorMessage = "";
        }
    }

    private String getExceptionMessage(Exception exception) {
        String string = "NO MESSAGE";
        if (exception instanceof SRMRuntimeException) {
            string = ((SRMRuntimeException)exception).getLocalizedMessage();
        } else if (exception.getMessage() == null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                string = "[" + stringWriter.toString() + "]";
            }
            catch (Exception exception2) {}
            string = "exception thrown " + exception.getClass().getName() + " " + string;
        } else {
            string = exception.getMessage();
        }
        return string;
    }

    private static SNMPAgent getSNMPAgent(String string) throws SQLException {
        SNMPAgent sNMPAgent;
        block5: {
            IpTarget ipTarget;
            DBConnection dBConnection;
            block3: {
                block4: {
                    dBConnection = ServiceUtils.getConnection();
                    try {
                        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                        hashtable.put(IpTarget.getColumnInfo((String)IP_ADDRESS_COLUMN), string);
                        ipTarget = IpTarget.retrieve((DBConnection)dBConnection, hashtable);
                        if (ipTarget != null) break block3;
                        Object var4_4 = null;
                        if (dBConnection == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var4_6 = null;
                            if (dBConnection == null) break block6;
                            dBConnection.commit();
                            dBConnection.close();
                        }
                        throw throwable;
                    }
                    dBConnection.commit();
                    dBConnection.close();
                }
                return null;
            }
            sNMPAgent = new SNMPAgent(ipTarget.getIpAddress(), ipTarget.getHostName(), ipTarget.getReadCommunityName(), ipTarget.getRwCommunityName(), ipTarget.getUserId(), ipTarget.getPassword());
            Object var4_5 = null;
            if (dBConnection == null) break block5;
            dBConnection.commit();
            dBConnection.close();
        }
        return sNMPAgent;
    }

    private void fillInHostInformation(OutOfBandFabricAgentInfo outOfBandFabricAgentInfo) {
        String string = outOfBandFabricAgentInfo.hostname;
        String string2 = outOfBandFabricAgentInfo.ipaddress;
        try {
            InetAddress inetAddress = InetAddress.getByName(outOfBandFabricAgentInfo.ipaddress);
            string = inetAddress.getHostName();
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.log("REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT unknown host exception add or modify will be attempted using host:" + string + " ipaddress " + string2);
        }
        outOfBandFabricAgentInfo.hostname = string;
        outOfBandFabricAgentInfo.ipaddress = string2;
    }

    public Response handle(Request request, Transceiver transceiver) {
        String string = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)12, null);
        OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = null;
        if (request.requestData instanceof OutOfBandFabricAgentInfo[] && ((OutOfBandFabricAgentInfo[])request.requestData).length > 0 && ((OutOfBandFabricAgentInfo[])request.requestData)[0].request_type == 3) {
            outOfBandFabricAgentInfo = ((OutOfBandFabricAgentInfo[])request.requestData)[0];
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
                Response response2 = response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz2.getName(), (String)"handle", (Object)response2);
                }
                return response2;
            }
            outOfBandFabricAgentInfo = (OutOfBandFabricAgentInfo)request.requestData;
        }
        string = request.userName;
        StringBuffer stringBuffer = new StringBuffer("Username = " + string);
        DeviceRequest deviceRequest = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        if (outOfBandFabricAgentInfo.request_type == 1) {
            try {
                SNMPAgent[] sNMPAgentArray;
                String string2 = outOfBandFabricAgentInfo.ipaddress;
                String string3 = outOfBandFabricAgentInfo.hostname;
                String string4 = string2;
                if (outOfBandFabricAgentInfo.ipaddress == null || outOfBandFabricAgentInfo.ipaddress.equals("")) {
                    string2 = "";
                    try {
                        sNMPAgentArray = InetAddress.getByName(string3);
                        string3 = sNMPAgentArray.getHostName();
                        string4 = string2 = sNMPAgentArray.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        string4 = outOfBandFabricAgentInfo.hostname;
                    }
                }
                this.log(" REQUEST_GET_INFO getOutBandAgents address: " + string4 + " hostname " + string3 + " ipaddress: " + string2);
                sNMPAgentArray = FabricDbAccess.getOutbandAgents((String)string4);
                if (sNMPAgentArray == null) {
                    this.log(" REQUEST_GET_INFO getOutBandAgents address: " + string4 + " hostname " + string3 + " ipaddress: " + string2 + " returned null");
                } else if (sNMPAgentArray.length > 0) {
                    this.log(" REQUEST_GET_INFO getOutBandAgents address: " + string4 + " hostname " + string3 + " ipaddress: " + string2 + " snmpAgent.length=" + sNMPAgentArray.length);
                } else {
                    this.log(" REQUEST_GET_INFO getOutBandAgents address: " + string4 + " hostname " + string3 + " ipaddress: " + string2 + " 0 agents returned");
                }
                if (sNMPAgentArray != null && sNMPAgentArray.length > 0) {
                    outOfBandFabricAgentInfo.hostname = sNMPAgentArray[0].getDnsName();
                    outOfBandFabricAgentInfo.ipaddress = sNMPAgentArray[0].getIpAddress();
                    outOfBandFabricAgentInfo.communityname = sNMPAgentArray[0].getCommunityName();
                    outOfBandFabricAgentInfo.communityname_rw = sNMPAgentArray[0].getRWCommunityName();
                    outOfBandFabricAgentInfo.username = sNMPAgentArray[0].getUserName();
                    outOfBandFabricAgentInfo.password = sNMPAgentArray[0].getPassword();
                    outOfBandFabricAgentInfo.status = 3;
                    if (sNMPAgentArray[0].getEnabled() == 1) {
                        outOfBandFabricAgentInfo.status = 2;
                    }
                    response.status = 0;
                    response.responseData = request.requestData;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
                    }
                    return response;
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"handle", (String)"database helper did not return an agent");
                }
                String string5 = "";
                string5 = sNMPAgentArray == null ? "snmpAgent is null" : "snmpAgent array length is " + sNMPAgentArray.length;
                this.setResponseError(response, "no agent returned", "no agent returned for agent [" + string4 + "] " + string5);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)exception);
                }
                this.setResponseError(response, "REQUEST_GET_INFO UNDECLARED EXCEPTION THROWN " + exception.getMessage(), this.getExceptionMessage(exception));
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
        }
        if (outOfBandFabricAgentInfo.request_type == 6) {
            try {
                this.log(" REQUEST_GET_ALL_INFO getOutBandAgents ");
                SNMPAgent[] sNMPAgentArray = FabricDbAccess.getOutbandAgents(null);
                if (sNMPAgentArray == null) {
                    this.log(" REQUEST_GET_ALL_INFO getOutBandAgents returned null");
                } else if (sNMPAgentArray.length > 0) {
                    this.log(" REQUEST_GET_ALL_INFO getOutBandAgents snmpAgent.length=" + sNMPAgentArray.length);
                } else {
                    this.log(" REQUEST_GET_ALL_INFO getOutBandAgents 0 agents returned");
                }
                if (sNMPAgentArray != null && sNMPAgentArray.length >= 0) {
                    OutOfBandFabricAgentInfo[] outOfBandFabricAgentInfoArray = new OutOfBandFabricAgentInfo[sNMPAgentArray.length];
                    int n = 0;
                    while (n < sNMPAgentArray.length) {
                        outOfBandFabricAgentInfoArray[n] = new OutOfBandFabricAgentInfo();
                        outOfBandFabricAgentInfoArray[n].hostname = sNMPAgentArray[n].getDnsName();
                        outOfBandFabricAgentInfoArray[n].ipaddress = sNMPAgentArray[n].getIpAddress();
                        outOfBandFabricAgentInfoArray[n].communityname = sNMPAgentArray[n].getCommunityName();
                        outOfBandFabricAgentInfoArray[n].communityname_rw = sNMPAgentArray[n].getRWCommunityName();
                        outOfBandFabricAgentInfoArray[n].username = sNMPAgentArray[n].getUserName();
                        outOfBandFabricAgentInfoArray[n].password = sNMPAgentArray[n].getPassword();
                        outOfBandFabricAgentInfoArray[n].status = 3;
                        if (sNMPAgentArray[n].getEnabled() == 1) {
                            outOfBandFabricAgentInfoArray[n].status = 2;
                        }
                        ++n;
                    }
                    response.status = 0;
                    response.responseData = outOfBandFabricAgentInfoArray;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
                    }
                    return response;
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"handle", (String)"database helper did not return an agent");
                }
                String string6 = "";
                string6 = sNMPAgentArray == null ? "snmpAgent is null" : "snmpAgent array length is " + sNMPAgentArray.length;
                this.setResponseError(response, "no agent returned", "no agent returned " + string6);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)exception);
                }
                this.setResponseError(response, "REQUEST_GET_INFO UNDECLARED EXCEPTION THROWN " + exception.getMessage(), this.getExceptionMessage(exception));
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
        }
        if (outOfBandFabricAgentInfo.request_type == 3) {
            Class<?> clazz;
            OutOfBandFabricAgentInfo[] outOfBandFabricAgentInfoArray = request.requestData instanceof OutOfBandFabricAgentInfo ? new OutOfBandFabricAgentInfo[]{outOfBandFabricAgentInfo} : (OutOfBandFabricAgentInfo[])request.requestData;
            String[] stringArray = new String[outOfBandFabricAgentInfoArray.length];
            int n = 0;
            while (n < outOfBandFabricAgentInfoArray.length) {
                String string7 = outOfBandFabricAgentInfoArray[n].ipaddress;
                String string8 = outOfBandFabricAgentInfoArray[n].hostname;
                String string9 = string7;
                if (outOfBandFabricAgentInfoArray[n].ipaddress == null || outOfBandFabricAgentInfoArray[n].ipaddress.equals("")) {
                    string7 = "";
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string8);
                        string8 = inetAddress.getHostName();
                        string9 = string7 = inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        string9 = outOfBandFabricAgentInfoArray[n].hostname;
                    }
                }
                stringArray[n] = string9;
                stringBuffer.append("\n Agents: Delete Out of Band Fabric Agent ");
                stringBuffer.append("\n host name = ");
                stringBuffer.append(string8);
                stringBuffer.append("\n IP address = ");
                stringBuffer.append(string7);
                stringBuffer.append("\n");
                ++n;
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IFabricManagerService iFabricManagerService = (IFabricManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            if (iFabricManagerService == null) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT Bind to IFabricManagerService on device server failed host: " + deviceRequest.deviceServerHost + " port: " + deviceRequest.deviceServerPort + " ", null);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            if (TraceLogger.enableAudit) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.auditMessage((String)clazz4.getName(), (String)"handle()-if REQUEST_REMOVE_AGENT", (String)String.valueOf(stringBuffer));
            }
            try {
                iFabricManagerService.deleteSNMPAgents(stringArray);
                response.status = 0;
                response.responseData = request.requestData;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz5.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (InvalidParameterException invalidParameterException) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT INVALID PARAMETER EXCEPTION " + invalidParameterException.getMessage(), this.getExceptionMessage((Exception)((Object)invalidParameterException)));
            }
            catch (MissingParameterException missingParameterException) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT MISSING PARAMETER EXCEPTION" + missingParameterException.getMessage(), this.getExceptionMessage((Exception)((Object)missingParameterException)));
            }
            catch (SRMException sRMException) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT TPC EXCEPTION " + sRMException.getMessage(), this.getExceptionMessage((Exception)((Object)sRMException)));
            }
            catch (Exception exception) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT UNDECLARED EXCEPTION THROWN " + exception.getMessage(), this.getExceptionMessage(exception));
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz6;
                try {
                    clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz6.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        if (outOfBandFabricAgentInfo.request_type == 2 || outOfBandFabricAgentInfo.request_type == 5) {
            Class<?> clazz;
            InetAddress inetAddress;
            String string10 = outOfBandFabricAgentInfo.hostname;
            String string11 = outOfBandFabricAgentInfo.ipaddress;
            try {
                inetAddress = InetAddress.getByName(outOfBandFabricAgentInfo.ipaddress);
                string10 = inetAddress.getHostName();
                string11 = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                StringTokenizer stringTokenizer = new StringTokenizer(unknownHostException.getLocalizedMessage(), ":");
                String string12 = MessageLog.getMessageNoID((String)"GEN0039E", (Object)stringTokenizer.nextToken().trim());
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT UNKNOWN HOST EXCEPTION THROWN " + unknownHostException.getMessage(), string12);
                return response;
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            inetAddress = (IFabricManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            if (inetAddress == null) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT Bind to IFabricManagerService on device server failed host: " + deviceRequest.deviceServerHost + " port: " + deviceRequest.deviceServerPort + " ", null);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz7;
                    try {
                        clazz7 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz7.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            int n = 1;
            SNMPAgent sNMPAgent = new SNMPAgent(string11, string10, outOfBandFabricAgentInfo.communityname, outOfBandFabricAgentInfo.communityname_rw, outOfBandFabricAgentInfo.username, outOfBandFabricAgentInfo.password);
            SNMPAgent[] sNMPAgentArray = new SNMPAgent[]{sNMPAgent};
            try {
                if (outOfBandFabricAgentInfo.username != null || outOfBandFabricAgentInfo.password != null) {
                    n = 2;
                    this.log("REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT testBrocadeAgentUserPassword host: " + sNMPAgentArray[0].getDnsName() + " ip: " + sNMPAgentArray[0].getIpAddress() + " community: " + sNMPAgentArray[0].getCommunityName() + " community_rw: " + sNMPAgentArray[0].getRWCommunityName() + " username:" + sNMPAgentArray[0].getUserName() + " password: " + sNMPAgentArray[0].getPassword());
                    this.setResponseError(response, "REQUEST_ADD/MODIFY no data (null) returned from testBrocadeAgentUserPassword", null);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz8;
                        try {
                            clazz8 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz8.getName(), (String)"handle", (Object)response);
                    }
                    return response;
                }
                sNMPAgentArray[0].setPassword("");
                sNMPAgentArray[0].setUserName("");
                if (outOfBandFabricAgentInfo.request_type == 5) {
                    n = 3;
                    stringBuffer.append("\n Agents: Modify Out of Band Fabric Agent ");
                    this.log("REQUEST_MODIFY_AGENT calling modifySNMPAgents host: " + sNMPAgentArray[0].getDnsName() + " ip: " + sNMPAgentArray[0].getIpAddress() + " community: " + sNMPAgentArray[0].getCommunityName() + " community_rw: " + sNMPAgentArray[0].getRWCommunityName() + " username:" + sNMPAgentArray[0].getUserName());
                    inetAddress.modifySNMPAgents(sNMPAgentArray);
                    this.log("REQUEST_MODIFY_AGENT finished calling modifySNMPAgents host: " + sNMPAgentArray[0].getDnsName() + " ip: " + sNMPAgentArray[0].getIpAddress() + " community: " + sNMPAgentArray[0].getCommunityName() + " community_rw: " + sNMPAgentArray[0].getRWCommunityName() + " username:" + sNMPAgentArray[0].getUserName());
                } else {
                    n = 4;
                    stringBuffer.append("\n Agents: Add Out of Band Fabric Agent ");
                    this.log("REQUEST_ADD_AGENT addSNMPAgents host: " + sNMPAgentArray[0].getDnsName() + " ip: " + sNMPAgentArray[0].getIpAddress() + " community: " + sNMPAgentArray[0].getCommunityName() + " community_rw: " + sNMPAgentArray[0].getRWCommunityName() + " username:" + sNMPAgentArray[0].getUserName());
                    inetAddress.addSNMPAgents(sNMPAgentArray);
                    this.log("REQUEST_ADD_AGENT addSNMPAgents  Returned host: " + sNMPAgentArray[0].getDnsName() + " ip: " + sNMPAgentArray[0].getIpAddress() + " community: " + sNMPAgentArray[0].getCommunityName() + " community_rw: " + sNMPAgentArray[0].getRWCommunityName() + " username:" + sNMPAgentArray[0].getUserName());
                }
                stringBuffer.append("\n host name = ");
                stringBuffer.append(string10);
                stringBuffer.append("\n IP address = ");
                stringBuffer.append(string11);
                stringBuffer.append("\n");
                if (TraceLogger.enableAudit) {
                    Class<?> clazz9;
                    try {
                        clazz9 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.auditMessage((String)clazz9.getName(), (String)"handle()-if REQUEST_ADD/MODIFY_AGENT", (String)String.valueOf(stringBuffer));
                }
                outOfBandFabricAgentInfo.hostname = string10;
                outOfBandFabricAgentInfo.ipaddress = string11;
                int n2 = GUIDeviceAccessor.getIpTargetStatus(sNMPAgentArray[0]);
                outOfBandFabricAgentInfo.message_status = 3;
                if (n2 == 1) {
                    this.log("REQUEST_ADD_AGENT status of agent " + sNMPAgentArray[0].getIpAddress() + " " + sNMPAgentArray[0].getDnsName() + " agent is responding");
                    outOfBandFabricAgentInfo.message_status = 2;
                } else {
                    this.log("REQUEST_ADD_AGENT status of agent " + sNMPAgentArray[0].getIpAddress() + " " + sNMPAgentArray[0].getDnsName() + " is not responding");
                }
                outOfBandFabricAgentInfo.status = 0;
                response.status = 0;
                response.responseData = request.requestData;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz10;
                    try {
                        clazz10 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz10.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            catch (InvalidParameterException invalidParameterException) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT INVALID PARAMETER EXCEPTION " + invalidParameterException.getMessage(), this.getExceptionMessage((Exception)((Object)invalidParameterException)));
            }
            catch (MissingParameterException missingParameterException) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT MISSING PARAMETER EXCEPTION " + missingParameterException.getMessage() + "(" + n + ")", String.valueOf(this.getExceptionMessage((Exception)((Object)missingParameterException))) + " (" + n + ")");
            }
            catch (SRMException sRMException) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT TPC EXCEPTION " + sRMException.getMessage() + "(" + n + ")", String.valueOf(this.getExceptionMessage((Exception)((Object)sRMException))) + " (" + n + ")");
            }
            catch (Exception exception) {
                this.setResponseError(response, "REQUEST_ADD_AGENT/REQUEST_MODIFY_AGENT UNDECLARED EXCEPTION THROWN " + exception.getMessage() + "(" + n + ")", String.valueOf(this.getExceptionMessage(exception)) + " (" + n + ")");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz11;
                try {
                    clazz11 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz11.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        if (outOfBandFabricAgentInfo.request_type == 4) {
            block146: {
                InetAddress inetAddress;
                String string13 = null;
                String string14 = null;
                String string15 = "";
                String string16 = "";
                if (outOfBandFabricAgentInfo.ipaddress != null && !outOfBandFabricAgentInfo.ipaddress.equals("")) {
                    string16 = outOfBandFabricAgentInfo.ipaddress;
                    try {
                        inetAddress = InetAddress.getByName(outOfBandFabricAgentInfo.ipaddress);
                        string13 = inetAddress.getHostName();
                        string14 = inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {}
                } else if (outOfBandFabricAgentInfo.hostname != null && !outOfBandFabricAgentInfo.hostname.equals("")) {
                    string15 = outOfBandFabricAgentInfo.hostname;
                    try {
                        inetAddress = InetAddress.getByName(outOfBandFabricAgentInfo.hostname);
                        string13 = inetAddress.getHostName();
                        string14 = inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
                if (string13 != null && string14 != null) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    inetAddress = (IFabricManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
                    if (inetAddress == null) {
                        this.setResponseError(response, "REQUEST_CHECK Bind to IFabricManagerService on device server failed host: " + deviceRequest.deviceServerHost + " port: " + deviceRequest.deviceServerPort + " ", null);
                        return response;
                    }
                    SNMPAgent sNMPAgent = new SNMPAgent(string14, string13, outOfBandFabricAgentInfo.communityname, outOfBandFabricAgentInfo.communityname_rw, outOfBandFabricAgentInfo.username, outOfBandFabricAgentInfo.password);
                    SNMPAgent[] sNMPAgentArray = new SNMPAgent[]{sNMPAgent};
                    try {
                        int[] nArray = inetAddress.testSNMPAgentConnection(sNMPAgentArray);
                        if (nArray != null && nArray.length > 0) {
                            outOfBandFabricAgentInfo.status = 3;
                            if (nArray[0] == 0) {
                                outOfBandFabricAgentInfo.status = 2;
                            }
                            response.status = 0;
                            response.responseData = request.requestData;
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz12;
                                try {
                                    clazz12 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exit((String)clazz12.getName(), (String)"handle", (Object)response);
                            }
                            return response;
                        }
                        if (nArray == null) {
                            this.setResponseError(response, "REQUEST_CHECK no data (null) returned from testSNMPAgentConnection", null);
                            break block146;
                        }
                        this.setResponseError(response, "REQUEST_CHECK not not enough data returned from testSNMPAgentConnection expected " + sNMPAgentArray.length + " items to be returned but only " + nArray.length + " items were returned. ", null);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        this.setResponseError(response, "REQUEST_CHECK INVALID PARAMETER EXCEPTION " + invalidParameterException.getMessage(), this.getExceptionMessage((Exception)((Object)invalidParameterException)));
                    }
                    catch (MissingParameterException missingParameterException) {
                        this.setResponseError(response, "REQUEST_CHECK MISSING PARAMETER EXCEPTION " + missingParameterException.getMessage(), this.getExceptionMessage((Exception)((Object)missingParameterException)));
                    }
                    catch (SRMException sRMException) {
                        this.setResponseError(response, "REQUEST_CHECK TPC EXCEPTION " + sRMException.getMessage(), this.getExceptionMessage((Exception)((Object)sRMException)));
                    }
                    catch (Exception exception) {
                        this.setResponseError(response, "REQUEST_CHECK UNDECLARED EXCEPTION THROWN " + exception.getMessage(), this.getExceptionMessage(exception));
                        exception.printStackTrace();
                    }
                } else {
                    this.setResponseError(response, "REQUEST_CHECK failed to determine hostname and ip address for " + string15 + " " + string16, null);
                }
            }
            return response;
        }
        outOfBandFabricAgentInfo.status = 1;
        response.responseData = outOfBandFabricAgentInfo;
        Response response3 = response;
        this.setResponseError(response, "OutOfBandFabricAgentHandler unknown request type " + outOfBandFabricAgentInfo.request_type, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response3);
        }
        return response;
    }
}

