/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.fabric;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.fabric.interfaces.IFabricInternalService;
import org.eclipse.aperi.fabric.interfaces.InvalidTokenException;
import org.eclipse.aperi.fabric.interfaces.ResourceLockedException;
import org.eclipse.aperi.fabric.interfaces.ResourceNotAvailableException;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public class ZoneRequestHandler
implements RequestHandler,
ThrowAway {
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        String string;
        block40: {
            string = "handle";
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)string, (String)"request, transceiver");
            }
            HashMap hashMap = (HashMap)request.requestData;
            response = Response.getResponse((short)0, null);
            try {
                if (hashMap.containsKey(GuiZoneConstants.GET_SANS)) {
                    HashMap<String, HashMap[]> hashMap2 = new HashMap<String, HashMap[]>();
                    hashMap2.put(GuiZoneConstants.GET_SANS, this.getSans());
                    response.responseData = hashMap2;
                } else if (hashMap.containsKey(GuiZoneConstants.POPULATE_ACTIVEZONEDEF)) {
                    String string2 = (String)hashMap.get(GuiZoneConstants.POPULATE_ACTIVEZONEDEF);
                    HashMap<String, ZoneDefinition> hashMap3 = new HashMap<String, ZoneDefinition>();
                    hashMap3.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, this.getZoneDefinition(string2, true));
                    response.responseData = hashMap3;
                } else if (hashMap.containsKey(GuiZoneConstants.POPULATE_ZONEDEF)) {
                    String string3 = (String)hashMap.get(GuiZoneConstants.POPULATE_ZONEDEF);
                    HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
                    ZoneDefinition zoneDefinition = this.getZoneDefinition(string3, false);
                    hashMap4.put(GuiZoneConstants.POPULATE_ZONEDEF, zoneDefinition);
                    hashMap4.put(GuiZoneConstants.NONSTD_ZONES, this.getNonStdZones(string3, zoneDefinition));
                    response.responseData = hashMap4;
                } else if (hashMap.containsKey(GuiZoneConstants.POPULATE_FABRICZONEDEF)) {
                    String string4 = (String)hashMap.get(GuiZoneConstants.POPULATE_FABRICZONEDEF);
                    String string5 = (String)hashMap.get(GuiZoneConstants.RESERVE_BY_USER);
                    Integer n = (Integer)hashMap.get(GuiZoneConstants.FLAG);
                    Token token = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                    response.responseData = this.getFabricZoneDefinition(string4, n, string5, token);
                } else if (hashMap.containsKey("pingZoneAgent")) {
                    String string6 = (String)hashMap.get("pingZoneAgent");
                    HashMap hashMap5 = this.ping(string6);
                    ZoneCapabilities zoneCapabilities = new ZoneCapabilities();
                    zoneCapabilities = (ZoneCapabilities)hashMap5.get("pingZoneAgent");
                    if (zoneCapabilities != null && zoneCapabilities.getAgentName() == null) {
                        zoneCapabilities.setAgentName(string6);
                        hashMap5.put("pingZoneAgent", zoneCapabilities);
                    }
                    response.responseData = hashMap5;
                } else if (hashMap.containsKey(GuiZoneConstants.ZM_SWITCHES)) {
                    String string7 = (String)hashMap.get(GuiZoneConstants.ZM_SWITCHES);
                    HashMap<String, HashMap[]> hashMap6 = new HashMap<String, HashMap[]>();
                    hashMap6.put(GuiZoneConstants.ZM_SWITCHES, this.getSwitchMembers(string7));
                    response.responseData = hashMap6;
                } else if (hashMap.containsKey(GuiZoneConstants.ZM_DEVICE)) {
                    String string8 = (String)hashMap.get(GuiZoneConstants.ZM_DEVICE);
                    HashMap<String, HashMap[]> hashMap7 = new HashMap<String, HashMap[]>();
                    hashMap7.put(GuiZoneConstants.ZM_DEVICE, this.getDeviceMembers(string8));
                    response.responseData = hashMap7;
                } else if (hashMap.containsKey(GuiZoneConstants.ZM_DEVICESP)) {
                    String string9 = (String)hashMap.get(GuiZoneConstants.ZM_DEVICESP);
                    HashMap<String, HashMap[]> hashMap8 = new HashMap<String, HashMap[]>();
                    hashMap8.put(GuiZoneConstants.ZM_DEVICESP, this.getDeviceSPMembers(string9));
                    response.responseData = hashMap8;
                } else if (hashMap.containsKey(GuiZoneConstants.ZM_NODE)) {
                    String string10 = (String)hashMap.get(GuiZoneConstants.ZM_NODE);
                    HashMap<String, HashMap[]> hashMap9 = new HashMap<String, HashMap[]>();
                    hashMap9.put(GuiZoneConstants.ZM_NODE, this.getNodeMembers(string10));
                    response.responseData = hashMap9;
                } else if (hashMap.containsKey(GuiZoneConstants.ZM_PORT)) {
                    String string11 = (String)hashMap.get(GuiZoneConstants.ZM_PORT);
                    HashMap<String, HashMap[]> hashMap10 = new HashMap<String, HashMap[]>();
                    hashMap10.put(GuiZoneConstants.ZM_PORT, this.getPortMembers(string11));
                    response.responseData = hashMap10;
                } else if (hashMap.containsKey(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS)) {
                    ZoneDefinition zoneDefinition = (ZoneDefinition)hashMap.get(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS);
                    String string12 = (String)hashMap.get(GuiZoneConstants.SAN_WWN);
                    HashMap<String, String> hashMap11 = new HashMap<String, String>();
                    this.saveZoneDescriptions(zoneDefinition, string12);
                    hashMap11.put(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS, "");
                    response.responseData = hashMap11;
                } else if (hashMap.containsKey(GuiZoneConstants.RESERVE_TOKEN)) {
                    String string13 = (String)hashMap.get(GuiZoneConstants.RESERVE_TOKEN);
                    String string14 = (String)hashMap.get(GuiZoneConstants.RESERVE_BY_USER);
                    response.responseData = this.reserveToken(string13, string14);
                } else if (hashMap.containsKey(GuiZoneConstants.RELEASE_TOKEN)) {
                    Token token = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                    String string15 = (String)hashMap.get(GuiZoneConstants.RELEASE_TOKEN);
                    response.responseData = this.releaseToken(string15, token);
                } else if (hashMap.containsKey(GuiZoneConstants.ROLLBACK_TOKEN)) {
                    Token token = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                    String string16 = (String)hashMap.get(GuiZoneConstants.ROLLBACK_TOKEN);
                    response.responseData = this.rollbackToken(string16, token);
                } else if (hashMap.containsKey("refreshtoken")) {
                    Token token = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                    response.responseData = this.refreshToken(token);
                }
            }
            catch (Exception exception) {
                Class<?> clazz;
                Server.setResponseError(response, exception);
                if (!TraceLogger.enableTrace) break block40;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string, (Throwable)exception);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string, (Object)response);
        }
        return response;
    }

    private HashMap[] getDeviceMembers(String string) {
        String string2 = "getDeviceMembers";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
        }
        HashMap[] hashMapArray = null;
        try {
            return FabricDbAccess.getPeripheralEntitiesForSan((String)string);
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)hashMapArray);
            }
            return hashMapArray;
        }
    }

    private HashMap[] getDeviceSPMembers(String string) {
        String string2 = "getDeviceSPMembers";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
        }
        HashMap[] hashMapArray = null;
        try {
            return FabricDbAccess.getComputersForSan((String)string);
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)hashMapArray);
            }
            return hashMapArray;
        }
    }

    private HashMap[] getNodeMembers(String string) {
        String string2 = "getNodeMembers";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
        }
        HashMap[] hashMapArray = null;
        try {
            return FabricDbAccess.getDeadEndNodesForSan((String)string);
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)hashMapArray);
            }
            return hashMapArray;
        }
    }

    private HashMap[] getPortMembers(String string) {
        String string2 = "getPortMembers";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
        }
        HashMap[] hashMapArray = null;
        try {
            return FabricDbAccess.getDeadEndPortsForSan((String)string);
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)hashMapArray);
            }
            return hashMapArray;
        }
    }

    private HashMap[] getSwitchMembers(String string) {
        String string2 = "getSwitchMembers";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
        }
        HashMap[] hashMapArray = null;
        try {
            return FabricDbAccess.getSwitchConnections((String)string);
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)hashMapArray);
            }
            return hashMapArray;
        }
    }

    private HashMap refreshToken(Token token) {
        HashMap<String, Integer> hashMap;
        String string;
        block16: {
            Class<?> clazz;
            string = "refreshToken";
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)string, (String)String.valueOf(token));
            }
            hashMap = new HashMap<String, Integer>();
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.interfaces.IFabricInternalService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IFabricInternalService iFabricInternalService = (IFabricInternalService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            int n = 0;
            if (iFabricInternalService != null) {
                try {
                    n = iFabricInternalService.updateTokenTimestamp(token);
                    if (n == 1) {
                        hashMap.put("refresh_token_status", new Integer(1));
                        break block16;
                    }
                    hashMap.put("refresh_token_status", new Integer(2));
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz3.getName(), (String)string, (Throwable)exception);
                    }
                    hashMap.put("refresh_token_status", new Integer(2));
                }
            } else {
                hashMap.put("refresh_token_status", new Integer(2));
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string, hashMap);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap reserveToken(String string, String string2) {
        HashMap<String, Object> hashMap;
        Integer n;
        String string3;
        block28: {
            Class<?> clazz;
            string3 = "reserveToken";
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)string3, (String)string);
            }
            n = new Integer(2);
            hashMap = new HashMap<String, Object>();
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.interfaces.IFabricInternalService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IFabricInternalService iFabricInternalService = (IFabricInternalService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            Token token = null;
            if (iFabricInternalService != null) {
                try {
                    token = iFabricInternalService.reserve(string, "ZoneGUI:" + string, string2);
                    hashMap.put(GuiZoneConstants.TOKEN, token);
                }
                catch (ResourceLockedException resourceLockedException) {
                    Class<?> clazz3;
                    n = new Integer(3);
                    this.updateResultWithLockInfo(resourceLockedException, hashMap);
                    if (!TraceLogger.enableTrace) break block28;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)string3, (Throwable)resourceLockedException);
                }
                catch (ResourceNotAvailableException resourceNotAvailableException) {
                    Class<?> clazz4;
                    n = new Integer(5);
                    if (!TraceLogger.enableTrace) break block28;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz4.getName(), (String)string3, (Throwable)resourceNotAvailableException);
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz5.getName(), (String)string3, (Throwable)exception);
                    }
                    try {
                        block29: {
                            try {
                                n = new Integer(1);
                            }
                            catch (Exception exception2) {
                                Class<?> clazz6;
                                if (!TraceLogger.enableTrace) break block29;
                                try {
                                    clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz6.getName(), (String)string3, (Throwable)exception2);
                            }
                        }
                        Object var11_15 = null;
                        if (token == null) break block28;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        if (token != null) {
                            iFabricInternalService.release(token);
                        }
                        throw throwable;
                    }
                    iFabricInternalService.release(token);
                }
            }
        }
        hashMap.put(GuiZoneConstants.SAVE_RESPONSE, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string3, hashMap);
        }
        return hashMap;
    }

    private HashMap releaseToken(String string, Token token) {
        HashMap<String, Integer> hashMap;
        String string2;
        block18: {
            Class<?> clazz;
            string2 = "releaseToken";
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)string2, (String)string);
            }
            hashMap = new HashMap<String, Integer>();
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.interfaces.IFabricInternalService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IFabricInternalService iFabricInternalService = (IFabricInternalService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            if (iFabricInternalService != null) {
                try {
                    iFabricInternalService.release(token);
                    hashMap.put("pingError", new Integer(2));
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz3.getName(), (String)string2, (Throwable)exception);
                    }
                    try {
                        hashMap.put("pingError", new Integer(1));
                    }
                    catch (Exception exception2) {
                        Class<?> clazz4;
                        if (!TraceLogger.enableTrace) break block18;
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz4.getName(), (String)string2, (Throwable)exception2);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string2, hashMap);
        }
        return hashMap;
    }

    private HashMap rollbackToken(String string, Token token) {
        HashMap<String, Integer> hashMap;
        String string2;
        block18: {
            Class<?> clazz;
            string2 = "rollbackToken";
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)string2, (String)string);
            }
            hashMap = new HashMap<String, Integer>();
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.interfaces.IFabricInternalService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IFabricInternalService iFabricInternalService = (IFabricInternalService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            if (iFabricInternalService != null) {
                try {
                    iFabricInternalService.rollbackTransaction(string);
                    hashMap.put("pingError", new Integer(2));
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz3.getName(), (String)string2, (Throwable)exception);
                    }
                    try {
                        hashMap.put("pingError", new Integer(1));
                    }
                    catch (Exception exception2) {
                        Class<?> clazz4;
                        if (!TraceLogger.enableTrace) break block18;
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz4.getName(), (String)string2, (Throwable)exception2);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string2, hashMap);
        }
        return hashMap;
    }

    private HashMap ping(String string) {
        ZoneCapabilities zoneCapabilities;
        HashMap<String, Integer> hashMap;
        block11: {
            String string2 = "ping";
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
            }
            hashMap = new HashMap<String, Integer>();
            zoneCapabilities = null;
            try {
                Class<?> clazz;
                zoneCapabilities = FabricDbAccess.getZoneControlCapabilities((String)string);
                if (zoneCapabilities != null) {
                    hashMap.put("pingError", new Integer(2));
                } else {
                    hashMap.put("pingError", new Integer(4));
                }
                if (!TraceLogger.enableTrace) break block11;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)string2, hashMap);
            }
            catch (Exception exception) {
                Class<?> clazz;
                hashMap.put("pingError", new Integer(4));
                if (!TraceLogger.enableTrace) break block11;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
        }
        hashMap.put("pingZoneAgent", (Integer)zoneCapabilities);
        return hashMap;
    }

    private void saveZoneDescriptions(ZoneDefinition zoneDefinition, String string) {
        String string2 = "saveZoneDescriptions";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string2, (String)"zoneDefintion");
        }
        this.saveZoneDescriptions(zoneDefinition.getZones(), string);
        this.saveZoneSetDescriptions(zoneDefinition.getZoneSets(), string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)"");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveZoneDescriptions(Zone[] var1_1, String var2_2) {
        block23: {
            var3_3 = "saveZoneDescriptions";
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)var3_3, (String)"zones");
            }
            if (var1_1 == null) break block23;
            var4_4 = null;
            try {
                block21: {
                    try {
                        var5_5 = DBConnPoolDataSource.getInstance();
                        var4_4 = (DBConnection)var5_5.getPooledConnection();
                        var6_7 = 0;
                        while (var6_7 < var1_1.length) {
                            var7_8 = var1_1[var6_7].getName();
                            if (var7_8 != null && FabricDbAccess.verifyZone((String)var2_2, (String)var7_8)) {
                                FabricDbAccess.saveZoneDescription((DBConnection)var4_4, (String)var1_1[var6_7].getDescription(), (String)var7_8);
                            }
                            ++var6_7;
                        }
                    }
                    catch (Exception var5_6) {
                        if (!TraceLogger.enableTrace) break block21;
                        try {
                            v2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                        TraceLogger.exception((String)v2.getName(), (String)var3_3, (Throwable)var5_6);
                    }
                }
                var8_11 = null;
            }
            catch (Throwable var9_9) {
                var8_10 = null;
                try {
                    if (var4_4 == null) throw var9_9;
                    var4_4.close();
                    throw var9_9;
                }
                catch (SQLException var10_12) {
                    if (TraceLogger.enableTrace == false) throw var9_9;
                    try {
                        v4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                    TraceLogger.exception((String)v4.getName(), (String)var3_3, (Throwable)var10_12);
                }
                throw var9_9;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 169->182)] { 
lbl54:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            break block23;
lbl57:
            // 1 sources

            catch (SQLException var10_13) {
                if (!TraceLogger.enableTrace) break block23;
                try {}
                catch (ClassNotFoundException v6) {
                    throw new NoClassDefFoundError(v6.getMessage());
                }
                TraceLogger.exception((String)Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler").getName(), (String)var3_3, (Throwable)var10_13);
            }
        }
        if (TraceLogger.enableTrace == false) return;
        try {
            v7 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
        }
        catch (ClassNotFoundException v8) {
            throw new NoClassDefFoundError(v8.getMessage());
        }
        TraceLogger.exit((String)v7.getName(), (String)var3_3, (Object)"");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveZoneSetDescriptions(ZoneSet[] var1_1, String var2_2) {
        block23: {
            var3_3 = "saveZoneSetDescriptions";
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)var3_3, (String)"zoneSets");
            }
            if (var1_1 == null) break block23;
            var4_4 = null;
            try {
                block21: {
                    try {
                        var5_5 = DBConnPoolDataSource.getInstance();
                        var4_4 = (DBConnection)var5_5.getPooledConnection();
                        var6_7 = 0;
                        while (var6_7 < var1_1.length) {
                            var7_8 = var1_1[var6_7].getName();
                            if (var7_8 != null && FabricDbAccess.verifyZoneSet((String)var2_2, (String)var7_8)) {
                                FabricDbAccess.saveZoneSetDescription((DBConnection)var4_4, (String)var1_1[var6_7].getDescription(), (String)var7_8);
                            }
                            ++var6_7;
                        }
                    }
                    catch (Exception var5_6) {
                        if (!TraceLogger.enableTrace) break block21;
                        try {
                            v2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                        TraceLogger.exception((String)v2.getName(), (String)var3_3, (Throwable)var5_6);
                    }
                }
                var8_11 = null;
            }
            catch (Throwable var9_9) {
                var8_10 = null;
                try {
                    if (var4_4 == null) throw var9_9;
                    var4_4.close();
                    throw var9_9;
                }
                catch (SQLException var10_12) {
                    if (TraceLogger.enableTrace == false) throw var9_9;
                    try {
                        v4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                    TraceLogger.exception((String)v4.getName(), (String)var3_3, (Throwable)var10_12);
                }
                throw var9_9;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 169->182)] { 
lbl54:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            break block23;
lbl57:
            // 1 sources

            catch (SQLException var10_13) {
                if (!TraceLogger.enableTrace) break block23;
                try {}
                catch (ClassNotFoundException v6) {
                    throw new NoClassDefFoundError(v6.getMessage());
                }
                TraceLogger.exception((String)Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler").getName(), (String)var3_3, (Throwable)var10_13);
            }
        }
        if (TraceLogger.enableTrace == false) return;
        try {
            v7 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
        }
        catch (ClassNotFoundException v8) {
            throw new NoClassDefFoundError(v8.getMessage());
        }
        TraceLogger.exit((String)v7.getName(), (String)var3_3, (Object)"");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap getFabricZoneDefinition(String string, Integer n, String string2, Token token) {
        HashMap<String, Object> hashMap;
        ZoneDefinition zoneDefinition;
        String string3;
        block41: {
            Class<?> clazz;
            string3 = "getFabricZoneDefinition";
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)string3, (String)string);
            }
            zoneDefinition = null;
            hashMap = new HashMap<String, Object>();
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.interfaces.IFabricInternalService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IFabricInternalService iFabricInternalService = (IFabricInternalService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            if (iFabricInternalService != null) {
                Token token2 = null;
                try {
                    try {
                        token2 = token == null ? iFabricInternalService.reserve(string, "ZoneGUI:" + string, string2) : token;
                        AsyncResult asyncResult = iFabricInternalService.readCurrentZoneDefinition(token2, string);
                        iFabricInternalService.waitForJobToComplete(asyncResult.getJobId());
                        Object[] objectArray = asyncResult.getResults();
                        if (objectArray.length != 0) {
                            zoneDefinition = (ZoneDefinition)objectArray[0];
                        }
                        if (token == null) {
                            iFabricInternalService.release(token2);
                            token2 = null;
                        }
                        hashMap.put(GuiZoneConstants.POPULATE_FABRICZONEDEF, zoneDefinition);
                    }
                    catch (ResourceLockedException resourceLockedException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz3.getName(), (String)string3, (Throwable)resourceLockedException);
                        }
                        hashMap.put("pingError", new Integer(3));
                        this.updateResultWithLockInfo(resourceLockedException, hashMap);
                    }
                    catch (ResourceNotAvailableException resourceNotAvailableException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz4;
                            try {
                                clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz4.getName(), (String)string3, (Throwable)resourceNotAvailableException);
                        }
                        hashMap.put("pingError", new Integer(5));
                    }
                    catch (InvalidTokenException invalidTokenException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz5;
                            try {
                                clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz5.getName(), (String)string3, (Throwable)invalidTokenException);
                        }
                        hashMap.put("pingError", new Integer(4));
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz6;
                            try {
                                clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz6.getName(), (String)string3, (Throwable)outOfMemoryError);
                        }
                        hashMap.put("pingError", new Integer(1));
                    }
                    catch (Exception exception) {
                        block40: {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz7;
                                try {
                                    clazz7 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz7.getName(), (String)string3, (Throwable)exception);
                            }
                            try {
                                iFabricInternalService.rollbackTransaction(string);
                            }
                            catch (Exception exception2) {
                                Class<?> clazz8;
                                if (!TraceLogger.enableTrace) break block40;
                                try {
                                    clazz8 = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz8.getName(), (String)string3, (Throwable)exception2);
                            }
                        }
                        hashMap.put("pingError", new Integer(1));
                    }
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    if (token == null && token != null) {
                        iFabricInternalService.release(token);
                    }
                    throw throwable;
                }
                {
                    Object var13_21 = null;
                    if (token != null || token == null) break block41;
                }
                iFabricInternalService.release(token);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string3, zoneDefinition);
        }
        return hashMap;
    }

    private ZoneDefinition getZoneDefinition(String string, boolean bl) {
        ZoneDefinition zoneDefinition;
        String string2;
        block11: {
            string2 = "getZoneDefinition";
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
            }
            zoneDefinition = new ZoneDefinition();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("FABRIC_WWN", string);
            try {
                String[] stringArray = FabricDbAccess.getFabrics(hashMap);
                if (stringArray != null && stringArray.length > 0) {
                    zoneDefinition = FabricDbAccess.getZoneDefinition((String)stringArray[0], (boolean)bl);
                }
            }
            catch (Exception exception) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block11;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)zoneDefinition);
        }
        return zoneDefinition;
    }

    private String[] getNonStdZones(String string, ZoneDefinition zoneDefinition) {
        String[] stringArray;
        String string2;
        block10: {
            string2 = "populateZones";
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)string2, (String)string);
            }
            stringArray = null;
            try {
                stringArray = FabricDbAccess.getNonStandardZones((String)string, (boolean)false);
            }
            catch (Exception exception) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string2, (Throwable)exception);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string2, (Object)zoneDefinition);
        }
        return stringArray;
    }

    private HashMap[] getSans() {
        HashMap[] hashMapArray;
        String string;
        block10: {
            string = "getSans";
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)string, (String)"");
            }
            hashMapArray = null;
            try {
                hashMapArray = FabricDbAccess.getFabricsForZoning();
            }
            catch (Exception exception) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)string, (Throwable)exception);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string, (Object)hashMapArray);
        }
        return hashMapArray;
    }

    private HashMap getDebugSANs() {
        String string = "getDebugSans";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)string, (String)"");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < 10) {
            String string2 = "SAN Label " + n;
            String string3 = "SAN WWN " + n;
            hashMap.put(string3, string2);
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)string, hashMap);
        }
        return hashMap;
    }

    private HashMap updateResultWithLockInfo(ResourceLockedException resourceLockedException, HashMap hashMap) {
        String string = resourceLockedException.getUserName();
        long l = resourceLockedException.getLockMoment();
        if (string != null && !string.trim().equals("")) {
            hashMap.put(GuiZoneConstants.LOCKED_BY_USER, string);
        }
        hashMap.put(GuiZoneConstants.LOCKED_MOMENT, new Date(l));
        return hashMap;
    }
}

