/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.Serializable;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.ScheduleComplete;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleHandler
implements RequestHandler {
    ScheduleComplete completeRoutine;
    ScheduleRunning runningRoutine;

    public ScheduleHandler() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ScheduleHandler", (String)"");
        }
        this.completeRoutine = new ScheduleComplete();
        this.runningRoutine = SchCommon.runningRoutine;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ScheduleHandler");
        }
    }

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = new Response(0, null, 0);
        if (SchCommon.stopped) {
            response.status = (short)24;
            response.setException(new StorageException("SRV0024E", null));
        } else if (!transceiver.transmitResponse(request, response)) {
            response = null;
        } else {
            Class<?> clazz;
            response = new Response(0, null);
            request.requestData = (Serializable)transceiver.receiveData(request);
            try {
                clazz = Class.forName("org.eclipse.aperi.jobs.StartedJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
                MessageLog.logMessage((String)"JSS0022E");
            } else {
                StartedJob startedJob = (StartedJob)request.requestData;
                int n = startedJob.getRunNumber();
                SchRunNode schRunNode = this.runningRoutine.getRun(n);
                if (schRunNode == null) {
                    SchCommon.buildTask.addRestart(n);
                    schRunNode = this.runningRoutine.getRun(n);
                }
                if (schRunNode == null) {
                    MessageLog.logMessage((String)"JSS0021E", (Object)Integer.toString(n), (Object)Integer.toString(startedJob.getExitCode()));
                } else {
                    this.completeRoutine.process(schRunNode, startedJob);
                }
            }
        }
        Response response2 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response2);
        }
        return response2;
    }
}

