/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.aperi.server.util.snmp.Asn1Value;
import org.eclipse.aperi.server.util.snmp.TrapPdu;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class SnmpTransmitter {
    public static final String PUBLIC_COMMUNITY = "public";
    public static final int STANDARD_PORT = 162;
    public static final Asn1Value SNMP_VERSION_1 = new Asn1Value(0);
    private DatagramSocket socket;
    private DatagramPacket packet = null;
    private String community = "public";
    private InetAddress address = null;
    private int port = 162;

    public SnmpTransmitter(String string, int n, String string2) throws LocalizableException {
        this.community = string2;
        this.port = n;
        try {
            this.address = InetAddress.getByName(string);
            this.socket = new DatagramSocket();
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{string};
            throw new NestableException("GEN0115E", objectArray, (Exception)unknownHostException);
        }
        catch (SocketException socketException) {
            throw new NestableException("GEN0107E", null, (Exception)socketException);
        }
    }

    public void setPacket(TrapPdu trapPdu) throws LocalizableException {
        Asn1Value[] asn1ValueArray = new Asn1Value[]{SNMP_VERSION_1, new Asn1Value(this.community), trapPdu.encode()};
        this.setPacket(new Asn1Value(asn1ValueArray));
    }

    public void setPacket(Asn1Value asn1Value) throws LocalizableException {
        this.setPacket(asn1Value.encode());
    }

    private void setPacket(byte[] byArray) {
        this.packet = new DatagramPacket(byArray, byArray.length, this.address, this.port);
    }

    public void transmit() throws LocalizableException {
        try {
            this.socket.send(this.packet);
        }
        catch (IOException iOException) {
            throw new NestableException("GEN0108E", null, (Exception)iOException);
        }
    }

    public void transmit(TrapPdu trapPdu) throws LocalizableException {
        this.setPacket(trapPdu);
        this.transmit();
    }

    public void transmit(Asn1Value asn1Value) throws LocalizableException {
        this.setPacket(asn1Value);
        this.transmit();
    }

    public void close() {
        this.socket.close();
    }
}

