/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.server.util.snmp.Asn1Value;
import org.eclipse.aperi.server.util.snmp.VarBind;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class TrapPdu {
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int LINK_UP = 3;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;
    private int[] productOID;
    private InetAddress networkAddress;
    private int genericTrap;
    private int specificTrap;
    private long timeTicks;
    private Vector varBinds;

    public TrapPdu(int[] nArray, int n, int n2, long l, Vector vector) throws LocalizableException {
        try {
            this.networkAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new NestableException("GEN0106E", null, (Exception)unknownHostException);
        }
        this.productOID = nArray;
        this.genericTrap = n;
        this.specificTrap = n2;
        this.timeTicks = l / 10L;
        this.varBinds = new Vector();
        this.addVarBinds(vector);
    }

    public TrapPdu(int[] nArray, int n, long l, Vector vector) throws LocalizableException {
        this(nArray, 6, n, l, vector);
    }

    public TrapPdu(int[] nArray, int n, long l) throws LocalizableException {
        this(nArray, 6, n, l, null);
    }

    public void addVarBind(VarBind varBind) {
        if (varBind != null) {
            this.varBinds.addElement(varBind);
        }
    }

    public void addVarBinds(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.addVarBind((VarBind)objectArray[n]);
                ++n;
            }
        }
    }

    public void addVarBinds(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.addVarBind((VarBind)enumeration.nextElement());
            }
        }
    }

    public Asn1Value encode() {
        Asn1Value[] asn1ValueArray = new Asn1Value[this.varBinds.size()];
        int n = 0;
        while (n < asn1ValueArray.length) {
            asn1ValueArray[n] = ((VarBind)this.varBinds.elementAt(n)).encode();
            ++n;
        }
        Asn1Value[] asn1ValueArray2 = new Asn1Value[]{Asn1Value.trellisoftOID(this.productOID), Asn1Value.ipAddress(this.networkAddress), new Asn1Value(this.genericTrap), new Asn1Value(this.specificTrap), Asn1Value.timeTicks(this.timeTicks), new Asn1Value(asn1ValueArray)};
        return new Asn1Value(Asn1Value.TRAP_ID, asn1ValueArray2);
    }
}

