/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.context;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ViewerAttributeBean
extends BaseAttributeBean {
    private int maxRows;
    private Map parametersAsString = null;
    private Collection parameterDefList = null;
    private Map displayTexts = null;
    private Map moduleOptions = null;
    private boolean isDocumentProcessing = false;

    public ViewerAttributeBean(HttpServletRequest httpServletRequest) {
        try {
            this.init(httpServletRequest);
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    protected void __init(HttpServletRequest httpServletRequest) throws Exception {
        if (ParameterAccessor.isGetImageOperator(httpServletRequest)) {
            return;
        }
        this.category = "BIRT";
        this.masterPageContent = ParameterAccessor.isMasterPageContent(httpServletRequest);
        this.isDesigner = ParameterAccessor.isDesigner(httpServletRequest);
        this.bookmark = ParameterAccessor.getBookmark(httpServletRequest);
        this.reportPage = String.valueOf(ParameterAccessor.getPage(httpServletRequest));
        this.reportDocumentName = ParameterAccessor.getReportDocument(httpServletRequest);
        this.reportDesignName = ParameterAccessor.getReport(httpServletRequest);
        this.format = ParameterAccessor.getFormat(httpServletRequest);
        this.maxRows = ParameterAccessor.getMaxRows(httpServletRequest);
        BirtResources.setLocale(ParameterAccessor.getLocale(httpServletRequest));
        ReportEngineService.getInstance().setMaxRows(this.maxRows);
        this.processReport(httpServletRequest);
        String string = BirtResources.getMessage("birt.viewer.title");
        this.reportTitle = ParameterAccessor.htmlEncode(string);
        this.__initParameters(httpServletRequest);
    }

    protected void __initParameters(HttpServletRequest httpServletRequest) throws Exception {
        this.reportDesignHandle = this.getDesignHandle(httpServletRequest);
        if (this.reportDesignHandle == null) {
            return;
        }
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        inputOptions.setOption("locale", this.locale);
        inputOptions.setOption("rtl", new Boolean(this.rtl));
        List list = this.getParameterList();
        if (this.isDesigner && !"/frameset".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            this.parseConfigVars(httpServletRequest, list);
        }
        this.parametersAsString = this.getParsedParametersAsString(list, httpServletRequest, inputOptions);
        this.parameterDefList = this.getReportService().getParameterDefinitions(this.reportDesignHandle, inputOptions, false);
        this.missingParameter = this.documentInUrl ? false : ViewerAttributeBean.validateParameters(this.parameterDefList, this.parametersAsString);
        this.parametersAsString = this.getParsedParametersAsStringWithDefaultValue(this.parametersAsString, httpServletRequest, inputOptions);
        this.parameters = (HashMap)this.getParsedParameters(this.reportDesignHandle, list, httpServletRequest, inputOptions);
        this.displayTexts = this.getDisplayTexts(this.displayTexts, httpServletRequest);
        this.moduleOptions = this.getModuleOptions(httpServletRequest);
    }

    protected void parseConfigVars(HttpServletRequest httpServletRequest, Collection collection) {
        block11: {
            this.configMap = new HashMap();
            String string = ParameterAccessor.getConfigFileName(this.reportDesignName);
            if (string == null) {
                return;
            }
            SessionHandle sessionHandle = DesignEngine.newSession((ULocale)ULocale.US);
            ReportDesignHandle reportDesignHandle = null;
            try {
                reportDesignHandle = sessionHandle.openDesign(string);
                if (reportDesignHandle == null) break block11;
                String string2 = null;
                Iterator iterator = reportDesignHandle.configVariablesIterator();
                while (iterator != null && iterator.hasNext()) {
                    String string3;
                    ConfigVariableHandle configVariableHandle = (ConfigVariableHandle)iterator.next();
                    if (configVariableHandle == null || configVariableHandle.getName() == null) continue;
                    String string4 = configVariableHandle.getName();
                    String string5 = configVariableHandle.getValue();
                    if (string4.toLowerCase().startsWith("__isnull") && string5 != null) {
                        string3 = this.getParameterName(string5);
                        if (string3 == null) continue;
                        this.configMap.put(string3, null);
                        continue;
                    }
                    string2 = ParameterAccessor.isDisplayText(string4);
                    if (string2 != null) {
                        string4 = this.getParameterName(string2);
                        if (string4 == null) continue;
                        if (this.displayTexts == null) {
                            this.displayTexts = new HashMap();
                        }
                        this.displayTexts.put(string4, string5);
                        continue;
                    }
                    string4 = this.getParameterName(string4);
                    string3 = (ScalarParameterHandle)this.findParameter(string4);
                    if (string5 == null || string3 == null) continue;
                    String string6 = configVariableHandle.getName() + "_" + "type";
                    ConfigVariable configVariable = reportDesignHandle.findConfigVariable(string6);
                    String string7 = string3.getDataType();
                    String string8 = null;
                    if (configVariable != null) {
                        string8 = configVariable.getValue();
                    }
                    if (string8 == null || !string8.equalsIgnoreCase(string7)) continue;
                    try {
                        if (!"string".equalsIgnoreCase(string7) && !"dateTime".equalsIgnoreCase(string7)) {
                            String string9 = string3.getPattern();
                            Object object = ParameterValidationUtil.validate((String)string7, (String)string9, (String)string5, (ULocale)ULocale.US);
                            string5 = ParameterValidationUtil.getDisplayValue((String)string7, (String)string9, (Object)object, (Locale)this.locale);
                        }
                    }
                    catch (Exception exception) {
                        string5 = configVariableHandle.getValue();
                    }
                    this.configMap.put(string4, string5);
                }
                reportDesignHandle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String getParameterDefaultValues(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions) throws ReportServiceException {
        if (iViewerReportDesignHandle == null) {
            return null;
        }
        String string2 = null;
        Object object = null;
        try {
            object = this.getReportService().getParameterDefaultValue(iViewerReportDesignHandle, string, inputOptions);
        }
        catch (ReportServiceException reportServiceException) {
            reportServiceException.printStackTrace();
        }
        ScalarParameterHandle scalarParameterHandle = (ScalarParameterHandle)this.findParameter(string);
        if (object != null && scalarParameterHandle != null) {
            String string3 = scalarParameterHandle.getDataType();
            String string4 = scalarParameterHandle.getPattern();
            if ("dateTime".equalsIgnoreCase(string3)) {
                string2 = ParameterValidationUtil.getDisplayValue((Object)object);
            } else {
                if ("string".equalsIgnoreCase(string3)) {
                    string4 = null;
                }
                string2 = ParameterValidationUtil.getDisplayValue(null, (String)string4, (Object)object, (Locale)this.locale);
            }
        }
        if (string2 == null && scalarParameterHandle != null) {
            string2 = scalarParameterHandle.getDefaultValue();
        }
        return string2;
    }

    private String getParameterName(String string) throws ReportServiceException {
        String string2 = null;
        List list = this.getParameterList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ScalarParameterHandle scalarParameterHandle = null;
                if (list.get(i) instanceof ScalarParameterHandle) {
                    scalarParameterHandle = (ScalarParameterHandle)list.get(i);
                }
                String string3 = null;
                if (scalarParameterHandle != null && scalarParameterHandle.getName() != null) {
                    string3 = scalarParameterHandle.getName() + "_" + scalarParameterHandle.getID();
                }
                if (string3 == null || !string3.equalsIgnoreCase(string)) continue;
                string2 = scalarParameterHandle.getName();
                break;
            }
        }
        return string2;
    }

    protected IViewerReportDesignHandle getDesignHandle(HttpServletRequest httpServletRequest) {
        Object object;
        BirtViewerReportDesignHandle birtViewerReportDesignHandle = null;
        IReportRunnable iReportRunnable = null;
        boolean bl = ParameterAccessor.isValidFilePath(this.reportDocumentName);
        if (bl && (object = ReportEngineService.getInstance().openReportDocument(this.reportDesignName, this.reportDocumentName, this.getModuleOptions(httpServletRequest))) != null) {
            iReportRunnable = object.getReportRunnable();
            if ("/frameset".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                this.parameterMap = object.getParameterValues();
            }
            if (ParameterAccessor.getParameter(httpServletRequest, "__document") != null) {
                this.documentInUrl = true;
            }
            if (!object.isComplete() && ParameterAccessor.isReportParameterExist(httpServletRequest, "__report")) {
                this.isDocumentProcessing = true;
            }
            object.close();
        }
        if (iReportRunnable == null) {
            if (ParameterAccessor.isReportParameterExist(httpServletRequest, "__document") && !ParameterAccessor.isReportParameterExist(httpServletRequest, "__report")) {
                this.exception = bl ? new ViewerException("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{this.reportDocumentName}) : new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{this.reportDocumentName});
                return birtViewerReportDesignHandle;
            }
            if (!ParameterAccessor.isValidFilePath(this.reportDesignName)) {
                this.exception = new ViewerException("birt.viewer.generalException.REPORT_ACCESS_ERROR", new String[]{this.reportDesignName});
            } else {
                try {
                    object = new File(this.reportDesignName);
                    if (((File)object).exists()) {
                        iReportRunnable = ReportEngineService.getInstance().openReportDesign(this.reportDesignName, this.getModuleOptions(httpServletRequest));
                    } else if (!ParameterAccessor.isWorkingFolderAccessOnly()) {
                        this.reportDesignName = ParameterAccessor.getParameter(httpServletRequest, "__report");
                        InputStream inputStream = null;
                        URL uRL = null;
                        try {
                            String string = this.reportDesignName;
                            if (!string.startsWith("/")) {
                                string = "/" + string;
                            }
                            if ((uRL = httpServletRequest.getSession().getServletContext().getResource(string)) != null) {
                                inputStream = uRL.openStream();
                            }
                            if (inputStream != null) {
                                iReportRunnable = ReportEngineService.getInstance().openReportDesign(uRL.toString(), inputStream, this.getModuleOptions(httpServletRequest));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (iReportRunnable == null) {
                        this.exception = new ViewerException("birt.viewer.generalException.REPORT_FILE_ERROR", new String[]{this.reportDesignName});
                    }
                }
                catch (EngineException engineException) {
                    this.exception = engineException;
                }
            }
        }
        if (iReportRunnable != null) {
            birtViewerReportDesignHandle = new BirtViewerReportDesignHandle("rptRunnableObject", iReportRunnable);
        }
        return birtViewerReportDesignHandle;
    }

    protected void processReport(HttpServletRequest httpServletRequest) throws Exception {
        File file = new File(this.reportDocumentName);
        File file2 = new File(this.reportDesignName);
        if (file2 != null && file2.exists() && file2.isFile() && file != null && file.exists() && file.isFile() && "get".equalsIgnoreCase(httpServletRequest.getMethod()) && (file2.lastModified() > file.lastModified() || ParameterAccessor.isOverwrite(httpServletRequest))) {
            file.delete();
        }
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    protected void __finalize() throws Throwable {
    }

    protected Map getParsedParameters(IViewerReportDesignHandle iViewerReportDesignHandle, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap hashMap = new HashMap();
        if (collection == null || this.parametersAsString == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ScalarParameterHandle scalarParameterHandle = null;
            Object e = iterator.next();
            if (e instanceof ScalarParameterHandle) {
                scalarParameterHandle = (ScalarParameterHandle)e;
            }
            if (scalarParameterHandle == null) continue;
            String string = scalarParameterHandle.getName();
            Object object = this.parametersAsString.get(string);
            if (object != null) {
                try {
                    String string2 = ParameterAccessor.getFormat(httpServletRequest, string);
                    if (string2 == null || string2.length() <= 0) {
                        string2 = scalarParameterHandle.getPattern();
                    }
                    object = DataUtil.validate(scalarParameterHandle.getDataType(), string2, object.toString(), this.locale);
                    hashMap.put(string, object);
                    continue;
                }
                catch (ValidationValueException validationValueException) {
                    if (!"/run".equalsIgnoreCase(httpServletRequest.getServletPath())) continue;
                    this.exception = validationValueException;
                    break;
                }
            }
            hashMap.put(string, null);
        }
        return hashMap;
    }

    protected String getParamValueAsString(HttpServletRequest httpServletRequest, ScalarParameterHandle scalarParameterHandle) {
        String string = scalarParameterHandle.getName();
        String string2 = null;
        if (ParameterAccessor.isReportParameterExist(httpServletRequest, string)) {
            string2 = ParameterAccessor.getReportParameter(httpServletRequest, string, null);
            return string2;
        }
        Object object = null;
        if (this.isDesigner && ("/run".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/parameter".equalsIgnoreCase(httpServletRequest.getServletPath())) && this.configMap != null && this.configMap.containsKey(string)) {
            object = this.configMap.get(string);
        } else if (this.parameterMap != null && this.parameterMap.containsKey(string)) {
            object = this.parameterMap.get(string);
            object = ParameterValidationUtil.getDisplayValue(null, (String)scalarParameterHandle.getPattern(), (Object)object, (Locale)this.locale);
        }
        if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }

    protected Map getParsedParametersAsString(Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (collection == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ScalarParameterHandle scalarParameterHandle = null;
            Object e = iterator.next();
            if (e instanceof ScalarParameterHandle) {
                scalarParameterHandle = (ScalarParameterHandle)e;
            }
            if (scalarParameterHandle == null) continue;
            String string = scalarParameterHandle.getName();
            String string2 = this.getParamValueAsString(httpServletRequest, scalarParameterHandle);
            if (string == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected Map getParsedParametersAsStringWithDefaultValue(Map hashMap, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        if (hashMap == null) {
            hashMap = new HashMap();
            return hashMap;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            Object object = hashMap.get(string);
            if (object != null || ParameterAccessor.isReportParameterExist(httpServletRequest, string) || !"/frameset".equalsIgnoreCase(httpServletRequest.getServletPath()) && this.configMap != null && this.configMap.containsKey(string)) continue;
            object = this.getParameterDefaultValues(this.reportDesignHandle, string, inputOptions);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private List getParameterList() throws ReportServiceException {
        IReportRunnable iReportRunnable = (IReportRunnable)this.reportDesignHandle.getDesignObject();
        ModuleHandle moduleHandle = null;
        if (iReportRunnable != null) {
            moduleHandle = iReportRunnable.getDesignHandle().getModuleHandle();
        }
        if (moduleHandle != null) {
            return moduleHandle.getFlattenParameters();
        }
        return null;
    }

    public ParameterHandle findParameter(String string) throws ReportServiceException {
        if (string == null) {
            return null;
        }
        IReportRunnable iReportRunnable = (IReportRunnable)this.reportDesignHandle.getDesignObject();
        ModuleHandle moduleHandle = null;
        if (iReportRunnable != null) {
            moduleHandle = iReportRunnable.getDesignHandle().getModuleHandle();
        }
        if (moduleHandle != null) {
            return moduleHandle.findParameter(string);
        }
        return null;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public String getReportTitle() throws ReportServiceException {
        IReportRunnable iReportRunnable;
        String string;
        Object object;
        String string2 = this.reportTitle;
        if (this.reportDesignHandle != null && (object = this.reportDesignHandle.getDesignObject()) instanceof IReportRunnable && (string = (String)(iReportRunnable = (IReportRunnable)object).getProperty("title")) != null && string.trim().length() > 0) {
            string2 = string;
        }
        return string2;
    }

    protected Map getDisplayTexts(Map hashMap, HttpServletRequest httpServletRequest) {
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = DataUtil.getString(enumeration.nextElement());
            String string2 = ParameterAccessor.isDisplayText(string);
            if (string2 == null) continue;
            hashMap.put(string2, ParameterAccessor.getParameter(httpServletRequest, string));
        }
        return hashMap;
    }

    protected Map getModuleOptions(HttpServletRequest httpServletRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("resourceFolder", ParameterAccessor.getResourceFolder(httpServletRequest));
        return hashMap;
    }

    public Map getParametersAsString() {
        return this.parametersAsString;
    }

    public Collection getParameterDefList() {
        return this.parameterDefList;
    }

    public Map getDisplayTexts() {
        return this.displayTexts;
    }

    public Map getModuleOptions() {
        return this.moduleOptions;
    }

    public boolean isDocumentProcessing() {
        return this.isDocumentProcessing;
    }
}

