/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware;

import com.ibm.log.Level;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.soap.encoding.soapenc.Base64;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.internal.server.device.DeviceServerActivator;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.DBAccess;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SessionContext;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.osgi.framework.ServiceReference;

public class DeviceServiceManager
implements Runnable,
IService,
IDeviceServiceManager,
ICliDispatcher {
    public static final long DEFAULT_MONITOR_INTERVAL = 60000L;
    private static final String setupFile = "setup.properties";
    public static final String MONITOR_INTERVAL = "monitorInterval";
    public static final String DS_FILE = "DeployedServices.ds";
    public static final String CONFIG_DIR = "configuration";
    private static Boolean started = Boolean.FALSE;
    private static Status status = new Status(5, 6);
    private static Hashtable<String, IService> serviceTable = new Hashtable();
    private static Thread daemonThread;
    private Properties setupProps = new Properties();
    private static DeviceServiceManager instance;
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManagerText";
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    static final String TRACE_NAME = "aperi.logger.trace.TSNMServiceManager";
    static final String MESSAGE_NAME = "aperi.logger.message.TSNMServiceManager";
    static long startupTime;
    private static FileLock rFl;
    private static FileChannel rFc;
    private static PrintStream rPs;
    private static FileOutputStream rFos;

    static {
        instance = null;
        msgLogger = null;
        traceLogger = null;
        startupTime = 0L;
        rFl = null;
        rFc = null;
        rPs = null;
        rFos = null;
        try {
            String string = Variables.getBaseDirectory();
            if (string != null && string.length() > 0) {
                String string2 = String.valueOf(string) + File.separator + "tmp" + File.separator + "runLock";
                rFos = new FileOutputStream(string2);
                rFc = rFos.getChannel();
                rFl = rFc.tryLock();
                if (rFl == null) {
                    throw new Exception("NULL_LOCK");
                }
                Date date = new Date();
                rPs = new PrintStream(rFos, true);
                rPs.println("DATE=\"" + date.toString() + "\"");
                rPs.println("EPOCH=" + date.getTime());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DeviceServiceManager() {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(BUNDLENAME);
        SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
    }

    public void run() {
        String string = this.getName();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)string, "run");
        }
        try {
            String string2 = Variables.getConfigurationDirectory();
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(string2) + File.separator + setupFile);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string3 = properties.getProperty("tsnm.type");
            if ("manager".equals(string3)) {
                this.registerServer();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        status.setRunStatus(4);
        this.setServiceRoleAndLicenseMappings();
        status.setRunStatus(8);
        startupTime = System.currentTimeMillis();
        this.monitor();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.getClass(), "run");
        }
    }

    public String handshake(String string) {
        String string2 = null;
        try {
            Object object;
            KeyAgreement keyAgreement = null;
            PublicKey publicKey = null;
            try {
                object = MiddlewareCrypto.decrypt((byte[])Base64.decode((String)string));
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
                publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                DHParameterSpec dHParameterSpec = ((DHPublicKey)publicKey).getParams();
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(dHParameterSpec);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                byte[] byArray = keyPair.getPublic().getEncoded();
                string2 = Base64.encode((byte[])MiddlewareCrypto.encrypt((byte[])byArray));
                keyAgreement = KeyAgreement.getInstance("DH");
                keyAgreement.init(keyPair.getPrivate());
                SessionContext.successfulHandshake();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to create Server key pair: " + exception.toString());
            }
            try {
                keyAgreement.doPhase(publicKey, true);
                object = keyAgreement.generateSecret("DES");
                SessionContext.setSecretKey((SecretKey)object);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to create Key Agreement: " + exception.toString());
            }
        }
        catch (Exception exception) {
            String string3 = SessionContext.getRemoteHostname();
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "handshake", "TSNMServiceManager_ServerAuthenticationFailed", (Object)string3);
        }
        return string2;
    }

    public Status getStatus(String string) {
        Status status = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getStatus");
        }
        if (serviceTable.containsKey(string)) {
            try {
                status = serviceTable.get(string).getStatus();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{string, exception.toString()};
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "getStatus", "TSNMServiceManager_ExcGettingStatus", objectArray);
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "getStatus", (Throwable)exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getStatus");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startup() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "startup");
        }
        Boolean bl = started;
        synchronized (bl) {
            block7: {
                if (!started.booleanValue()) break block7;
                return true;
            }
            started = Boolean.TRUE;
        }
        status.setRunStatus(9);
        this.deleteDSFile();
        serviceTable.clear();
        if (rFl == null) {
            msgLogger.text(IRecordType.TYPE_ERR, (Object)this, "startup", "NULL_LOCK");
            return true;
        }
        System.err.println("Starting Device Server");
        daemonThread = new Thread(this);
        daemonThread.start();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "startup");
        }
        return true;
    }

    public synchronized boolean shutdown() {
        status.setRunStatus(11);
        String string = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string);
        }
        if (daemonThread != null) {
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "TSNMServiceManager_InterruptingMonitor");
            daemonThread.interrupt();
            try {
                daemonThread.join();
                daemonThread = null;
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "TSNMServiceManagerCli_CaughtException", (Object)exception.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
            }
        }
        status.setRunStatus(10);
        started = Boolean.FALSE;
        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "TSNMServiceManager_ShuttingDown");
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date();
        stringBuffer.append(DateFormat.getDateInstance(3).format(date));
        stringBuffer.append(" ");
        stringBuffer.append(DateFormat.getTimeInstance(1).format(date));
        stringBuffer.append("  Stopped Device Server");
        System.err.println(stringBuffer.toString());
        this.deleteDSFile();
        serviceTable.clear();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string);
        }
        return true;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "DeviceServiceManager";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("TSNMServiceManager_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("TSNMServiceManager_Description");
    }

    public String getDescription() {
        return "Framework";
    }

    public Status getStatus() {
        return status;
    }

    public String dispatch(String string, String[] stringArray) {
        return CliDispatcher.dispatch((Object)this, (String)string, (String[])stringArray);
    }

    public static DeviceServiceManager getInstance() {
        if (instance == null) {
            instance = new DeviceServiceManager();
        }
        return instance;
    }

    public Object getTargetObject(String string) {
        DeviceServiceManager deviceServiceManager = null;
        if (string.equals("DeviceServiceManager")) {
            deviceServiceManager = this;
        }
        return deviceServiceManager;
    }

    private boolean registerServer() {
        Server server;
        DBConnection dBConnection;
        block11: {
            String string;
            String string2;
            block10: {
                try {
                    String string3 = Variables.getBaseDirectory();
                    String string4 = String.valueOf(string3) + File.separator + CONFIG_DIR + File.separator + setupFile;
                    FileInputStream fileInputStream = new FileInputStream(string4);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    string2 = properties.getProperty("manager.port");
                    String string5 = properties.getProperty("tsnm.type");
                    string = properties.getProperty("installationPass");
                    System.err.println("Port = " + string2 + "\n" + "Type = " + string5 + "\n" + "Password = " + string + "\n");
                    if (string5 != null && string2 != null && string != null) break block10;
                    System.err.println("Incomplete database connection properties");
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            dBConnection = null;
            Server.ServerCursor serverCursor = null;
            String string6 = InetAddress.getLocalHost().getHostName();
            server = null;
            try {
                dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(Server.getColumnInfo((String)"SERVER_TYPE"), Integer.toString(1));
                hashtable.put(Server.getColumnInfo((String)"SERVER_NAME"), InetAddress.getLocalHost().getHostName());
                serverCursor = Server.getCursor((DBConnection)dBConnection, hashtable, null);
                if (!serverCursor.next()) {
                    server = new Server();
                    server.setServerId(AutoIdentifier.getIdentifier((int)1, (int)1));
                    server.setServerName(string6);
                    server.setServerToken(0.0);
                    server.setComputerId(0);
                    server.setPortNumber(Integer.parseInt(string2));
                    server.setServerType(1);
                    server.setPassword(string);
                    server.insert(dBConnection);
                    dBConnection.commit();
                }
                serverCursor.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (dBConnection != null) break block11;
            return false;
        }
        try {
            dBConnection.close();
        }
        catch (Exception exception) {}
        if (server != null) {
            new DBAccess().syncInstallPassword("" + server.getServerId(), server.getPassword());
        }
        return true;
    }

    private void monitor() {
        long l;
        ServiceReference[] serviceReferenceArray;
        Long l2 = null;
        String string = Variables.getBaseDirectory();
        String string2 = String.valueOf(string) + File.separator + CONFIG_DIR + File.separator;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "monitor");
        }
        try {
            this.readProps(String.valueOf(string2) + setupFile, this.setupProps);
            serviceReferenceArray = this.setupProps.getProperty(MONITOR_INTERVAL);
            l2 = Long.valueOf((String)serviceReferenceArray);
            l = l2 * 1000L;
            if (l <= 0L) {
                l = 60000L;
            }
        }
        catch (Exception exception) {
            l = 60000L;
        }
        msgLogger.message(IRecordType.TYPE_WARN, (Object)this, "monitor", "TSNMServiceManager_Monitoring", (Object)new Long(l / 1000L));
        serviceReferenceArray = null;
        String string3 = null;
        while (!Thread.interrupted()) {
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.interfaces.IService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                serviceReferenceArray = DeviceServerActivator.getContext().getAllServiceReferences(clazz.getName(), null);
                if (serviceReferenceArray != null) {
                    int n = 0;
                    while (n < serviceReferenceArray.length) {
                        string3 = (String)serviceReferenceArray[n].getProperty("org.eclipse.aperi.webservice.name");
                        if (!serviceTable.containsKey(string3)) {
                            serviceTable.put(string3, (IService)DeviceServerActivator._serviceHelper.bindLocal(string3));
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManagerCli_CaughtException", (Object)exception.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "monitor", (Throwable)exception);
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "monitor");
                }
                return;
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManagerCli_CaughtException", (Object)exception.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "monitor", (Throwable)exception);
            }
            Enumeration<String> enumeration = serviceTable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = enumeration.nextElement();
                IService iService = serviceTable.get(string3);
                if (iService.getStatus().getInstallStatus() != 5 || iService.getStatus().getRunStatus() != 8) continue;
                try {
                    iService.getStatus();
                }
                catch (RuntimeException runtimeException) {
                    msgLogger.exception(IRecordType.TYPE_WARN, (Object)this, "monitor", (Throwable)runtimeException);
                }
                Object[] objectArray = new Object[]{string3, status.getRunStatusAsText()};
                if (status == null) continue;
                if (status.getRunStatus() == 2) {
                    iService.getStatus().setRunStatus(2);
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManager_StatusMsg", objectArray);
                    continue;
                }
                if (status.getRunStatus() != 10) continue;
                iService.getStatus().setRunStatus(10);
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManager_StatusMsg", objectArray);
            }
            if (status.getRunStatus() != 10) continue;
            return;
        }
        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManager_MonitorExits");
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "monitor");
        }
    }

    private void deleteDSFile() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "deleteDSFile");
        }
        String string = CONFIG_DIR + File.separator + DS_FILE;
        System.out.println("dsFileName = " + string);
        File file = new File(string);
        if (file.exists()) {
            if (file.delete()) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "deleteDSFile", "TSNMServiceManager_DeletedFile", (Object)string);
            } else {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "deleteDSFile", "TSNMServiceManager_CouldNotDeleteFile", (Object)string);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "deleteDSFile");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readProps(String var1_1, Properties var2_2) {
        block13: {
            if (DeviceServiceManager.traceLogger.isLogging()) {
                DeviceServiceManager.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "readConnectionProps", (Object)"entered");
            }
            var3_3 = 0;
            var4_4 = null;
            try {
                try {
                    var4_4 = new FileInputStream(var1_1);
                    var2_2.load(var4_4);
                    if (DeviceServiceManager.traceLogger.isLogging()) {
                        var5_5 = var2_2.keySet().iterator();
                        while (var5_5.hasNext()) {
                            var6_7 = (String)var5_5.next();
                            var7_8 = var2_2.getProperty(var6_7);
                            DeviceServiceManager.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "readConnectionProps", "SAN DB Connection parm: " + var6_7 + " = " + var7_8);
                        }
                    }
                    DeviceServiceManager.msgLogger.message(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "readConnectionProps", "TSNMServiceManager_successfulReadingParms", (Object)var1_1);
                }
                catch (Exception var5_6) {
                    DeviceServiceManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this.getClass().getName(), "readConnectionProps", "TSNMServiceManager_errorReadingParms", (Object)var1_1);
                    DeviceServiceManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "readConnectionProps", (Throwable)var5_6);
                    var3_3 = -1;
                }
            }
            catch (Throwable var9_9) {
                var8_10 = null;
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Exception var10_12) {
                        DeviceServiceManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "readConnectionProps", (Throwable)var10_12);
                    }
                }
                var4_4 = null;
                if (DeviceServiceManager.traceLogger.isLogging() == false) throw var9_9;
                DeviceServiceManager.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "readConnectionProps", (Object)"exited");
                throw var9_9;
            }
            {
                var8_11 = null;
                if (var4_4 == null) break block13;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 241->249)] { 
lbl40:
            // 1 sources

            var4_4.close();
            break block13;
lbl42:
            // 1 sources

            catch (Exception var10_13) {
                DeviceServiceManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "readConnectionProps", (Throwable)var10_13);
            }
        }
        var4_4 = null;
        if (DeviceServiceManager.traceLogger.isLogging() == false) return var3_3;
        DeviceServiceManager.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "readConnectionProps", (Object)"exited");
        return var3_3;
    }

    public String[] getListOfServices() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = serviceTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public HashMap getServiceProperties(String string, Locale locale) {
        IService iService = serviceTable.get(string);
        if (iService == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ID", iService.getClass().getName());
        hashMap.put("Name", iService.getLocalizedName(locale));
        hashMap.put("Available", new Boolean(iService.getStatus().getRunStatus() == 8).toString());
        hashMap.put("DeployedStatus", iService.getStatus().getInstallStatusAsText());
        hashMap.put("RunStatus", (String)iService.getStatus());
        hashMap.put("Status", iService.getStatus().getLocalizedStatusAsText(locale));
        hashMap.put("Version", iService.getVersion());
        hashMap.put("Description", iService.getLocalizedDescription(locale));
        return hashMap;
    }

    public long getStartupTime() {
        return startupTime;
    }

    public long getElapseTime() {
        return System.currentTimeMillis() - startupTime;
    }

    public long getVMSize() {
        return Runtime.getRuntime().totalMemory();
    }

    public int getRoleBitmap() {
        int n = 0;
        if (SessionContext.isUserInRole((String)"itsrmAdmin")) {
            n = 1 | n;
        }
        if (SessionContext.isUserInRole((String)"itsrmViewer")) {
            n = 2 | n;
        }
        return n;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("getListOfServices", new Integer(RoleChecker.SUPERUSER));
        hashtable.put("getServiceProperties", new Integer(RoleChecker.SUPERUSER));
        return hashtable;
    }

    public void refreshRoleCache() throws SQLException {
        Roles.refresh();
    }

    private void setServiceRoleAndLicenseMappings() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setServiceRoleAndLicenseMappings");
        }
        Enumeration<String> enumeration = serviceTable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                IService iService = serviceTable.get(enumeration.nextElement());
                Hashtable hashtable = iService.getRoleMap();
                if (hashtable == null) continue;
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    Integer n = (Integer)hashtable.get(string);
                    RPCSecureJavaProvider.setRoleMapping((String)iService.getName(), (String)string, (Integer)n);
                }
            }
            catch (Throwable throwable) {
                traceLogger.exception(Level.DEBUG_MIN, (Object)this, "setServiceRoleAndLicenseMappings", throwable);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setServiceRoleAndLicenseMappings");
        }
    }
}

