/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.Discover;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.ProcessProcessor;
import org.eclipse.aperi.discovery.cimom.CIMScanner;
import org.eclipse.aperi.discovery.cimom.SLPScanner;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.parser.CIMParser;
import org.eclipse.aperi.discovery.parser.SLPObjectParser;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class DiscoverService
implements IDiscover,
IService,
ICliDispatcher {
    public static String className;
    public static final String MESSAGE_NAME = "aperi.logger.message.Discovery";
    public static final String TRACE_NAME = "aperi.logger.trace.Discovery";
    public static String MSG_FILE;
    public Status status = new Status(5, 6);
    public static final String PROPERTY_GROUP = "DiscoverService";
    public static final String PROPERTY_NUM_CIM_SCANNERS = "NumCIMScanners";
    public static final String PROPERTY_NUM_SLP_SCANNERS = "NumSLPScanners";
    public static final String PROPERTY_NUM_PROCESSORS = "NumProcessors";
    public static final String PROPERTY_NUM_CIM_PARSERS = "NumCIMParsers";
    public static final String PROPERTY_NUM_SLP_PARSERS = "NumSLPParsers";
    public static final int DEFAULT_NUM_RESOURCES = 10;
    HashSet<CIMScanner> cimScanners = null;
    HashSet<SLPScanner> slpScanners = null;
    HashSet<ProcessProcessor> processors = null;
    HashSet<CIMParser> cimParsers = null;
    HashSet<SLPObjectParser> slpParsers = null;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    private static IConfigService configServiceProxy;
    public static final String SELECT_SERVER_ID = "SELECT SERVER_ID FROM T_RES_SERVER S WHERE S.SERVER_TYPE = 1 AND S.SERVER_NAME = ?";
    public static final String SELECT_RUNS = "SELECT SCHEDULE_ID, RUN_NUMBER FROM T_RUNS WHERE DEVICE_SERVER_ID = ?";
    public static final String SELECT_RUN_JOBS = "SELECT JOB_RUN_NUMBER FROM T_RUN_JOBS WHERE SCHEDULE_ID = ? AND SID_RUN_NUMBER = ? AND COMPUTER_ID = ? AND RETURN_CODE = -1";
    public static final String UPDATE_RUNS = "UPDATE T_RUNS SET STATUS = ? WHERE SCHEDULE_ID = ? AND RUN_NUMBER = ?";
    public static final String UPDATE_RUN_JOBS = "UPDATE T_RUN_JOBS SET RETURN_CODE = ? WHERE JOB_RUN_NUMBER = ?";

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.DiscoverService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        MSG_FILE = "org.eclipse.aperi.resources.Discover";
        msgLogger = null;
        traceLogger = null;
        configServiceProxy = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public void addProcess(String string, IDiscoverProcess iDiscoverProcess) {
        Router.getRouter().addProcess(string, iDiscoverProcess);
    }

    public String discover(String string, Hashtable hashtable) {
        String string2 = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        String string3 = null;
        Hashtable<String, Object[]> hashtable2 = new Hashtable<String, Object[]>();
        hashtable2.put("Request", new Object[]{string, hashtable});
        string3 = Router.getRouter().perform(Discover.frontEndProcessHandler, hashtable2)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, (Object)string3);
        }
        return string3;
    }

    public String discover(String string, Hashtable hashtable, ILogger iLogger) {
        String string2 = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        String string3 = null;
        Hashtable<String, Object[]> hashtable2 = new Hashtable<String, Object[]>();
        hashtable2.put("Request", new Object[]{string, hashtable});
        string3 = Router.getRouter().perform(Discover.frontEndProcessHandler, hashtable2, true, iLogger)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, (Object)string3);
        }
        return string3;
    }

    public String discover(DiscoverRequest discoverRequest) {
        String string = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        hashtable.put("Request", new Object[]{discoverRequest.getCommand(), discoverRequest.getParameters()});
        String string2 = Router.getRouter().perform(Discover.frontEndProcessHandler, hashtable)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)string2);
        }
        return string2;
    }

    public String discover(DiscoverRequest discoverRequest, ILogger iLogger) {
        String string = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        hashtable.put("Request", new Object[]{discoverRequest.getCommand(), discoverRequest.getParameters()});
        String string2 = Router.getRouter().perform(Discover.frontEndProcessHandler, hashtable, true, iLogger)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)string2);
        }
        return string2;
    }

    public Map getSupportedDiscoverRequests() {
        return Router.getRouter().getSupportedRequests();
    }

    public AsyncResult cancel(String string) {
        return DiscoverUtils.cancelJob(string);
    }

    public AsyncResult waitTilComplete(String string) {
        return DiscoverUtils.waitForJobToComplete(string);
    }

    public AsyncResult getJobStatus(String string) {
        return ServiceUtils.getJobStatus((String)string);
    }

    public String getDescription() {
        return "Service that performs discovery functions";
    }

    public String getName() {
        return PROPERTY_GROUP;
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("DiscoverService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("DiscoverService_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean shutdown() {
        Iterator<Thread> iterator;
        this.status.setRunStatus(11);
        if (this.cimScanners != null) {
            iterator = this.cimScanners.iterator();
            while (iterator.hasNext()) {
                ((CIMScanner)iterator.next()).shutdown();
            }
            this.cimScanners = null;
        }
        if (this.slpScanners != null) {
            iterator = this.slpScanners.iterator();
            while (iterator.hasNext()) {
                ((SLPScanner)iterator.next()).shutdown();
            }
            this.slpScanners = null;
        }
        if (this.cimParsers != null) {
            iterator = this.cimParsers.iterator();
            while (iterator.hasNext()) {
                ((CIMParser)iterator.next()).shutdown();
            }
            this.cimParsers = null;
        }
        if (this.slpParsers != null) {
            iterator = this.slpParsers.iterator();
            while (iterator.hasNext()) {
                ((SLPObjectParser)iterator.next()).shutdown();
            }
            this.slpParsers = null;
        }
        if (this.processors != null) {
            iterator = this.processors.iterator();
            while (iterator.hasNext()) {
                ((ProcessProcessor)iterator.next()).shutdown();
            }
            this.processors = null;
        }
        this.status.setRunStatus(10);
        return true;
    }

    private int getCountProperty(String string, int n, Properties properties) {
        int n2 = n;
        try {
            String string2 = properties.getProperty(string);
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    public boolean startup() {
        try {
            this.setJobStatus();
            this.status.setRunStatus(9);
            Properties properties = this.getConfigServiceProxy().getProperties(PROPERTY_GROUP);
            this.cimScanners = new HashSet();
            int n = this.getCountProperty(PROPERTY_NUM_CIM_SCANNERS, 10, properties);
            int n2 = 0;
            while (n2 < n) {
                this.cimScanners.add(new CIMScanner());
                ++n2;
            }
            this.slpScanners = new HashSet();
            n = this.getCountProperty(PROPERTY_NUM_SLP_SCANNERS, 1, properties);
            n2 = 0;
            while (n2 < n) {
                this.slpScanners.add(new SLPScanner());
                ++n2;
            }
            this.processors = new HashSet();
            n = this.getCountProperty(PROPERTY_NUM_PROCESSORS, 10, properties);
            n2 = 0;
            while (n2 < n) {
                this.processors.add(new ProcessProcessor());
                ++n2;
            }
            this.cimParsers = new HashSet();
            n = this.getCountProperty(PROPERTY_NUM_CIM_PARSERS, 10, properties);
            n2 = 0;
            while (n2 < n) {
                this.cimParsers.add(new CIMParser());
                ++n2;
            }
            this.slpParsers = new HashSet();
            n = this.getCountProperty(PROPERTY_NUM_SLP_PARSERS, 1, properties);
            n2 = 0;
            while (n2 < n) {
                this.slpParsers.add(new SLPObjectParser());
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.shutdown();
        }
        this.status.setRunStatus(8);
        return true;
    }

    public String dispatch(String string, String[] stringArray) {
        boolean bl;
        StringBuffer stringBuffer;
        String string2;
        block20: {
            string2 = "dispatch";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string2);
            }
            stringBuffer = new StringBuffer();
            bl = false;
            if (string.equalsIgnoreCase("help")) {
                stringBuffer.append("\nDiscover Service CLI supports the following commands:\n - list supported\n - list jobs\n - discover <DiscoverRequest> <parameter>=<value>*");
            } else if (string.equalsIgnoreCase("list")) {
                if (stringArray.length < 1) {
                    stringBuffer.append("Missing parameter\n");
                    bl = true;
                } else if (stringArray[0].equalsIgnoreCase("supported")) {
                    Map map = this.getSupportedDiscoverRequests();
                    stringBuffer.append("Supported DISCOVER requests:\n");
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        DiscoverRequest discoverRequest = (DiscoverRequest)map.get(string3);
                        stringBuffer.append(String.valueOf(string3) + " (" + discoverRequest.getDescription() + ")\n");
                        Iterator iterator2 = discoverRequest.getParameters().keySet().iterator();
                        while (iterator2.hasNext()) {
                            String string4 = (String)iterator2.next();
                            String string5 = discoverRequest.getParameterType(string4);
                            stringBuffer.append("    " + string4 + "\t\t" + string5 + '\n');
                        }
                        stringBuffer.append('\n');
                    }
                } else if (stringArray[0].equalsIgnoreCase("jobs")) {
                    stringBuffer.append(Router.getRouter().getJobStatus());
                } else {
                    stringBuffer.append("Incorrect parameter");
                    bl = true;
                }
            } else if (string.equalsIgnoreCase("discover")) {
                try {
                    String string6 = stringArray[0];
                    DiscoverRequest discoverRequest = (DiscoverRequest)this.getSupportedDiscoverRequests().get(string6);
                    if (discoverRequest == null) {
                        stringBuffer.append("Discover request: " + stringArray[0] + " is not recognized.\n");
                        bl = true;
                        break block20;
                    }
                    Hashtable hashtable = DiscoverUtils.parseParameters(stringArray, discoverRequest);
                    System.out.println(discoverRequest + " " + hashtable);
                    String string7 = this.discover(string6, hashtable);
                    stringBuffer.append("Discover request " + string7 + " started.");
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            } else {
                stringBuffer.append("Invalid command\n");
                bl = true;
            }
        }
        if (bl) {
            stringBuffer.append("Use 'help' to get syntax of supported commands.");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string2);
        }
        return stringBuffer.toString();
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("discover", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("dispatch", new Integer(RoleChecker.FABRIC_ADMIN));
        return hashtable;
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)DiscoveryActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    public Object invoke(String string, String string2, String string3, String string4, String string5, String string6, String string7, Object[] objectArray) throws ServerException {
        try {
            Object object = DiscoveryActivator._serviceHelper.bindLocal(string5);
            Method method = null;
            Method[] methodArray = object.getClass().getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Class<?>[] classArray;
                if (methodArray[n].getName().equals(string7) && objectArray.length == (classArray = methodArray[n].getParameterTypes()).length) {
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (objectArray[n2] != null && !classArray[n2].isInstance(objectArray[n2])) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        method = methodArray[n];
                        break;
                    }
                }
                ++n;
            }
            if (method == null) {
                throw new NoSuchMethodException(String.valueOf(string5) + "." + string7);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("TPC_USER", string == null ? "" : string);
            hashtable.put("TPC_JOBNAME", string2 == null ? "" : string2);
            hashtable.put("TPC_SCHEDULE_ID", string3 == null ? "" : string3);
            hashtable.put("TPC_DESCRIPTION", string4 == null ? "" : string4);
            RPCSecureJavaProvider.addUserProperties(hashtable);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string5, string6, string7};
            SRMMessage sRMMessage = new SRMMessage("BTAFM4001E", stringArray);
            throw new ServerException(sRMMessage, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setJobStatus() {
        block38: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            var8_8 = null;
            var9_9 = null;
            if (DiscoverService.traceLogger.isLogging()) {
                DiscoverService.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setJobStatus");
            }
            try {
                try {
                    block36: {
                        var10_10 = DBConnPoolDataSource.getInstance();
                        var1_1 = (DBConnection)var10_10.getPooledConnection();
                        var2_2 = var1_1.prepareStatement("SELECT SERVER_ID FROM T_RES_SERVER S WHERE S.SERVER_TYPE = 1 AND S.SERVER_NAME = ?");
                        var2_2.setString(1, InetAddress.getLocalHost().getHostName());
                        var9_9 = var2_2.executeQuery();
                        if (!var9_9.next()) break block36;
                        var11_13 = Integer.parseInt(var9_9.getObject("SERVER_ID").toString());
                        var3_3 = var1_1.prepareStatement("SELECT SCHEDULE_ID, RUN_NUMBER FROM T_RUNS WHERE DEVICE_SERVER_ID = ?");
                        var4_4 = var1_1.prepareStatement("SELECT JOB_RUN_NUMBER FROM T_RUN_JOBS WHERE SCHEDULE_ID = ? AND SID_RUN_NUMBER = ? AND COMPUTER_ID = ? AND RETURN_CODE = -1");
                        var5_5 = var1_1.prepareStatement("UPDATE T_RUNS SET STATUS = ? WHERE SCHEDULE_ID = ? AND RUN_NUMBER = ?");
                        var6_6 = var1_1.prepareStatement("UPDATE T_RUN_JOBS SET RETURN_CODE = ? WHERE JOB_RUN_NUMBER = ?");
                        var3_3.setInt(1, var11_13);
                        var7_7 = var3_3.executeQuery();
                        block15: while (true) {
                            block37: {
                                if (var7_7.next()) break block37;
                                var1_1.commit();
                                ** GOTO lbl-1000
                            }
                            var12_16 = Integer.parseInt(var7_7.getObject("SCHEDULE_ID").toString());
                            var13_17 = Integer.parseInt(var7_7.getObject("RUN_NUMBER").toString());
                            var4_4.setInt(1, var12_16);
                            var4_4.setInt(2, var13_17);
                            var4_4.setInt(3, var11_13);
                            var8_8 = var4_4.executeQuery();
                            var14_18 = false;
                            while (true) {
                                if (!var8_8.next()) {
                                    if (!var14_18) continue block15;
                                    var5_5.setString(1, Integer.toString(0));
                                    var5_5.setInt(2, var12_16);
                                    var5_5.setInt(3, var13_17);
                                    var5_5.executeUpdate();
                                    continue block15;
                                }
                                var15_19 = Integer.parseInt(var8_8.getObject("JOB_RUN_NUMBER").toString());
                                var14_18 = true;
                                var6_6.setInt(1, 8);
                                var6_6.setInt(2, var15_19);
                                var6_6.executeUpdate();
                            }
                            break;
                        }
                    }
                    try {
                        v0 = Class.forName("org.eclipse.aperi.DiscoverService");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                    DiscoverService.msgLogger.message(IRecordType.TYPE_WARN, v0, "setJobStatus", "TSNMServiceManager_NoValidServerID");
                }
                catch (SQLException var10_11) {
                    var10_11.printStackTrace();
                    try {
                        var1_1.rollback();
                    }
                    catch (SQLException var11_14) {
                        var11_14.printStackTrace();
                    }
                }
                catch (Exception var10_12) {
                    var10_12.printStackTrace();
                    try {
                        var1_1.rollback();
                    }
                    catch (SQLException var11_15) {
                        var11_15.printStackTrace();
                    }
                }
            }
            catch (Throwable var17_20) {
                var16_21 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    if (var9_9 != null) {
                        var9_9.close();
                    }
                    if (var7_7 != null) {
                        var7_7.close();
                    }
                    if (var8_8 != null) {
                        var8_8.close();
                    }
                    if (var1_1 == null) throw var17_20;
                    var1_1.close();
                    throw var17_20;
                }
                catch (SQLException var18_23) {
                    var18_23.printStackTrace();
                }
                throw var17_20;
            }
lbl-1000:
            // 6 sources

            {
                var16_22 = null;
            }
            ** try [egrp 5[TRYBLOCK] [7 : 427->514)] { 
lbl107:
            // 1 sources

            if (var2_2 != null) {
                var2_2.close();
            }
            if (var3_3 != null) {
                var3_3.close();
            }
            if (var4_4 != null) {
                var4_4.close();
            }
            if (var5_5 != null) {
                var5_5.close();
            }
            if (var6_6 != null) {
                var6_6.close();
            }
            if (var9_9 != null) {
                var9_9.close();
            }
            if (var7_7 != null) {
                var7_7.close();
            }
            if (var8_8 != null) {
                var8_8.close();
            }
            if (var1_1 != null) {
                var1_1.close();
            }
            break block38;
lbl126:
            // 1 sources

            catch (SQLException var18_24) {
                var18_24.printStackTrace();
            }
        }
        if (DiscoverService.traceLogger.isLogging() == false) return;
        DiscoverService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setJobStatus");
    }
}

