/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.interfaces.CIMEnumerationResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.discovery.parser.Parser;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.client.CIMEnumeration;

public class CIMParser
extends Thread {
    public static String queueName = "CIMParser";
    public static final String MESSAGE_NAME = "aperi.logger.message.CIMParser";
    public static final String TRACE_NAME = "aperi.logger.trace.Discovery";
    public static String MSG_FILE = "org.eclipse.aperi.resources.CIMParser";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public boolean trace = false;
    String className;
    private Worker worker;
    private boolean shutdown;
    private Thread thread;

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public CIMParser() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.parser.CIMParser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.className = clazz.getName();
        this.worker = null;
        this.shutdown = false;
        this.thread = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            this.trace = true;
        }
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        this.worker = new Worker();
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    public void run() {
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            if (Configuration.debug && traceLogger.isLogging()) {
                traceLogger.message(IRecordType.TYPE_INFO, (Object)this, queueName, ": waiting for a job");
            }
            JobInfo jobInfo = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (jobInfo == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.message(IRecordType.TYPE_ERROR, (Object)this.className, queueName, ":Error - got a NULL job from queue");
                }
                System.out.println(String.valueOf(queueName) + ":Error - got a NULL job from the queue");
                msgLogger.message(IRecordType.TYPE_INFO, (Object)this, queueName, ":Error - got a NULL job from the queue");
                continue;
            }
            this.worker.processJob(jobInfo);
        }
    }

    public void shutdown() {
        String string = "shutdown";
        this.shutdown = true;
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, string, "Exception During:" + string);
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, string, (Throwable)exception);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, (Throwable)exception);
                }
                exception.printStackTrace();
            }
        }
    }

    class Worker
    extends Parser {
        Worker() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void parse(JobInfo var1_1) {
            var2_2 = "parse";
            var3_3 = var1_1.getRequest();
            try {
                block41: {
                    if (!(var3_3 instanceof CIMEnumerationResponse)) break block41;
                    if (Configuration.debug) {
                        System.out.println(String.valueOf(CIMParser.queueName) + ": Received a CIM Enumeration response");
                        if (CIMParser.traceLogger.isLogging()) {
                            CIMParser.traceLogger.message(IRecordType.TYPE_ERROR, (Object)CIMParser.this.className, var2_2, String.valueOf(CIMParser.queueName) + ": Received a CIM Enumeration response");
                        }
                        CIMParser.msgLogger.message(IRecordType.TYPE_INFO, (Object)this, var2_2, String.valueOf(CIMParser.queueName) + ": Received a CIM Enumeration response");
                    }
                    var4_4 = null;
                    var5_5 = new CIMProcessor();
                    try {
                        try {
                            if (var5_5.start(var1_1)) {
                                var4_4 = (CIMEnumeration)var3_3.getData();
                                if (var1_1 != null) {
                                    var6_6 = (Query)var1_1.getPreviousJob().getRequest().getData();
                                    switch (var6_6.getCmd()) {
                                        case 0: 
                                        case 1: {
                                            while (var4_4.hasMoreElements()) {
                                                var7_9 = (CIMInstance)var4_4.nextElement();
                                                var5_5.handleInstance(var1_1, var7_9);
                                            }
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            var7_10 = CIMProcessor.convertPropertiesToHashtable(var6_6.getProperties(), new Hashtable<K, V>());
                                            while (var4_4.hasMoreElements()) {
                                                var8_12 = (CIMInstance)var4_4.nextElement();
                                                var9_14 = CIMProcessor.convertPropertiesToHashtable(var8_12.getAllProperties(), new Hashtable<K, V>());
                                                var5_5.handleAssociation(var1_1, var6_6.getAssocClassName(), var6_6.getClassName(), var7_10, var8_12.getClassName(), var9_14, null);
                                            }
                                            break;
                                        }
                                        case 4: 
                                        case 5: {
                                            while (var4_4.hasMoreElements()) {
                                                var7_11 = (CIMClass)var4_4.nextElement();
                                                if (var7_11.getSuperClass() == null) continue;
                                                var8_13 = new Hashtable<String, String>();
                                                var8_13.put("ref_classname", var7_11.getName());
                                                var8_13.put("ref_superclass", var7_11.getSuperClass());
                                                var5_5.handleEntity(var1_1, "CIM_Class", var8_13);
                                            }
                                            break;
                                        }
                                        default: {
                                            if (CIMParser.traceLogger.isLogging()) {
                                                CIMParser.traceLogger.message(IRecordType.TYPE_INFORMATION, (Object)CIMParser.this.className, var2_2, "Unable to determine type of data-cmd" + ((Query)var1_1.getRequest().getData()).getCmd() + "is undefined");
                                            }
                                            CIMParser.msgLogger.message(IRecordType.TYPE_INFO, (Object)this, var2_2, " unable to determine type of data - cmd = " + ((Query)var1_1.getRequest().getData()).getCmd() + "is undefined.");
                                            System.out.println(String.valueOf(CIMParser.queueName) + " unable to determine type of data - cmd = " + ((Query)var1_1.getRequest().getData()).getCmd() + "is undefined.");
                                            break;
                                        }
                                    }
                                } else {
                                    if (CIMParser.traceLogger.isLogging()) {
                                        CIMParser.traceLogger.message(IRecordType.TYPE_INFORMATION, (Object)CIMParser.this.className, var2_2, String.valueOf(CIMParser.queueName) + ": Unable to determine type of data - no previousJobInfo");
                                    }
                                    System.out.println(String.valueOf(CIMParser.queueName) + ": unable to determine type of data - no previousJob info");
                                }
                                var1_1.setReturnCode(0);
                                var1_1.complete(true);
                            }
                        }
                        catch (Exception var6_7) {
                            CIMParser.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, "Exception in CIMParse:" + var2_2);
                            CIMParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, (Throwable)var6_7);
                            if (CIMParser.traceLogger.isLogging()) {
                                CIMParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, var2_2, (Throwable)var6_7);
                            }
                            var1_1.setReturnCode(99);
                            var1_1.complete(false);
                            var6_7.printStackTrace();
                        }
                        catch (Throwable var6_8) {
                            CIMParser.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, "Exception in CIMParse:" + var2_2);
                            CIMParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, var6_8);
                            if (CIMParser.traceLogger.isLogging()) {
                                CIMParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, var2_2, var6_8);
                            }
                            var1_1.complete(false);
                            var6_8.printStackTrace();
                        }
                    }
                    catch (Throwable var11_15) {
                        var10_16 = null;
                        if (var5_5 != null) {
                            var5_5.end(Integer.parseInt(var1_1.getDiscoverRequest()));
                            var5_5.shutdown();
                            var5_5 = null;
                        }
                        try {
                            if (var4_4 == null) throw var11_15;
                            var4_4.close();
                            throw var11_15;
                        }
                        catch (Exception var12_18) {
                            CIMParser.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, "Exception in CIMParse:" + var2_2);
                            CIMParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, (Throwable)var12_18);
                            if (CIMParser.traceLogger.isLogging()) {
                                CIMParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, var2_2, (Throwable)var12_18);
                            }
                            var12_18.printStackTrace();
                        }
                        throw var11_15;
                    }
                    {
                        var10_17 = null;
                        if (var5_5 != null) {
                            var5_5.end(Integer.parseInt(var1_1.getDiscoverRequest()));
                            var5_5.shutdown();
                            var5_5 = null;
                        }
                        ** try [egrp 3[TRYBLOCK] [4 : 913->928)] { 
lbl100:
                        // 1 sources

                        if (var4_4 != null) {
                            var4_4.close();
                        }
                        ** GOTO lbl-1000
lbl104:
                        // 1 sources

                        catch (Exception var12_19) {
                            CIMParser.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, "Exception in CIMParse:" + var2_2);
                            CIMParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, (Throwable)var12_19);
                            if (CIMParser.traceLogger.isLogging()) {
                                CIMParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, var2_2, (Throwable)var12_19);
                            }
                            var12_19.printStackTrace();
                        }
                    }
                    ** GOTO lbl-1000
                }
                System.out.println("Invalid response type for CIM Parser");
                var1_1.complete(false);
            }
            catch (Throwable var14_20) {
                var13_21 = null;
                try {
                    if (Configuration.debug) {
                        System.out.println(String.valueOf(CIMParser.queueName) + ": Finishing job");
                    }
                    var3_3.close();
                    throw var14_20;
                }
                catch (Exception var15_23) {
                    CIMParser.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, "Exception in CIMParse:" + var2_2);
                    CIMParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, (Throwable)var15_23);
                    if (CIMParser.traceLogger.isLogging()) {
                        CIMParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, var2_2, (Throwable)var15_23);
                    }
                    var15_23.printStackTrace();
                }
                throw var14_20;
            }
lbl-1000:
            // 4 sources

            {
                var13_22 = null;
            }
            try {}
            catch (Exception var15_24) {
                CIMParser.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, "Exception in CIMParse:" + var2_2);
                CIMParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, (Throwable)var15_24);
                if (CIMParser.traceLogger.isLogging()) {
                    CIMParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CIMParser.this.className, var2_2, (Throwable)var15_24);
                }
                var15_24.printStackTrace();
                return;
            }
            if (Configuration.debug) {
                System.out.println(String.valueOf(CIMParser.queueName) + ": Finishing job");
            }
            var3_3.close();
        }
    }
}

