/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class SnmpTrap
extends SnmpMetaPDU {
    public static final int COLDSTART = 0;
    public static final int WARMSTART = 1;
    public static final int LINKDOWN = 2;
    public static final int LINKUP = 3;
    public static final int AUTHENTICATIONFAILURE = 4;
    public static final int EGPNEIGHBORLOSS = 5;
    public static final int ENTERPRISESPECIFIC = 6;
    public static final byte TRAP_TAG = -92;
    public OID enterprise;
    public IPAddress agentAddr;
    public int genericTrap = 0;
    public int specificTrap = 0;
    public TimeTicks timeStamp;

    public SnmpTrap() {
        this.communityString = new OctetString("public");
        this.enterprise = null;
        this.agentAddr = null;
        this.senderAddr = null;
        this.genericTrap = 0;
        this.specificTrap = 0;
        this.timeStamp = null;
    }

    public SnmpTrap(SnmpTrap snmpTrap) {
        super(snmpTrap);
        this.enterprise = new OID(snmpTrap.enterprise);
        this.agentAddr = new IPAddress(snmpTrap.agentAddr.toString());
        this.agentAddr = new IPAddress(snmpTrap.senderAddr.toString());
        this.genericTrap = snmpTrap.genericTrap;
        this.specificTrap = snmpTrap.specificTrap;
        this.timeStamp = new TimeTicks(snmpTrap.timeStamp.value);
    }

    public SnmpTrap(Vector vector) {
        super(vector);
        this.communityString = new OctetString("public");
        this.enterprise = null;
        this.agentAddr = null;
        this.genericTrap = 0;
        this.specificTrap = 0;
        this.timeStamp = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Message :");
        stringBuffer.append(" version=" + this.version + " communityString=" + this.communityString.toDisplayString() + "\n          enterprise=" + this.enterprise.toString() + " agentAddr=" + this.agentAddr.toString() + " genericTrap=" + this.genericTrap + "\n          specificTrap=" + this.specificTrap + " timeStamp=" + this.timeStamp + "\n          ");
        stringBuffer.append(this.varBindListToString());
        return stringBuffer.toString();
    }

    public void set_notify_timestamp(TimeTicks timeTicks) {
        this.timeStamp = timeTicks;
    }

    public TimeTicks get_notify_timestamp() {
        return this.timeStamp;
    }

    public void set_notify_id(OID oID) {
        System.out.println("SnmpTrap:set_notify_id(id) - ID?? what is the ID in a Trap?");
    }

    public OID get_notify_id() {
        System.out.println("SnmpTrap:get_notify_id() - ID?? what is the ID in a Trap?");
        return null;
    }

    public void set_notify_enterprise(OID oID) {
        this.enterprise = oID;
    }

    public OID get_notify_enterprise() {
        return this.enterprise;
    }

    public boolean isTrapEnterpriseSpecific() {
        return this.genericTrap == 6;
    }

    public int get_generic_id() {
        return this.genericTrap;
    }

    public int get_specific_id() {
        return this.specificTrap;
    }
}

