/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.eclipse.aperi.snmp.SessionInfo;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpEncodeException;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpTarget;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;

public class SnmpTrapSession
extends SnmpTarget {
    protected SnmpTrapSession(String string, int n) throws SnmpUnknownHostException {
        super(string, n);
    }

    public static SnmpTrapSession open(String string) throws SnmpUnknownHostException, SnmpSocketException {
        return SnmpTrapSession.open(string, 162);
    }

    public static SnmpTrapSession open(String string, int n) throws SnmpUnknownHostException, SnmpSocketException {
        if (!SnmpV1API.initialized) {
            throw new SnmpSocketException("SnmpV1API not available");
        }
        try {
            SnmpV1API.initializeTraps();
        }
        catch (Exception exception) {
            throw new SnmpSocketException(exception.getMessage());
        }
        return new SnmpTrapSession(string, n);
    }

    public void changeRemotePort(int n) {
        this.port = n;
    }

    public void close() {
        SnmpV1API.terminateTraps();
    }

    public static void send(SnmpTrap snmpTrap, String string, int n) throws SnmpUnknownHostException, IOException {
        InetAddress inetAddress;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + snmpTrap.toString());
        }
        if (SnmpV1API.trapSocket != null) {
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                throw new SnmpUnknownHostException();
            }
        } else {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] byArray = SnmpAsn1.encode(snmpTrap, null);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        SnmpV1API.trapSocket.send(datagramPacket);
    }

    public static void sendTrapOrInform(SnmpMetaPDU snmpMetaPDU, String string, int n) throws SnmpUnknownHostException, IOException, SnmpEncodeException {
        InetAddress inetAddress;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + snmpMetaPDU.toString());
        }
        if (SnmpV1API.trapSocket != null) {
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                throw new SnmpUnknownHostException();
            }
        } else {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] byArray = SnmpTrapSession.encodeTrapOrInform(snmpMetaPDU, null);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        SnmpV1API.trapSocket.send(datagramPacket);
    }

    public static void send(SnmpTrap snmpTrap, String string) throws SnmpUnknownHostException, IOException {
        try {
            SnmpTrapSession.sendTrapOrInform(snmpTrap, string, 162);
        }
        catch (SnmpEncodeException snmpEncodeException) {
            throw new SnmpSocketException("Problem encoding message" + snmpEncodeException.toString());
        }
    }

    public void sendTrapOrInform(SnmpMetaPDU snmpMetaPDU) throws IOException, SnmpEncodeException {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap at \n" + snmpMetaPDU.toString());
        }
        if (SnmpV1API.trapSocket == null) {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] byArray = SnmpTrapSession.encodeTrapOrInform(snmpMetaPDU, null);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.destination, this.port);
        SnmpV1API.trapSocket.send(datagramPacket);
    }

    private static byte[] encodeTrapOrInform(SnmpMetaPDU snmpMetaPDU, SessionInfo sessionInfo) throws SnmpEncodeException {
        byte[] byArray = null;
        if (snmpMetaPDU instanceof SnmpTrap) {
            byArray = SnmpAsn1.encode((SnmpTrap)snmpMetaPDU, sessionInfo);
        } else if (snmpMetaPDU instanceof SnmpV2PDU) {
            byArray = SnmpAsn1.encode((SnmpV2PDU)snmpMetaPDU, sessionInfo);
        }
        return byArray;
    }
}

