/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.eclipse.aperi.snmp.data.Hex;

public class DisplayHint
implements Serializable {
    private static final boolean debug = false;

    public static String stringFromHint(String string, long l) {
        String string2 = null;
        if (string != null) {
            if (string.length() == 1) {
                if (Character.toLowerCase(string.charAt(0)) == 'x') {
                    string2 = Long.toHexString(l);
                } else if (Character.toLowerCase(string.charAt(0)) == 'd') {
                    string2 = Long.toString(l);
                } else if (Character.toLowerCase(string.charAt(0)) == 'o') {
                    string2 = Long.toOctalString(l);
                } else if (Character.toLowerCase(string.charAt(0)) == 'b') {
                    string2 = Long.toBinaryString(l);
                }
            } else if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == 'd' && string.charAt(1) == '-' && Character.isDigit(string.charAt(2))) {
                double d = 10.0;
                Integer n = new Integer(string.substring(2));
                double d2 = n.doubleValue();
                Long l2 = new Long(l);
                double d3 = l2.doubleValue();
                if (d2 >= 0.0) {
                    string2 = Double.toString(d3 /= Math.pow(d, d2));
                }
            }
        }
        return string2;
    }

    public static String stringFromHint(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 1;
        class SeqInfo {
            int seqPos = 0;
            boolean seqRepeat;
            int seqLength;
            char seqFormat;
            char seqDspSep;
            char seqRptSep;

            public boolean nextInfo(String string, boolean bl) {
                int n = this.seqPos;
                boolean bl2 = true;
                if (!bl) {
                    this.seqPos = 0;
                }
                if (string.length() > this.seqPos) {
                    if (string.charAt(this.seqPos) == '*') {
                        this.seqRepeat = true;
                        ++this.seqPos;
                    } else {
                        this.seqRepeat = false;
                    }
                    if (Character.isDigit(string.charAt(this.seqPos))) {
                        int n2 = this.seqPos;
                        while (this.seqPos < string.length() && Character.isDigit(string.charAt(this.seqPos))) {
                            ++this.seqPos;
                        }
                        this.seqLength = Integer.parseInt(string.substring(n2, this.seqPos));
                        if (this.seqPos < string.length()) {
                            this.seqFormat = string.charAt(this.seqPos);
                            switch (this.seqFormat) {
                                case 'A': 
                                case 'D': 
                                case 'O': 
                                case 'T': 
                                case 'X': 
                                case 'a': 
                                case 'd': 
                                case 'o': 
                                case 't': 
                                case 'x': {
                                    ++this.seqPos;
                                    break;
                                }
                                default: {
                                    this.seqPos = n;
                                    this.seqRepeat = false;
                                    this.seqLength = 0;
                                    this.seqFormat = (char)32;
                                    this.seqDspSep = '\u0000';
                                    this.seqRptSep = '\u0000';
                                    bl2 = false;
                                }
                            }
                            if (this.seqPos < string.length() && this.seqPos > n) {
                                if (string.charAt(this.seqPos) != '*' && !Character.isDigit(string.charAt(this.seqPos))) {
                                    this.seqDspSep = string.charAt(this.seqPos);
                                    ++this.seqPos;
                                    if (this.seqRepeat && this.seqPos < string.length() && string.charAt(this.seqPos) != '*' && !Character.isDigit(string.charAt(this.seqPos))) {
                                        this.seqRptSep = string.charAt(this.seqPos);
                                        ++this.seqPos;
                                    } else {
                                        this.seqRptSep = '\u0000';
                                    }
                                } else {
                                    this.seqDspSep = '\u0000';
                                    this.seqRptSep = '\u0000';
                                }
                            }
                        } else {
                            this.seqPos = n;
                            this.seqRepeat = false;
                            this.seqLength = 0;
                            this.seqFormat = (char)32;
                            this.seqDspSep = '\u0000';
                            this.seqRptSep = '\u0000';
                            bl2 = false;
                        }
                    } else {
                        this.seqPos = n;
                        this.seqRepeat = false;
                        this.seqLength = 0;
                        this.seqFormat = (char)32;
                        this.seqDspSep = '\u0000';
                        this.seqRptSep = '\u0000';
                        bl2 = false;
                    }
                } else if (!bl) {
                    this.seqPos = 0;
                    this.seqRepeat = false;
                    this.seqLength = 0;
                    this.seqFormat = (char)32;
                    this.seqDspSep = '\u0000';
                    this.seqRptSep = '\u0000';
                    bl2 = false;
                }
                return bl2;
            }

            public SeqInfo(String string) {
                this.nextInfo(string, false);
            }

            public boolean isSeqRepeated() {
                return this.seqRepeat;
            }

            public int length() {
                return this.seqLength;
            }

            public boolean isSeqHex() {
                return this.seqFormat == 'x' || this.seqFormat == 'X';
            }

            public boolean isSeqDec() {
                return this.seqFormat == 'd' || this.seqFormat == 'D';
            }

            public boolean isSeqOct() {
                return this.seqFormat == 'o' || this.seqFormat == 'O';
            }

            public boolean isSeqUTF8() {
                return this.seqFormat == 't' || this.seqFormat == 'T';
            }

            public boolean isSeqAsc() {
                return this.seqFormat == 'a' || this.seqFormat == 'A';
            }

            public boolean isDisplaySepChar() {
                return this.seqDspSep != '\u0000';
            }

            public boolean isRepeatSepChar() {
                return this.seqRptSep != '\u0000';
            }

            public char displaySepChar() {
                return this.seqDspSep;
            }

            public char repeatSepChar() {
                return this.seqRptSep;
            }

            public boolean isThereMore(String string) {
                return string.length() > this.seqPos;
            }
        }
        SeqInfo seqInfo = new SeqInfo(string);
        while (n < byArray.length) {
            if (seqInfo.isSeqRepeated()) {
                n2 = byArray[n];
                ++n;
            }
            while (n < byArray.length && n2 > 0) {
                int n3 = n + seqInfo.length() <= byArray.length ? seqInfo.length() : byArray.length - n;
                if (seqInfo.isSeqHex()) {
                    String string2 = Hex.toString(byArray, n, n3);
                    stringBuffer.append(string2);
                } else if (seqInfo.isSeqDec()) {
                    String string3 = Hex.toUnsignedDec(byArray, n, n3);
                    stringBuffer.append(string3);
                } else if (seqInfo.isSeqOct()) {
                    String string4 = Hex.toString(byArray, n, n3, 8);
                    stringBuffer.append(string4);
                } else if (seqInfo.isSeqAsc()) {
                    int n4 = n + n3;
                    int n5 = n;
                    while (n5 < n4) {
                        stringBuffer.append((char)byArray[n5]);
                        ++n5;
                    }
                } else if (seqInfo.isSeqUTF8()) {
                    try {
                        stringBuffer.append(new String(byArray, n, n3, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
                if (seqInfo.isDisplaySepChar() && (n += n3) < byArray.length && (!seqInfo.isThereMore(string) || n2 >= 1)) {
                    stringBuffer.append(seqInfo.displaySepChar());
                }
                --n2;
            }
            if (n < byArray.length && seqInfo.isRepeatSepChar()) {
                stringBuffer.append(seqInfo.repeatSepChar());
            }
            n2 = 1;
            if (seqInfo.nextInfo(string, true)) continue;
            n = byArray.length;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("Valid Long test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: hex   of     0 = " + DisplayHint.stringFromHint("x", 0L));
        System.out.println(" 2: Hex   of  1234 = " + DisplayHint.stringFromHint("X", 1234L));
        System.out.println(" 3: Hex   of -1234 = " + DisplayHint.stringFromHint("X", -1234L));
        System.out.println(" 4: oct   of     0 = " + DisplayHint.stringFromHint("o", 0L));
        System.out.println(" 5: Oct   of  1234 = " + DisplayHint.stringFromHint("O", 1234L));
        System.out.println(" 6: Oct   of -1234 = " + DisplayHint.stringFromHint("O", -1234L));
        System.out.println(" 7: bin   of     0 = " + DisplayHint.stringFromHint("b", 0L));
        System.out.println(" 8: Bin   of  1234 = " + DisplayHint.stringFromHint("B", 1234L));
        System.out.println(" 9: Bin   of -1234 = " + DisplayHint.stringFromHint("B", -1234L));
        System.out.println("10: dec   of     0 = " + DisplayHint.stringFromHint("d", 0L));
        System.out.println("11: Dec   of  1234 = " + DisplayHint.stringFromHint("D", 1234L));
        System.out.println("12: Dec   of -1234 = " + DisplayHint.stringFromHint("D", -1234L));
        System.out.println("13: Dec.0 of  1234 = " + DisplayHint.stringFromHint("D-0", 1234L));
        System.out.println("14: Dec.1 of  1234 = " + DisplayHint.stringFromHint("D-1", 1234L));
        System.out.println("15: Dec.2 of  1234 = " + DisplayHint.stringFromHint("D-2", 1234L));
        System.out.println("16: Dec.3 of  1234 = " + DisplayHint.stringFromHint("D-3", 1234L));
        System.out.println("17: Dec.4 of  1234 = " + DisplayHint.stringFromHint("D-4", 1234L));
        System.out.println("18: Dec.5 of  1234 = " + DisplayHint.stringFromHint("D-5", 1234L));
        System.out.println("19: Dec.6 of  1234 = " + DisplayHint.stringFromHint("D-6", 1234L));
        System.out.println("20: Dec.0 of -1234 = " + DisplayHint.stringFromHint("D-0", -1234L));
        System.out.println("21: Dec.1 of -1234 = " + DisplayHint.stringFromHint("D-1", -1234L));
        System.out.println("22: Dec.2 of -1234 = " + DisplayHint.stringFromHint("D-2", -1234L));
        System.out.println("23: Dec.3 of -1234 = " + DisplayHint.stringFromHint("D-3", -1234L));
        System.out.println("24: Dec.4 of -1234 = " + DisplayHint.stringFromHint("D-4", -1234L));
        System.out.println("25: Dec.5 of -1234 = " + DisplayHint.stringFromHint("D-5", -1234L));
        System.out.println("26: Dec.6 of -1234 = " + DisplayHint.stringFromHint("D-6", -1234L));
        System.out.println(" ");
        System.out.println("Error Long test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: c     of     0 = " + DisplayHint.stringFromHint("c", 0L));
        System.out.println(" 2: C     of  1234 = " + DisplayHint.stringFromHint("C", 1234L));
        System.out.println(" 3: Null  of  1234 = " + DisplayHint.stringFromHint(null, 1234L));
        System.out.println(" 4: Empty of  1234 = " + DisplayHint.stringFromHint("", 1234L));
        System.out.println(" 5: d--   of     0 = " + DisplayHint.stringFromHint("d--", 0L));
        System.out.println(" 6: D--   of  1234 = " + DisplayHint.stringFromHint("D--", 1234L));
        System.out.println(" 7: d--2  of  1234 = " + DisplayHint.stringFromHint("D--2", 1234L));
        System.out.println(" 8: d+5   of  1234 = " + DisplayHint.stringFromHint("d+5", 1234L));
        System.out.println(" 9: d-a   of  1234 = " + DisplayHint.stringFromHint("d-a", 1234L));
        byte[] byArray = new byte[]{3, 0, 0, 4, -46, 0, 0, 4, -46, 0, 0, 4, -46, 77, 121, 32, 110, 97, 109, 101, 32, 105, 115, 32, 72, 97, 110, 122, 44, 32, 117, 110, 100, 32, 109, 121, 32, 110, 97, 109, 101, 32, 105, 115, 32, 70, 114, 97, 110, 122, 46, 0, 0, 4, -46, 0, 0, 4, -46, 4, 0, 0, 4, -46, 0, 0, 4, -46};
        byte[] byArray2 = new byte[]{7, -49, 3, 24, 15, 58, 19, 0};
        System.out.println(" ");
        System.out.println("Valid OctetString DateAndTIme testcases:");
        System.out.println("===============================================");
        System.out.println(" 1: 2d-1d-1d,1d:1d:1d.1d,1a1d:1d= " + DisplayHint.stringFromHint("2d-1d-1d,1d:1d:1d.1d,1a1d:1d", byArray2));
        System.out.println(" 2: 1x: = " + DisplayHint.stringFromHint("1x:", byArray2));
        System.out.println(" 3: 2x: = " + DisplayHint.stringFromHint("2x:", byArray2));
        System.out.println(" 4: 4x: = " + DisplayHint.stringFromHint("4x:", byArray2));
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Valid OctetString test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: *4x,|38a|4x;4x;*4x,  = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;*4x,", byArray));
        System.out.println(" 2: *4x,|38a|4x;4x;4x,   = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;4x,", byArray));
        System.out.println(" 3: *4x,|38a|4x;4x;*4x,! = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;*4x,!", byArray));
        System.out.println(" 4: *4x,38a4x4x*4x       = " + DisplayHint.stringFromHint("*4x,38a4x4x*4x", byArray));
        System.out.println(" 5: *4x38a4x4x*4x        = " + DisplayHint.stringFromHint("*4x38a4x4x*4x", byArray));
        System.out.println(" 6: 1x:                  = " + DisplayHint.stringFromHint("1x:", byArray));
        System.out.println(" ");
        System.out.println("Error OctetString test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: *12a,|*4x; = " + DisplayHint.stringFromHint("*12a,|*4x;", byArray));
        System.out.println(" 1: 13x,|4a;  = " + DisplayHint.stringFromHint("13x,|4a;", byArray));
    }
}

