/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.data.oda.util.logging.LogFormatter;
import org.eclipse.birt.data.oda.util.logging.LogRecord;
import org.eclipse.birt.data.oda.util.logging.LoggingErrorHandler;
import org.eclipse.birt.data.oda.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private String m_filename;
    private File m_file;

    private FileHandler() {
    }

    public FileHandler(String filename) {
        this.m_filename = filename;
    }

    public FileHandler(String filename, LogFormatter formatter) {
        this.m_filename = filename;
        this.setFormatter(formatter);
    }

    public void publish(LogRecord record) {
        if (this.m_file == null) {
            this.setOutputFile(this.m_filename);
        }
        super.publish(record);
    }

    public void close() {
        super.close();
        this.m_file = null;
        this.m_filename = null;
    }

    private File getUniqueFile(String filename) {
        try {
            File file = new File(filename);
            this.createParentDirectory(file);
            int index = filename.lastIndexOf(".");
            String prefix = filename.substring(0, index);
            String suffix = filename.substring(index, filename.length());
            for (int looping = 0; !file.createNewFile() && looping < 10; ++looping) {
                file = new File(prefix + "-" + looping + suffix);
            }
            return file;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    String getPreferredFilename() {
        return this.m_filename;
    }

    private void createParentDirectory(File file) {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
    }

    void setOutputFile(String filename) {
        try {
            this.m_file = this.getUniqueFile(filename);
            if (this.m_file != null) {
                this.setOutputStream(new FileOutputStream(this.m_file));
            } else {
                this.reportError("", null, LoggingErrorHandler.OPEN_FAILURE);
            }
        }
        catch (FileNotFoundException ex) {
            this.reportError("", ex, LoggingErrorHandler.OPEN_FAILURE);
        }
    }
}

