/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.scanner;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.agent.scanner.InbandZoneControl;
import org.eclipse.aperi.agent.scanner.ScannerProcess;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogFileHandler;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.Command;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.IZoneControlAgent;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class Scanner
implements IScanner,
IService,
IZoneControlAgent {
    private static final long serialVersionUID = 20001130L;
    static final String MESSAGE_NAME = "aperi.logger.message.SanAgent_Scanner";
    static final String TRACE_NAME = "aperi.logger.trace.SanAgent_Scanner";
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    private String executableLocation = null;
    private StringBuffer nativeBinDirectory = null;
    private StringBuffer subagentHomeDirectory = null;
    private StringBuffer valuePath = null;
    private StringBuffer valueSystemroot = null;
    private StringBuffer valueLdlibrarypath = null;
    public static final String w32ix86 = "w32-ix86";
    public static final String winnt = "Windows NT";
    public static final String win2k = "Windows 2000";
    private static String MSG_FILE;
    private Status status = new Status(5, 9);
    private String description = "Collects data on agents";
    private String guid = null;
    private Vector<ScannerProcess> procs = new Vector();
    private Object procsVectorLock = new Object();
    private boolean shutdownInvoked = false;
    private static final String FULL_SCAN_OPT = "";
    private static final String FS_SCAN_OPT = "FS";
    private static final String VG_SCAN_OPT = "VG";
    private static final String PE_SCAN_OPT = "PE";
    private InbandZoneControl izc = null;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.agent.scanner.Scanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.ScannerTMS";
    }

    public Scanner() {
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (msgLogger != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
    }

    public Response invoke(String string, String string2) {
        String string3 = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3, (Object)(" with scanner = " + string + "target = " + string2));
        }
        if (string.equalsIgnoreCase("AttributePEOnly")) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Invoking Attribute scanner with PE option...");
            }
            return this.invoke("Attribute", string2, 3, null);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Invoking " + string + " scanner with FULL option...");
        }
        return this.invoke(string, string2, 0, null);
    }

    public Response invoke(String string, String string2, int n) {
        String string3 = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3, (Object)(" with scanner = " + string + "target = " + string2 + " option = " + n));
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Invoking " + string + " scanner with specified option...");
        }
        return this.invoke(string, string2, n, null);
    }

    public Response invoke(String string, String string2, String string3) {
        String string4 = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4, (Object)(" with scanner = " + string + "target = " + string2 + " benchmarkLabel = " + string3));
        }
        if (string.equalsIgnoreCase("AttributePEOnly")) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "Invoking Attribute scanner with PE option and benchmark comparison...");
            }
            return this.invoke("Attribute", string2, 3, string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "Invoking " + string + " scanner with FULL option and benchmark comparison...");
        }
        return this.invoke(string, string2, 0, string3);
    }

    /*
     * Exception decompiling
     */
    public Response invoke(String var1_1, String var2_2, int var3_3, String var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return "SANAgentScanner";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("Scanner_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("Scanner_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        String string = "shutdown";
        Process process = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.shutdownInvoked = true;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Set shutdownInvoked to true");
        }
        Object object = this.procsVectorLock;
        synchronized (object) {
            Iterator<ScannerProcess> iterator = this.procs.iterator();
            while (iterator.hasNext()) {
                ScannerProcess scannerProcess = iterator.next();
                if (scannerProcess != null) {
                    process = scannerProcess.getProc();
                }
                if (process == null) continue;
                process.destroy();
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Killed a unterminated scanner");
            }
            this.procsVectorLock.notifyAll();
        }
        this.status.setRunStatus(10);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public boolean startup() {
        boolean bl;
        String string;
        block42: {
            File file;
            block41: {
                string = "startup";
                bl = false;
                file = null;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
                }
                this.status.setRunStatus(9);
                this.executableLocation = this.getExecutableLocation();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "executableLocation = " + this.executableLocation);
                }
                if (this.executableLocation.equals(FULL_SCAN_OPT) && traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Unable to get executable location...Default to current directory...");
                }
                try {
                    if (this.executableLocation == null) {
                        this.executableLocation = new String(FULL_SCAN_OPT);
                    }
                    this.nativeBinDirectory = new StringBuffer(Variables.getNativeLibDirectory());
                    if (this.nativeBinDirectory == null) {
                        this.nativeBinDirectory = new StringBuffer(FULL_SCAN_OPT);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "nativeBinDirectory is " + this.nativeBinDirectory);
                    }
                    this.subagentHomeDirectory = new StringBuffer(Variables.getBaseDirectory());
                    if (this.subagentHomeDirectory == null) {
                        this.subagentHomeDirectory = new StringBuffer(FULL_SCAN_OPT);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "subAgentHomeDirectory is " + this.subagentHomeDirectory);
                    }
                }
                catch (Exception exception) {
                    if (msgLogger != null) {
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "Got Exception: Unable to nativeBinDirectory or subAgentHomeDirectory");
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                    this.nativeBinDirectory = new StringBuffer(FULL_SCAN_OPT);
                    this.subagentHomeDirectory = new StringBuffer(FULL_SCAN_OPT);
                }
                try {
                    String string2;
                    String string3 = Variables.getEnvironmentValue((String)"PATH");
                    this.valuePath = string3 != null ? new StringBuffer(string3) : new StringBuffer(FULL_SCAN_OPT);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for PATH returned " + this.valuePath);
                    }
                    if ((string2 = this.getInterp()) != null && string2.equals(w32ix86)) {
                        string3 = Variables.getEnvironmentValue((String)"SYSTEMROOT");
                        this.valueSystemroot = string3 != null ? new StringBuffer(string3) : new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                        }
                    } else {
                        this.valueSystemroot = new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                        }
                    }
                    if (string2 != null && string2.equals(w32ix86)) {
                        this.valueLdlibrarypath = new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                        }
                    } else {
                        string3 = Variables.getEnvironmentValue((String)"LD_LIBRARY_PATH");
                        this.valueLdlibrarypath = string3 != null ? new StringBuffer(string3) : new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                        }
                    }
                }
                catch (Exception exception) {
                    if (msgLogger != null) {
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) break block41;
                    traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "Got Exception: getEnvValue");
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
            try {
                file = new File(String.valueOf(this.executableLocation) + "RNID");
                if (file.exists()) {
                    file.delete();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, String.valueOf(this.executableLocation) + "RNID" + " File exists, deleting");
                    }
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, String.valueOf(this.executableLocation) + "RNID" + " File does not exist");
                }
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block42;
                traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "Got Exception: Unable to getEnvValue");
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        this.guid = GUID.readGUID().toString();
        if (this.guid == null || this.guid.equals(FULL_SCAN_OPT)) {
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "Scanner_getGuidError");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "Failed to get GUID");
            }
        } else {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "GUID = " + this.guid);
            }
            bl = true;
        }
        if (this.izc == null) {
            this.izc = new InbandZoneControl();
        }
        if (bl) {
            this.status.setRunStatus(8);
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string, "Scanner_serviceReady");
            }
        } else {
            this.status.setRunStatus(2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean isAlive() {
        return true;
    }

    private boolean compare(String[] stringArray, String[] stringArray2) {
        String string = "compare";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, String.valueOf(string) + " with benchmark");
        }
        StringBuffer stringBuffer = new StringBuffer(FULL_SCAN_OPT);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(FULL_SCAN_OPT);
        boolean bl = false;
        while (bl < stringArray2.length) {
            stringBuffer2.append(stringArray2[bl]);
            bl += 1;
        }
        bl = stringBuffer.toString().equals(stringBuffer2.toString());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)(bl ? "Match with benchmark" : "Mismatch with benchmark"));
        }
        return bl;
    }

    private String getExecutableLocation() {
        String string = "getExecutableLocation";
        String string2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        string2 = Variables.getExecutableDirectory();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    private String getInterp() {
        String string = "getInterp";
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.version");
        String string4 = System.getProperty("os.arch");
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Calling InterpResolver.getInterp with osName: " + string2 + ", osVersion: " + string3 + ", osArch: " + string4);
        }
        String string5 = InterpResolver.getInterp((String)string2, (String)string3, (String)string4);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)("interp = " + string5));
        }
        return string5;
    }

    private synchronized Response performBMCompare(int n, String[] stringArray, String string, String string2) {
        Closeable closeable;
        Closeable closeable2;
        String string3 = "performBMCompare";
        int n2 = -1;
        String[] stringArray2 = new String[]{};
        boolean bl = false;
        String string4 = null;
        File file = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        try {
            string4 = String.valueOf(this.executableLocation) + string + ".BM_" + string2;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "bmFile = " + string4);
            }
            if ((file = new File(string4)).exists()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Reading benchmark file...");
                }
                closeable2 = new FileInputStream(string4);
                closeable = new ObjectInputStream((InputStream)closeable2);
                n2 = (Integer)((ObjectInputStream)closeable).readObject();
                stringArray2 = (String[])((ObjectInputStream)closeable).readObject();
                ((FileInputStream)closeable2).close();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Comparing data to benchmark with oldLevel = " + n2);
                }
                bl = this.compare(stringArray, stringArray2);
            }
        }
        catch (Exception exception) {
            if (msgLogger != null) {
                file.delete();
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string3, "Scanner_readBenchmarkError", (Object)string4);
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
            bl = false;
            n2 = -1;
        }
        if (bl) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Data for scanner " + string + " benchmark label " + string2 + " is same as current benchmark");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, n);
            }
            return new Response(n, stringArray, n2, n2, string2, bl);
        }
        try {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Saving benchmark file...");
            }
            closeable2 = new FileOutputStream(string4);
            closeable = new ObjectOutputStream((OutputStream)closeable2);
            Integer n3 = new Integer(n2 < 1000 ? n2 + 1 : 0);
            ((ObjectOutputStream)closeable).writeObject(n3);
            ((ObjectOutputStream)closeable).writeObject(stringArray);
            ((FileOutputStream)closeable2).close();
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Saved data as benchmark with newLevel = " + n3);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, n);
            }
            return new Response(n, stringArray, n3.intValue(), n2, string2, bl);
        }
        catch (Exception exception) {
            if (msgLogger != null) {
                file.delete();
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string3, "Scanner_saveBenchmarkError");
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, n);
            }
            return new Response(n, stringArray);
        }
    }

    public String[] readString(InputStream inputStream) {
        Vector<String> vector;
        String string;
        block10: {
            string = "readString";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            vector = new Vector<String>();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            int n = 0;
            String string2 = "TOS error";
            String string3 = "<";
            boolean bl = false;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "readString with filter for error messages embedded in xml\n");
            }
            try {
                String string4;
                while ((string4 = bufferedReader.readLine()) != null) {
                    n = string4.indexOf(string2);
                    if (n == -1) {
                        if (!bl) {
                            n = string4.indexOf(string3);
                            if (n == -1) {
                                if (traceLogger == null || !traceLogger.isLogging()) continue;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "scanner output filtered is " + string4 + "\n");
                                continue;
                            }
                            bl = true;
                            vector.add(string4.substring(n));
                            continue;
                        }
                        vector.add(string4);
                        continue;
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "scanner output filtered is " + string4 + "\n");
                }
            }
            catch (IOException iOException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "Scanner_retrieveDataError");
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)iOException);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block10;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)iOException);
            }
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return stringArray;
    }

    public int lock(String string, String[] stringArray) {
        return this.izc.lock(string, stringArray);
    }

    public int startTransaction(String string) {
        return this.izc.startTransaction(string);
    }

    public int commitTransaction(String string) {
        return this.izc.commitTransaction(string);
    }

    public int rollbackTransaction(String string) {
        return this.izc.rollbackTransaction(string);
    }

    public int release(String string) {
        return this.izc.release(string);
    }

    public int sendCommandArray(String string, Command[] commandArray) {
        return this.izc.sendCommandArray(string, commandArray);
    }

    public int setZoneInfo(String string, ZoneDefinition zoneDefinition, int n) {
        return this.izc.setZoneInfo(string, zoneDefinition, n);
    }

    public int createZoneSet(String string, String string2) {
        return this.izc.createZoneSet(string, string2);
    }

    public int createZone(String string, String string2, short s, short s2) {
        return this.izc.createZone(string, string2, s, s2);
    }

    public int createZoneAlias(String string, String string2) {
        return this.izc.createZoneAlias(string, string2);
    }

    public int createZoneMemberSettingData(String string, short s, String string2, short s2, String string3) {
        return this.izc.createZoneMemberSettingData(string, s, string2, s2, string3);
    }

    public int addZoneToZoneSet(String string, String string2, String string3) {
        return this.izc.addZoneToZoneSet(string, string2, string3);
    }

    public int addZoneMemberToZone(String string, String string2, String string3, short s) {
        return this.izc.addZoneMemberToZone(string, string2, string3, s);
    }

    public int addZoneAliasToZone(String string, String string2, String string3) {
        return this.izc.addZoneAliasToZone(string, string2, string3);
    }

    public int addZoneMemberToZoneAlias(String string, String string2, String string3, short s) {
        return this.izc.addZoneMemberToZoneAlias(string, string2, string3, s);
    }

    public int removeZoneFromZoneSet(String string, String string2, String string3) {
        return this.izc.removeZoneFromZoneSet(string, string2, string3);
    }

    public int removeZoneAliasFromZone(String string, String string2, String string3) {
        return this.izc.removeZoneAliasFromZone(string, string2, string3);
    }

    public int removeZoneMemberFromZone(String string, String string2, String string3, short s) {
        return this.izc.removeZoneMemberFromZone(string, string2, string3, s);
    }

    public int removeZoneMemberFromZoneAlias(String string, String string2, String string3, short s) {
        return this.izc.removeZoneMemberFromZoneAlias(string, string2, string3, s);
    }

    public int deleteZoneMember(String string, String string2, short s) {
        return this.izc.deleteZoneMember(string, string2, s);
    }

    public int deleteZone(String string, String string2) {
        return this.izc.deleteZone(string, string2);
    }

    public int deleteZoneSet(String string, String string2) {
        return this.izc.deleteZoneSet(string, string2);
    }

    public int deleteZoneAlias(String string, String string2) {
        return this.izc.deleteZoneAlias(string, string2);
    }

    public int activateZoneSet(String string, String string2) {
        return this.izc.activateZoneSet(string, string2);
    }

    public int deactivateZoneSet(String string, String string2) {
        return this.izc.deactivateZoneSet(string, string2);
    }

    public int ping(String string, String[] stringArray) {
        return this.izc.ping(string, stringArray);
    }

    public ZoneCapabilities getCapabilities(String string) {
        return this.izc.getCapabilities(string);
    }

    public ZoneDefinition getOldZoneDefinition(String string) {
        return this.izc.getOldZoneDefinition(string);
    }

    public ZoneDefinition getNewZoneDefinition(String string) {
        return this.izc.getNewZoneDefinition(string);
    }

    public int readCurrentZoneDefinition(String string, ZoneDefinition zoneDefinition) throws Exception {
        return this.izc.readCurrentZoneDefinition(string, zoneDefinition);
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }

    public ReadLogResponse getLog(String string, byte by, LogFilePos logFilePos, int n) throws Exception {
        ReadLogResponse readLogResponse = new ReadLogResponse();
        readLogResponse = LogFileHandler.getLog((String)string, (byte)by, (LogFilePos)logFilePos, (int)n);
        return readLogResponse;
    }

    public ReadLogResponse getLog(String string, byte by, LogFilePos logFilePos, String string2, int n) throws Exception {
        ReadLogResponse readLogResponse = new ReadLogResponse();
        readLogResponse = LogFileHandler.getLog((String)string, (byte)by, (LogFilePos)logFilePos, (String)string2, (int)n);
        return readLogResponse;
    }
}

