/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ServletRegistration
extends Registration {
    private Servlet servlet;
    private HttpContext httpContext;
    private Set servlets;
    private ClassLoader registeredContextClassLoader;
    private ProxyContext proxyContext;

    public ServletRegistration(Servlet servlet, ProxyContext proxyContext, HttpContext httpContext, Bundle bundle, Set set) {
        this.servlet = servlet;
        this.servlets = set;
        this.httpContext = httpContext;
        this.proxyContext = proxyContext;
        this.registeredContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void destroy() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            super.destroy();
            this.servlet.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void close() {
        this.servlets.remove(this.servlet);
        this.proxyContext.destroyContextAttributes(this.httpContext);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        boolean bl = false;
        this.proxyContext.createContextAttributes(this.httpContext);
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
                this.servlet.init(servletConfig);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            this.servlets.add(this.servlet);
            bl = true;
        }
        finally {
            if (!bl) {
                this.proxyContext.destroyContextAttributes(this.httpContext);
            }
        }
    }

    public void checkServletRegistration() throws ServletException {
        if (this.servlets.contains(this.servlet)) {
            throw new ServletException("This servlet has already been registered at a different alias.");
        }
    }

    public boolean handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        HttpServletRequestAdaptor httpServletRequestAdaptor = new HttpServletRequestAdaptor(httpServletRequest, string, this.servlet);
        if (this.httpContext.handleSecurity((HttpServletRequest)httpServletRequestAdaptor, httpServletResponse)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
                this.servlet.service((ServletRequest)httpServletRequestAdaptor, (ServletResponse)httpServletResponse);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        return true;
    }
}

