
sqlcount=96

##########################################################################
# Non dbms specific repository creation script. 
# Processed by TrelliSoft.install.RepositoryInstall
# 
# This file must have the following format:
# 1) The first line of the file must contain a count of the sql stmts
#    included in the line. This info is used to update a progress bar
#    as the sql file is being processed. This line should be in the
#    format:
#        sqlcount = <n>
#    where <n> represents the # of statements contained in the file
#
# 2) Each sql statement must be terminated by a ';' as the first char
#    of a new line. Everything else on the terminator line is ignored.
#
# 3) Comments are denoted by a '#' as the first char of a line. Everything
#    on a comment line is ignored
#
# Parm    Oracle        MSSQL                      DB2
# ----    ------        -----                      ---
# {0}     decimal(10)   integer                    integer
# {1}     decimal(5)    smallint                   smallint
# {2}     raw(20)       varbinary(20)              varchar(20) for bit data
# {3}     date          datetime                   timestamp
# {4}     long          text                       long varchar
# {5}     long raw      image                      long varchar for bit data
# {6}     <empty>       case_mask varbinary(8)     <empty>
#                         default 0x00 not null,
# {7}     <empty>       case_mask varbinary(64)    <empty>
#                         default 0x00 not null,
# {8}     sysdate       current_timestamp          current timestamp
# {9}     '20'          ' '                        ' '
# {10}    <empty>       , case_mask                <empty>
# {11}    <empty>       0x00,                      <empty>
# {12}    float         float                      float
# {13}    raw(60)       varbinary(60)              varchar(60) for bit data
# {14}    <empty>       t_res_stat_dir.            <empty>
# {15}    modify        alter column               alter
# {16}    <empty>       <empty>                    set data type
# {17}    <empty>       not null                   <empty>
# {18}    column        column                     <empty>
# {19}    '4e'          0x4e                       x'4e'
# {20}    partition     partition                  "partition"
# {21}    default null  null                       <empty>
# {22}    <empty>       <empty>                    IN <tablspace>
# {110}   '00'          0x00                       x'00'
# {111}    -            -                          bigint
###########################################################################

# Change Log
# Date/Author/Description
#--------------------------
# Sep 28, 2006/Ted Slupesky/Add view definitions required for Netapp support
# Sep 28, 2006/Khan Tasinga/Add 'job_type_id' column to t_schedule
# Oct 16, 2006/Prasenjit Sarkar/Ported over TPC 3.1.2 changes - ought to make things slower
# Oct 26, 2006/Prasenjit Sarkar/Added temporary tables for the view-->table conversion
# Jan  4, 2007/Khan Tasinga/Updated alert ID of CIMOM discovery entry in T_SCHEDULE

------------------------------------------------
-- DDL Statements for table "T_RES_AGGREGATE"
-- FOREIGN KEYS: COLLECTION_ID, LOGICAL_DISK_ID
------------------------------------------------
CREATE TABLE T_RES_AGGREGATE 
(LOGICAL_DISK_ID     {0}    NOT NULL,                        
 COLLECTION_ID       {0}    NOT NULL                         
) {22}                               
;

CREATE INDEX T_RES_AGGREGATE_IX ON T_RES_AGGREGATE(LOGICAL_DISK_ID, COLLECTION_ID)
;
 
create view t_view_comp_SCSI_FC_disk
	(computer_id, capacity, free_space, disk_id, manufacturer, 
	 controller_type) as
	select  distinct host.computer_id, dh.capacity, dh.free_space,
			dh.disk_id, model.model_name, ctrl.controller_type
	from	t_res_host host, t_res_physical_volume pv, t_stat_disk_hist dh,
			t_res_controller ctrl , t_res_dev_access devacc, t_res_model model 

	where   ctrl.controller_type in (0, 5)
		and host.computer_id = ctrl.computer_id 
		and devacc.controller_id = ctrl.controller_id 
		and dh.disk_id = devacc.device_id 
		and dh.disk_id = pv.physical_volume_id
		and pv.device_type = 0
		and pv.model_id = model.model_id
		and dh.statistic_type = '3'
;

create view t_view_comp_SCSI_disksum
     (computer_id, capacity, freespace) as 
  select   computer_id, sum(capacity), sum(free_space)
  from     t_view_comp_SCSI_FC_disk
  where    controller_type = 0
  group by computer_id
;

create view t_view_comp_FC_disksum 
      (computer_id, capacity, freespace) as 
  select   computer_id, sum(capacity), sum(free_space)
  from     t_view_comp_SCSI_FC_disk
  where    controller_type = 5
  group by computer_id
;



-------------------------------------------------------------------------------
-- Sep 28, 2006/Khan Tasinga/Add 'job_type_id' column to t_schedule ...
--
-- Add 'job_type_id' column to 't_schedule'. It is effectively a replacement
-- for 'job_type'. This change was made to eliminate the need to convert a
-- resource type to a single character string for schedule persistance, a
-- process which was 1) unnecessary and 2) added complexity to extensibility.
-- The 'job_type' column was declared as 'not null'. A default value is added
-- to the 'job_type' column so that it does not need to be specified in any
-- insert statements.
--
-- Migration requires populating the new 'job_type_id' column by taking the
-- values stored in the existing 'job_type' column and applying the conversion
-- previously performed in TSchedule.externalToInternal(). It is pretty much
-- covered by the series 'update t_schedule ...' statements below.
--
-- The '[LEGACY]' marker is used to indicate job types which are not supported
-- by Aperi, but existed in the product from which it was spawned.
-------------------------------------------------------------------------------
alter table t_schedule
  add job_type_id {1} default -1 not null
;

-- The syntax below is not supported by Derby 10.1. Result? We cannot set a
-- default value on the legacy 'job_type' column and must include a dummy
-- value with our insert statements ('-') to deal with the fact that it
-- was declared 'not null'. We may want to put the statement below in a
-- future AlterVersion script.
-- alter table t_schedule
--   alter column job_type set default '-'
-- ;

-- job_type_id = 15 (ResourceType.RES_SCAN_SCHEDULE)
-- job_type = '1' (TSchedule.SCAN_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 15
 where job_type = '1'
;

-- job_type_id = 17 (ResourceType.RES_PING_SCHEDULE)
-- job_type = '2' (TSchedule.PING_EXTERNAL)
update t_schedule
   set job_type_id = 17
 where job_type = '2'
;

-- job_type_id = 16 (ResourceType.RES_PROBE_SCHEDULE)
-- job_type = '3' (TSchedule.PROBE_EXTERNAL)
update t_schedule
   set job_type_id = 16
 where job_type = '3'
;

-- job_type_id = 19 (ResourceType.RES_QUOTA)
-- job_type = '4' (TSchedule.QUOTA_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 19
 where job_type = '4'
;

-- job_type_id = 31 (ResourceType.RES_AGGREGATE)
-- job_type = '5' (TSchedule.AGGREGATE_EXTERNAL)
--  ('5') ->  (31)
update t_schedule
   set job_type_id = 31
 where job_type = '5'
;

-- job_type_id = 32 (ResourceType.RES_DISCOVERY)
-- job_type = '6' (TSchedule.DISCOVERY_EXTERNAL)
update t_schedule
   set job_type_id = 32
 where job_type = '6'
;

-- job_type_id = 36 (ResourceType.RES_REPORT_SCHEDULE)
-- job_type = '7' (TSchedule.REPORT_EXTERNAL)
update t_schedule
   set job_type_id = 36
 where job_type = '7'
;

-- job_type_id = 37 (ResourceType.RES_DB_REPORT_SCHEDULE)
-- job_type = '8' (TSchedule.DB_REPORT_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 37
 where job_type = '8'
;

-- job_type_id = 38 (ResourceType.RES_DB_DISCOVERY)
-- job_type = '9' (TSchedule.DB_DISCOVERY_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 38
 where job_type = '9'
;

-- job_type_id = 39 (ResourceType.RES_DB_PROBE_SCHEDULE)
-- job_type = 'A' (TSchedule.DB_PROBE_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 39
 where job_type = 'A'
;

-- job_type_id = 40 (ResourceType.RES_DB_SCAN_SCHEDULE)
-- job_type = 'B' (TSchedule.DB_SCAN_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 40
 where job_type = 'B'
;

-- job_type_id = 42 (ResourceType.RES_DB_QUOTA)
-- job_type = 'C' (TSchedule.DB_QUOTA_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 42
 where job_type = 'C'
;

-- job_type_id = 65 (ResourceType.RES_NAS_DISCOVERY)
-- job_type = 'D' (TSchedule.NAS_DISCOVERY_EXTERNAL)
update t_schedule
   set job_type_id = 65
 where job_type = 'D'
;

-- job_type_id = 67 (ResourceType.RES_SCRIPT_SCHEDULE)
-- job_type = 'E' (TSchedule.SCRIPT_EXTERNAL)
update t_schedule
   set job_type_id = 67
 where job_type = 'E'
;

-- job_type_id = 75 (ResourceType.RES_NETAPP_QUOTA_JOB)
-- job_type = 'F' (TSchedule.NETAPP_QUOTA_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 75
 where job_type = 'F'
;

-- job_type_id = 83 (ResourceType.RES_EXTENSION_POLICY)
-- job_type = 'G' (TSchedule.FS_EXTENSION_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 83
 where job_type = 'G'
;

-- job_type_id = 88 (ResourceType.RES_UPGRADE_SCHEDULE)
-- job_type = 'H' (TSchedule.UPGRADE_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 88
 where job_type = 'H'
;

-- job_type_id = 102 (ResourceType.RES_BACKUP_SCHEDULE)
-- job_type = 'I' (TSchedule.BACKUP_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 102
 where job_type = 'I'
;

-- job_type_id = 104 (ResourceType.RES_CIMOM_DISCOVERY)
-- job_type = 'J' (TSchedule.CIMOM_DISCOVERY_EXTERNAL)
update t_schedule
   set job_type_id = 104
 where job_type = 'J'
;

-- job_type_id = 105 (ResourceType.RES_SNMP_DISCOVERY)
-- job_type = 'K' (TSchedule.SNMP_DISCOVERY_EXTERNAL)
update t_schedule
   set job_type_id = 105
 where job_type = 'K'
;

-- job_type_id = 106 (ResourceType.RES_NETWARE_DISCOVERY)
-- job_type = 'L' (TSchedule.NETWARE_DISCOVERY_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 106
 where job_type = 'L'
;

-- job_type_id = 107 (ResourceType.RES_DISK_JOBS)
-- job_type = 'M' (TSchedule.DISK_JOBS_EXTERNAL)
update t_schedule
   set job_type_id = 107
 where job_type = 'M'
;

-- job_type_id = 108 (ResourceType.RES_FABRIC_JOBS)
-- job_type = 'N' (TSchedule.FABRIC_JOBS_EXTERNAL)
update t_schedule
   set job_type_id = 108
 where job_type = 'N'
;

-- job_type_id = 109 (ResourceType.RES_PM_JOBS)
-- job_type = 'O' (TSchedule.PM_JOBS_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 109
 where job_type = 'O'
;

-- job_type_id = 110 (ResourceType.RES_TAPE_JOBS)
-- job_type = 'P' (TSchedule.TAPE_JOBS_EXTERNAL)
update t_schedule
   set job_type_id = 110
 where job_type = 'P'
;

-- job_type_id = 111 (ResourceType.RES_API_JOBS)
-- job_type = 'Q' (TSchedule.API_JOBS_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 111
 where job_type = 'Q'
;

-- job_type_id = 112 (ResourceType.RES_SUBSYSTEM_PERFORMANCE_MONITOR)
-- job_type = 'R' (TSchedule.PERF_SUBSYSTEM_MONITOR_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 112
 where job_type = 'R'
;

-- job_type_id = 116 (ResourceType.RES_FABRIC_PERFORMANCE_MONITOR)
-- job_type = 'S' (TSchedule.PERF_FABRIC_MONITOR_EXTERNAL) [LEGACY]
update t_schedule
   set job_type_id = 116
 where job_type = 'S'
;



#/*
# Change Log added by Prasenjit
# -------------------------------------------------------------------------------------------------
# Mar 28, 2006	added a new col in t_res_tape_media_location
# Apr 11, 2006	add all views related to the changed view tview_tape_library
# Apr 11, 2006	added new table for ONTAP 7 support
# Apr 13, 2006	added new table for global topology settings
# Apr 13, 2006	added new table temporary tables for topology viewer L1 views
# Apr 19, 2006	Add additional error metrics for switch ports
# May  4, 2006	Update sql for the SUBSYSTEM_ID column in T_RES_PORT table
# May  8, 2006	Remove schema names from SQL stmnts
# May 12, 2006	update T_RES_CONFIG_DATA with extended indication filter list
# May 15, 2006	Add the view T_VIEW_COMPUTER_ATTRS
# May 16, 2006	Modified T_VIEW_COMPUTER_ATTRS: 
#             	Added " " (space) between NODE_HOSTED_ID and FROM
#             	DB2 creation did not recognize newline; concatenated 
#             	NODE_HOSTED_ID and FROM during schema install
# Jun  8, 2006	Update instructions
# Jun  9, 2006	Insert a config value to T_RES_CONFIG_DATA
# Jun  6, 2006	varchar column resizing
# Jun  6, 2006	update to view T_VIEW_ENTITY_TO_PORT used by topology viewer
# Jun 26, 2006	removed redundant view drop and fixed defect in update above
#*/



update t_schedule set start_hour = 4, start_minute = 30 where name = 'SQL_NAME_SNMP_DISCOVERY'
;

alter table t_res_tape_media_location add
    MediaTypesSupported             {1}  
;


################################################################
# All views are dropped in reverse sequence 

DROP VIEW T_VIEW_ENTITY_TO_PORT
;

DROP VIEW T_VIEW_PORTS_FROM_ENTITY   
;

DROP VIEW T_VIEW_ENTITY2PORT   
;  

DROP VIEW T_VIEW_ZONE2MEMBER   
; 

DROP VIEW T_VIEW_PORT2ZSET
;

DROP VIEW T_VIEW_PORT2ZONE
;

DROP VIEW T_VIEW_VHOST2SUBSYSTEM   
;  

DROP VIEW T_VIEW_VOTHER2FABRIC   
;  

DROP VIEW T_VIEW_VTAPE2FABRIC   
;  

DROP VIEW T_VIEW_VHOST2FABRIC   
; 

DROP VIEW T_VIEW_VSUBSYSTEM2FABRIC   
; 

DROP VIEW T_VIEW_VSWITCH2FABRIC   
; 

DROP VIEW T_VIEW_VSWITCH2OTHER   
; 

DROP VIEW T_VIEW_VSWITCH2HOST   
; 

DROP VIEW T_VIEW_VSWITCH2TAPE   
;


DROP VIEW T_VIEW_VSWITCH2SUBSYSTEM   
; 

DROP VIEW T_VIEW_VTAPE2PORT   
; 

DROP VIEW T_VIEW_VSUBSYSTEM2PORT   
; 

DROP VIEW T_VIEW_VHOST2PORT  
; 

DROP VIEW T_VIEW_VSWITCH2PORT  
;

DROP VIEW T_VIEW_VTAPE_LIBRARY
;

DROP VIEW T_VIEW_VSWITCH
;

DROP VIEW T_VIEW_VHOST
;

DROP VIEW T_VIEW_VSTORAGE_SUBSYSTEM
;

DROP VIEW T_VIEW_VOTHER2PORT
;

DROP VIEW T_VIEW_VOTHER
;

DROP VIEW T_VIEW_VUNKNOWN2PORT
;

DROP VIEW T_VIEW_VUNKNOWN
;
   
###############################################################
## TABLE: T_RES_TOPO_GLOBAL_SETTINGS
## KEYS: USERNAME, SETTING
###############################################################
CREATE TABLE T_RES_TOPO_GLOBAL_SETTINGS 
(VAL          {1}            NOT NULL,                        # T_RES_TOPO_GLOBAL_SETTINGS.VAL
 USERNAME     {23}           NOT NULL,                        # T_RES_TOPO_GLOBAL_SETTINGS.USERNAME
 SETTING      varchar(64)    NOT NULL                         # T_RES_TOPO_GLOBAL_SETTINGS.SETTING
){22}                               
;

ALTER TABLE T_RES_TOPO_GLOBAL_SETTINGS ADD PRIMARY KEY (USERNAME, SETTING)
;

###############################################################
## TABLE: T_RES_TMP_TOPOLOGY_ENTITY
## KEYS:
###############################################################
CREATE TABLE T_RES_TMP_TOPOLOGY_ENTITY (
 PREFIX_ID     	{23},
 ENTITY_ID 	{0},
 ID		{0}
){22}
;

UPDATE T_RES_CONFIG_DATA SET VALUE = 'VolumeStatistics;VolumeSpaceStatistics;FCPortStatistics;StorageExtentStatistics;FlashCopyStorageSynchronized;PerfomanceStatisticsService;ListenerDestinationCIMXML' WHERE ATTRIBUTE = 'Indication.FilterList'
;

INSERT INTO T_RES_CONFIG_DATA VALUES ('System.LocalIPAddress', 'NOT SET', 'DeviceServer')
;

################################################################  

CREATE VIEW T_VIEW_COMPUTER_ATTRS AS (  
  
SELECT	  
	h.GUID GUID, 
	h.HOST_URL HOST_URL,
	COALESCE(h.OS_TYPE, f.OS_TYPE) OS_TYPE,
	h.OS_VERSION OS_VERSION,
	h.NETWORK_NAME NETWORK_NAME,
	h.DOMAIN_NAME DOMAIN_NAME,
	COALESCE(h.COMPUTER_ID, f.FOUND_COMPUTER_ID) COMPUTER_ID,
	h.HOST_NAME HOST_NAME,
	h.HARDWARE_ID HARDWARE_ID,
	h.VENDOR_ID VENDOR_ID,
	h.TIME_ZONE TIME_ZONE,
	h.DISCOVERED_TIME DISCOVERED_TIME,
	h.PRODUCT_STATES PRODUCT_STATES,
	h.CPU_ARCHITECTURE CPU_ARCHITECTURE,
	h.ORIGINAL_ALIAS ORIGINAL_ALIAS,
	COALESCE(h.IP_ADDRESS, f.IP_ADDRESS) IP_ADDRESS,
	h.DETECTABLE DETECTABLE,
	h.OPERATIONAL_STATUS OPERATIONAL_STATUS,
	h.CONSOLIDATED_STATUS CONSOLIDATED_STATUS,
	h.PROPAGATED_STATUS PROPAGATED_STATUS,
	h.CHANGED_TIMESTAMP CHANGED_TIMESTAMP,
	h.UPDATE_TIMESTAMP UPDATE_TIMESTAMP,
	h.USER_ATTRIB1 USER_ATTRIB1,
	h.USER_ATTRIB2 USER_ATTRIB2,
	h.USER_ATTRIB3 USER_ATTRIB3,

	f.NAME NAME,
	f.DOMAIN_NAME WIN_DOMAIN_NAME,
	f.DISCOVERY_METHOD DISCOVERY_METHOD,
	f.NAME_IS_LOCAL NAME_IS_LOCAL,
	f.WHEN_DISCOVERED WHEN_DISCOVERED,
	f.TIMES_MISSING TIMES_MISSING,

	s.DOMAIN_ID DOMAIN_ID,
	s.GROUP_ID GROUP_ID,
	s.MANUFACTURER MANUFACTURER,
	s.MODEL MODEL,
	s.SERIAL_NUMBER SERIAL_NUMBER,
	s.PROCESSOR_TYPE PROCESSOR_TYPE,
	s.PROCESSOR_COUNT PROCESSOR_COUNT,
	s.PROCESSOR_SPEED PROCESSOR_SPEED,
	s.RAM RAM,
	s.SWAP_SPACE SWAP_SPACE,
	s.DISK_CAPACITY DISK_CAPACITY,
	s.FS_FREE_SPACE FS_FREE_SPACE,
	s.DISK_FREE_SPACE DISK_FREE_SPACE,
	s.LAST_BOOT_TIME LAST_BOOT_TIME,
	s.PROBE_STATUS PROBE_STATUS,
	s.LAST_PROBE_TIME LAST_PROBE_TIME,
	s.OWNED_DISK_CAP OWNED_DISK_CAP,
	s.OWNED_DISK_FREE_SP OWNED_DISK_FREE_SP,
	s.CLUSTER_ID CLUSTER_ID,
	s.NODE_HOSTED_ID NODE_HOSTED_ID 	
	
FROM   
	T_RES_HOST h 
	LEFT OUTER JOIN T_STAT_COMPUTER s ON s.COMPUTER_ID = h.COMPUTER_ID
	LEFT OUTER JOIN T_FOUND_COMPUTER f ON  f.FOUND_COMPUTER_ID = h.COMPUTER_ID 
UNION	
SELECT	  
	h.GUID GUID, 
	h.HOST_URL HOST_URL,
	COALESCE(h.OS_TYPE, f.OS_TYPE) OS_TYPE,
	h.OS_VERSION OS_VERSION,
	h.NETWORK_NAME NETWORK_NAME,
	h.DOMAIN_NAME DOMAIN_NAME,
	COALESCE(h.COMPUTER_ID, f.FOUND_COMPUTER_ID) COMPUTER_ID,
	h.HOST_NAME HOST_NAME,
	h.HARDWARE_ID HARDWARE_ID,
	h.VENDOR_ID VENDOR_ID,
	h.TIME_ZONE TIME_ZONE,
	h.DISCOVERED_TIME DISCOVERED_TIME,
	h.PRODUCT_STATES PRODUCT_STATES,
	h.CPU_ARCHITECTURE CPU_ARCHITECTURE,
	h.ORIGINAL_ALIAS ORIGINAL_ALIAS,
	COALESCE(h.IP_ADDRESS, f.IP_ADDRESS) IP_ADDRESS,
	h.DETECTABLE DETECTABLE,
	h.OPERATIONAL_STATUS OPERATIONAL_STATUS,
	h.CONSOLIDATED_STATUS CONSOLIDATED_STATUS,
	h.PROPAGATED_STATUS PROPAGATED_STATUS,
	h.CHANGED_TIMESTAMP CHANGED_TIMESTAMP,
	h.UPDATE_TIMESTAMP UPDATE_TIMESTAMP,
	h.USER_ATTRIB1 USER_ATTRIB1,
	h.USER_ATTRIB2 USER_ATTRIB2,
	h.USER_ATTRIB3 USER_ATTRIB3,

	f.NAME NAME,
	f.DOMAIN_NAME WIN_DOMAIN_NAME,
	f.DISCOVERY_METHOD DISCOVERY_METHOD,
	f.NAME_IS_LOCAL NAME_IS_LOCAL,
	f.WHEN_DISCOVERED WHEN_DISCOVERED,
	f.TIMES_MISSING TIMES_MISSING,

	s.DOMAIN_ID DOMAIN_ID,
	s.GROUP_ID GROUP_ID,
	s.MANUFACTURER MANUFACTURER,
	s.MODEL MODEL,
	s.SERIAL_NUMBER SERIAL_NUMBER,
	s.PROCESSOR_TYPE PROCESSOR_TYPE,
	s.PROCESSOR_COUNT PROCESSOR_COUNT,
	s.PROCESSOR_SPEED PROCESSOR_SPEED,
	s.RAM RAM,
	s.SWAP_SPACE SWAP_SPACE,
	s.DISK_CAPACITY DISK_CAPACITY,
	s.FS_FREE_SPACE FS_FREE_SPACE,
	s.DISK_FREE_SPACE DISK_FREE_SPACE,
	s.LAST_BOOT_TIME LAST_BOOT_TIME,
	s.PROBE_STATUS PROBE_STATUS,
	s.LAST_PROBE_TIME LAST_PROBE_TIME,
	s.OWNED_DISK_CAP OWNED_DISK_CAP,
	s.OWNED_DISK_FREE_SP OWNED_DISK_FREE_SP,
	s.CLUSTER_ID CLUSTER_ID,
	s.NODE_HOSTED_ID NODE_HOSTED_ID 	
	
FROM   	
	T_RES_HOST h 
	LEFT OUTER JOIN T_STAT_COMPUTER s ON s.COMPUTER_ID = h.COMPUTER_ID
	RIGHT OUTER JOIN T_FOUND_COMPUTER f ON  f.FOUND_COMPUTER_ID = h.COMPUTER_ID 
)  
;  

########################################################################
# 29169 changes
########################################################################

alter table t_res_storage_extent alter column element_name set data type varchar(256)
;

alter table t_res_storage_extent alter column display_name set data type varchar(256)
;

alter table t_res_storage_extent alter column device_id set data type varchar(256)
;

alter table t_res_storage_pool alter column raid_level set data type varchar(256)
;

alter table t_res_storage_volume alter column name set data type varchar(256)
;

alter table t_res_storage_volume alter column display_name set data type varchar(256)
;

alter table t_res_host alter column domain_name set data type varchar(255)
;

alter table t_res_physical_volume alter column device_id set data type varchar(256)
;

alter table t_res_physical_volume alter column name set data type varchar(256)
;

alter table t_res_physical_volume alter column display_name set data type varchar(256)
;

alter table t_res_masking_info alter column host_element_name set data type varchar(256)
;

alter table t_res_data_path alter column unknown_host_name set data type varchar(256)
;

alter table t_res_registered_cimom alter column interop_schema_namespace set data type varchar(256)
;

ALTER TABLE T_RES_CLUSTER ALTER COLUMN IP_ADDRESS SET DATA TYPE VARCHAR (255) 
;


# First batch of changes to convert some hard-hit views to tables

###
## change t_res_view_ssluncmp to a regular table
###
drop view t_res_view_ssluncmp
;

create table t_res_view_ssluncmp (
 computer_id {0},
 subsystem_id {0},
 physical_volume_id {0},
 lun_id varchar(255),
 svid {0}) {22}
;

##
# create t_res_comp2lun table to be used for COMPUTER_TO_LUN
# report in RptEndToEnd.java
##

create table t_res_comp2lun
 (sd_disk_id {0},
 host_name varchar(250),
 da_path varchar(256),
 ss_os_type {1},
 ss_display_name varchar(255),
 ss_name varchar(255),
 ss_vendor_id {0},
 ss_vendor_name varchar(128),
 pv_serial_number varchar (255),
 sd_capacity decimal(13),
 sdh_free_space decimal(13),
 sv_unique_id varchar(255),
 sv_display_name varchar(256),
 cimv_device_id varchar(255),
 computer_id {0},
 subsystem_id {0},
 physical_volume_id {0},
 agtlun_id varchar(255))  {22}
;


##
# create t_res_lv2lun table to be used for LV_SIMPLE_TO_LUN
# report in RptEndToEnd.java
##
 create table t_res_lv2lun
 (logical_disk_id   {0} ,
 physical_volume_id {0},
 host_name varchar(250),
 ss_vendor_name varchar(128),
 ld_capacity  decimal(13),
 da_path varchar(256),
 ss_os_type {1},
 ss_display_name varchar(255),
 ss_name varchar(255),
 agtlun_id varchar(255),
 sd_capacity decimal(13),
 sv_unique_id varchar(255),
 sv_display_name varchar(256),
 cimv_device_id varchar(255),
 computer_id {0},
 subsystem_id {0} ) {22}
;

##
# create t_res_fs2lun table to be used for FILESYSTEM_SIMPLE_TO_LUN
# report in RptEndToEnd.java
##

create table t_res_fs2lun
 (logical_disk_id   {0}, 
 sd_disk_id {0},
 host_name varchar(250), 
 ss_vendor_name varchar(128),
 mount_point varchar(256), 
 fs_capacity decimal(13),
 fs_free_space decimal(13),
 filesystem_id {0},
 da_path varchar(256),
 ss_os_type {1},
 ss_display_name varchar(255),
 ss_name varchar(255),
 agtlun_id varchar(255),
 sd_capacity decimal(13),
 sv_unique_id varchar(255),
 sv_display_name varchar(256),
 cimv_device_id varchar(255),
 computer_id {0},
 subsystem_id {0} ) {22}
;

#stage 1 in view 2 table modifications...

create table T_VIEW_VUNKNOWN (
  PREFIX_ID  			VARCHAR(5),
  UNKNOWN_ID 			{0},
  DISPLAY_NAME 			VARCHAR(255),
  WWN				VARCHAR(255),
  ACCESS_INFO			VARCHAR(255),
  SERIAL_NUMBER			VARCHAR(255),
  MODEL_ID			{1},
  VENDOR_ID			{1},
  DETECTABLE			{1},
  PROPAGATED_STATUS 		{0},
  OTHER_TYPE			{0}) {22}
;

create table T_VIEW_VUNKNOWN2PORT (
  PREFIX_ID			VARCHAR(5),
  UNKNOWN_ID			{0},
  PORT_ID			{0}) {22}
;

create table T_VIEW_VOTHER (
  OTHER_ID			{0},
  PREFIX_ID			VARCHAR(5),
  UNKNOWN_ID			{0},
  DISPLAY_NAME			VARCHAR(255),
  WWN				VARCHAR(255),
  ACCESS_INFO			VARCHAR(255),
  SERIAL_NUMBER			VARCHAR(255),
  MODEL_ID			{1},
  VENDOR_ID			{1},
  DETECTABLE			{1},
  PROPAGATED_STATUS		{0},
  OTHER_TYPE			{0}) {22}
;


create table T_VIEW_VOTHER2PORT (
  PREFIX_ID			VARCHAR(5),
  OTHER_ID			{0},
  PORT_ID			{0}) {22}
;


create table T_VIEW_VSTORAGE_SUBSYSTEM (
  PREFIX_ID			VARCHAR(10),
  SUBSYSTEM_ID			{0},
  ALLOCATED_CAPACITY		BIGINT,
  AVAILABLE_CAPACITY		BIGINT,
  BACKEND_STORAGE_CAPACITY	BIGINT,
  VENDOR_ID			{1},
  MODEL_ID			{1},
  NAME				VARCHAR(255),
  NAME_FORMAT			{1},
  CACHE				BIGINT,
  OS_TYPE			{1},
  TYPE				VARCHAR(255),
  IP_ADDRESS			VARCHAR(255),
  CODE_LEVEL			VARCHAR(255),
  SERIAL_NUMBER			VARCHAR(255),
  DISPLAY_NAME			VARCHAR(255),
  USER_PROVIDED_NAME		VARCHAR(255),
  DETECTABLE			{1},
  OPERATIONAL_STATUS		{0},
  CONSOLIDATED_STATUS		{1},
  PROPAGATED_STATUS		{0},
  USER_ATTRIB1			VARCHAR(255),
  USER_ATTRIB2			VARCHAR(255),
  USER_ATTRIB3			VARCHAR(255),
  ACCESS_INFO			VARCHAR(255)) {22}
;

create table T_VIEW_VHOST (
  PREFIX_ID			VARCHAR(7),
  COMPUTER_ID			{0},
  HOST_URL			VARCHAR(255),
  HOST_NAME			VARCHAR(255),
  GUID				CHAR(47),
  OS_TYPE			{1},
  OS_VERSION			VARCHAR(255),
  TIME_ZONE			VARCHAR(64),
  IP_ADDRESS			VARCHAR(255),
  DETECTABLE			{1},
  OPERATIONAL_STATUS		{0},
  CONSOLIDATED_STATUS		{1},
  PROPAGATED_STATUS		{0},
  USER_ATTRIB1			VARCHAR(255),
  USER_ATTRIB2			VARCHAR(255),
  USER_ATTRIB3			VARCHAR(255),
  DEV_STATUS			CHAR(5),
  DAT_STATUS			VARCHAR(2)) {22}
;

create table T_VIEW_VSWITCH (
  PREFIX_ID			VARCHAR(7),
  SWITCH_ID			{0},
  DISPLAY_NAME			VARCHAR(255),
  LOGICAL_NAME			VARCHAR(255),
  SWITCH_WWN			CHAR(16),
  SERIAL_NUMBER			VARCHAR(255),
  DESCRIPTION			VARCHAR(255),
  IP_ADDRESS			VARCHAR(255),
  DOMAIN			VARCHAR(128),
  VERSION			VARCHAR(255),
  MODEL_ID			{1},
  VENDOR_ID			{1},
  PARENT_SWITCH_WWN		CHAR(16),
  MGMT_URL_ADDR			VARCHAR(255),
  DETECTABLE			{1},
  OPERATIONAL_STATUS		{0},
  CONSOLIDATED_STATUS		{1},
  PROPAGATED_STATUS		{1},
  USER_ATTRIB1			VARCHAR(255),
  USER_ATTRIB2			VARCHAR(255),
  USER_ATTRIB3			VARCHAR(255)) {22}
;

create table T_VIEW_VTAPE_LIBRARY (
  PREFIX_ID			VARCHAR(12),
  TAPE_LIBRARY_ID		{0},
  DISPLAY_NAME			VARCHAR(255),
  NAME				VARCHAR(255),
  FIRMWARE_VERSION		VARCHAR(255),
  MAX_CARTRIDGES		{0},
  VENDOR_ID			{1},
  MODEL_ID			{1},
  SERIAL_NUMBER			VARCHAR(255),
  ACCESS_INFO			VARCHAR(255),
  DETECTABLE			{1},
  OPERATIONAL_STATUS		{0},
  CONSOLIDATED_STATUS		{1},
  PROPAGATED_STATUS		{1},
  TOTAL_DRIVES			{0},
  TOTAL_CARTRIDGES		{0},
  USER_PROVIDED_NAME		VARCHAR(255),
  USER_ATTRIB1			VARCHAR(255),
  USER_ATTRIB2			VARCHAR(255),
  USER_ATTRIB3			VARCHAR(255)) {22}
;

create table T_VIEW_VHOST2PORT (
  PREFIX_ID			VARCHAR(7),
  HOST_ID			{0},
  PORT_ID			{0}) {22}
;

create table T_VIEW_VSUBSYSTEM2PORT (
  PORT_ID			{0},
  PREFIX_ID			VARCHAR(10),
  SUBSYSTEM_ID			{0}) {22}
;

create table T_VIEW_VSWITCH2PORT (
  PORT_ID			{0},
  PREFIX_ID			VARCHAR(7),
  SWITCH_ID			{0}) {22}
;

create table T_VIEW_VTAPE2PORT (
  PORT_ID			{0},
  PREFIX_ID			VARCHAR(12),
  TAPE_LIBRARY_ID		{0}) {22}
;

create table T_VIEW_VSWITCH2SUBSYSTEM (
  SUBSYSTEM_PREFIX_ID		VARCHAR(10),
  SUBSYSTEM_ID			{0},
  SUBSYSTEM_PORT_ID		{0},
  SWITCH_PORT_ID		{0},
  SWITCH_PREFIX_ID		VARCHAR(7),
  SWITCH_ID			{0},
  DETECTABLE			{1},
  PORT2PORT_ID			{0}) {22}
;

create table T_VIEW_VSWITCH2HOST (
  HOST_PREFIX_ID		VARCHAR(7),
  HOST_ID			{0},
  HOST_PORT_ID			{0},
  SWITCH_PREFIX_ID		VARCHAR(7),
  SWITCH_ID			{0},
  PORT2PORT_ID			{0},
  DETECTABLE			{1},
  SWITCH_PORT_ID		{0}) {22}
;

create table T_VIEW_VSWITCH2OTHER (
  OTHER_ID			{0},
  OTHER_PREFIX_ID		VARCHAR(5),
  OTHER_PORT_ID			{0},
  SWITCH_PORT_ID		{0},
  PORT2PORT_ID			{0},
  DETECTABLE			{1},
  SWITCH_PREFIX_ID		VARCHAR(7),
  SWITCH_ID			{0}) {22}
;

create table T_VIEW_VSWITCH2TAPE (
  TAPE_PREFIX_ID		VARCHAR(12),
  TAPE_LIBRARY_ID		{0},
  TAPE_PORT_ID			{0},
  SWITCH_PREFIX_ID		VARCHAR(7),
  SWITCH_PORT_ID		{0},
  SWITCH_ID			{0},
  DETECTABLE			{1},
  PORT2PORT_ID			{0}) {22}
;

create table T_VIEW_VSWITCH2FABRIC (
  PREFIX_ID			VARCHAR(7),
  SWITCH_ID			{0},
  FABRIC_ID			{0}) {22}
;

create table T_VIEW_VHOST2FABRIC (
  PREFIX_ID			VARCHAR(7),
  HOST_ID			{0},
  FABRIC_ID			{0}) {22}
;

create table T_VIEW_VOTHER2FABRIC (
  OTHER_ID			{0},
  PREFIX_ID			VARCHAR(5),
  FABRIC_ID			{0}) {22}
;

create table T_VIEW_VSUBSYSTEM2FABRIC (
  PREFIX_ID			VARCHAR(10),
  SUBSYSTEM_ID			{0},
  FABRIC_ID			{0}) {22}
;


create table T_VIEW_VTAPE2FABRIC (
  PREFIX_ID			VARCHAR(12),
  TAPE_LIBRARY_ID		{0},
  FABRIC_ID			{0}) {22}
;

create table T_VIEW_VHOST2SUBSYSTEM (
  HOST_PREFIX_ID		VARCHAR(7),
  HOST_ID			{0},
  HOST_PORT_ID			{0},
  SUBSYSTEM_PREFIX_ID		VARCHAR(10),
  SUBSYSTEM_ID			{0},
  SUBSYSTEM_PORT_ID		{0},
  PORT2PORT_ID			{0},
  DETECTABLE			{1}) {22}
;

create table T_VIEW_ENTITY2PORT (
  TYPE				VARCHAR(12),
  PORT_ID			{0},
  PREFIX_ID			VARCHAR(12),
  ENTITY_ID			{0}) {22}
;

create table T_VIEW_ENTITY_TO_PORT (
  TYPE				VARCHAR(12),
  PORT_ID			{0},
  PREFIX_ID			VARCHAR(12),
  ENTITY_ID			{0},
  DISPLAY_NAME			VARCHAR(255),
  PORT_NUMBER			VARCHAR(8),
  PORT_DISPLAY_NAME		VARCHAR(255)) {22}
;

CREATE VIEW T_VIEW_PORT2ZONE AS (	
SELECT  
    MEMBER.ZONE_MEMBER_ID, 	 MEMBER.MEMBER_NAME,     PORT.PORT_ID, 
    MEMBER2ZONE.ZONE_ID 
FROM 
    T_VIEW_MEMBER2ZONE MEMBER2ZONE, 	 T_RES_ZONE_MEMBER MEMBER left outer join T_RES_PORT PORT on 
    MEMBER.MEMBER_NAME = PORT.NAME 
WHERE 
    (MEMBER.TYPE = 11 or MEMBER.TYPE = 10) and 
	 MEMBER.ZONE_MEMBER_ID = MEMBER2ZONE.ZONE_MEMBER_ID 
UNION 
SELECT   
    MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME,  
    MEMBER2PORT.PORT_ID, 
    MEMBER2ZONE.ZONE_ID  
FROM   
    T_RES_ZONE_MEMBER MEMBER left outer join ( 
	SELECT MEMBER2ZONE.ZONE_MEMBER_ID, MEMBER2ZONE.ZONE_ID, PORT.PORT_ID, SWITCH.DOMAIN || ',' || PORT.PORT_NUMBER DOMAIN_PORT 
	FROM 
	  T_VIEW_MEMBER2ZONE MEMBER2ZONE, T_RES_ZONE ZONE, T_RES_FABRIC2SWITCH FABRIC2SWITCH, 
	  T_RES_SWITCH SWITCH, T_VIEW_VSWITCH2PORT SWITCH2PORT, T_RES_PORT PORT 
	WHERE 
    	  MEMBER2ZONE.ZONE_ID = ZONE.ZONE_ID and   
    	  ZONE.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN and  
    	  FABRIC2SWITCH.SWITCH_WWN = SWITCH.SWITCH_WWN and   
    	  SWITCH.SWITCH_ID = SWITCH2PORT.SWITCH_ID and  
    	  SWITCH2PORT.PORT_ID = PORT.PORT_ID and 		  SWITCH2PORT.PREFIX_ID = 'switch:' 
	) MEMBER2PORT on  
MEMBER.ZONE_MEMBER_ID = MEMBER2PORT.ZONE_MEMBER_ID and  
MEMBER.MEMBER_NAME = DOMAIN_PORT, T_VIEW_MEMBER2ZONE MEMBER2ZONE 
WHERE   
MEMBER.TYPE = 12  and 
MEMBER.ZONE_MEMBER_ID = MEMBER2ZONE.ZONE_MEMBER_ID  
UNION 
SELECT 
    MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME,     PORT.PORT_ID, 
    MEMBER2ZONE.ZONE_ID 
FROM 
    T_VIEW_MEMBER2ZONE MEMBER2ZONE, 
    T_RES_ZONE_MEMBER MEMBER left outer join T_RES_PORT PORT on 
	 MEMBER.MEMBER_NAME = RTRIM(CAST(PORT.FC_PORT_ID AS CHAR(16))) 
WHERE 
    MEMBER2ZONE.ZONE_MEMBER_ID = MEMBER.ZONE_MEMBER_ID and 
    MEMBER.TYPE = 13 
UNION 
SELECT  
    MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME,   
    NODE2PORT.PORT_ID,  
    MEMBER2ZONE.ZONE_ID  
FROM  
    T_VIEW_MEMBER2ZONE MEMBER2ZONE,  
    T_RES_ZONE_MEMBER MEMBER left outer join (SELECT NODE.NAME, PORT.PORT_ID FROM T_RES_NODE NODE, T_RES_PORT PORT 
	WHERE 
	 NODE.NODE_ID = PORT.NODE_ID ) NODE2PORT on 
    MEMBER.MEMBER_NAME = NODE2PORT.NAME    
WHERE  
    MEMBER2ZONE.ZONE_MEMBER_ID = MEMBER.ZONE_MEMBER_ID and  
    MEMBER.TYPE = 14 
UNION 
SELECT 
    MEMBER.ZONE_MEMBER_ID,     MEMBER.MEMBER_NAME, 	 SWITCH2PORT.PORT_ID, 
    MEMBER2ZONE.ZONE_ID 
FROM 
    T_VIEW_MEMBER2ZONE MEMBER2ZONE, 
    T_RES_ZONE_MEMBER MEMBER left outer join (SELECT SWITCH.SWITCH_WWN, SWITCH2PORT.PORT_ID FROM  T_VIEW_VSWITCH2PORT SWITCH2PORT, T_RES_SWITCH SWITCH 
	 WHERE SWITCH2PORT.SWITCH_ID = SWITCH.SWITCH_ID	 	AND SWITCH2PORT.PREFIX_ID = 'switch:') SWITCH2PORT on 
	 MEMBER.MEMBER_NAME = SWITCH2PORT.SWITCH_WWN 
WHERE 
    MEMBER2ZONE.ZONE_MEMBER_ID = MEMBER.ZONE_MEMBER_ID and 
    MEMBER.TYPE = 16 

)
;

CREATE VIEW T_VIEW_PORT2ZSET AS (

	
SELECT 
	PORT2ZONE.PORT_ID PORT_ID, 
   PORT2ZONE.ZONE_ID ZONE_ID, 
   ZSET2ZONE.ZSET_ID ZSET_ID 
FROM 
T_VIEW_PORT2ZONE PORT2ZONE, T_RES_ZSET2ZONE ZSET2ZONE 
WHERE 
    PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID
)
;


##***********************************************************
## Tables related to snapshot requirements
##***********************************************************

###############################################################
## TABLE: T_RES_SNAPSHOT_METADATA
###############################################################
CREATE TABLE T_RES_SNAPSHOT_METADATA
(SNAPSHOT_ID          {0} NOT NULL,                                # Auto-generated ID
 SNAPSHOT_TIME        {3} NOT NULL,                                # Timestamp when snapshot was created
 SYSTEM_ID            {0},                                         # ID of system whose snapshot was taken
 SYSTEM_TYPE          {1},                                         # Type of system 
 SNAPSHOT_CONSISTENT  {1},                                         # Indicates whether the snapshot was completed in a consistent fashion or not
 SNAPSHOT_TYPE        {1} NOT NULL) {121}                          # Type of snapshot
;

ALTER TABLE T_RES_SNAPSHOT_METADATA ADD PRIMARY KEY (SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_STORAGE_SUBSYSTEM_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, VENDOR_ID, MODEL_ID, 
## SUBSYSTEM_ID 
###############################################################
CREATE TABLE T_RES_STORAGE_SUBSYSTEM_SNAPSHOT
(SNAPSHOT_ID               {0} NOT NULL,                       # Snapshot ID 
 SUBSYSTEM_ID              {0}      NOT NULL,                  # Auto-generated ID
 ALLOCATED_CAPACITY        BIGINT,                             # Total storage capacity already used
 AVAILABLE_CAPACITY        BIGINT,                             # Total storage capacity available for allocation
 BACKEND_STORAGE_CAPACITY  BIGINT,                             # Total backend disk storage capacity
 VENDOR_ID                 {1} DEFAULT 0 NOT NULL,             # Vendor. Normalized Key
 MODEL_ID                  {1} DEFAULT 0 NOT NULL,             # Model. Normalized Key
 NAME                      VARCHAR (255) NOT NULL,             # Name of subsystem 
                                                               # Natural Key. 
                                                               # Example: For ESS, NAME = 2105.21974, 
                                                               #          NAME_FORMAT = Normalized key representing Other
                                                               # For SVC, NAME = 9.11.213.191:0000020060400A8A, 
                                                               #          NAME_FORMAT = Normalized key representing Other
                                                               # Example: Normalized key representing Other, IP, WWN, NAA
 NAME_FORMAT               {1}           NOT NULL,             # Name format of subsystem
 CACHE                     BIGINT,                             # Total cache (MB) of subsystem
 NVS                       BIGINT,                             # Non-volatile storage (MB) of subsystem
 DG_FREESPACE              BIGINT,                             # Free space of disk groups
 N_DISKS                   {0},                                # Number of disks
 N_LUNS                    {0},                                # Number of LUNs
 LAST_PROBE_TIME           {3},                                # Last probe time of subsystem
 PROBE_STATUS              CHAR(5),                            # Last probe status of subsystem
 GROUP_ID                  {0} DEFAULT 8 NOT NULL,             # ID of group that subsystem belongs to
 PROBING_HOST_ID           {0},                                # Host that detects the subsystem 
 VG_CAPACITY               BIGINT,                             # Capacity of Volume Groups
 VG_FREESPACE              BIGINT,                             # Free space of Volume Groups
 OS_TYPE                   {1},                                # Type of storage subsystem 
 PRODUCT_STATES            VARCHAR(20),                        #
 TYPE                      VARCHAR (255),                      # Type of subsystem
 IP_ADDRESS                VARCHAR(255),                       # IP Address of subsystem
 CODE_LEVEL                VARCHAR(255),                       # Code Level of subsystem
 SERIAL_NUMBER             VARCHAR (255),                      # Serial Number
 PHYSICAL_PACKAGE_ID       {0},                                # ID of physical package that the subsystem belongs to 
 LGLDISK_ASSIGNED_CAPACITY DECIMAL(13) DEFAULT -1 NOT NULL,    # 
 LUN_CAPACITY_ZOS          DECIMAL(13) DEFAULT -1 NOT NULL,    #
 DISPLAY_NAME              VARCHAR(128),                       # Display name derived from other colums and formatted according to specifications
 DETECTABLE                {1},                                # Whether the storage subsystem is detectable or not
 OPERATIONAL_STATUS        {0},                                # Operation status of the storage subsystem
 CONSOLIDATED_STATUS       {1},                                # Consolidated status for display in the GUI
 PROPAGATED_STATUS         {1},                                # Propagated status of all entities below the subsystem
 USER_ATTRIB1              VARCHAR(255),                       # User-defined attribute
 USER_ATTRIB2              VARCHAR(255),                       # User-defined attribute
 USER_ATTRIB3              VARCHAR(255),                       # User-defined attribute
 CHANGED_TIMESTAMP         {3},                                # Timestamp when this data was last updated
 ACCESS_INFO               VARCHAR(255),                       #
 USER_PROVIDED_NAME        VARCHAR(255),                       # User-provided name. Maps to CIM attribute ELEMENT_NAME.
 USER_PROVIDED_LOCATION    VARCHAR(255),                       # User-provided location
 COLLECTION_STATUS         {0},                                # Bit-encoded status of the data collection  
 UPDATE_TIMESTAMP          {3},                                # Timestamp when this data was last updated by a scan
 TIME_ZONE                 VARCHAR(64)) {22}                   # Time zone of the subsystem
;

ALTER TABLE T_RES_STORAGE_SUBSYSTEM_SNAPSHOT ADD PRIMARY KEY 
 (NAME, NAME_FORMAT, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_SUBSNAP_SSSNAPID ON T_RES_STORAGE_SUBSYSTEM_SNAPSHOT
 (SUBSYSTEM_ID, SNAPSHOT_ID)
;

###############################################################        
## T_RES_VENDOR_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, VENDOR_ID 
###############################################################        
CREATE TABLE T_RES_VENDOR_SNAPSHOT
(SNAPSHOT_ID        {0} NOT NULL,                              # Snapshot ID
 VENDOR_ID          {1} NOT NULL,                              # Auto-generated ID
 VENDOR_NAME        VARCHAR (128) NOT NULL,                    # Name of vendor
 VENDOR_DESCRIPTION VARCHAR (255)) {22}                        # Description
;

ALTER TABLE T_RES_VENDOR_SNAPSHOT ADD PRIMARY KEY (VENDOR_NAME, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_VSNAP_VSNAPID ON T_RES_VENDOR_SNAPSHOT (VENDOR_ID, SNAPSHOT_ID)
;

###############################################################        
## T_RES_MODEL_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, MODEL_ID 
###############################################################        
CREATE TABLE T_RES_MODEL_SNAPSHOT
(SNAPSHOT_ID       {0} NOT NULL,                               # Snapshot ID
 MODEL_ID          {1} NOT NULL,                               # Auto-generated ID
 MODEL_NAME        VARCHAR (128) NOT NULL,                     # Name of model
 MODEL_DESCRIPTION VARCHAR (255)) {22}                         # Description
;

ALTER TABLE T_RES_MODEL_SNAPSHOT ADD PRIMARY KEY (MODEL_NAME, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_MSNAP_MSNAPID ON T_RES_MODEL_SNAPSHOT (MODEL_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_STORAGE_POOL_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, POOL_ID
###############################################################
CREATE TABLE T_RES_STORAGE_POOL_SNAPSHOT 
(SNAPSHOT_ID                  {0} NOT NULL,                    # Snapshot ID
 POOL_ID                      {0} NOT NULL,                    # Auto-generated ID
 TOTAL_MANAGED_SPACE          BIGINT,                          # Total managed space in the pool
 REMAINING_MANAGED_SPACE      BIGINT,                          # Space available for use in the pool
 PRIMORDIAL                   {1},                             # Whether the pool is primordial or not
 CAPACITY                     DOUBLE PRECISION,                # Capacity of the storage pool
 EXTENT_SIZE                  {0},                             # Size of extents in pool
 NATIVE_STATUS                {1},                             # Native status of the pool
 NUMBER_OF_BACKEND_VOLUMES    {0},                             # Number of backend disks
 NUMBER_OF_STORAGE_VOLUMES    {0},                             # Number of storage volumes
 TOTAL_AVAILABLE_SPACE        BIGINT,                          # Total available space on the pool
 ELEMENT_TYPE                 {1},                             # Type of storage pool
 RAID_LEVEL                   VARCHAR(32),                     # RAID level of pool
 INSTANCE_ID                  VARCHAR(255) NOT NULL,           # CIM Key: Instance ID
 SUBSYSTEM_ID                 {0} NOT NULL,                    # CIM Key: ID of storage subsystem that the pool belongs to
 VOL_GROUP_TYPE               {1},                             # 
 LSS                          {0},                             # ESS/DS LSS. Data Legacy
 CONFIG                       {1},                             #
 DISK_GROUP_ID                {0},                             # 
 FORMAT                       {1},                             #
 SURFACED_LUN_CAP             BIGINT,                          #
 UNSURFACED_LUN_CAP           BIGINT,                          # 
 DISCOVERED_TIME              {3},                             # Time when pool was first discovered. Data Legacy
 LAST_PROBE_TIME              {3},                             # Time when pool was last probed. Data Legacy
 DETECTABLE                   {1},                             # Whether the pool is detectable or not
 OPERATIONAL_STATUS           {0},                             # Operational status of pool 
 CONSOLIDATED_STATUS          {1},                             # Consolidated status for GUI display
 PROPAGATED_STATUS            {1},                             # Propagated status of all entities below the pool
 USER_ATTRIB1                 VARCHAR(255),                    # User-defined attribute
 USER_ATTRIB2                 VARCHAR(255),                    # User-defined attribute
 USER_ATTRIB3                 VARCHAR(255),                    # User-defined attribute
 UPDATE_TIMESTAMP             {3},                             # Timestamp when this data was last updated by a scan
 NAME                         VARCHAR(255),                    # Name of pool
 DATA_REDUNDANCY_MIN          {0},                             # Minimum data redundancy
 DATA_REDUNDANCY_MAX          {0},                             # Maximum data redundancy
 DATA_REDUNDANCY_DEF          {0},                             # Default data redundancy
 PCK_REDUNDANCY_MIN           {0},                             # Minimum package redundancy
 PCK_REDUNDANCY_MAX           {0},                             # Maximum package redundancy
 PCK_REDUNDANCY_DEF           {0},                             # Default package redundancy
 DELTA_RES_MIN                {0},                             # Minimum delta reservation
 DELTA_RES_MAX                {0},                             # Maximum delta reservation
 DELTA_RES_DEF                {0},                             # Default delta reservation
 DISPLAY_NAME                 VARCHAR(255),                    # Display name derived from other colums and formatted according to specifications
 RANK_GROUP                   {1},                             # Represents the rank group that the pool belongs to in a DS system, for e.g. server0 or server1
 CLASS_NAME_ID                {1} NOT NULL) {22}               # "LSISSI_StorageVolume" for a FAStT and "IBMTSESS_VolumeSpace" for ESS 
;

ALTER TABLE T_RES_STORAGE_POOL_SNAPSHOT ADD PRIMARY KEY 
 (SUBSYSTEM_ID, INSTANCE_ID, SNAPSHOT_ID, CLASS_NAME_ID)
;

CREATE UNIQUE INDEX I_SPSNAP_SPSNAPID ON T_RES_STORAGE_POOL_SNAPSHOT
 (POOL_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_STORAGE_VOLUME_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, SVID
###############################################################
CREATE TABLE T_RES_STORAGE_VOLUME_SNAPSHOT 
(SNAPSHOT_ID                 {0} NOT NULL,                     # Snapshot ID
 SVID                        {0}  NOT NULL,                    # Auto-generated ID
 CAPACITY                    BIGINT,                           # Size of volume
 PACKAGE_REDUNDANCY          {1},                              # Package redundancy
 DATA_REDUNDANCY             {1},                              # Data redundancy
 SIZE_ALLOCATED              REAL,                             # Total size allocated 
 BLOCK_SIZE                  BIGINT,                           # Block size 
 CONSUMABLE_BLOCKS           BIGINT,                           # Number of consumable blocks 
 NATIVE_STATUS               {1},                              # Native status 
 NUMBER_OF_BLOCKS            BIGINT,                           # Total number of blocks 
 THROTTLE                    BIGINT,                           # Throttle for VDisk 
 VDISK_TYPE                  {1},                              # Type of VDisk
 NAME                        VARCHAR (255)   NOT NULL,         # Name of volume in the format specified in column NAME_FORMAT 
                                                               # Example: For ESS, NAME = 0A02, 
                                                               #          NAME_FORMAT = Normalized key representing Other 
                                                               # For SVC, NAME = 3, 
                                                               # NAME_FORMAT = Normalized key representing Other
 NAME_FORMAT                 {1}             NOT NULL,         # Name format of volume 
                                                               # Example: Normalized key representing Unknown, Other, VPD83NAA6, VPD83NAA5, 
                                                               # VPD83Type2, VPD83Type1, VPD83Type0, SNVM, NodeWWNNAA, EUI64, T10VID   
 SUBSYSTEM_ID                {0}             NOT NULL,         # ID of the volumes storage subsystem
 POOL_ID                     {0},                              # ID of the volumes storage pool
 LOGICAL_DISK_TYPE           CHAR(5),                          # Type of the volumes logical disk. Data Legacy
 MIRROR_COUNT                {1},                              # Mirror count. Data Legacy
 IS_SWAP                     CHAR(5),                          # Is volume used for swap or not. Data Legacy
 USE_COUNT                   {1},                              # Number of users of volumes. Data Legacy
 SNAP_SOURCE_ID              {0} DEFAULT -1,                   #      
 IS_VCMDB                    CHAR(5) DEFAULT '0',              # 
 REPLICATION_MODE            CHAR(5) DEFAULT '0',              # 
 NOT_EXPOSED                 CHAR(5),                          # 
 OVERHEAD                    BIGINT,                           # 
 LUN_IDENTITY                CHAR(5) DEFAULT '0' NOT NULL,     #
 LSS                         {0},                              # ESS/DS LSS (required for replication)
 SERIAL_NUMBER               VARCHAR (255),                    # Serial Number 
 DISPLAY_NAME                VARCHAR(128),                     # Display name derived from other colums and formatted according to specifications
 VCID                        {0},                              # Volume Container ID
 DETECTABLE                  {1},                              # Whether the volume is detectable or not
 OPERATIONAL_STATUS          {0},                              # Operational status of the volume
 CONSOLIDATED_STATUS         {1},                              # Consolidated status for GUI display
 USER_ATTRIB1                VARCHAR(255),                     # User-defined attribute
 USER_ATTRIB2                VARCHAR(255),                     # User-defined attribute
 USER_ATTRIB3                VARCHAR(255),                     # User-defined attribute
 UPDATE_TIMESTAMP            {3},                              # Timestamp when this data was last updated by a scan
 UNDERLYING_REDUNDANCY       {1},                              # 
 DELTA_RESERVATION           {0},                              #
 IO_GROUP_ID                 {0},                              # ID of IO group that the volume belongs to
 REDUNDANCY                  {1},                              # More specific information about redundancy
 LOGICAL_CAPACITY            BIGINT,                           # Logical capacity of volume
 LOGICAL_FREE                BIGINT,                           # Remaining logical capacity of volume
 FORMAT                      {1},                              # Format of volume e.g. FB, CKD, etc.
 IS_ASSIGNED                 {1},                              # Whether the volume is assigned to some host or not
 FLASH_COPY_ID               VARCHAR(64),                      # Flash Copy ID
 FLASH_COPY_NAME             VARCHAR(64),                      # Flash Copy Name
 METRO_MIRROR_ID             VARCHAR(64),                      # Metro Mirror ID
 METRO_MIRROR_NAME           VARCHAR(64),                      # Metro Mirror Name
 FAST_WRITE_STATE            {0},                              # Cache state of volume. e.g. Empty, Non-Empty or Corrupt
 PREFERRED_NODE              VARCHAR(64),                      # 
 UNIQUE_ID                   VARCHAR(255),                     #
 MDISK_ID                    {0},                              # Points to the corresponding SVC MDisk if there is one
 IS_FORMATTED                {1},                              # Whether the VDisk is formatted or not
 ELEMENT_NAME                VARCHAR(255),                     # User-provided name. Maps to CIM attribute ELEMENT_NAME.
 NO_SINGLE_PT_FAILURE        {1},                              # Indicates if the volume has a single point of failure 
 VOLUME_NUMBER               {1}) {22}                         # Represents thr volume number with an LSS
;

ALTER TABLE T_RES_STORAGE_VOLUME_SNAPSHOT ADD PRIMARY KEY 
 (NAME, NAME_FORMAT, SUBSYSTEM_ID, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_SVSNAP_SVSNAPID ON T_RES_STORAGE_VOLUME_SNAPSHOT
 (SVID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_PORT_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, PORT_ID
###############################################################
CREATE TABLE T_RES_PORT_SNAPSHOT
(SNAPSHOT_ID              {0} NOT NULL,                        # Snapshot ID
 PORT_ID                  {0} NOT NULL,                        # Auto-generated ID
 NAME                     VARCHAR(255) NOT NULL,               # Name of port e.g. WWN
 NAME_FORMAT              {1} NOT NULL,                        # Name format of port. e.g. FC WWN, iSCSI
 PORT_NUMBER              VARCHAR(8),                          # Port number
 TYPE                     {1} DEFAULT 1 NOT NULL,              # Type of port
 NODE_ID                  {0},                                 # ID of node that the port belongs to
 DISPLAY_NAME             VARCHAR (64),                        # User-provided name
 DISPLAY_ICON_TYPE        {1},                                 # Display icon type
 RIO_LOOP_ID              {0},                                 # RIO loop ID that the port belongs to
 DETECTABLE               {1},                                 # Whether the port is detectable or not
 OPERATIONAL_STATUS       {0},                                 # Operational status of the port
 CONSOLIDATED_STATUS      {1},                                 # Consolidated status for GUI display
 UPDATE_TIMESTAMP         {3},                                 # Timestamp when this data was last updated by a scan
 NETWORK_ADDRESSES        VARCHAR(255),                        # Fibre-channel addresses of the port 
 PORT_SPEED               BIGINT,                              # Speed of port
 FC_PORT_ID               {0},                                 # 3-field ID: domain ID of the switch, port number of the switch, an identifier for the device 
 SUBSYSTEM_ID             {0})  {22}                           # ID of subsystem that the port belongs to
;

ALTER TABLE T_RES_PORT_SNAPSHOT ADD PRIMARY KEY (NAME, NAME_FORMAT, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_PSNAP_PSNAPID ON T_RES_PORT_SNAPSHOT (PORT_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_SWITCH_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, VENDOR_ID, MODEL_ID, SWITCH_WWN
###############################################################
CREATE TABLE T_RES_SWITCH_SNAPSHOT 
(SNAPSHOT_ID               {0} NOT NULL,                       # Snapshot ID
 SWITCH_WWN                CHAR(16) NOT NULL,                  # WWN of switch
 SWITCH_ID                 {0} NOT NULL,                       # Auto-generated ID
 VENDOR_ID                 {1} DEFAULT 0 NOT NULL,             # Vendor. Normalized Key
 MODEL_ID                  {1} DEFAULT 0 NOT NULL,             # Model. Normalized Key
 PARENT_SWITCH_WWN         CHAR(16),                           # WWN of the physical switch if this one is virtual 
 SERIAL_NUMBER             VARCHAR(255),                       # Serial Number of the switch
 DESCRIPTION               VARCHAR(255),                       # Description
 CONTACT                   VARCHAR(255),                       # Person to contact if there is an issue. SNMP information
 LOCATION                  VARCHAR(255),                       # Physical location of the switch. SNMP information
 IP_ADDRESS                VARCHAR(255),                       # IP Address for switch 
 DISPLAY_NAME              VARCHAR(64),                        # User-provided name
 LOGICAL_NAME              VARCHAR(255),                       # Logical name of switch. Name and Logical Name are same. Both fields populated by outband, inband populates logical name only
 DOMAIN                    VARCHAR(128),                       # Used as a part of the fabric address for zoning 
 MANAGEMENT_ID             VARCHAR(128),                       # Correlation ID for some vendor management applications 
 MGMT_TEL_ADDR             VARCHAR(255),                       # Management telnet address 
 MGMT_SNMP_ADDR            VARCHAR(255),                       # Management SNMP address 
 MGMT_URL_ADDR             VARCHAR(255),                       # Management URL address
 VERSION                   VARCHAR(255),                       # Version of the switch
 DETECTABLE                {1},                                # Whether the switch is detectable or not
 OPERATIONAL_STATUS        {0},                                # Operational status of the switch
 CONSOLIDATED_STATUS       {1},                                # Consolidated status for GUI display
 PROPAGATED_STATUS         {1},                                # Propagated status of all entities below the switch
 CHANGED_TIMESTAMP         {3},                                # Timestamp when this data was last updated
 UPDATE_TIMESTAMP          {3},                                # Timestamp when this data was last updated by a scan
 USER_ATTRIB1              VARCHAR(255),                       # User-defined attribute
 USER_ATTRIB2              VARCHAR(255),                       # User-defined attribute
 USER_ATTRIB3              VARCHAR(255)) {22}                  # User-defined attribute
;

ALTER TABLE T_RES_SWITCH_SNAPSHOT ADD PRIMARY KEY (SWITCH_WWN, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_SWSNAP_SWSNAPID ON T_RES_SWITCH_SNAPSHOT (SWITCH_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_STORAGE_EXTENT_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, STORAGE_EXTENT_ID
###############################################################
CREATE TABLE T_RES_STORAGE_EXTENT_SNAPSHOT
(SNAPSHOT_ID                   {0} NOT NULL,                   # Snapshot ID
 STORAGE_EXTENT_ID             {0} NOT NULL,                   # Auto-generated ID
 NUM_EXTENTS                   {0},                            # Number of extents in the rank 
 EXTENT_TYPE                   {0},                            # Type of extent 
 POOL_ID                       {0},                            # ID of extent pool that the storage extent belongs to
 TOTAL_CAPACITY                DOUBLE PRECISION,               # Total capacity of storage extent
 FREE_SPACE                    DOUBLE PRECISION,               # Free space available on storage extent
 VOLS_IN_STORAGE_EXTENT        {0},                            # Number of volumes in extent
 NAME                          VARCHAR(255),                   # Name of extent
 ELEMENT_NAME                  VARCHAR(255),                   # Name of the extent in case of SVC MDisk
 OTHER_NAME                    VARCHAR(64),                    # 
 RANK_ID                       VARCHAR(255),                   # Contains the rank ID of the rank required for PM correlation
 CONFIG                        VARCHAR(32),                    # 
 VOL_GROUP_ID                  {0},                            # 
 GROUP_ID                      VARCHAR(32),                    # 
 DEVICE_ID                     VARCHAR(255) NOT NULL,          # CIM Key: Device ID
 CREATION_CLASS_NAME_ID        {1},                            # CIM Key: Creation class name. Normalized key
 SYSTEM_CREATION_CLASS_NAME_ID {1},                            # CIM Key: System creation class name. Normalized key
 SYSTEM_NAMES_ID               {1} NOT NULL,                   # CIM Key: System name 
 SUBSYSTEM_ID                  {0} NOT NULL,                   # ID of storage subsystem
 BLOCK_SIZE                    {0},                            # Block size
 NUM_OF_BLOCKS                 DOUBLE PRECISION,               # Number of blocks
 CONSUMABLE_BLOCKS             DOUBLE PRECISION,               # Number of consumable blocks
 OPERATIONAL_STATUS            {0},                            # Operational status of extent
 NATIVE_STATUS                 {1},                            # Native status of extent
 MODE                          {0},                            # Mode of MDisk
 DISPLAY_NAME                  VARCHAR(255),                   # Display name derived from other colums and formatted according to specifications
 UPDATE_TIMESTAMP              {3},                            # Timestamp when this data was last updated by a scan
 BACKEND_CONTROLLER_ID         {0},                            # Represents the backend controller that the MDisk belongs to
 SERIAL_NUMBER                 VARCHAR(255),                   # Serial Number of MDisk 
 ARRAY_IDS                     VARCHAR(32),                    # Represents the arrays that this storage extent is made up of 
 REDUNDANCY                    {0}) {22}                       # 
;
 
ALTER TABLE T_RES_STORAGE_EXTENT_SNAPSHOT ADD PRIMARY KEY (DEVICE_ID, SUBSYSTEM_ID, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_SESNAP_SESNAPID ON T_RES_STORAGE_EXTENT_SNAPSHOT
 (STORAGE_EXTENT_ID, SNAPSHOT_ID)
;

##############################################################
## TABLE: T_RES_SYSTEM_NAMES_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_SYSTEM_NAMES_SNAPSHOT
(SNAPSHOT_ID                    {0} NOT NULL,                  # Snapshot ID
 SYSTEM_NAMES_ID                {1} NOT NULL,                  # Auto-generated ID
 SYSTEM_NAME                    VARCHAR(255) NOT NULL) {22}    # CIM Key: System Name
;

ALTER TABLE T_RES_SYSTEM_NAMES_SNAPSHOT ADD PRIMARY KEY (SYSTEM_NAME, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_DISK_GROUP_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, DISK_GROUP_ID
###############################################################
CREATE TABLE T_RES_DISK_GROUP_SNAPSHOT 
(SNAPSHOT_ID                 {0} NOT NULL,                     # Snapshot ID
 DISK_GROUP_ID               {0} NOT NULL,                     # Auto-generated ID
 NAME                        VARCHAR (255),                    # Name of disk group driver
 DESCRIPTION                 VARCHAR (128),                    # Description of disk group driver
 RAID_LEVEL                  VARCHAR(32),                      # RAID level of disk group. Data legacy
 LOOP                        VARCHAR(256),                     # Identifier for port on device adapter used for SSA loop connection. Data Legacy
 ARRAY                       VARCHAR(256),                     # Array/Disk Group Number. Data Legacy
 SUBSYSTEM_ID                {0},                              # ID of subsystem that the disk group belongs to
 WIDTH                       {1},                              # Number of disks in disk group 
 STORAGE_EXTENT_ID           {0},                              # ID of storage extent (rank) that this disk group belongs to
 DEVICE_ADAPTER1             VARCHAR(32),                      # ID of device adapter 1
 DEVICE_ADAPTER2             VARCHAR(32),                      # ID of device adapter 2
 DA_PAIR_ID                  {0},                              # ID of device adapter pair
 DDM_CAP                     DOUBLE PRECISION,                 # Disk Drive Module capacity
 DDM_SPEED                   VARCHAR(255),                     # Disk Drive Module speed
 UPDATE_TIMESTAMP            {3},                              # Timestamp when this data was last updated by a scan
 TAG                         VARCHAR(255) NOT NULL,            # Arbitrary string that uniquely identifies the disk group
 DISK_GROUP_NUMBER           {1},                              # Unique number between 1-12 for each storage subsystem
 CREATION_CLASS_NAME_ID      {1}) {22}                         # Creation class name. Normalized key
;

ALTER TABLE T_RES_DISK_GROUP_SNAPSHOT ADD PRIMARY KEY (TAG, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_DGSNAP_DGSNAPID ON T_RES_DISK_GROUP_SNAPSHOT (DISK_GROUP_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_VOLUME2EXTENT_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_VOLUME2EXTENT_SNAPSHOT
(SNAPSHOT_ID           {0} NOT NULL,                           # Snapshot ID
 VOLUME_ID             {0} NOT NULL,                           # ID of storage volume
 STORAGE_EXTENT_ID     {0} NOT NULL,                           # ID of storage extent
 TOTAL_NUM_EXTENTS     {0},                                    # Total number of extents that the volume is created on
 UPDATE_TIMESTAMP      {3})  {22}                              # Timestamp when this data was last updated by a scan
;

ALTER TABLE T_RES_VOLUME2EXTENT_SNAPSHOT ADD PRIMARY KEY (VOLUME_ID, STORAGE_EXTENT_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_SWITCH2PORT_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_SWITCH2PORT_SNAPSHOT
(SNAPSHOT_ID        {0} NOT NULL,                              # Snapshot ID
 SWITCH2PORT_ID     {0} NOT NULL,                              # Auto-generated ID
 SWITCH_WWN         CHAR(16) NOT NULL,                         # Switch WWN
 PORT_ID            {0} NOT NULL,                              # Port ID
 DETECTABLE         {0},                                       # Whether the relation is detectable or not
 UPDATE_TIMESTAMP   {3}) {22}                                  # Timestamp when this data was last updated by a scan 
;

ALTER TABLE T_RES_SWITCH2PORT_SNAPSHOT ADD PRIMARY KEY 
 (SWITCH_WWN, PORT_ID, SNAPSHOT_ID)
;

CREATE INDEX I_S2PSNAP_PORTID ON T_RES_SWITCH2PORT_SNAPSHOT (PORT_ID)
;

CREATE UNIQUE INDEX I_S2PSN_S2PSID ON T_RES_SWITCH2PORT_SNAPSHOT (SWITCH2PORT_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_NODE_SNAPSHOT
## FOERIGN KEYS: SNAPSHOT_ID, NODE_ID
###############################################################
CREATE TABLE T_RES_NODE_SNAPSHOT
(SNAPSHOT_ID               {0} NOT NULL,                       # Snapshot ID
 SCSI_SUPPORT              {1} DEFAULT 1 NOT NULL,             # SCSI support - whether is an initiator, target, unknown, etc.
 NODE_ID                   {0} NOT NULL,                       # Auto-generated ID 
 NAME                      VARCHAR(255) NOT NULL,              # Name of node
 NAME_FORMAT               {1} NOT NULL,                       # Format of name
 OTHER_NAME                VARCHAR(64),                        # Extra name to determine the special icon type for ESS, SVC, DS6000 and DS8000. Also used as a label for the objects in some cases.
 PLATFORM_TYPE             {1} DEFAULT 1 NOT NULL,             # Device registration idenitification information. Indicates the type of device
 RNID_TYPE                 {1} DEFAULT 1 NOT NULL,             # Device return idenitification information. Indicates the type of device
 SYSTEM_ID                 {0},                                # ID of subsystem or the ape library that the node belongs to
 TAPE_LIBRARY_ID           {0},                                # ID of the tape library that the node belongs to 
 BLADE_ID                  {0},                                # ID of blade that the node belongs to
 DISPLAY_NAME              VARCHAR(64),                        # User-provided name
 DISPLAY_ICON_TYPE         {1},                                # Type of display icon
 MGMT_URL_ADDR             VARCHAR(255),                       # Management URL address 
 MGMT_TEL_ADDR             VARCHAR(255),                       # Management telnet address
 MGMT_SNMP_ADDR            VARCHAR(255),                       # Management SNMP address
 DETECTABLE                {1},                                # Whether the node is detectable or not
 OPERATIONAL_STATUS        {0},                                # Operational status of the node
 CONSOLIDATED_STATUS       {1},                                # Consolidated status for GUI display
 PROPAGATED_STATUS         {1},                                # Propagated status of all entities below the node
 UPDATE_TIMESTAMP          {3}) {22}                           # Timestamp when this data was last updated by a scan
;
       

ALTER TABLE T_RES_NODE_SNAPSHOT ADD PRIMARY KEY (NAME, NAME_FORMAT, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_NSNAP_NSNAPID ON T_RES_NODE_SNAPSHOT (NODE_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_REGISTERED_CIMOM_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, SERVICE_URL 
###############################################################
CREATE TABLE T_RES_REGISTERED_CIMOM_SNAPSHOT
(SNAPSHOT_ID                {0} NOT NULL,                              # Snapshot ID 
 REG_CIMOM_ID               {0} NOT NULL,                              # Auto-generated ID
 SERVICE_URL                VARCHAR(255) NOT NULL,                     # URL to access the CIMOM 
 HI_NAME                    VARCHAR(255),                              # Human interface name
 DESCRIPTION                VARCHAR (255),                             # Description 
 SOFTWARE_LEVEL             VARCHAR (128),                             # Software level
 PROTOCOL_VERSION           VARCHAR (25),                              # Protocol version
 AUTHENTICATION_MECHANISM   VARCHAR (25),                              # Mechanism for authentication
 USER_ID                    VARCHAR (128),                             # User ID
 PASSWORD                   VARCHAR (128),                             # User Password
 TRUST_STORE_LOCATION       VARCHAR (50),                              # Location of trust store
 TRUST_STORE_PASSPHRASE     VARCHAR (50),                              # Password for trust store
 INTEROP_SCHEMA_NAMESPACE   VARCHAR(255),                              # Interoperability schema namespace
 PROTOCOL                   VARCHAR(25) DEFAULT 'cim#xml' NOT NULL,    # Protocol 
 DISPLAY_NAME               VARCHAR(255),                              # Display name derived from other colums and formatted according to specifications
 STATUS                     {1},                                       # Status of the cimom
 STATUS_TIMESTAMP           {3}) {22}                                  # Timestamp when the cimom status was last updated
;

ALTER TABLE T_RES_REGISTERED_CIMOM_SNAPSHOT ADD PRIMARY KEY (SERVICE_URL, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_CIMSNAP_CSNAPID ON T_RES_REGISTERED_CIMOM_SNAPSHOT
 (REG_CIMOM_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_SLP_ATTRIBUTES_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_SLP_ATTRIBUTES_SNAPSHOT 
(SNAPSHOT_ID                   {0} NOT NULL,                   # Snapshot ID
 ATTRIBUTE_NAME                VARCHAR(255),                   # Name of SLP attribute
 VALUE                         VARCHAR(255),                   # Value of SLP attribute
 REG_CIMOM_ID                  {0})                            # Pointer to the registered CIMOM that this attribute belongs to
;

###############################################################
## TABLE: T_RES_CIMOM2NAMESPACE_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID, CIM_NAMESPACE_ID
###############################################################
CREATE TABLE T_RES_CIMOM2NAMESPACE_SNAPSHOT 
(SNAPSHOT_ID          {0} NOT NULL,                            # Snapshot ID
 CIM_NAMESPACE_ID     {0}    NOT NULL,                         # Auto-generated ID
 CIMOM_ID             {0}    NOT NULL,                         # CIMOM ID
 NAMESPACE            VARCHAR (255) NOT NULL,                  # CIMOM Namespace
 UPDATE_TIMESTAMP     {3}) {22}                                # Timestamp when this data was last updated by a scan
;

ALTER TABLE T_RES_CIMOM2NAMESPACE_SNAPSHOT ADD PRIMARY KEY (CIMOM_ID, NAMESPACE, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_C2N_CNSNAPID ON T_RES_CIMOM2NAMESPACE_SNAPSHOT
 (CIM_NAMESPACE_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_CIMKEY_SWITCH_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_CIMKEY_SWITCH_SNAPSHOT
(SNAPSHOT_ID             {0} NOT NULL,                         # Snapshot ID
 CIMKEY_SWITCH_ID        {0} NOT NULL,                         # Auto-generated ID
 SWITCH_WWN              CHAR (16) NOT NULL,                   # Switch WWN
 CIM_NAMESPACE_ID        {0} NOT NULL,                         # CIMOM Namespace ID
 NAME                    VARCHAR (255),                        # CIM Key: Name of switch
 NAME_FORMAT             {1},                                  # Name format
 CREATION_CLASS_NAME_ID  {1},                                  # CIM Key: Creation class name. Normalized key
 ACTIVE                  {1} DEFAULT NULL) {22}                # Whether it is the active CIMOM or not
;        

ALTER TABLE T_RES_CIMKEY_SWITCH_SNAPSHOT ADD PRIMARY KEY 
 (SWITCH_WWN, CIM_NAMESPACE_ID, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_CSWSN_CSWSNID ON T_RES_CIMKEY_SWITCH_SNAPSHOT (CIMKEY_SWITCH_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_CIMKEY_SUBSYSTEM_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_CIMKEY_SUBSYSTEM_SNAPSHOT 
(SNAPSHOT_ID                {0} NOT NULL,                      # Snapshot ID
 CIMKEY_SUBSYSTEM_ID        {0} NOT NULL,                      # Auto-generated ID
 SUBSYSTEM_ID               {0} NOT NULL,                      # Subsystem ID
 CIM_NAMESPACE_ID           {0} NOT NULL,                      # CIMOM Namespace ID
 NAME                       VARCHAR (255),                     # CIM Key: Name of subsystem
 NAME_FORMAT                {1},                               # Name format
 CREATION_CLASS_NAME_ID     {1},                               # CIM Key: Creation class name. Normalized key
 CAPABILITY_DATA_ID         {0},                               # Capability data ID
 ACTIVE                     {1} DEFAULT NULL) {22}             # Whether it is the active CIMOM or not
;        

ALTER TABLE T_RES_CIMKEY_SUBSYSTEM_SNAPSHOT ADD PRIMARY KEY 
 (SUBSYSTEM_ID, CIM_NAMESPACE_ID, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_CSYSSN_CSSNID ON T_RES_CIMKEY_SUBSYSTEM_SNAPSHOT 
 (CIMKEY_SUBSYSTEM_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_CIMKEY_PORT_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_CIMKEY_PORT_SNAPSHOT 
(SNAPSHOT_ID                       {0} NOT NULL,               # Snapshot ID 
 CIMKEY_PORT_ID                    {0} NOT NULL,               # Auto-generated ID
 PORT_ID                           {0} NOT NULL,               # Port ID
 CIM_NAMESPACE_ID                  {0} NOT NULL,               # CIMOM Namespace ID
 SYSTEM_CREATION_CLASS_NAME_ID     {1},                        # CIM Key: System creation class name. Normalized key
 SYSTEM_NAMES_ID                   {1},                        # CIM Key: Name of subsystem that the port belongs to
 CREATION_CLASS_NAME_ID            {1},                        # CIM Key: Creation class name. Normalized key
 DEVICE_ID                         VARCHAR (255),              # CIM Key: Device ID 
 ACTIVE                            {1} DEFAULT NULL,           # Whether it is the active CIMOM or not
 UPDATE_TIMESTAMP                  {3}) {22}                   # Timestamp when this data was last updated by a scan
;        

ALTER TABLE T_RES_CIMKEY_PORT_SNAPSHOT ADD PRIMARY KEY 
 (PORT_ID, CIM_NAMESPACE_ID, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_CPRTSN_CPRTSNID ON T_RES_CIMKEY_PORT_SNAPSHOT
 (CIMKEY_PORT_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_CIMKEY_VOLUME_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_CIMKEY_VOLUME_SNAPSHOT 
(SNAPSHOT_ID                     {0} NOT NULL,                 # Snapshot ID
 VOLUME_ID                       {0} NOT NULL,                 # Volume ID
 CIM_NAMESPACE_ID                {0} NOT NULL,                 # CIMOM Namespace ID
 SYSTEM_NAMES_ID                 {1},                          # CIM Key: Name of subsystem that the volume belongs to
 CREATION_CLASS_NAME_ID          {1},                          # CIM Key: Creation class name. Normalized key
 SYSTEM_CREATION_CLASS_NAME_ID   {1},                          # CIM Key: System creation class name. Normalized key
 DEVICE_ID                       VARCHAR (255),                # CIM Key: Device ID
 ACTIVE                          {1} DEFAULT NULL,             # Whether it is the active CIMOM or not
 UPDATE_TIMESTAMP                {3}) {22}                     # Timestamp when this data was last updated by a scan
;
        
ALTER TABLE T_RES_CIMKEY_VOLUME_SNAPSHOT ADD PRIMARY KEY (VOLUME_ID, CIM_NAMESPACE_ID, SNAPSHOT_ID)
;

###############################################################
## TABLE: T_RES_IO_GROUP_SNAPSHOT
## FOREIGN KEYS: SNAPSHOT_ID
###############################################################
CREATE TABLE T_RES_IO_GROUP_SNAPSHOT    
(SNAPSHOT_ID      {0} NOT NULL,                                # Snapshot ID
 IO_GROUP_ID      {0} NOT NULL,                                # Auto-generated ID
 GROUP_ID         VARCHAR(255),                                # IO Group ID
 NAME             VARCHAR(255) NOT NULL,                       # Name of IO Group
 SUBSYSTEM_ID     {0} NOT NULL) {22}                           # ID of subsystem that the IO group belongs to  
;
	
ALTER TABLE T_RES_IO_GROUP_SNAPSHOT ADD PRIMARY KEY (NAME, SUBSYSTEM_ID, SNAPSHOT_ID)
;

CREATE UNIQUE INDEX I_IOGSN_IOGID ON T_RES_IO_GROUP_SNAPSHOT (IO_GROUP_ID, SNAPSHOT_ID)
;



-------------------------------------------------------------------------------
-- Jan  4, 2007/Khan Tasinga/Updated alert ID of CIMOM discovery entry in T_SCHEDULE ...
--
-- Update the alert ID associated with the schedule entry of the default CIMOM
-- discovery job. It is incorrectly set to 114 in AlterVersion005000000.sql, which
-- results in a subsystem discovery alert when the CIMOM discovery job fails.
-------------------------------------------------------------------------------
update t_schedule
   set alert_id = 110
 where schedule_id = 110
;
