/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.QualifierWindow;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.DefaultProperties;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.TextFieldFocusListener;
import org.wbemservices.wbem.apps.common.Util;

public class AddClassDialog
extends AdminDialog
implements DocumentListener,
ListSelectionListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected JTextField classNameField;
    protected String className;
    private JButton btnAddProperty;
    private JButton btnDeleteProperty;
    private JButton btnPropertyQualifiers;
    private JButton btnClassQualifiers;
    private CIMTableTabbedPane tables;
    private CIMClass cimClass;
    private CIMClient cimClient;
    private int parentPropertyCount = 0;

    public AddClassDialog(Frame parent, String scName) {
        super(parent, I18N.loadString("TTL_NEW_CLASS"), false);
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new ButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new ButtonListener());
        JPanel mainPanel = this.getRightPanel();
        String tmpClassName = I18N.loadString("LBL_UNTITLED", "org.wbemservices.wbem.apps.common.common");
        this.cimClient = CIMClientObject.getClient();
        this.cimClass = new CIMClass(tmpClassName);
        if (!scName.equals("")) {
            this.cimClass.setSuperClass(scName);
            this.copySuperClassElements(scName);
        }
        this.classNameField = new JTextField(20);
        this.classNameField.addFocusListener(new TextFieldFocusListener());
        this.classNameField.getDocument().addDocumentListener(this);
        this.classNameField.setText(tmpClassName);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BorderLayout());
        JPanel classNamePanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        classNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ActionString asClassName = new ActionString("LBL_CLASS_NAME");
        JLabel lClassName = new JLabel(asClassName.getString());
        lClassName.setDisplayedMnemonic(asClassName.getMnemonic());
        lClassName.setLabelFor(this.classNameField);
        classNamePanel.add(lClassName);
        classNamePanel.add(this.classNameField);
        mainPanel.add("North", classNamePanel);
        this.tables = new CIMTableTabbedPane(true);
        this.tables.removeMethodsTab();
        this.tables.addListSelectionListener(this);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        centerPanel.add("Center", this.tables);
        this.setUpControls();
        JPanel sideButtons = new JPanel();
        sideButtons.setBorder(BorderFactory.createEmptyBorder(25, 5, 5, 5));
        sideButtons.setLayout(new ColumnLayout());
        sideButtons.add(this.btnAddProperty);
        sideButtons.add(this.btnDeleteProperty);
        sideButtons.add(this.btnPropertyQualifiers);
        sideButtons.add(this.btnClassQualifiers);
        centerPanel.add("East", sideButtons);
        mainPanel.add("Center", centerPanel);
        this.populateTables(this.cimClass);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_000.htm"), true);
        this.btnOK.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_000.htm"));
        this.btnCancel.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_000.htm"));
        this.classNameField.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_010.htm"));
        this.btnAddProperty.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_020.htm"));
        this.btnDeleteProperty.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_030.htm"));
        this.btnPropertyQualifiers.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_040.htm"));
        this.btnClassQualifiers.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_050.htm"));
        this.setOKEnabled();
        this.setSize(DefaultProperties.addClassDlgSize);
        Util.positionWindow(this, parent);
        this.setVisible(true);
    }

    private void setUpControls() {
        ActionString asAddProperty = new ActionString("MNU_ADD_PROPERTY");
        ActionString asDeleteProperty = new ActionString("MNU_DELETE_PROPERTY");
        ActionString asPropertyQualifier = new ActionString("MNU_PROPERTY_QUALIFIERS");
        ActionString asClassQualifier = new ActionString("MNU_CLASS_QUALIFIERS");
        this.btnAddProperty = new JButton(asAddProperty.getString());
        this.btnAddProperty.setMnemonic(asAddProperty.getMnemonic());
        this.btnAddProperty.addActionListener(this.tables.getPropertiesTable());
        this.btnAddProperty.setActionCommand("ADD_PROPERTY");
        this.btnAddProperty.setToolTipText(asAddProperty.getString());
        this.btnAddProperty.setEnabled(true);
        this.btnDeleteProperty = new JButton(asDeleteProperty.getString());
        this.btnDeleteProperty.setMnemonic(asDeleteProperty.getMnemonic());
        this.btnDeleteProperty.addActionListener(this.tables.getPropertiesTable());
        this.btnDeleteProperty.setActionCommand("DELETE_PROPERTY");
        this.btnDeleteProperty.setToolTipText(asDeleteProperty.getString());
        this.btnDeleteProperty.setEnabled(false);
        this.btnPropertyQualifiers = new JButton(asPropertyQualifier.getString());
        this.btnPropertyQualifiers.setMnemonic(asPropertyQualifier.getMnemonic());
        this.btnPropertyQualifiers.addActionListener(this.tables.getPropertiesTable());
        this.btnPropertyQualifiers.setActionCommand("QUALIFIERS");
        this.btnPropertyQualifiers.setToolTipText(asPropertyQualifier.getString());
        this.btnPropertyQualifiers.setEnabled(false);
        this.btnClassQualifiers = new JButton(asClassQualifier.getString());
        this.btnClassQualifiers.setMnemonic(asClassQualifier.getMnemonic());
        this.btnClassQualifiers.addActionListener(new ButtonListener());
        this.btnClassQualifiers.setToolTipText(asClassQualifier.getString());
        this.btnClassQualifiers.setEnabled(true);
    }

    private void copySuperClassElements(String scName) {
        try {
            CIMClass cimSuperClass = this.cimClient.getClass(new CIMObjectPath(scName), false, true, true, null);
            Vector<Object> v = new Vector<Object>();
            Vector propVector = cimSuperClass.getProperties();
            if (propVector != null) {
                Enumeration e = propVector.elements();
                while (e.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)((CIMProperty)e.nextElement()).clone();
                    if (prop.getOriginClass() == null) {
                        prop.setOriginClass(scName);
                    }
                    v.addElement(prop);
                }
            }
            this.cimClass.setProperties(v);
            v = new Vector();
            Vector qualVector = cimSuperClass.getQualifiers();
            if (qualVector != null) {
                Enumeration e = qualVector.elements();
                while (e.hasMoreElements()) {
                    CIMQualifier qual = (CIMQualifier)((CIMQualifier)e.nextElement()).clone();
                    v.addElement(qual);
                }
            }
            this.cimClass.setQualifiers(v);
            v = new Vector();
            Vector methVector = cimSuperClass.getMethods();
            if (methVector != null) {
                Enumeration e = methVector.elements();
                while (e.hasMoreElements()) {
                    CIMMethod meth = (CIMMethod)((CIMMethod)e.nextElement()).clone();
                    v.addElement(meth);
                }
            }
            this.cimClass.setMethods(v);
        }
        catch (CIMException exc) {
            return;
        }
    }

    private void populateTables(CIMClass superClass) {
        this.tables.populateTables(this.cimClient, (CIMElement)superClass);
        this.parentPropertyCount = this.tables.getProperties().size();
        Vector<Integer> uneditableProperties = new Vector<Integer>();
        for (int i = 0; i < this.parentPropertyCount; ++i) {
            uneditableProperties.addElement(new Integer(i));
        }
        this.tables.setUneditableProperties(uneditableProperties);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.btnPropertyQualifiers.setEnabled(true);
        int selectedRow = this.tables.getPropertiesTable().getSelectedRow();
        boolean bEnable = selectedRow > this.parentPropertyCount - 1;
        this.btnDeleteProperty.setEnabled(bEnable);
    }

    private boolean saveValues() {
        boolean ret = true;
        Util.setWaitCursor(this);
        Vector props = this.tables.getProperties();
        Vector newProps = new Vector();
        for (int i = this.parentPropertyCount; i < props.size(); ++i) {
            newProps.addElement(props.elementAt(i));
        }
        if (props.size() > 0) {
            this.cimClass.setProperties(newProps);
        }
        this.cimClass.setName(this.className);
        try {
            this.cimClient.createClass(new CIMObjectPath(this.className), this.cimClass);
        }
        catch (CIMException exc) {
            if (exc.getID().equals("CIM_ERR_INVALID_PARAMETER")) {
                JOptionPane.showMessageDialog(null, Util.wrapText(I18N.loadString("MSG_INVALID_CLASS_NAME")), I18N.loadString("TTL_CIM_ERROR"), 0);
            } else {
                CIMErrorDialog.display(this, exc);
            }
            ret = false;
        }
        Util.setDefaultCursor(this);
        return ret;
    }

    public String getClassName() {
        return this.className;
    }

    public void changedUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void setOKEnabled() {
        this.btnOK.setEnabled(this.classNameField.getText().trim().length() != 0);
    }

    public void windowOpened(WindowEvent evt) {
        this.classNameField.requestFocus();
    }

    public void focusGained(FocusEvent evt) {
        JTextField tf;
        if (evt.getComponent() instanceof JTextField && (tf = (JTextField)evt.getComponent()).isEditable() && tf.getText().length() > 0) {
            tf.setCaretPosition(tf.getText().length());
            tf.selectAll();
        }
    }

    public void focusLost(FocusEvent evt) {
        if (evt.getComponent() instanceof JTextField) {
            JTextField tf = (JTextField)evt.getComponent();
            tf.select(0, 0);
        }
    }

    public boolean verifyClassName() {
        String untitled;
        String cName = this.classNameField.getText().trim();
        if (cName.equals(untitled = I18N.loadString("LBL_UNTITLED", "org.wbemservices.wbem.apps.common.common"))) {
            JOptionPane.showMessageDialog(null, I18N.loadStringFormat("ERR_CHANGE_CLASSNAME", untitled), I18N.loadString("TTL_CIM_ERROR"), 0);
            return false;
        }
        this.className = cName;
        return true;
    }

    public void okClicked() {
        if (!this.verifyClassName()) {
            return;
        }
        if (this.saveValues()) {
            this.dispose();
        }
    }

    public void cancelClicked() {
        this.className = null;
        this.dispose();
    }

    public void classQualifiersClicked() {
        this.cimClass.setName(this.classNameField.getText().trim());
        QualifierWindow qualifierWindow = new QualifierWindow(Util.getFrame(this), this.cimClient, (CIMElement)this.cimClass, true);
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AddClassDialog.this.btnCancel) {
                AddClassDialog.this.cancelClicked();
            } else if (e.getSource() == AddClassDialog.this.btnOK) {
                AddClassDialog.this.okClicked();
            } else if (e.getSource() == AddClassDialog.this.btnClassQualifiers) {
                AddClassDialog.this.classQualifiersClicked();
            }
        }
    }
}

