/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.wbemservices.wbem.apps.cimworkshop.CIMEditDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMTypes;
import org.wbemservices.wbem.apps.cimworkshop.CharFieldDialog;
import org.wbemservices.wbem.apps.cimworkshop.DateTimeDialog;
import org.wbemservices.wbem.apps.cimworkshop.IntegerFieldDialog;
import org.wbemservices.wbem.apps.cimworkshop.RealNumberFieldDialog;
import org.wbemservices.wbem.apps.cimworkshop.TextFieldDialog;
import org.wbemservices.wbem.apps.cimworkshop.TrueFalseDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CancelObject;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.Util;

class ArrayEditDialog
extends CIMEditDialog
implements MouseListener,
ListSelectionListener,
ActionListener {
    protected JList list;
    protected JButton btnAdd;
    protected JButton btnDelete;
    protected JButton btnModify;
    protected JPopupMenu popup;
    protected int currentRow;
    protected Frame parentFrame;
    protected Vector cimValues;
    protected CIMTypes cimTypes = new CIMTypes();

    public ArrayEditDialog(Frame frame, String name, String type, Vector values) {
        this(frame, name, type, values, true);
    }

    public ArrayEditDialog(Frame frame, String name, String type, Vector values, boolean editable) {
        super(frame, name, type, editable);
        int currentType = this.cimTypes.getCIMType(this.dataType);
        this.dataType = this.cimTypes.getCIMType(currentType -= 14);
        this.cimValues = values;
        if (this.cimValues == null) {
            this.cimValues = new Vector();
        }
        this.parentFrame = frame;
        this.list = new JList(this.cimValues);
        this.list.setVisibleRowCount(7);
        JScrollPane scrollPane = new JScrollPane(this.list){

            public Dimension getPreferredSize() {
                return new Dimension(100, 125);
            }
        };
        JPanel sideButtons = new JPanel(new ColumnLayout());
        String defaultHelp = "ShowValue_000.htm";
        if (this.isEditable) {
            this.list.addMouseListener(this);
            this.list.addListSelectionListener(this);
            ActionString asAdd = new ActionString("MNU_ADD", "org.wbemservices.wbem.apps.common.common");
            ActionString asDelete = new ActionString("MNU_DELETE", "org.wbemservices.wbem.apps.common.common");
            ActionString asModify = new ActionString("MNU_MODIFY", "org.wbemservices.wbem.apps.common.common");
            this.btnAdd = new JButton(asAdd.getString());
            this.btnAdd.setMnemonic(asAdd.getMnemonic());
            this.btnAdd.addActionListener(this);
            this.btnAdd.setActionCommand("add");
            this.btnDelete = new JButton(asDelete.getString());
            this.btnDelete.setMnemonic(asDelete.getMnemonic());
            this.btnDelete.addActionListener(this);
            this.btnDelete.setActionCommand("delete");
            this.btnModify = new JButton(asModify.getString());
            this.btnModify.setMnemonic(asModify.getMnemonic());
            this.btnModify.addActionListener(this);
            this.btnModify.setActionCommand("modify");
            sideButtons.setBorder(BorderFactory.createEmptyBorder(50, 5, 5, 5));
            sideButtons.add(this.btnAdd);
            sideButtons.add(this.btnDelete);
            sideButtons.add(this.btnModify);
            this.btnDelete.setEnabled(false);
            this.btnModify.setEnabled(false);
            defaultHelp = "Array_000.htm";
            this.popup = new JPopupMenu();
            JMenuItem menuItem = this.popup.add(new JMenuItem(asAdd.getString()));
            menuItem.setMnemonic(asAdd.getMnemonic());
            menuItem.setActionCommand("add");
            menuItem.addActionListener(this);
            menuItem = this.popup.add(new JMenuItem(asDelete.getString()));
            menuItem.setMnemonic(asDelete.getMnemonic());
            menuItem.setActionCommand("delete");
            menuItem.addActionListener(this);
            menuItem = this.popup.add(new JMenuItem(asModify.getString()));
            menuItem.setMnemonic(asModify.getMnemonic());
            menuItem.setActionCommand("modify");
            menuItem.addActionListener(this);
        } else {
            this.list.setEnabled(false);
        }
        JPanel listPanel = new JPanel(new ColumnLayout());
        ActionString asValue = new ActionString("LBL_VALUE");
        JLabel valueLabel = new JLabel(asValue.getString() + ":");
        valueLabel.setDisplayedMnemonic(asValue.getMnemonic());
        valueLabel.setLabelFor(this.list);
        listPanel.add(valueLabel);
        listPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        listPanel.add(scrollPane);
        JPanel basePanel = new JPanel(new BorderLayout());
        basePanel.add("West", listPanel);
        basePanel.add("East", sideButtons);
        JPanel mainPanel = this.getMainPanel();
        mainPanel.add(basePanel);
        this.setDefaultHelp(defaultHelp);
        if (this.cimValues.size() > 0 && editable) {
            this.list.setSelectedIndex(0);
        }
        this.pack();
        this.setLocation(Util.getCenterPoint(frame, this));
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String actionCmd = evt.getActionCommand();
        if (!this.isEditable) {
            return;
        }
        if (actionCmd.equals("add")) {
            this.showDialog(null);
            this.list.setSelectedIndex(this.cimValues.size() - 1);
        } else if (actionCmd.equals("modify")) {
            Object o = this.cimValues.elementAt(this.list.getSelectedIndex());
            this.showDialog(o);
        } else if (actionCmd.equals("delete")) {
            this.cimValues.removeElementAt(this.list.getSelectedIndex());
            this.list.setListData(this.cimValues);
            if (this.cimValues.size() > 0) {
                this.list.setSelectedIndex(0);
            } else {
                this.btnDelete.setEnabled(false);
                this.btnModify.setEnabled(false);
            }
        }
    }

    protected void showPopupMenu(Point point) {
        if (!this.isEditable) {
            return;
        }
        this.currentRow = this.list.locationToIndex(point);
        this.list.getSelectionModel().setSelectionInterval(this.currentRow, this.currentRow);
        this.popup.show(this, point.x, point.y);
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void showDialog(Object value) {
        CIMEditDialog editDialog;
        String valueString = "";
        if (value != null) {
            valueString = value.toString();
        }
        int currentType = this.cimTypes.getCIMType(this.dataType);
        switch (currentType) {
            case 9: {
                editDialog = new TrueFalseDialog(this.parentFrame, this.nameString, this.dataType, (Boolean)value, this.isEditable);
                break;
            }
            case 8: {
                editDialog = new TextFieldDialog(this.parentFrame, this.nameString, this.dataType, valueString, this.isEditable);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                editDialog = new IntegerFieldDialog(this.parentFrame, this.nameString, this.dataType, valueString, this.isEditable);
                break;
            }
            case 10: 
            case 11: {
                editDialog = new RealNumberFieldDialog(this.parentFrame, this.nameString, this.dataType, valueString, this.isEditable);
                break;
            }
            case 12: {
                editDialog = new DateTimeDialog(this.parentFrame, this.nameString, this.dataType, valueString, this.isEditable);
                break;
            }
            case 13: {
                editDialog = new CharFieldDialog(this.parentFrame, this.nameString, this.dataType, valueString, this.isEditable);
                break;
            }
            default: {
                editDialog = new TextFieldDialog(this.parentFrame, this.nameString, this.dataType, valueString, this.isEditable);
            }
        }
        Object currentValue = editDialog.getValueObject();
        if (currentValue instanceof CancelObject || currentValue == null) {
            return;
        }
        if (value == null) {
            this.cimValues.addElement(currentValue);
        } else {
            this.cimValues.setElementAt(currentValue, this.list.getSelectedIndex());
        }
        this.list.setListData(this.cimValues);
    }

    public void okClicked() {
        this.returnObject = this.cimValues.size() == 0 ? null : this.cimValues;
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        boolean b = this.list.getSelectedIndex() >= 0;
        this.btnDelete.setEnabled(b);
        this.btnModify.setEnabled(b);
    }

    public Vector getValue() {
        return this.cimValues;
    }
}

