/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMTypeDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMTypes;
import org.wbemservices.wbem.apps.cimworkshop.CIMValueDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CancelObject;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class CIMElementsTable
extends JScrollPane
implements ListSelectionListener,
TableModelListener,
MouseListener,
ActionListener {
    public static final int PROPERTY_TABLE = 0;
    public static final int QUALIFIER_TABLE = 1;
    public static final int NON_EDITABLE = 0;
    public static final int EDITABLE = 1;
    public static final int ONLY_VALUE_EDITABLE = 2;
    protected JTable table;
    protected Vector tableHeading;
    protected Vector cimElements = null;
    protected CIMElement parentElement = null;
    protected ElementsDataModel elementsDataModel;
    protected String emptyString;
    protected boolean dataChanged = false;
    protected boolean isClass = false;
    protected boolean newElement = false;
    protected int tableType;
    protected CIMValue currentCIMValue;
    protected int accessState;
    protected JPopupMenu popupMenu;
    protected CIMClient cimClient;
    protected ImageIcon keyIcon;
    protected ImageIcon inheritedIcon;
    protected ImageIcon blankIcon;
    protected CIMTypes cimTypes;
    private final int INHERITED_COLUMN = 0;
    private final int KEY_COLUMN = 1;
    private int nameColumn;
    private int typeColumn;
    private int valueColumn;
    protected Vector uneditableRows;

    public CIMElementsTable() {
        this(1, 0, false);
    }

    public CIMElementsTable(int tType) {
        this(0, tType);
    }

    public CIMElementsTable(int tType, boolean nElement) {
        this(0, tType, nElement);
        if (nElement) {
            this.accessState = 2;
        }
    }

    public CIMElementsTable(int aState, int tType) {
        this(aState, tType, false);
    }

    public CIMElementsTable(int aState, int tType, boolean nElement) {
        this.accessState = aState;
        this.tableType = tType;
        this.newElement = nElement;
        this.nameColumn = this.tableType == 0 ? 2 : 0;
        this.typeColumn = this.nameColumn + 1;
        this.valueColumn = this.nameColumn + 2;
        this.uneditableRows = new Vector();
        this.cimTypes = new CIMTypes();
        this.emptyString = I18N.loadString("LBL_EMPTY");
        this.cimElements = new Vector();
        this.keyIcon = Util.loadImageIcon("key.gif");
        this.blankIcon = Util.loadImageIcon("blank.gif");
        this.inheritedIcon = Util.loadImageIcon("inherited.gif");
        this.popupMenu = new JPopupMenu();
        this.elementsDataModel = new ElementsDataModel();
        this.tableHeading = new Vector();
        if (this.tableType == 0) {
            this.tableHeading.addElement("");
            this.tableHeading.addElement("");
        }
        ActionString asName = new ActionString("LBL_NAME", "org.wbemservices.wbem.apps.common.common");
        ActionString asType = new ActionString("LBL_TYPE");
        ActionString asValue = new ActionString("LBL_VALUE");
        this.tableHeading.addElement(asName.getString());
        this.tableHeading.addElement(asType.getString());
        this.tableHeading.addElement(asValue.getString());
        this.table = new JTable(this.elementsDataModel){

            public String getToolTipText(MouseEvent e) {
                String s = "";
                Point p = e.getPoint();
                int col = this.columnAtPoint(p);
                int row = this.rowAtPoint(p);
                if (row < 0 || row >= CIMElementsTable.this.elementsDataModel.getRowCount()) {
                    return "";
                }
                Object obj = CIMElementsTable.this.elementsDataModel.getValueAt(row, col);
                String name = CIMElementsTable.this.elementsDataModel.getValueAt(row, CIMElementsTable.this.nameColumn).toString();
                if (col >= CIMElementsTable.this.nameColumn && col <= CIMElementsTable.this.valueColumn) {
                    s = obj.toString();
                } else if (col == 0) {
                    s = obj == CIMElementsTable.this.inheritedIcon ? I18N.loadStringFormat("MSG_PROP_INHERITED", name) : I18N.loadStringFormat("MSG_PROP_NOT_INHERITED", name);
                } else if (col == 1) {
                    s = obj == CIMElementsTable.this.keyIcon ? I18N.loadStringFormat("MSG_PROP_KEY", name) : I18N.loadStringFormat("MSG_PROP_NOT_KEY", name);
                }
                return s;
            }
        };
        this.table.setBackground(this.getBackground());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.elementsDataModel.addTableModelListener(this);
        JTextField keyField = new JTextField();
        JTextField inheritedField = new JTextField();
        JTextField nameField = new JTextField();
        JTextField typeField = new JTextField();
        JTextField valueField = new JTextField();
        if (this.tableType == 0) {
            TableColumn col0 = this.table.getColumnModel().getColumn(0);
            TableColumn col1 = this.table.getColumnModel().getColumn(1);
            col0.setMinWidth(20);
            col0.setMaxWidth(20);
            col1.setMinWidth(20);
            col1.setMaxWidth(20);
            this.table.sizeColumnsToFit(0);
            col0.setCellEditor(new DefaultCellEditor(inheritedField){

                public boolean isCellEditable(EventObject evt) {
                    return false;
                }
            });
            col1.setCellEditor(new DefaultCellEditor(keyField){

                public boolean isCellEditable(EventObject evt) {
                    return false;
                }
            });
        }
        this.table.getColumnModel().getColumn(this.nameColumn).setCellEditor(new DefaultCellEditor(nameField){

            public boolean isCellEditable(EventObject evt) {
                return false;
            }
        });
        this.table.getColumnModel().getColumn(this.typeColumn).setCellEditor(new CIMTypeEditor(typeField));
        TableColumn col3 = this.table.getColumnModel().getColumn(this.valueColumn);
        col3.setCellEditor(new CIMTextFieldCellEditor(valueField));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.setViewportView(this.table);
    }

    public JTable getTable() {
        return this.table;
    }

    public void hideIconColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        TableColumn col0 = this.table.getColumnModel().getColumn(0);
        TableColumn col1 = this.table.getColumnModel().getColumn(1);
        tcm.removeColumn(col0);
        tcm.removeColumn(col1);
        this.table.sizeColumnsToFit(0);
    }

    public void actionPerformed(ActionEvent evt) {
        String actionCmd = evt.getActionCommand();
        if (actionCmd.equals("SHOW_VALUE")) {
            this.showValue();
        }
    }

    public void showValue() {
        String name = null;
        CIMDataType dataType = null;
        Object value = null;
        CIMElement currentElement = (CIMElement)this.cimElements.elementAt(this.getSelectedRow());
        name = currentElement.getName();
        if (this.tableType == 0) {
            dataType = ((CIMProperty)currentElement).getType();
            CIMValue cv = ((CIMProperty)currentElement).getValue();
            value = cv != null ? cv.getValue() : null;
        } else if (this.tableType == 1) {
            CIMValue cv = ((CIMQualifier)currentElement).getValue();
            if (cv != null) {
                dataType = cv.getType();
                value = cv.getValue();
            } else {
                value = null;
            }
        }
        CIMValueDialog.showDialog(Util.getFrame(this.table), value, name, dataType, false);
    }

    public void setUneditableRows(Vector v) {
        this.uneditableRows = v;
    }

    public void addTableListener(TableModelListener tml) {
        this.elementsDataModel.addTableModelListener(tml);
    }

    public void addListSelectionListener(ListSelectionListener lsl) {
        this.table.getSelectionModel().addListSelectionListener(lsl);
    }

    protected void setParentElement(CIMElement parent) {
        this.parentElement = parent;
    }

    protected void deleteElement(int row) {
        if (this.tableType == 0) {
            CIMProperty prop = (CIMProperty)this.cimElements.elementAt(row);
        } else if (this.tableType == 1) {
            CIMQualifier cIMQualifier = (CIMQualifier)this.cimElements.elementAt(row);
        }
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int getSelectedColumn() {
        return this.table.getSelectedColumn();
    }

    public boolean isNameDefined(String name) {
        if (name != null) {
            for (int i = 0; i < this.cimElements.size(); ++i) {
                String nameVal = (String)this.elementsDataModel.getValueAt(i, this.nameColumn);
                if (!name.equalsIgnoreCase(nameVal)) continue;
                return true;
            }
        }
        return false;
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    public boolean isSelectionEmpty() {
        return this.table == null || this.table.getSelectedRow() < 0;
    }

    protected void createPopupMenu(Point point) {
        int currentRow = this.table.rowAtPoint(point);
        this.table.setRowSelectionInterval(currentRow, currentRow);
        Point vpLocation = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - vpLocation.x + 10, point.y - vpLocation.y);
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.createPopupMenu(evt.getPoint());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.createPopupMenu(evt.getPoint());
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.createPopupMenu(evt.getPoint());
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void tableChanged(TableModelEvent e) {
    }

    public void setAccessState(int as) {
        this.accessState = as;
    }

    public void windowClosing(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public class CIMTypeEditor
    extends DefaultCellEditor {
        String currentName;
        String currentType;
        CIMElement currentElement;
        int currentRow;

        public CIMTypeEditor(JTextField textField) {
            super(textField);
        }

        public Component getTableCellEditorComponent(JTable tbl, Object value, boolean isSelected, int row, int column) {
            this.currentRow = row;
            ((JTextField)this.editorComponent).setEditable(false);
            this.currentElement = (CIMElement)CIMElementsTable.this.cimElements.elementAt(row);
            this.currentName = this.currentElement.getName();
            if (CIMElementsTable.this.tableType == 0) {
                CIMDataType cdt = ((CIMProperty)this.currentElement).getType();
                this.currentType = Util.getDataTypeString(cdt);
            } else if (CIMElementsTable.this.tableType == 1) {
                CIMValue cv = ((CIMQualifier)this.currentElement).getValue();
                this.currentType = cv != null ? Util.getDataTypeString(cv.getType()) : "Null";
            }
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.currentType;
        }

        public boolean isCellEditable(EventObject evt) {
            if (!CIMClientObject.userHasWritePermission()) {
                return false;
            }
            if (CIMElementsTable.this.accessState == 1) {
                return !CIMElementsTable.this.isClass || !(this.currentElement instanceof CIMProperty) || ((CIMProperty)this.currentElement).getOriginClass() == null;
            }
            CIMElementsTable.this.table.setRowSelectionInterval(this.currentRow, this.currentRow);
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public boolean shouldSelectCell(EventObject evt) {
            if (this.isCellEditable(evt)) {
                this.showDialog();
            }
            return false;
        }

        public void showDialog() {
            CIMTypeDialog dlg = new CIMTypeDialog(Util.getFrame(CIMElementsTable.this.table), this.currentType);
            String newType = dlg.getType();
            if (newType == null || newType.equals(this.currentType)) {
                this.fireEditingCanceled();
            } else {
                this.currentType = newType;
                this.fireEditingStopped();
            }
        }
    }

    public class CIMTextFieldCellEditor
    extends DefaultCellEditor {
        String currentName;
        CIMDataType currentDataType = null;
        Object currentValue;
        CIMElement currentElement;
        int currentRow;
        boolean isKey;

        public CIMTextFieldCellEditor(JTextField textField) {
            super(textField);
        }

        public Component getTableCellEditorComponent(JTable tbl, Object value, boolean isSelected, int row, int column) {
            this.currentRow = row;
            ((JTextField)this.editorComponent).setEditable(this.isTextFieldEditable());
            this.currentElement = (CIMElement)CIMElementsTable.this.cimElements.elementAt(row);
            this.currentName = this.currentElement.getName();
            if (CIMElementsTable.this.tableType == 0) {
                this.currentDataType = ((CIMProperty)this.currentElement).getType();
                CIMValue cv = ((CIMProperty)this.currentElement).getValue();
                this.currentValue = cv != null ? cv.getValue() : null;
                this.isKey = ((CIMProperty)this.currentElement).isKey();
            } else if (CIMElementsTable.this.tableType == 1) {
                CIMValue cv = ((CIMQualifier)this.currentElement).getValue();
                if (cv != null) {
                    this.currentDataType = cv.getType();
                    this.currentValue = cv.getValue();
                } else {
                    try {
                        CIMQualifierType cqt = CIMElementsTable.this.cimClient.getQualifierType(new CIMObjectPath(this.currentName));
                        if (cqt != null) {
                            this.currentDataType = cqt.getType();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.currentValue = null;
                    if (this.currentDataType == null) {
                        this.currentDataType = new CIMDataType(8);
                    }
                }
                this.isKey = false;
            }
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public boolean isCellEditable(EventObject evt) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public boolean shouldSelectCell(EventObject evt) {
            if (CIMElementsTable.this.table.getModel().isCellEditable(this.currentRow, CIMElementsTable.this.valueColumn)) {
                this.currentValue = CIMValueDialog.showDialog(Util.getFrame(CIMElementsTable.this.table), this.currentValue, this.currentName, this.currentDataType, true);
                if (this.currentValue instanceof CancelObject) {
                    this.fireEditingCanceled();
                } else {
                    this.fireEditingStopped();
                }
            }
            return false;
        }

        public boolean isTextFieldEditable() {
            boolean ret = false;
            return ret;
        }

        public void showDialog() {
        }
    }

    class ElementsDataModel
    extends DefaultTableModel {
        ElementsDataModel() {
        }

        public int getColumnCount() {
            if (CIMElementsTable.this.tableHeading != null) {
                return CIMElementsTable.this.tableHeading.size();
            }
            return 0;
        }

        public Object getValueAt(int row, int col) {
            CIMQualifier prop;
            if (CIMElementsTable.this.tableType == 0) {
                CIMProperty prop2 = (CIMProperty)CIMElementsTable.this.cimElements.elementAt(row);
                if (prop2 != null) {
                    if (col == CIMElementsTable.this.nameColumn) {
                        return prop2.getName();
                    }
                    if (col == CIMElementsTable.this.typeColumn) {
                        return Util.getDataTypeString(prop2.getType());
                    }
                    if (col == CIMElementsTable.this.valueColumn) {
                        CIMValue cv = prop2.getValue();
                        String val = CIMElementsTable.this.emptyString;
                        if (cv != null && cv.getValue() != null && (val = cv.getValue().toString()).equals("")) {
                            val = CIMElementsTable.this.emptyString;
                        }
                        return val;
                    }
                    if (col == 0) {
                        String origClass = prop2.getOriginClass();
                        if (origClass == null || CIMElementsTable.this.parentElement == null) {
                            return CIMElementsTable.this.blankIcon;
                        }
                        if (CIMElementsTable.this.parentElement.getName().equals(origClass)) {
                            return CIMElementsTable.this.blankIcon;
                        }
                        return CIMElementsTable.this.inheritedIcon;
                    }
                    if (col == 1) {
                        if (prop2.isKey()) {
                            return CIMElementsTable.this.keyIcon;
                        }
                        return CIMElementsTable.this.blankIcon;
                    }
                }
            } else if (CIMElementsTable.this.tableType == 1 && (prop = (CIMQualifier)CIMElementsTable.this.cimElements.elementAt(row)) != null) {
                if (col == CIMElementsTable.this.nameColumn) {
                    return prop.getName();
                }
                if (col == CIMElementsTable.this.typeColumn) {
                    try {
                        CIMQualifierType cqt = CIMElementsTable.this.cimClient.getQualifierType(new CIMObjectPath(prop.getName()));
                        return Util.getDataTypeString(cqt.getType());
                    }
                    catch (Exception e) {
                        return "NULL";
                    }
                }
                if (col == CIMElementsTable.this.valueColumn) {
                    CIMValue cv = prop.getValue();
                    String val = CIMElementsTable.this.emptyString;
                    if (cv != null && cv.getValue() != null && (val = cv.getValue().toString()).equals("")) {
                        val = CIMElementsTable.this.emptyString;
                    }
                    return val;
                }
                return CIMElementsTable.this.blankIcon;
            }
            return CIMElementsTable.this.emptyString;
        }

        public void setValueAt(Object value, int row, int col) {
            if (CIMElementsTable.this.tableType == 0) {
                CIMProperty prop = (CIMProperty)CIMElementsTable.this.cimElements.elementAt(row);
                if (prop == null) {
                    prop = new CIMProperty();
                }
                if (col == CIMElementsTable.this.nameColumn) {
                    prop.setName((String)value);
                } else if (col == CIMElementsTable.this.typeColumn) {
                    CIMDataType cdt = ((String)value).indexOf(95) > 0 ? new CIMDataType((String)value) : new CIMDataType(CIMElementsTable.this.cimTypes.getCIMType((String)value));
                    prop.setType(cdt);
                } else if (col == CIMElementsTable.this.valueColumn) {
                    prop.setValue(new CIMValue(value));
                }
                CIMElementsTable.this.cimElements.setElementAt(prop, row);
            } else if (CIMElementsTable.this.tableType == 1) {
                CIMQualifier prop = (CIMQualifier)CIMElementsTable.this.cimElements.elementAt(row);
                if (prop == null) {
                    prop = new CIMQualifier();
                }
                if (col == CIMElementsTable.this.valueColumn) {
                    prop.setValue(new CIMValue(value));
                }
                CIMElementsTable.this.cimElements.setElementAt(prop, row);
            }
            this.fireTableCellUpdated(row, col);
        }

        public String getColumnName(int col) {
            return (String)CIMElementsTable.this.tableHeading.elementAt(col);
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            boolean b = false;
            if (col != CIMElementsTable.this.valueColumn || !CIMClientObject.userHasWritePermission() || CIMElementsTable.this.uneditableRows.contains(new Integer(row)) || CIMElementsTable.this.accessState == 0) {
                b = false;
            } else if (CIMElementsTable.this.newElement) {
                b = true;
            } else if (CIMElementsTable.this.parentElement instanceof CIMInstance) {
                CIMElement currentElement = (CIMElement)CIMElementsTable.this.cimElements.elementAt(row);
                b = CIMElementsTable.this.tableType != 0 || !((CIMProperty)currentElement).isKey();
            }
            return b;
        }
    }
}

