/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.ButtonPanel;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.FlowArea;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class CIMEventsPanel
extends JScrollPane
implements ActionListener {
    protected Hashtable eventSelectionTable = new Hashtable();
    protected Hashtable filterInstanceTable = new Hashtable();
    protected Hashtable filterDeliveryInstanceTable = new Hashtable();
    protected int eventMask = 0;
    protected CIMClass cimClass = null;
    protected CIMClient cimClient = null;
    protected CIMObjectPath indicationHandler = null;
    protected JPanel mainPanel;
    protected CardLayout card;
    JButton btnSet;
    JCheckBox btnInstCreate;
    JCheckBox btnInstDelete;
    JCheckBox btnInstModify;
    JRadioButton btnEnable;
    JRadioButton btnDisable;
    private final String CREATE = "CIM_InstCreation";
    private final String DELETE = "CIM_InstDeletion";
    private final String MODIFY = "CIM_InstModification";
    private final int NONE = 0;
    private final int LIFE_CYCLE = 1;
    private final int PROCESS_INDICATION = 2;
    protected int eventType = 0;
    protected boolean eventsSupported = true;

    public CIMEventsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.mainPanel = new JPanel();
        this.card = new CardLayout();
        this.mainPanel.setLayout(this.card);
        ActionString asSet = new ActionString("LBL_SET");
        this.btnSet = new JButton(asSet.getString());
        this.btnSet.setMnemonic(asSet.getMnemonic());
        this.btnSet.setActionCommand("SET");
        this.btnSet.addActionListener(this);
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.add(this.btnSet);
        this.mainPanel.add("LIFE_CYCLE", this.createLifeCyclePanel());
        this.mainPanel.add("PROCESS_INDICATION", this.createProcessIndicationPanel());
        this.mainPanel.add("NONE", this.createMsgPanel("MSG_EVENT_CLASS"));
        this.mainPanel.add("NO_EVENTS", this.createMsgPanel("MSG_NO_EVENTS"));
        this.card.show(this.mainPanel, "NO_NONE");
        panel.add((Component)this.mainPanel, "North");
        panel.add((Component)buttonPanel, "South");
        this.setViewportView(panel);
    }

    private JPanel createMsgPanel(String msg) {
        JPanel panel = new JPanel();
        FlowArea msgArea = new FlowArea(I18N.loadString(msg), 35);
        msgArea.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        panel.add(msgArea);
        return panel;
    }

    private JPanel createLifeCyclePanel() {
        JPanel panel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.CENTER));
        ActionString asCreate = new ActionString("LBL_INSTANCE_CREATE");
        ActionString asDelete = new ActionString("LBL_INSTANCE_DELETE");
        ActionString asModify = new ActionString("LBL_INSTANCE_MODIFY");
        this.btnInstCreate = new JCheckBox(asCreate.getString());
        this.btnInstCreate.setMnemonic(asCreate.getMnemonic());
        this.btnInstCreate.addActionListener(this);
        this.btnInstDelete = new JCheckBox(asDelete.getString());
        this.btnInstDelete.setMnemonic(asDelete.getMnemonic());
        this.btnInstDelete.addActionListener(this);
        this.btnInstModify = new JCheckBox(asModify.getString());
        this.btnInstModify.setMnemonic(asModify.getMnemonic());
        this.btnInstModify.addActionListener(this);
        FlowArea msg = new FlowArea(I18N.loadString("MSG_SELECT_EVENTS"), 35);
        msg.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        JPanel cbPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        cbPanel.add(this.btnInstCreate);
        cbPanel.add(this.btnInstDelete);
        cbPanel.add(this.btnInstModify);
        panel.add(msg);
        panel.add(cbPanel);
        return panel;
    }

    private JPanel createProcessIndicationPanel() {
        JPanel panel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.CENTER));
        ActionString asEnable = new ActionString("LBL_ENABLED");
        ActionString asDisable = new ActionString("LBL_DISABLED");
        this.btnEnable = new JRadioButton(asEnable.getString());
        this.btnEnable.setMnemonic(asEnable.getMnemonic());
        this.btnEnable.addActionListener(this);
        this.btnDisable = new JRadioButton(asDisable.getString());
        this.btnDisable.setMnemonic(asDisable.getMnemonic());
        this.btnDisable.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnEnable);
        group.add(this.btnDisable);
        FlowArea msg = new FlowArea(I18N.loadString("MSG_PI_EVENTS"), 35);
        msg.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        JPanel cbPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        cbPanel.add(this.btnEnable);
        cbPanel.add(this.btnDisable);
        panel.add(msg);
        panel.add(cbPanel);
        return panel;
    }

    public void deleteEventSubscriptions() {
        if (this.cimClient != null) {
            String key;
            Enumeration keys = this.filterDeliveryInstanceTable.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                CIMObjectPath filterDelivery = (CIMObjectPath)this.filterDeliveryInstanceTable.get(key);
                try {
                    this.cimClient.deleteInstance(filterDelivery);
                }
                catch (CIMException e) {
                    CIMErrorDialog.display(this, e);
                }
            }
            keys = this.filterInstanceTable.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                CIMObjectPath filter = (CIMObjectPath)this.filterInstanceTable.get(key);
                try {
                    this.cimClient.deleteInstance(filter);
                }
                catch (CIMException e) {
                    CIMErrorDialog.display(this, e);
                }
            }
            if (this.indicationHandler != null) {
                try {
                    this.cimClient.deleteInstance(Util.getRelativeObjectPath(this.indicationHandler));
                    this.indicationHandler = null;
                }
                catch (CIMException e) {
                    CIMErrorDialog.display(this, e);
                }
            }
        }
        this.filterInstanceTable.clear();
        this.filterDeliveryInstanceTable.clear();
        this.eventSelectionTable.clear();
    }

    public void initializeEvents(CIMObjectPath indHandler, CIMClient cClient) {
        this.indicationHandler = indHandler;
        boolean bl = this.eventsSupported = this.indicationHandler != null;
        if (!this.eventsSupported) {
            this.card.show(this.mainPanel, "NO_EVENTS");
        } else {
            this.card.show(this.mainPanel, "NONE");
        }
        this.cimClient = cClient;
    }

    public void setEventsSelection(CIMClass cc) {
        if (this.cimClient == null || !this.eventsSupported) {
            return;
        }
        this.cimClass = cc;
        if (this.cimClass == null) {
            this.eventType = 0;
        } else {
            String name = this.cimClass.getName();
            CIMQualifier qual = cc.getQualifier("Indication");
            Boolean b = new Boolean("true");
            this.eventType = qual != null && qual.hasValue() && b.equals(qual.getValue().getValue()) ? 2 : 1;
            Integer i = new Integer(0);
            if (this.eventSelectionTable.containsKey(name)) {
                i = (Integer)this.eventSelectionTable.get(name);
            }
            this.eventMask = i;
            this.initializeControls();
        }
        switch (this.eventType) {
            case 0: {
                this.card.show(this.mainPanel, "NONE");
                break;
            }
            case 1: {
                this.card.show(this.mainPanel, "LIFE_CYCLE");
                break;
            }
            case 2: {
                this.card.show(this.mainPanel, "PROCESS_INDICATION");
            }
        }
        this.btnSet.setEnabled(false);
    }

    private void initializeControls() {
        if (this.eventType == 1) {
            this.btnInstCreate.setSelected((this.eventMask & 1) > 0);
            this.btnInstDelete.setSelected((this.eventMask & 2) > 0);
            this.btnInstModify.setSelected((this.eventMask & 4) > 0);
        } else if (this.eventType == 2) {
            this.btnDisable.setSelected(this.eventMask == 0);
        }
    }

    private int getSelectedMask() {
        int ret = 0;
        if (this.eventType == 1) {
            if (this.btnInstCreate.isSelected()) {
                ++ret;
            }
            if (this.btnInstDelete.isSelected()) {
                ret += 2;
            }
            if (this.btnInstModify.isSelected()) {
                ret += 4;
            }
        } else if (this.eventType == 2 && this.btnEnable.isSelected()) {
            ret = 1;
        }
        return ret;
    }

    public void actionPerformed(ActionEvent evt) {
        String action = evt.getActionCommand();
        if (action.equals("SET")) {
            int i = this.getSelectedMask();
            this.setEvents(i);
            if (i == 0) {
                this.eventSelectionTable.remove(this.cimClass.getName());
            } else {
                this.eventSelectionTable.put(this.cimClass.getName(), new Integer(i));
            }
            this.eventMask = i;
            this.btnSet.setEnabled(false);
        } else {
            this.enableSetButton();
        }
    }

    private void enableSetButton() {
        this.btnSet.setEnabled(this.eventMask != this.getSelectedMask());
    }

    private void setEvents(int newMask) {
        if (!this.createIndicationHandler()) {
            return;
        }
        if (this.eventType == 1) {
            if ((~(this.eventMask & 1) & (newMask & 1)) > 0) {
                this.setLifeCycleInstance("CIM_InstCreation");
            }
            if ((~(this.eventMask & 2) & (newMask & 2)) > 0) {
                this.setLifeCycleInstance("CIM_InstDeletion");
            }
            if ((~(this.eventMask & 4) & (newMask & 4)) > 0) {
                this.setLifeCycleInstance("CIM_InstModification");
            }
            if ((this.eventMask & 1 & ~(newMask & 1)) > 0) {
                this.removeLifeCycleInstance("CIM_InstCreation");
            }
            if ((this.eventMask & 2 & ~(newMask & 2)) > 0) {
                this.removeLifeCycleInstance("CIM_InstDeletion");
            }
            if ((this.eventMask & 4 & ~(newMask & 4)) > 0) {
                this.removeLifeCycleInstance("CIM_InstModification");
            }
        } else if (this.eventType == 2) {
            if (this.eventMask == 0 && newMask == 1) {
                this.setIndicationInstance();
            } else if (this.eventMask == 1 && newMask == 0) {
                this.removeIndicationInstance();
            }
        }
    }

    public void addFilter(String name, String query, String queryLanguage) {
        this.addFilter("", "", "", name, "", query, queryLanguage);
    }

    public void addFilter(String systemCreationClassName, String systemName, String creationClassName, String name, String sourceNamespace, String query, String queryLanguage) {
        CIMObjectPath filter = null;
        try {
            CIMClass cimFilter = this.cimClient.getClass(new CIMObjectPath("CIM_IndicationFilter"), true, true, true, null);
            CIMInstance ci = cimFilter.newInstance();
            if (systemCreationClassName != null && systemCreationClassName.trim().length() > 0) {
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)systemCreationClassName));
            }
            if (systemName != null && systemName.trim().length() > 0) {
                ci.setProperty("SystemName", new CIMValue((Object)systemName));
            }
            if (creationClassName != null && creationClassName.trim().length() > 0) {
                ci.setProperty("CreationClassName", new CIMValue((Object)creationClassName));
            }
            if (sourceNamespace != null && sourceNamespace.trim().length() > 0) {
                ci.setProperty("SourceNamespace", new CIMValue((Object)sourceNamespace));
            }
            if (query != null) {
                ci.setProperty("Query", new CIMValue((Object)query));
            }
            if (queryLanguage != null) {
                ci.setProperty("QueryLanguage", new CIMValue((Object)queryLanguage));
            } else {
                ci.setProperty("QueryLanguage", new CIMValue((Object)"WQL"));
            }
            filter = this.cimClient.createInstance(new CIMObjectPath(), ci);
            CIMClass ccFilterDelivery = this.cimClient.getClass(new CIMObjectPath("CIM_IndicationSubscription"), true, true, true, null);
            ci = ccFilterDelivery.newInstance();
            ci.setProperty("filter", new CIMValue((Object)filter));
            ci.setProperty("handler", new CIMValue((Object)this.indicationHandler));
            CIMObjectPath filterDelivery = this.cimClient.createInstance(new CIMObjectPath(), ci);
            if (filterDelivery == null) {
                filterDelivery = new CIMObjectPath();
                filterDelivery.setNameSpace("");
                filterDelivery.setObjectName(ci.getClassName());
                filterDelivery.setKeys(ci.getKeys());
            }
            this.filterInstanceTable.put(name, Util.getRelativeObjectPath(filter));
            this.filterDeliveryInstanceTable.put(name, Util.getRelativeObjectPath(filterDelivery));
        }
        catch (CIMException e) {
            CIMErrorDialog.display(this, e);
            try {
                if (filter != null) {
                    this.cimClient.deleteInstance(Util.getRelativeObjectPath(filter));
                }
            }
            catch (CIMException e1) {
                // empty catch block
            }
            return;
        }
    }

    private void removeLifeCycleInstance(String instanceType) {
        if (this.cimClass == null) {
            return;
        }
        String cName = this.cimClass.getName();
        String name = instanceType + "." + cName;
        CIMObjectPath filter = null;
        CIMObjectPath filterDelivery = null;
        filter = (CIMObjectPath)this.filterInstanceTable.get(name);
        filterDelivery = (CIMObjectPath)this.filterDeliveryInstanceTable.get(name);
        try {
            if (filterDelivery != null) {
                this.cimClient.deleteInstance(filterDelivery);
                this.filterDeliveryInstanceTable.remove(name);
            }
        }
        catch (CIMException e1) {
            CIMErrorDialog.display(this, e1);
        }
        try {
            if (filter != null) {
                this.cimClient.deleteInstance(filter);
                this.filterInstanceTable.remove(name);
            }
        }
        catch (CIMException e) {
            CIMErrorDialog.display(this, e);
        }
    }

    private void removeIndicationInstance() {
        if (this.cimClass == null) {
            return;
        }
        String name = this.cimClass.getName();
        CIMObjectPath filter = null;
        CIMObjectPath filterDelivery = null;
        filter = (CIMObjectPath)this.filterInstanceTable.get(name);
        filterDelivery = (CIMObjectPath)this.filterDeliveryInstanceTable.get(name);
        try {
            if (filterDelivery != null) {
                this.cimClient.deleteInstance(filterDelivery);
                this.filterDeliveryInstanceTable.remove(name);
            }
        }
        catch (CIMException e1) {
            CIMErrorDialog.display(this, e1);
        }
        try {
            if (filter != null) {
                this.cimClient.deleteInstance(filter);
                this.filterInstanceTable.remove(name);
            }
        }
        catch (CIMException e) {
            CIMErrorDialog.display(this, e);
        }
    }

    private void setIndicationInstance() {
        if (this.cimClass == null) {
            return;
        }
        String cName = this.cimClass.getName();
        String filter = "SELECT * FROM " + cName;
        this.addFilter(cName, filter, "WQL");
    }

    private void setLifeCycleInstance(String instanceType) {
        if (this.cimClass == null) {
            return;
        }
        String cName = this.cimClass.getName();
        String name = instanceType + "." + cName;
        String filter = "SELECT * FROM " + instanceType + " WHERE sourceInstance ISA " + cName;
        CIMNameSpace ns = new CIMNameSpace();
        if (ns.getNameSpace().equals(CIMClientObject.getNameSpace())) {
            this.addFilter(name, filter, "WQL");
        } else {
            this.addFilter("", "", "", name, CIMClientObject.getNameSpace(), filter, "WQL");
        }
    }

    private boolean createIndicationHandler() {
        if (this.indicationHandler == null) {
            try {
                CIMInstance ci = this.cimClient.getIndicationHandler(null);
                this.indicationHandler = this.cimClient.createInstance(new CIMObjectPath(), ci);
            }
            catch (CIMException e) {
                return false;
            }
        }
        return true;
    }
}

