/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMFlavor;
import org.wbemservices.wbem.apps.cimworkshop.FlavorTypes;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class CIMFlavorDialog
extends AdminDialog
implements ListSelectionListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected JList list;
    protected Vector flavors = null;
    protected boolean newElement;

    public CIMFlavorDialog(Frame parent, Vector prevFlavor, String name, boolean nElement) {
        super(parent, I18N.loadStringFormat("TTL_FLAVOR", name), false);
        JPanel mainPanel = this.getRightPanel();
        this.newElement = nElement;
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel centerPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FlavorTypes flavorTypes = new FlavorTypes();
        this.list = new JList(flavorTypes.getTypes());
        this.list.getSelectionModel().setSelectionMode(2);
        Enumeration e = prevFlavor.elements();
        while (e.hasMoreElements()) {
            CIMFlavor cimFlavor = (CIMFlavor)e.nextElement();
            int i = cimFlavor.getFlavor();
            this.list.addSelectionInterval(i, i);
        }
        JScrollPane scrollList = new JScrollPane(this.list);
        ActionString asFlavors = new ActionString("MNU_FLAVOR");
        JLabel lFlavors = new JLabel(asFlavors.getString() + ":");
        lFlavors.setDisplayedMnemonic(asFlavors.getMnemonic());
        lFlavors.setLabelFor(this.list);
        centerPanel.add(lFlavors);
        centerPanel.add(scrollList);
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new ButtonListener());
        this.btnOK = this.getOKBtn();
        if (nElement) {
            this.btnOK.addActionListener(new ButtonListener());
            lFlavors.setDisplayedMnemonic(asFlavors.getMnemonic());
            lFlavors.setLabelFor(this.list);
        } else {
            this.getbuttonPanel().remove(this.btnOK);
            this.btnCancel.setText(I18N.loadString("LBL_CLOSE", "org.wbemservices.wbem.apps.common.common"));
        }
        mainPanel.add(centerPanel);
        this.list.setEnabled(nElement);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "flavors_000.htm"), true);
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    public Vector getSelectedFlavors() {
        return this.flavors;
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
    }

    public void okClicked() {
        int[] selFlavors = this.list.getSelectedIndices();
        this.flavors = new Vector();
        for (int i = 0; i < selFlavors.length; ++i) {
            this.flavors.addElement(new CIMFlavor(selFlavors[i]));
        }
        this.dispose();
    }

    public void cancelClicked() {
        this.flavors = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent evt) {
        super.windowOpened(evt);
        if (this.newElement) {
            this.list.requestFocus();
        } else {
            this.btnCancel.requestFocus();
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CIMFlavorDialog.this.btnCancel) {
                CIMFlavorDialog.this.cancelClicked();
            } else if (e.getSource() == CIMFlavorDialog.this.btnOK) {
                CIMFlavorDialog.this.okClicked();
            }
        }
    }
}

